/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.fi.ar.AccountAgeQueryParam;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.arap.client.AbstractArApAgingTimeSettingUI;
import com.kingdee.eas.fi.arap.util.paramconvertor.AccountAgeRptParamConvertor;
import com.kingdee.eas.fi.arap.util.paramconvertor.IRptParamConvertor;
import com.kingdee.eas.fi.arap.util.paramconvertor.RptParamConvertorFactory;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ArApAgingTimeSettingUI
extends AbstractArApAgingTimeSettingUI {
    private static final long serialVersionUID = -4766157695398686822L;
    private static final Logger logger = CoreUIObject.getLogger(ArApAgingTimeSettingUI.class);
    private AccountAgeQueryParam rptParam = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initTables();
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnUndueAdd.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnUndueDel.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.setPanelName(this.getUITitle());
    }

    private void initTables() {
        this.tblOverdue.checkParsed();
        this.tblUndue.checkParsed();
        this.tblOverdue.getIndexColumn().getStyleAttributes().setHided(true);
        this.tblUndue.getIndexColumn().getStyleAttributes().setHided(true);
        this.tblOverdue.setActiveCellStatus(1);
        this.tblUndue.setActiveCellStatus(1);
        KDFormattedTextField txtDay = new KDFormattedTextField(0);
        txtDay.setMinimumValue((Comparable)new Integer("1"));
        txtDay.setMaximumValue((Comparable)new Integer("9999"));
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)txtDay);
        this.tblOverdue.removeRows();
        this.tblOverdue.addRows(3);
        this.tblUndue.removeRows();
        this.tblUndue.addRows(3);
        this.tblOverdue.getColumn(0).setEditor((ICellEditor)cellEditor);
        this.tblUndue.getColumn(0).setEditor((ICellEditor)cellEditor);
        this.tblOverdue.getColumn(1).getStyleAttributes().setLocked(true);
        this.tblUndue.getColumn(1).getStyleAttributes().setLocked(true);
    }

    @Override
    protected void tblOverdue_editStopped(KDTEditEvent e) throws Exception {
        this.setViewContent(e);
    }

    @Override
    protected void btnDelRow_actionPerformed(ActionEvent e) throws Exception {
        this.delRow(this.tblOverdue);
    }

    @Override
    protected void btnAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.addRow(this.tblOverdue);
    }

    @Override
    protected void tblUndue_editStopped(KDTEditEvent e) throws Exception {
        this.setViewContent(e);
    }

    @Override
    protected void btnUndueDel_actionPerformed(ActionEvent e) throws Exception {
        this.delRow(this.tblUndue);
    }

    @Override
    protected void btnUndueAddAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.addRow(this.tblUndue);
    }

    private void addRow(KDTable tbl) throws Exception {
        tbl.addRow();
        logger.debug((Object)("add, rows " + tbl.getRowCount()));
    }

    private void delRow(KDTable tbl) throws Exception {
        logger.debug((Object)("del, rows " + tbl.getRowCount()));
        if (tbl.getRowCount() == 0) {
            return;
        }
        if (tbl.getSelectManager().size() > 0) {
            KDTSelectBlock block = tbl.getSelectManager().get();
            if (block != null) {
                tbl.removeRow(block.getTop());
            }
        } else if (tbl.getRowCount() > 0) {
            tbl.removeRow(tbl.getRowCount() - 1);
        }
    }

    private void setViewContent(KDTEditEvent e) {
        Object oldVal = e.getOldValue();
        Object val = e.getValue();
        if (oldVal == null && val == null) {
            return;
        }
        if (oldVal != null && val != null && oldVal.equals(val)) {
            return;
        }
        int rowIndex = e.getRowIndex();
        KDTable tbl = (KDTable)e.getSource();
        this.checkDayValid(tbl, rowIndex);
        this.setAllDateLbl(tbl);
    }

    private void checkDayValid(KDTable tbl, int rowIndex) {
        IRow row = tbl.getRow(rowIndex);
        Integer dayNum = (Integer)row.getCell(0).getValue();
        if (dayNum == null) {
            row.getCell(1).setValue(null);
        }
        int hasDateRows = this.getHasDateRowCount(tbl);
        for (int i = 0; i < hasDateRows; ++i) {
            int days = (Integer)tbl.getRow(i).getCell(0).getValue();
            if (i <= 0) continue;
            int preDays = (Integer)tbl.getRow(i - 1).getCell(0).getValue();
            if (days <= preDays) {
                days = preDays + 10;
                tbl.getRow(i).getCell(0).setValue((Object)new Integer(days));
                continue;
            }
            if (days >= preDays || i <= 1) continue;
            int prepDays = (Integer)tbl.getRow(i - 2).getCell(0).getValue();
            preDays = (prepDays + days) / 2;
            tbl.getRow(i - 1).getCell(0).setValue((Object)new Integer(preDays));
        }
    }

    private void setAllDateLbl(KDTable tbl) {
        String resLbl = null;
        resLbl = tbl.getName().equals("tblOverdue") ? "Lbl_FOL" : "Lbl_FUL";
        int dayDiff = 0;
        IRow row = null;
        int hasDateRows = this.getHasDateRowCount(tbl);
        for (int i = 0; i < hasDateRows; ++i) {
            row = tbl.getRow(i);
            dayDiff = (Integer)row.getCell(0).getValue();
            Object[] args = null;
            if (i == 0) {
                args = new String[]{String.valueOf(1), String.valueOf(dayDiff)};
            } else {
                int preDiff = (Integer)tbl.getRow(i - 1).getCell(0).getValue() + 1;
                args = new String[]{String.valueOf(preDiff), String.valueOf(dayDiff)};
            }
            String colTitle = EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)resLbl);
            row.getCell(1).setValue((Object)MessageFormat.format(colTitle, args));
        }
    }

    private int getHasDateRowCount(KDTable tbl) {
        IRow row;
        int hasDateRows = 0;
        int n = tbl.getRowCount();
        for (int i = 0; i < n && (row = tbl.getRow(i)).getCell(0).getValue() != null; ++i) {
            ++hasDateRows;
        }
        return hasDateRows;
    }

    public boolean verify() {
        return true;
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public CustomerParams getCustomerParams() {
        IRptParamConvertor convertor = RptParamConvertorFactory.getConvertor(this.getRptParam());
        return convertor.convertClient();
    }

    public IReportQueryParam getRptParam() {
        AccountAgeQueryParam param = new AccountAgeQueryParam();
        this.saveDateRanges(param);
        return param;
    }

    private void saveDateRanges(AccountAgeQueryParam param) {
        Integer days;
        Integer day;
        IRow row;
        Integer day2;
        IRow row2;
        ArrayList<Integer> undueList = new ArrayList<Integer>();
        int n = this.tblUndue.getRowCount();
        for (int i = 0; i < n && (row2 = this.tblUndue.getRow(i)) != null && row2.getCell(0) != null && row2.getCell(0).getValue() != null && (day2 = (Integer)row2.getCell(0).getValue()) != null; ++i) {
            int dayDiff = day2;
            undueList.add(new Integer(dayDiff));
        }
        ArrayList<Integer> overdueList = new ArrayList<Integer>();
        int n2 = this.tblOverdue.getRowCount();
        for (int i = 0; i < n2 && (row = this.tblOverdue.getRow(i)) != null && row.getCell(0) != null && row.getCell(0).getValue() != null && (day = (Integer)row.getCell(0).getValue()) != null; ++i) {
            int dayDiff = day;
            overdueList.add(new Integer(dayDiff));
        }
        int lstSize = undueList.size();
        if (lstSize != 0) {
            Object lastObj = undueList.get(lstSize - 1);
            days = new Integer((Integer)lastObj + 1);
            undueList.add(days);
        }
        if ((lstSize = overdueList.size()) != 0) {
            Object lastObj = overdueList.get(lstSize - 1);
            days = new Integer(Integer.parseInt(lastObj.toString()) + 1);
            overdueList.add(days);
        }
        param.setOverdueList(overdueList);
        param.setUndueList(undueList);
    }

    public RptParams getCustomCondition() {
        RptParams biRptParam = new RptParams();
        biRptParam.setObject("qryParam-timeSetting", (Object)this.getRptParam());
        return biRptParam;
    }

    public void setCustomCondition(RptParams params) {
    }

    public void setCustomerParams(CustomerParams cp) {
        this.rptParam = new AccountAgeQueryParam();
        AccountAgeRptParamConvertor convertor = new AccountAgeRptParamConvertor();
        convertor.setRptParam((IReportQueryParam)this.rptParam);
        try {
            convertor.read(null, cp);
        }
        catch (Exception e) {
            logger.error((Object)"exception: parse the customerParams ", (Throwable)e);
        }
    }

    public void loadData(EntityViewInfo view) {
        this.loadRptParam(this.rptParam);
    }

    private void loadRptParam(AccountAgeQueryParam rptParam) {
        this.clear();
        this.setDateRangesToUI(rptParam.getUndueList(), this.tblUndue);
        this.setDateRangesToUI(rptParam.getOverdueList(), this.tblOverdue);
    }

    private void setDateRangesToUI(List dayLst, KDTable tbl) {
        if (dayLst != null && dayLst.size() > 0) {
            tbl.removeRows();
            int n = dayLst.size() - 1;
            tbl.addRows(n);
            for (int i = 0; i < n; ++i) {
                IRow row = tbl.getRow(i);
                row.getCell(0).setValue((Object)new Integer(dayLst.get(i).toString()));
            }
            this.setAllDateLbl(tbl);
        }
    }

    public void clear() {
        this.tblUndue.removeRows();
        this.tblOverdue.removeRows();
        this.tblUndue.addRows(3);
        this.tblOverdue.addRows(3);
    }

    public AccountAgeQueryParam getAccountAgeQueryParam() {
        return this.rptParam;
    }
}

