/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.AbstractArApBiRptBaseFilterUI;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApQueryUIUtil;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ArApBiRptBaseFilterUI
extends AbstractArApBiRptBaseFilterUI {
    private static final Logger logger = CoreUIObject.getLogger(ArApBiRptBaseFilterUI.class);
    protected static final String RES = "com.kingdee.eas.fi.ar.ArReport";
    protected boolean isArRpt = true;
    protected CompanyOrgUnitInfo currentCompany = null;
    protected String companyId = "";
    protected transient Object[] selectedComps = null;
    protected transient ICompanyOrgUnit iComp = null;
    protected transient CompanyOrgUnitCollection selectedCompInfos = null;
    protected transient ArApSysParamInfo sysInfo = null;
    protected transient HashMap map = new HashMap();
    protected transient IArApBillFacade iBillFacade = null;
    protected transient IObjectPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
    protected boolean fSameCu = false;
    protected transient Object[] currentCompArr = null;
    protected transient SCMRptMultiOrgsF7 compF7 = null;
    private int defaultCussTypeInd = 0;
    private int defaultCurrencyInd = 0;

    private void isAR() throws Exception {
        String title = EASResource.getString((String)"com.kingdee.eas.fi.arap.ArApRptResource", (String)"CompanysSelection");
        String permItem = this.getPermissionItem();
        this.compF7 = new SCMRptMultiOrgsF7(this.prmtCompany, OrgType.Company, permItem, title);
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
        ClientUtils.setCurrencyList((KDComboBox)this.comboCurrency, (boolean)true);
    }

    public void onLoad() throws Exception {
        this.isAR();
        this.checkBeforeLoad();
        this.initCtrls();
        super.onLoad();
    }

    protected boolean isArRpt() {
        return this.isArRpt;
    }

    protected final SystemEnum getSystemEnum() {
        return this.isArRpt() ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
    }

    protected void checkBeforeLoad() {
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (this.currentCompany == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"companyFail"));
            logger.error((Object)"has not default company!");
            SysUtil.abort();
        }
    }

    protected void initCompanysF7() throws Exception {
        this.companyId = this.currentCompany.getId().toString();
        FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
        orgInfo.setId(this.currentCompany.getId());
        orgInfo.setName(this.currentCompany.getName());
        orgInfo.setNumber(this.currentCompany.getNumber());
        this.currentCompArr = new Object[]{orgInfo};
        this.selectedCompInfos = ArApQueryUIUtil.getFullPermCompany(this.userPK, this.currentCompArr, this.getPermissionItem());
        this.currentCompArr = null;
        if (this.selectedCompInfos != null) {
            this.currentCompArr = new Object[this.selectedCompInfos.size()];
            CompanyOrgUnitInfo compInfo = null;
            int n = this.selectedCompInfos.size();
            for (int i = 0; i < n; ++i) {
                compInfo = this.selectedCompInfos.get(i);
                orgInfo = new FullOrgUnitInfo();
                orgInfo.setId(compInfo.getId());
                orgInfo.setName(compInfo.getName());
                orgInfo.setNumber(compInfo.getNumber());
                this.currentCompArr[i] = orgInfo;
            }
            this.selectedComps = this.currentCompArr;
        }
        if (this.currentCompArr != null && this.currentCompArr.length > 0) {
            this.prmtCompany.setValue((Object)this.currentCompArr);
        }
    }

    protected String getPermissionItem() {
        return null;
    }

    protected void initCtrls() throws Exception {
        this.map.put("isSCM", Boolean.FALSE);
        this.map.put("sysEnum", this.getSystemEnum());
        this.sysInfo = this.iBillFacade.getSysParams(this.currentCompany, this.map);
        this.initCompanysF7();
        ClientUtils.setSelectedItem((KDComboBox)this.comboCurrency, (String)this.currentCompany.getBaseCurrency().getId().toString());
        this.comboCussType.setRequired(true);
        this.defaultCurrencyInd = this.comboCurrency.getSelectedIndex();
        this.defaultCussTypeInd = this.comboCussType.getSelectedIndex();
    }

    public void clear() {
        this.prmtCompany.setValue((Object)this.currentCompArr);
        if (this.comboCussType.getItemCount() > 0 && this.defaultCussTypeInd > -1) {
            this.comboCussType.setSelectedIndex(this.defaultCussTypeInd);
        }
        if (this.comboCurrency.getItemCount() > 0 && this.defaultCurrencyInd > -1) {
            this.comboCurrency.setSelectedIndex(this.defaultCurrencyInd);
        }
        this.prmtCsspGrp.setValue(null);
        this.prmtCussFrom.setData(null);
        this.prmtCussTo.setData(null);
    }

    protected String getPermissionRes() {
        return null;
    }

    public boolean verify() {
        if (this.prmtCompany.getValue() == null || this.selectedComps == null || this.selectedComps.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"Company_Not_Null"));
            return false;
        }
        try {
            String notStartComps = this.getNotStartCompanys();
            if (!StringUtils.isEmpty((String)notStartComps)) {
                String msgPattern = EASResource.getString((String)RES, (String)(this.isArRpt() ? "companysArNotStarted" : "companysApNotStarted"));
                StringBuffer errorMsg = new StringBuffer(msgPattern);
                errorMsg = errorMsg.delete(errorMsg.indexOf(":"), errorMsg.length());
                MsgBox.showDetailAndOK((Component)((Object)this), (String)errorMsg.toString(), (String)notStartComps, (int)8188);
                return false;
            }
        }
        catch (Exception e) {
            logger.error((Object)"exception, check the companys status", (Throwable)e);
            SysUtil.abort();
        }
        List requiredCtrls = this.getRequiredCtrls();
        if (requiredCtrls == null || requiredCtrls.size() == 0) {
            return true;
        }
        String msgPattern = EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"QryUI_MustHave");
        int n = requiredCtrls.size();
        for (int i = 0; i < n; ++i) {
            Component obj = (Component)requiredCtrls.get(i);
            if (obj instanceof KDComboBox) {
                if (((KDComboBox)obj).getSelectedItem() != null) continue;
                this.showWarningMsg(msgPattern, obj);
                return false;
            }
            if (!(obj instanceof KDDatePicker) || ((KDDatePicker)obj).getValue() != null) continue;
            this.showWarningMsg(msgPattern, obj);
            return false;
        }
        return true;
    }

    protected List getRequiredCtrls() {
        ArrayList<KDComboBox> lst = new ArrayList<KDComboBox>();
        lst.add(this.comboCussType);
        lst.add(this.comboCurrency);
        return lst;
    }

    private void showWarningMsg(String msgPattern, Component obj) {
        String lbl = this.getCtrlWarningLabel(obj);
        String msg = MessageFormat.format(msgPattern, lbl);
        MsgBox.showWarning((Component)((Object)this), (String)msg);
    }

    protected String getCtrlWarningLabel(Component obj) {
        String lbl = null;
        lbl = obj.getParent() instanceof KDLabelContainer ? ((KDLabelContainer)obj.getParent()).getBoundLabelText() : obj.getName();
        return lbl;
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        return null;
    }

    public void setCustomCondition(RptParams params) {
    }

    protected boolean isExcludeInnerCust() {
        return false;
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitCollection comps;
        if (this.compF7 == null) {
            return;
        }
        Object[] newComps = (Object[])this.compF7.getFullData();
        if (newComps == null) {
            return;
        }
        Object[] oldComps = this.selectedComps;
        this.selectedComps = newComps;
        if (oldComps != null && Arrays.equals(oldComps, this.selectedComps)) {
            return;
        }
        this.selectedCompInfos = comps = ArApQueryUIUtil.getFullPermCompany(this.userPK, this.selectedComps, this.getPermissionItem());
        if (comps == null) {
            this.prmtCompany.setValue(null);
            if (this.comboCussType.getItemCount() == 0) {
                this.prmtCsspGrp.setEnabled(false);
                this.prmtCussFrom.setEnabled(false);
                this.prmtCussTo.setEnabled(false);
            }
            return;
        }
        HashSet<BOSUuid> companyIds = new HashSet<BOSUuid>();
        int n = comps.size();
        for (int i = 0; i < n; ++i) {
            CompanyOrgUnitInfo compInfo = comps.get(i);
            companyIds.add(compInfo.getId());
        }
        this.fSameCu = companyIds.size() == 1;
        ArApQueryUIUtil.setCussTypebyCompanys(companyIds, this.isArRpt(), this.comboCussType);
    }

    protected String getNotStartCompanys() throws BOSException, EASBizException {
        StringBuffer msg = new StringBuffer();
        SystemEnum sysEnum = this.getSystemEnum();
        int n = this.selectedCompInfos.size();
        for (int i = 0; i < n; ++i) {
            CompanyOrgUnitInfo compInfo = this.selectedCompInfos.get(i);
            if (compInfo.isIsOnlyUnion() || SystemStatusCtrolUtils.isStart(null, (SystemEnum)sysEnum, (CompanyOrgUnitInfo)compInfo)) continue;
            msg.append(compInfo.getName());
            msg.append(", ");
        }
        if (msg.length() > 0) {
            msg.delete(msg.length() - 2, msg.length());
        }
        return msg.toString();
    }

    @Override
    protected void comboCussType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1 || this.comboCussType.getItemCount() == 0 || this.comboCussType.getSelectedItem() == null) {
            return;
        }
        AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
        if (typeInfo != null && typeInfo.getDefaultQueryName() != null) {
            this.prmtCussFrom.setEnabled(true);
            this.prmtCussTo.setEnabled(true);
            ArApBillUIUtil.setCompsAsstActSelector((CoreUIObject)this, this.prmtCussFrom, this.prmtCussTo, typeInfo, this.selectedCompInfos, this.sysInfo, this.isExcludeInnerCust());
            if (this.prmtCsspGrp.getValue() == null) {
                ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCussFrom, (Object)typeInfo, this.sysInfo, true, true);
                ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCussTo, (Object)typeInfo, this.sysInfo, false, true);
            }
            ArApQueryUIUtil.setCompsCsspGrpF7((IUIObject)this, this.prmtCsspGrp, typeInfo, this.fSameCu);
        } else {
            this.prmtCsspGrp.setEnabled(false);
            this.prmtCussFrom.setEnabled(false);
            this.prmtCussTo.setEnabled(false);
        }
        this.prmtCsspGrp.setValue(null);
        this.prmtCussFrom.setValue(null);
        this.prmtCussTo.setValue(null);
    }

    @Override
    protected void prmtCsspGrp_dataChanged(DataChangeEvent e) throws Exception {
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
        ArApQueryUIUtil.csspGrpValueChangeProcess((CoreUIObject)this, this.companyId, asstActTypeInfo, this.prmtCsspGrp, this.prmtCussFrom, this.prmtCussTo);
    }

    @Override
    protected void prmtCussFrom_dataChanged(DataChangeEvent e) throws Exception {
        ArApQueryUIUtil.objFromChanged((IUIObject)this, this.prmtCussFrom, this.prmtCussTo);
    }

    protected List getQueryCompanyIds() {
        ArrayList<String> ids = new ArrayList<String>();
        int n = this.selectedCompInfos.size();
        for (int i = 0; i < n; ++i) {
            ids.add(this.selectedCompInfos.get(i).getId().toString());
        }
        return ids;
    }

    protected List getQueryCompanyCuIds() {
        HashSet<String> cuIds = new HashSet<String>();
        int n = this.selectedCompInfos.size();
        for (int i = 0; i < n; ++i) {
            CompanyOrgUnitInfo compInfo = this.selectedCompInfos.get(i);
            if (compInfo.getCU() == null) continue;
            cuIds.add(compInfo.getCU().getId().toString());
        }
        ArrayList<String> cuIdLst = new ArrayList<String>();
        cuIdLst.addAll(cuIds);
        return cuIdLst;
    }

    protected void loadCompanysData(List companyIds) {
        if (companyIds == null || companyIds.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(companyIds), CompareType.INCLUDE));
        try {
            IFullOrgUnit iOrg = FullOrgUnitFactory.getRemoteInstance();
            FullOrgUnitCollection orgs = iOrg.getFullOrgUnitCollection(view);
            this.prmtCompany.setData((Object)orgs.toArray());
        }
        catch (Exception e) {
            logger.error((Object)"exception while get the fullorgInfo", (Throwable)e);
        }
    }

    protected void setCurrCussAcct2RptParam(ArApQueryParam param) {
        ArApQueryUIUtil.saveCurrency(this.comboCurrency, param);
        ArApQueryUIUtil.saveCussType(this.comboCussType, param);
        ArApQueryUIUtil.saveCsspGrp(this.prmtCsspGrp, param);
        ArApQueryUIUtil.saveCussAcctRange(this.prmtCussFrom, this.prmtCussTo, param);
    }

    protected void loadCurrCussAcctData(ArApQueryParam param) {
        ClientUtils.setSelectedItem((KDComboBox)this.comboCurrency, (String)param.getCurrencyId());
        ClientUtils.setSelectedItem((KDComboBox)this.comboCussType, (String)param.getCussTypeId());
        ArApQueryUIUtil.loadCsspGrp(this.prmtCsspGrp, param);
        ArApQueryUIUtil.loadCussAcctRange((IUIObject)this, this.prmtCussFrom, this.prmtCussTo, param);
    }
}

