/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.ctrl.analysis.olap.Member;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.fi.ar.ItemRptQueryParam;
import com.kingdee.eas.fi.ar.SummaryRptQueryParam;
import com.kingdee.eas.fi.arap.client.ArApBiRptBaseUI;
import com.kingdee.eas.fi.arap.client.ArApVirtualRptBaseUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.sql.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class ArApBiSumRptClntHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.client.ArApBiSumRptClntHelper");

    private ArApBiSumRptClntHelper() {
    }

    public static ItemRptQueryParam getItemRptParam(Member[] ms, ArApBiRptBaseUI biRptUI, SummaryRptQueryParam param) throws Exception {
        if (ms == null) {
            logger.debug((Object)"invalid rows, pls select the data cells");
            return null;
        }
        Object objComp = biRptUI.getKeyVal(ms, "Company");
        List compIds = param.getCompanyIds();
        if (objComp == null && compIds != null && compIds.size() > 0) {
            objComp = compIds.get(0);
        }
        Object objCussAcct = biRptUI.getKeyVal(ms, "CussAcct");
        if (objComp == null || StringUtils.isEmpty((String)objComp.toString()) || objCussAcct == null || StringUtils.isEmpty((String)objCussAcct.toString())) {
            logger.error((Object)"invalid row, the company is null or the row is the sum row");
            return null;
        }
        ICompanyOrgUnit iComp = CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo compInfo = iComp.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(objComp.toString()));
        if (compInfo == null || compInfo.isIsOnlyUnion()) {
            String msg = EASResource.getString((String)biRptUI.getResource(), (String)(compInfo == null ? "JoinQry_CompNULL" : "JoinQry_CompNotBeVirtual"));
            biRptUI.setMessageText(msg);
            biRptUI.showMessage();
            logger.debug((Object)"invalid company id or the company is null");
            return null;
        }
        Date beginDate = null;
        Date endDate = null;
        int periodYear = 0;
        int periodNum = 0;
        if (param.isByPeriod()) {
            Object objPeriod = biRptUI.getKeyVal(ms, "Period");
            if (objPeriod == null) {
                logger.debug((Object)"invalid row, period null");
                SysUtil.abort();
            }
            PeriodInfo periodInfo = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(objPeriod.toString()));
            beginDate = new Date(periodInfo.getBeginDate().getTime());
            endDate = new Date(periodInfo.getEndDate().getTime());
            periodYear = periodInfo.getPeriodYear();
            periodNum = periodInfo.getPeriodNumber();
        } else {
            beginDate = param.getBeginDate();
            endDate = param.getEndDate();
        }
        Object objCussType = biRptUI.getKeyVal(ms, "CussType");
        AsstActTypeInfo asstActTypeInfo = null;
        if (objCussType != null) {
            IAsstActType iAsstActType = AsstActTypeFactory.getRemoteInstance();
            asstActTypeInfo = iAsstActType.getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(objCussType.toString()));
        }
        Object objCurr = biRptUI.getKeyVal(ms, "Currency");
        String currencyId = null;
        CurrencyInfo currInfo = null;
        if (objCurr != null) {
            ICurrency iCurr = CurrencyFactory.getRemoteInstance();
            currencyId = objCurr.toString();
            currInfo = iCurr.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        } else {
            currencyId = param.getCurrencyId();
            currInfo = param.getCurrencyInfo();
        }
        IObjectValue cussAcctInfo = null;
        ObjectUuidPK cussAcctPK = new ObjectUuidPK(objCussAcct.toString());
        BOSObjectType objType = cussAcctPK.getObjectType();
        IDynamicObject iDyn = DynamicObjectFactory.getRemoteInstance();
        cussAcctInfo = iDyn.getValue(objType, (IObjectPK)cussAcctPK);
        String cussAcctNum = cussAcctInfo.getString("number");
        String cussAcctName = cussAcctInfo.getString("name");
        ItemRptQueryParam itemRptParam = new ItemRptQueryParam();
        itemRptParam.setCompanyId(compInfo.getId().toString());
        itemRptParam.setCuId(compInfo.getCU().getId().toString());
        itemRptParam.setCussAcctTypeInfo(asstActTypeInfo);
        if (asstActTypeInfo != null) {
            itemRptParam.setCussTable(asstActTypeInfo.getRealtionDataObject());
            itemRptParam.setCussTypeId(asstActTypeInfo.getId().toString());
        }
        itemRptParam.setCussAcctFromNum(cussAcctNum);
        itemRptParam.setCussAcctFromName(cussAcctName);
        itemRptParam.setCussAcctToNum(cussAcctNum);
        itemRptParam.setCussAcctToName(cussAcctName);
        itemRptParam.setCussAcctId(cussAcctInfo.getString("id"));
        itemRptParam.setBeginDate(beginDate);
        itemRptParam.setEndDate(endDate);
        if (param.isByPeriod()) {
            itemRptParam.setStartPeriodYear(periodYear);
            itemRptParam.setStartPeriodNum(periodNum);
            itemRptParam.setEndPeriodYear(periodYear);
            itemRptParam.setEndPeriodNum(periodNum);
        }
        itemRptParam.setCurrencyId(currencyId);
        itemRptParam.setCurrencyInfo(currInfo);
        itemRptParam.setByPeriod(param.isByPeriod());
        itemRptParam.setIsBizZero(param.isBizZero());
        itemRptParam.setIsBalZero(param.isBalZero());
        itemRptParam.setIncludeBizBill(param.isIncludeBizBill());
        itemRptParam.setBizeCheckBox(param.isBizeCheckBox());
        itemRptParam.setBizeIndex(param.getBizeIndex());
        itemRptParam.setIsArRpt(param.isArRpt());
        itemRptParam.setLinkSum(true);
        return itemRptParam;
    }

    public static ItemRptQueryParam getItemRptParam(IRow row, ArApVirtualRptBaseUI biRptUI, SummaryRptQueryParam param) throws Exception {
        if (row == null) {
            logger.debug((Object)"invalid rows, pls select the data cells");
            return null;
        }
        Object objComp = row.getCell("FCompanyId").getValue();
        List compIds = param.getCompanyIds();
        if (objComp == null && compIds != null && compIds.size() > 0) {
            objComp = compIds.get(0);
        }
        Object objCussAcct = row.getCell("FAsstActId").getValue();
        if (objComp == null || StringUtils.isEmpty((String)objComp.toString()) || objCussAcct == null || StringUtils.isEmpty((String)objCussAcct.toString())) {
            logger.error((Object)"invalid row, the company is null or the row is the sum row");
            return null;
        }
        ICompanyOrgUnit iComp = CompanyOrgUnitFactory.getRemoteInstance();
        CompanyOrgUnitInfo compInfo = iComp.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(objComp.toString()));
        if (compInfo == null || compInfo.isIsOnlyUnion()) {
            String msg = EASResource.getString((String)biRptUI.getResource(), (String)(compInfo == null ? "JoinQry_CompNULL" : "JoinQry_CompNotBeVirtual"));
            biRptUI.setMessageText(msg);
            biRptUI.showMessage();
            logger.debug((Object)"invalid company id or the company is null");
            return null;
        }
        Date beginDate = null;
        Date endDate = null;
        int periodYear = 0;
        int periodNum = 0;
        if (param.isByPeriod()) {
            Object objPeriod = row.getCell("FPeriodId").getValue();
            if (objPeriod == null) {
                logger.debug((Object)"invalid row, period null");
                SysUtil.abort();
            }
            PeriodInfo periodInfo = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(objPeriod.toString()));
            beginDate = new Date(periodInfo.getBeginDate().getTime());
            endDate = new Date(periodInfo.getEndDate().getTime());
            periodYear = periodInfo.getPeriodYear();
            periodNum = periodInfo.getPeriodNumber();
        } else {
            beginDate = param.getBeginDate();
            endDate = param.getEndDate();
        }
        Object objCussType = row.getCell("FAsstActTypeId").getValue();
        AsstActTypeInfo asstActTypeInfo = null;
        if (objCussType != null) {
            IAsstActType iAsstActType = AsstActTypeFactory.getRemoteInstance();
            asstActTypeInfo = iAsstActType.getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(objCussType.toString()));
        }
        Object objCurr = row.getCell("FCurrencyId") == null ? null : row.getCell("FCurrencyId").getValue();
        String currencyId = null;
        CurrencyInfo currInfo = null;
        if (objCurr != null) {
            ICurrency iCurr = CurrencyFactory.getRemoteInstance();
            currencyId = objCurr.toString();
            currInfo = iCurr.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
        } else {
            currencyId = param.getCurrencyId();
            currInfo = param.getCurrencyInfo();
        }
        IObjectValue cussAcctInfo = null;
        ObjectUuidPK cussAcctPK = new ObjectUuidPK(objCussAcct.toString());
        BOSObjectType objType = cussAcctPK.getObjectType();
        IDynamicObject iDyn = DynamicObjectFactory.getRemoteInstance();
        cussAcctInfo = iDyn.getValue(objType, (IObjectPK)cussAcctPK);
        String cussAcctNum = cussAcctInfo.getString("number");
        String cussAcctName = cussAcctInfo.getString("name");
        ItemRptQueryParam itemRptParam = new ItemRptQueryParam();
        itemRptParam.setCompanyId(compInfo.getId().toString());
        itemRptParam.setCuId(compInfo.getCU().getId().toString());
        itemRptParam.setCussAcctTypeInfo(asstActTypeInfo);
        if (asstActTypeInfo != null) {
            itemRptParam.setCussTable(asstActTypeInfo.getRealtionDataObject());
            itemRptParam.setCussTypeId(asstActTypeInfo.getId().toString());
        }
        itemRptParam.setCussAcctFromNum(cussAcctNum);
        itemRptParam.setCussAcctFromName(cussAcctName);
        itemRptParam.setCussAcctToNum(cussAcctNum);
        itemRptParam.setCussAcctToName(cussAcctName);
        itemRptParam.setCussAcctId(cussAcctInfo.getString("id"));
        itemRptParam.setBeginDate(beginDate);
        itemRptParam.setEndDate(endDate);
        if (param.isByPeriod()) {
            itemRptParam.setStartPeriodYear(periodYear);
            itemRptParam.setStartPeriodNum(periodNum);
            itemRptParam.setEndPeriodYear(periodYear);
            itemRptParam.setEndPeriodNum(periodNum);
        }
        itemRptParam.setCurrencyId(currencyId);
        itemRptParam.setCurrencyInfo(currInfo);
        itemRptParam.setByPeriod(param.isByPeriod());
        itemRptParam.setIsBizZero(param.isBizZero());
        itemRptParam.setIsBalZero(param.isBalZero());
        itemRptParam.setIncludeBizBill(param.isIncludeBizBill());
        itemRptParam.setIncludeBizIndex(param.getIncludeBizIndex());
        itemRptParam.setBizeCheckBox(param.isBizeCheckBox());
        itemRptParam.setBizeIndex(param.getBizeIndex());
        itemRptParam.setIsArRpt(param.isArRpt());
        itemRptParam.setLinkSum(true);
        return itemRptParam;
    }
}

