/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.SCMRptMultiOrgsF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.ArApQueryParam;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.DbUtilFacadeFactory;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.client.AbstractArApVirtualRptBaseQueryUI;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApQueryUIUtil;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class ArApVirtualRptBaseQueryUI
extends AbstractArApVirtualRptBaseQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(ArApVirtualRptBaseQueryUI.class);
    protected static final String RES = "com.kingdee.eas.fi.ar.ArReport";
    protected boolean isArRpt = true;
    protected CompanyOrgUnitInfo currentCompany = null;
    protected String companyId = "";
    protected transient Object[] selectedComps = null;
    protected transient CompanyOrgUnitCollection selectedCompInfos = null;
    protected transient ArApSysParamInfo sysInfo = null;
    protected transient HashMap map = new HashMap();
    protected transient IArApBillFacade iBillFacade = null;
    protected transient IObjectPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
    protected boolean fSameCu = false;
    protected transient Object[] defaultCompArr = null;
    protected transient SCMRptMultiOrgsF7 compF7 = null;
    private int defaultCussTypeInd = 0;
    private int defaultCurrencyInd = 0;
    public static final String CRTL = " \r\n ";

    public ArApVirtualRptBaseQueryUI() throws Exception {
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.initCtrls();
        super.onLoad();
    }

    protected boolean isArRpt() {
        return this.isArRpt;
    }

    protected void initCompanysF7() throws Exception {
        this.companyId = this.currentCompany.getId().toString();
        FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
        orgInfo.setId(this.currentCompany.getId());
        orgInfo.setName(this.currentCompany.getName());
        orgInfo.setNumber(this.currentCompany.getNumber());
        this.defaultCompArr = new Object[]{orgInfo};
        this.selectedCompInfos = ArApQueryUIUtil.getFullPermCompany(this.userPK, this.defaultCompArr, this.getPermissionItem());
        this.setRealValueForCompanyF7(true);
    }

    protected void setRealValueForCompanyF7(boolean isNotify) {
        Object[] currentCompArr = null;
        if (this.selectedCompInfos != null) {
            currentCompArr = new Object[this.selectedCompInfos.size()];
            int n = this.selectedCompInfos.size();
            for (int i = 0; i < n; ++i) {
                CompanyOrgUnitInfo compInfo = this.selectedCompInfos.get(i);
                FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
                orgInfo.setId(compInfo.getId());
                orgInfo.setName(compInfo.getName());
                orgInfo.setNumber(compInfo.getNumber());
                currentCompArr[i] = orgInfo;
            }
            this.selectedComps = currentCompArr;
        }
        if (currentCompArr != null && currentCompArr.length > 0) {
            if (isNotify) {
                this.prmtCompany.setValue((Object)currentCompArr);
            } else {
                this.prmtCompany.setDataNoNotify((Object)currentCompArr);
            }
        } else {
            this.prmtCompany.setValue(null);
        }
    }

    protected String getPermissionItem() {
        return null;
    }

    protected void getSysParams() throws EASBizException, BOSException {
        this.map.put("isSCM", Boolean.FALSE);
        this.map.put("sysEnum", this.isArRpt() ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE);
        this.map.put("permissionItem", this.getPermissionItem());
        this.sysInfo = this.iBillFacade.getSysParams(null, this.map);
    }

    private void setAsstActType() throws EASBizException, BOSException {
        this.getSysParams();
        ArApBillUIUtil.makeAsstActType(this.comboCussType, this.sysInfo, false);
    }

    protected void initCtrls() throws Exception {
        this.getSysParams();
        this.currentCompany = this.sysInfo.getCompany();
        String title = EASResource.getString((String)"com.kingdee.eas.fi.arap.ArApRptResource", (String)"CompanysSelection");
        String permItem = this.getPermissionItem();
        this.compF7 = new SCMRptMultiOrgsF7(this.prmtCompany, OrgType.Company, permItem, title);
        this.initCompanysF7();
        ClientUtils.setCurrencyList((KDComboBox)this.comboCurrency, (boolean)true);
        ClientUtils.setSelectedItem((KDComboBox)this.comboCurrency, (String)this.currentCompany.getBaseCurrency().getId().toString());
        this.comboCussType.setRequired(true);
        this.defaultCurrencyInd = this.comboCurrency.getSelectedIndex();
        this.defaultCussTypeInd = this.comboCussType.getSelectedIndex();
    }

    protected boolean isExcludeInnerCust() {
        return false;
    }

    public void clear() {
        this.prmtCompany.setValue((Object)this.defaultCompArr);
        if (this.comboCussType.getItemCount() > 0 && this.defaultCussTypeInd > -1) {
            this.comboCussType.setSelectedIndex(this.defaultCussTypeInd);
        }
        if (this.comboCurrency.getItemCount() > 0 && this.defaultCurrencyInd > -1) {
            this.comboCurrency.setSelectedIndex(this.defaultCurrencyInd);
        }
        this.prmtCsspGrp.setValue(null);
        this.prmtCussFrom.setData(null);
        this.prmtCussTo.setData(null);
    }

    protected String getPermissionRes() {
        return null;
    }

    public boolean verify() {
        List requiredCtrls;
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"Company_Not_Null"));
            return false;
        }
        if (this.isNeedCompanyStart()) {
            try {
                String notStartComps = this.getNotStartCompanys();
                if (!StringUtils.isEmpty((String)notStartComps)) {
                    String msgPattern = EASResource.getString((String)RES, (String)"companysNotStarted");
                    String sys = this.isArRpt() ? SystemEnum.ACCOUNTSRECEIVABLE.getAlias() : SystemEnum.ACCOUNTSPAYABLE.getAlias();
                    String msg = MessageFormat.format(msgPattern, sys, notStartComps);
                    MsgBox.showInfo((Component)((Object)this), (String)msg);
                    return false;
                }
            }
            catch (Exception e) {
                logger.error((Object)"exception, check the companys status", (Throwable)e);
                SysUtil.abort();
            }
        }
        if ((requiredCtrls = this.getRequiredCtrls()) == null || requiredCtrls.size() == 0) {
            return true;
        }
        String msgPattern = EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"QryUI_MustHave");
        int n = requiredCtrls.size();
        for (int i = 0; i < n; ++i) {
            Component obj = (Component)requiredCtrls.get(i);
            if (obj instanceof KDComboBox) {
                if (((KDComboBox)obj).getSelectedItem() != null) continue;
                this.showWarningMsg(msgPattern, obj);
                return false;
            }
            if (!(obj instanceof KDDatePicker) || ((KDDatePicker)obj).getValue() != null) continue;
            this.showWarningMsg(msgPattern, obj);
            return false;
        }
        return true;
    }

    protected boolean isNeedCompanyStart() {
        return true;
    }

    protected List getRequiredCtrls() {
        ArrayList<KDComboBox> lst = new ArrayList<KDComboBox>();
        lst.add(this.comboCussType);
        lst.add(this.comboCurrency);
        return lst;
    }

    private void showWarningMsg(String msgPattern, Component obj) {
        String lbl = this.getCtrlWarningLabel(obj);
        String msg = MessageFormat.format(msgPattern, lbl);
        MsgBox.showWarning((Component)((Object)this), (String)msg);
    }

    protected String getCtrlWarningLabel(Component obj) {
        String lbl = null;
        lbl = obj.getParent() instanceof KDLabelContainer ? ((KDLabelContainer)obj.getParent()).getBoundLabelText() : obj.getName();
        return lbl;
    }

    protected String getNotStartCompanys() throws BOSException, EASBizException {
        CompanyOrgUnitCollection notStartCompanys;
        ArrayList<String> ids = new ArrayList<String>(50);
        if (null != this.selectedCompInfos && this.selectedCompInfos.size() > 0) {
            int n = this.selectedCompInfos.size();
            for (int i = 0; i < n; ++i) {
                ids.add(this.selectedCompInfos.get(i).getId().toString());
            }
        }
        Object obj = this.prmtCompany.getValue();
        if (ids.size() == 0 && null != obj && obj instanceof Object[]) {
            Object[] orgArr = (Object[])obj;
            int n = orgArr.length;
            for (int i = 0; i < n; ++i) {
                ids.add(((FullOrgUnitInfo)orgArr[i]).getId().toString());
            }
        }
        if (null == (notStartCompanys = this.getNotStartCompanyOrgUnit(ids))) {
            return null;
        }
        StringBuilder msg = new StringBuilder(notStartCompanys.size() * 255);
        for (int i = 0; i < notStartCompanys.size(); ++i) {
            if (i != 0) {
                msg.append(", ");
            }
            msg.append(notStartCompanys.get(i).getName());
        }
        return msg.toString();
    }

    @Override
    protected void comboCussType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1 || this.comboCussType.getItemCount() == 0 || this.comboCussType.getSelectedItem() == null) {
            return;
        }
        this.setAsstAndGroupF7();
    }

    protected void setAsstAndGroupF7() throws Exception {
        AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
        if (typeInfo != null && typeInfo.getDefaultQueryName() != null) {
            this.prmtCussFrom.setEnabled(true);
            this.prmtCussTo.setEnabled(true);
            ArApBillUIUtil.setCompsAsstActSelector((CoreUIObject)this, this.prmtCussFrom, this.prmtCussTo, typeInfo, this.selectedCompInfos, this.sysInfo, this.isExcludeInnerCust());
            ArApQueryUIUtil.setCompsCsspGrpF7((IUIObject)this, this.prmtCsspGrp, typeInfo, true);
        } else {
            this.prmtCsspGrp.setEnabled(false);
            this.prmtCussFrom.setEnabled(false);
            this.prmtCussTo.setEnabled(false);
        }
        this.prmtCsspGrp.setValue(null);
        this.prmtCussFrom.setValue(null);
        this.prmtCussTo.setValue(null);
    }

    @Override
    protected void prmtCsspGrp_dataChanged(DataChangeEvent e) throws Exception {
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.comboCussType.getSelectedItem();
        ArApQueryUIUtil.csspGrpValueChangeProcess((CoreUIObject)this, this.companyId, asstActTypeInfo, this.prmtCsspGrp, this.prmtCussFrom, this.prmtCussTo);
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitCollection comps;
        if (this.compF7 == null || this.compF7.getFullData() == null) {
            return;
        }
        Object[] oldComps = this.selectedComps;
        this.selectedComps = (Object[])this.compF7.getFullData();
        if (oldComps != null && Arrays.equals(oldComps, this.selectedComps)) {
            return;
        }
        this.selectedCompInfos = comps = ArApQueryUIUtil.getFullPermCompany(this.userPK, this.selectedComps, this.getPermissionItem());
        if (comps == null || comps.size() == 0) {
            this.prmtCompany.setValue(null);
            this.prmtCsspGrp.setEnabled(false);
            this.prmtCussFrom.setEnabled(false);
            this.prmtCussTo.setEnabled(false);
            return;
        }
        this.filterNotStartCompanys();
        Boolean isAllVirtualOrg = true;
        if (this.selectedCompInfos != null) {
            for (int i = 0; i < this.selectedCompInfos.size(); ++i) {
                if (!this.selectedCompInfos.get(i).isIsBizUnit()) continue;
                isAllVirtualOrg = false;
                break;
            }
        }
        if (isAllVirtualOrg.booleanValue()) {
            this.prmtCompany.setValue(null);
            this.prmtCsspGrp.setEnabled(false);
            this.prmtCussFrom.setEnabled(false);
            this.prmtCussTo.setEnabled(false);
            return;
        }
        HashSet<BOSUuid> companyIds = new HashSet<BOSUuid>();
        int n = comps.size();
        for (int i = 0; i < n; ++i) {
            CompanyOrgUnitInfo compInfo = comps.get(i);
            if (!compInfo.isIsBizUnit()) continue;
            companyIds.add(compInfo.getId());
        }
        this.fSameCu = companyIds.size() == 1;
        this.setAsstActType();
        this.setAsstAndGroupF7();
    }

    protected void filterNotStartCompanys() throws BOSException {
        ArrayList<String> checkCompanyIds = new ArrayList<String>(this.selectedCompInfos.size());
        int n = this.selectedCompInfos.size();
        for (int i = 0; i < n; ++i) {
            CompanyOrgUnitInfo compInfo = this.selectedCompInfos.get(i);
            String companyId = compInfo.getId().toString();
            if (!compInfo.isIsBizUnit() || compInfo.isIsCU()) continue;
            checkCompanyIds.add(companyId);
        }
        if (checkCompanyIds.size() > 0) {
            CompanyOrgUnitCollection notSartCompanys = this.getNotStartCompanyOrgUnit(checkCompanyIds);
            block1: for (int i = 0; i < notSartCompanys.size(); ++i) {
                for (int j = 0; j < this.selectedCompInfos.size(); ++j) {
                    if (!this.selectedCompInfos.get(j).getId().equals((Object)notSartCompanys.get(i).getId())) continue;
                    this.selectedCompInfos.removeObject(j);
                    continue block1;
                }
            }
        }
        this.setRealValueForCompanyF7(false);
    }

    public static String convertIds2SqlString(ArrayList<String> ids) {
        if (null == ids || ids.size() == 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder(ids.size() * 45);
        for (int i = 0; i < ids.size(); ++i) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append("'").append(ids.get(i)).append("'");
        }
        return buf.toString();
    }

    protected CompanyOrgUnitCollection getNotStartCompanyOrgUnit(ArrayList<String> ids) throws BOSException {
        if (null == ids || ids.size() == 0) {
            return null;
        }
        int system = this.isArRpt() ? 12 : 13;
        StringBuilder buf = new StringBuilder(200);
        buf.append("SELECT DISTINCT COMPANY.FID FID, COMPANY.FNAME_").append(this.getCurrentLocale()).append(" FNAME").append(CRTL).append("  FROM T_BD_SYSTEMSTATUSCTROL SYSTEMSTATUSCTROL ").append(CRTL).append("  INNER JOIN T_BD_SYSTEMSTATUS SYSTEMSTATUS ").append(CRTL).append("        ON SYSTEMSTATUSCTROL.FSYSTEMSTATUSID = SYSTEMSTATUS.FID ").append(CRTL).append("  INNER JOIN T_ORG_COMPANY COMPANY ").append(CRTL).append("        ON SYSTEMSTATUSCTROL.FCOMPANYID = COMPANY.FID ").append(CRTL).append("  WHERE COMPANY.FISONLYUNION = 0 ").append(CRTL).append("  AND SYSTEMSTATUSCTROL.FISSTART = 0 ").append(CRTL).append("  AND SYSTEMSTATUS.FNAME = ").append(system).append(CRTL);
        String sqlIdStr = ArApVirtualRptBaseQueryUI.convertIds2SqlString(ids);
        if (!StringUtils.isEmpty((String)sqlIdStr)) {
            buf.append(" AND SYSTEMSTATUSCTROL.FCOMPANYID in (").append(sqlIdStr).append(")");
        }
        IRowSet rs = DbUtilFacadeFactory.getRemoteInstance().executeQuery(buf.toString());
        CompanyOrgUnitCollection col = new CompanyOrgUnitCollection();
        try {
            while (rs.next()) {
                CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                company.setId(BOSUuid.read((String)rs.getString("FID")));
                company.setName(rs.getString("FNAME"));
                col.add(company);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return col;
    }

    @Override
    protected void prmtCussFrom_dataChanged(DataChangeEvent e) throws Exception {
        ArApQueryUIUtil.objFromChanged((IUIObject)this, this.prmtCussFrom, this.prmtCussTo);
        if (this.prmtCussTo.getValue() instanceof Object[]) {
            this.prmtCussTo.setEnabled(false);
        }
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        return null;
    }

    public void setCustomCondition(RptParams params) {
    }

    protected List getQueryCompanyIds() {
        ArrayList<String> ids = new ArrayList<String>();
        int n = this.selectedCompInfos.size();
        for (int i = 0; i < n; ++i) {
            ids.add(this.selectedCompInfos.get(i).getId().toString());
        }
        return ids;
    }

    protected List getQueryCompanyCuIds() {
        HashSet<String> cuIds = new HashSet<String>();
        int n = this.selectedCompInfos.size();
        for (int i = 0; i < n; ++i) {
            CompanyOrgUnitInfo compInfo = this.selectedCompInfos.get(i);
            if (compInfo.getCU() == null) continue;
            cuIds.add(compInfo.getCU().getId().toString());
        }
        ArrayList<String> cuIdLst = new ArrayList<String>();
        cuIdLst.addAll(cuIds);
        return cuIdLst;
    }

    protected void loadCompanysData(List companyIds) {
        if (companyIds == null || companyIds.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(companyIds), CompareType.INCLUDE));
        try {
            IFullOrgUnit iOrg = FullOrgUnitFactory.getRemoteInstance();
            FullOrgUnitCollection orgs = iOrg.getFullOrgUnitCollection(view);
            this.prmtCompany.setData((Object)orgs.toArray());
        }
        catch (Exception e) {
            logger.error((Object)"exception while get the fullorgInfo", (Throwable)e);
        }
    }

    protected void setCurrCussAcct2RptParam(ArApQueryParam param) {
        ArApQueryUIUtil.saveCurrency(this.comboCurrency, param);
        ArApQueryUIUtil.saveCussType(this.comboCussType, param);
        ArApQueryUIUtil.saveCsspGrp(this.prmtCsspGrp, param);
        ArApQueryUIUtil.saveCussAcctRange(this.prmtCussFrom, this.prmtCussTo, param);
    }

    protected void setCurrCussAcct2RptParamCopy(ArApQueryParam param) {
        ArApQueryUIUtil.saveCussType(this.comboCussType, param);
        ArApQueryUIUtil.saveCsspGrp(this.prmtCsspGrp, param);
        ArApQueryUIUtil.saveCussAcctRange(this.prmtCussFrom, this.prmtCussTo, param);
    }

    protected void loadCurrCussAcctData(ArApQueryParam param) {
        ClientUtils.setSelectedItem((KDComboBox)this.comboCurrency, (String)param.getCurrencyId());
        ClientUtils.setSelectedItem((KDComboBox)this.comboCussType, (String)param.getCussTypeId());
        ArApQueryUIUtil.loadCsspGrp(this.prmtCsspGrp, param);
        ArApQueryUIUtil.loadCussAcctRange((IUIObject)this, this.prmtCussFrom, this.prmtCussTo, param);
    }
}

