/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.ar.InitDataInputARFactory;
import com.kingdee.eas.fi.arap.client.AbstractAsstActUpdateUI;
import com.kingdee.eas.fi.arap.client.ArApCompanyF7;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class AsstActUpdateUI
extends AbstractAsstActUpdateUI {
    private static final Logger logger = CoreUIObject.getLogger(AsstActUpdateUI.class);
    boolean isSuccess = false;
    HashMap param = new HashMap();
    private SelectorListener prmtAsstActSelectorListener;

    @Override
    protected void prmtCompanyOrgUnit_dataChanged(DataChangeEvent e) throws Exception {
        CompanyOrgUnitCollection company = new CompanyOrgUnitCollection();
        Object obj = e.getNewValue();
        if (obj instanceof CompanyOrgUnitInfo) {
            company.add((CompanyOrgUnitInfo)obj);
        } else if (obj instanceof Object[]) {
            Object[] companyArr = (Object[])e.getNewValue();
            for (int i = 0; i < companyArr.length; ++i) {
                company.add((CompanyOrgUnitInfo)companyArr[i]);
            }
        }
        this.fillAsstActType(company);
    }

    @Override
    protected void kdComAsstActType_itemStateChanged(ItemEvent e) throws Exception {
        if ("".equals(e.getItem())) {
            this.prmtAsstAct.setEnabled(false);
        } else {
            this.prmtAsstAct.setEnabled(true);
            this.prmtAsstAct.setEnabledMultiSelection(true);
        }
    }

    public void onLoad() {
        Map uiCtx = this.getUIContext();
        CompanyOrgUnitInfo currentCompany = (CompanyOrgUnitInfo)uiCtx.get("company");
        CompanyOrgUnitCollection companyOrgUnitCollection = new CompanyOrgUnitCollection();
        companyOrgUnitCollection.add(currentCompany);
        try {
            this.fillAsstActType(companyOrgUnitCollection);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.prmtCompany.setValue((Object)new CompanyOrgUnitInfo[]{currentCompany});
        if (this.prmtAsstActSelectorListener == null) {
            this.prmtAsstActSelectorListener = new SelectorListener(){

                public void willShow(SelectorEvent e) {
                    try {
                        AsstActUpdateUI.this.prmtAsstAct_willShow(e);
                    }
                    catch (Exception exc) {
                        AsstActUpdateUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtAsstAct.addSelectorListener(this.prmtAsstActSelectorListener);
        this.prmtAsstAct.setEditable(false);
        this.initCompanyOrgUnitF7();
    }

    private void initCompanyOrgUnitF7() {
        ArApCompanyF7 companyF7 = new ArApCompanyF7();
        companyF7.setSynCheck(true);
        companyF7.setMultiSelect(true);
        companyF7.setRootUnitID("11111111-1111-1111-1111-111111111111CCE7AED4");
        this.prmtCompany.setSelector((KDPromptSelector)companyF7);
    }

    private void prmtAsstAct_willShow(SelectorEvent e) {
        CompanyOrgUnitInfo selectCompany;
        AsstActTypeInfo asstActTypeInfo = (AsstActTypeInfo)this.cbAsstActType.getSelectedItem();
        FilterItemInfo groupStandFilter = null;
        if ("t_bd_customer".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            this.prmtAsstAct.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7CustomerCompanyQuery");
            groupStandFilter = new FilterItemInfo("customerGroupStandard.isBasic", (Object)1, CompareType.EQUALS);
        } else if ("t_bd_supplier".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            this.prmtAsstAct.setQueryInfo("com.kingdee.eas.basedata.master.cssp.app.F7SupplierCompanyQuery");
            groupStandFilter = new FilterItemInfo("supplierGroupStandard.isBasic", (Object)1, CompareType.EQUALS);
        } else if ("t_bd_material".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            this.prmtAsstAct.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialFIQuery");
        } else {
            this.prmtAsstAct.setQueryInfo(asstActTypeInfo.getDefaultQueryName());
        }
        HashSet<String> companyIds = new HashSet<String>();
        if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo) {
            selectCompany = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
            companyIds.add(selectCompany.getId().toString());
        } else if (this.prmtCompany.getValue() instanceof Object[]) {
            Object[] obj = (Object[])this.prmtCompany.getValue();
            for (int i = 0; i < obj.length; ++i) {
                selectCompany = (CompanyOrgUnitInfo)obj[i];
                companyIds.add(selectCompany.getId().toString());
            }
        }
        String dataObject = asstActTypeInfo.getRealtionDataObject();
        if (companyIds.size() > 0) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            if ("t_bd_material".equalsIgnoreCase(dataObject)) {
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", companyIds, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
                filter.setMaskString("#0 AND #1");
            } else if ("t_bd_supplier".equalsIgnoreCase(dataObject) || "t_bd_customer".equalsIgnoreCase(dataObject)) {
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", companyIds, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1, CompareType.EQUALS));
                filter.setMaskString("#0 AND #1");
            }
            if (null != groupStandFilter) {
                filter.getFilterItems().add(groupStandFilter);
                filter.setMaskString(filter.getMaskString() + " AND #" + (filter.getFilterItems().size() - 1));
            }
            ev.setFilter(filter);
            this.prmtAsstAct.setEntityViewInfo(ev);
            this.prmtAsstAct.getQueryAgent().resetRuntimeEntityView();
        }
    }

    @Override
    public void actionUpdateAsstAct_actionPerformed(ActionEvent e) throws Exception {
        KDDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        dialog = win instanceof KDDialog ? (KDDialog)win : new KDDialog();
        LongTimeDialog ltd = new LongTimeDialog((Dialog)dialog);
        ltd.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                AsstActUpdateUI.this.isSuccess = true;
                HashMap<String, Object> param = new HashMap<String, Object>();
                HashSet<String> companyIdSet = new HashSet<String>();
                Object[] obj = (Object[])AsstActUpdateUI.this.prmtCompany.getValue();
                if (obj != null) {
                    for (int i = 0; i < obj.length; ++i) {
                        if (obj[i] == null) continue;
                        companyIdSet.add(((CompanyOrgUnitInfo)obj[i]).getId().toString());
                    }
                }
                HashSet<String> asstActIdSet = new HashSet<String>();
                obj = (Object[])AsstActUpdateUI.this.prmtAsstAct.getValue();
                if (obj != null) {
                    for (int i = 0; i < obj.length; ++i) {
                        if (obj[i] == null) continue;
                        asstActIdSet.add(((CoreBaseInfo)obj[i]).getId().toString());
                    }
                }
                param.put("company", companyIdSet);
                param.put("asstActType", AsstActUpdateUI.this.cbAsstActType.getSelectedItem());
                param.put("asstAct", asstActIdSet);
                AsstActUpdateUI.this.isSuccess = InitDataInputARFactory.getRemoteInstance().updateAssAct(param);
                return Boolean.TRUE;
            }

            public void afterExec(Object arg0) throws Exception {
                if (AsstActUpdateUI.this.isSuccess) {
                    MsgBox.showInfo(null, (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"updateAsstActFinished"));
                }
            }
        });
        ltd.show();
    }

    @Override
    public void actionExit_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    protected void fillAsstActType(CompanyOrgUnitCollection company) throws BOSException {
        HashSet<BOSUuid> companyIds = new HashSet<BOSUuid>();
        for (int i = 0; i < company.size(); ++i) {
            companyIds.add(company.get(i).getId());
        }
        AsstActTypeCollection asstActType = ArApBillUtil.getDefaultAsstActTypeColl(null, companyIds);
        this.cbAsstActType.removeAllItems();
        this.cbAsstActType.addItem((Object)"");
        for (int i = 0; i < asstActType.size(); ++i) {
            this.cbAsstActType.addItem((Object)asstActType.get(i));
        }
        this.prmtAsstAct.setEnabled(false);
    }
}

