/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.client.AtTermCreditRightConditionUI;
import com.kingdee.eas.fi.ar.client.PrintExtVarProvider;
import com.kingdee.eas.fi.arap.AtTermRptFacadeFactory;
import com.kingdee.eas.fi.arap.IAtTermRptFacade;
import com.kingdee.eas.fi.arap.client.AbstractAtTermCreditBaseRptUI;
import com.kingdee.eas.fi.arap.client.KDTableUtils;
import com.kingdee.eas.fi.arap.client.MultiPrint;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.client.util.TablePrintUtil;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.gl.common.print.IRequestTableData;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.DefaultKDTableInsertHandler;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AtTermCreditBaseRptUI
extends AbstractAtTermCreditBaseRptUI
implements IRequestTableData {
    private static final Logger logger = CoreUIObject.getLogger(AtTermCreditBaseRptUI.class);
    private boolean firstLoadData = true;
    protected boolean isAR = true;
    private ExtVarProvider printVarProvider = null;
    private ForPrintClass currentAcct = null;
    protected boolean isAsynchronism = true;

    public AtTermCreditBaseRptUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getColumn("currency").setGroup(true);
        this.tblMain.getColumn("currency").setMergeable(true);
        this.tblMain.getColumn("asstType").setGroup(true);
        this.tblMain.getColumn("asstType").setMergeable(true);
        this.tblMain.getColumn("asstActNumber").setGroup(true);
        this.tblMain.getColumn("asstActNumber").setMergeable(true);
        this.tblMain.getColumn("asstNum").setGroup(true);
        this.tblMain.getColumn("asstNum").setMergeable(true);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        this.enableExportExcel(this.tblMain);
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return AtTermRptFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected RptParams getParamsForInit() {
        RptParams initParam = new RptParams();
        return initParam;
    }

    protected void query() {
        this.tblMain.removeRows();
    }

    public void getData(KDTDataRequestEvent e) {
        this.tblMain.getDataRequestManager().removeDataRequestListener((KDTDataRequestListener)this);
        int from = e.getFirstRow();
        int len = e.getLastRow() - from + 1;
        RptParams para = this.params;
        try {
            ICommRptBase iRptBase = this.getRemoteInstance();
            if (from == 0 && this.firstLoadData) {
                this.prepareRptParams(para);
                RptParams rp = iRptBase.createTempTable(para);
                this.setTempTable(rp.getString("tempTable"));
            }
            para.setBoolean("firstLoadData", this.firstLoadData);
            para.setString("tempTable", this.getTempTable());
            RptParams rpt = iRptBase.query(para, from, len);
            if (rpt == null) {
                return;
            }
            RptRowSet rs = (RptRowSet)rpt.getObject("rowset");
            if (this.firstLoadData) {
                this.tblMain.setRowCount(rpt.getInt("totalRowCount"));
            }
            KDTableUtils.insertRows(rs, from, this.tblMain, true, (KDTableInsertHandler)new DefaultKDTableInsertHandler(rs));
            IRow row = null;
            Color sumColor = new Color(15789529);
            Map currencyFormat = (Map)para.getObject("currencyFormat");
            Date celValue = null;
            for (int i = e.getFirstRow(); i <= e.getLastRow(); ++i) {
                row = this.tblMain.getRow(i);
                if (row == null) continue;
                if (row.getCell("billID").getValue() == null) {
                    row.getStyleAttributes().setBackground(sumColor);
                    row.getCell("overDueDays").setValue(null);
                    row.getCell("unOverDueDays").setValue(null);
                }
                if (currencyFormat != null) {
                    row.getCell("recPayAmount").getStyleAttributes().setNumberFormat(String.valueOf(currencyFormat.get(row.getCell("currency").getValue())));
                    row.getCell("initAmount").getStyleAttributes().setNumberFormat(String.valueOf(currencyFormat.get(row.getCell("currency").getValue())));
                }
                if (row.getCell("billDate").getValue() != null && row.getCell("billDate").getValue() instanceof Timestamp) {
                    celValue = TypeConversionUtils.objToDate((Object)row.getCell("billDate").getValue());
                    row.getCell("billDate").setValue((Object)celValue);
                }
                if (row.getCell("recPayDate").getValue() == null || !(row.getCell("recPayDate").getValue() instanceof Timestamp)) continue;
                celValue = TypeConversionUtils.objToDate((Object)row.getCell("recPayDate").getValue());
                row.getCell("recPayDate").setValue((Object)celValue);
            }
            if (this.firstLoadData) {
                this.tblMain.getGroupManager().group();
            }
            this.firstLoadData = false;
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
    }

    private void prepareRptParams(RptParams para) {
        para.setBoolean("isAR", this.isAR);
        para.setObject("billDateFrom", this.params.getObject("billDateFrom"));
        para.setObject("billDateTo", this.params.getObject("billDateTo"));
        para.setObject("calDate", this.params.getObject("calDate"));
        para.setBoolean("isIncludeUndue", this.params.getBoolean("isIncludeUndue"));
        if (this.params.getBoolean("isIncludeUndue")) {
            para.setObject("aheadDays", this.params.getObject("aheadDays"));
            this.tblMain.getColumn("unOverDueDays").getStyleAttributes().setHided(false);
        } else {
            this.tblMain.getColumn("unOverDueDays").getStyleAttributes().setHided(true);
        }
        para.setBoolean("isIncludeNegtive", this.params.getBoolean("isIncludeNegtive"));
        para.setString("company", this.params.getString("company"));
        para.setString("cu", this.params.getString("cu"));
        Object t = this.params.getObject("asstType");
        if (t != null) {
            para.setString("asstTypeId", t.toString());
        } else {
            para.setString("asstTypeId", null);
        }
        t = this.params.getObject("csspGrp");
        if (t != null) {
            para.setString("csspGrpId", t.toString());
        } else {
            para.setString("csspGrpId", null);
        }
        if (this.currentAcct != null) {
            para.setString("asstActId", this.currentAcct.acctNumber);
            para.setString("currency", this.currentAcct.currencyID);
        } else {
            t = this.params.getObject("currency");
            if (t != null) {
                para.setString("currency", t.toString());
            }
            if ((t = this.params.getObject("asstFrom")) != null) {
                if (!(t instanceof Object[])) {
                    para.setString("asstFromNumber", (String)para.getObject("asstFromNumber"));
                }
                t = this.params.getObject("asstTo");
                if (t != null) {
                    para.setString("asstToNumber", (String)para.getObject("asstToNumber"));
                }
            }
        }
        t = this.params.getObject("deptFrom");
        if (t != null) {
            para.setString("deptFrom", (String)para.getObject("deptFromNumber"));
        }
        if ((t = this.params.getObject("deptTo")) != null) {
            para.setString("deptTo", (String)para.getObject("deptToNumber"));
        }
        if ((t = this.params.getObject("personFrom")) != null) {
            para.setString("personFrom", (String)para.getObject("personFromNumber"));
        }
        if ((t = this.params.getObject("personTo")) != null) {
            para.setString("personTo", (String)para.getObject("personToNumber"));
        }
        if ((t = this.params.getObject("billNumFrom")) != null) {
            para.setString("billNumFrom", (String)para.getObject("billNumFromNumber"));
        }
        if ((t = this.params.getObject("billNumTo")) != null) {
            para.setString("billNumTo", (String)para.getObject("billNumToNumber"));
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        super.actionRefresh_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        this.firstLoadData = true;
        super.actionQuery_actionPerformed(e);
    }

    @Override
    public void actionViewBill_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.size() <= 0) {
            return;
        }
        IRow row = this.tblMain.getRow(selectBlock.getTop());
        Object billId = row.getCell("billID").getValue();
        if (billId != null) {
            String uiClass = this.getViewBillUIName();
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"ID", billId);
            RealModeIDList idList = new RealModeIDList();
            idList.add(1, billId.toString());
            uiContext.put((Object)"IDList", (Object)idList);
            IUIWindow popUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(uiClass, (Map)uiContext, null, OprtState.VIEW);
            popUI.show();
        }
    }

    protected String getViewBillUIName() {
        return null;
    }

    protected String getQueryDialogTitle(CustomerQueryPanel[] userPanels) {
        return this.getUITitle() + " - " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Query_Filter");
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return new AtTermCreditRightConditionUI(this.isAR);
    }

    protected Dimension getQueryDialogSize(CustomerQueryPanel[] userPanels) {
        return new Dimension(500, 310);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    protected void printTbl(boolean preview) throws Exception {
        if (this.tblMain == null) {
            return;
        }
        String currency = this.params.getString("currency");
        String logMsg = ArApReportUIUtil.getPrintLogMsg(this.getUITitle(), preview);
        IObjectPK pkOut = LogUtil.beginLog(null, (String)logMsg, (BOSObjectType)this.getRemoteInstance().getType(), null, (String)logMsg);
        MultiPrint mp = new MultiPrint((Component)((Object)this));
        if (!mp.showPrintOption()) {
            return;
        }
        this.preparePrintPage(this.tblMain);
        mp.getMultiPrintModel().setTable(this.tblMain);
        this.prepareTblPrintVarMap(mp);
        if (preview) {
            mp.preview();
        } else {
            mp.print();
        }
        this.currentAcct = null;
        this.params.remove("asstActId");
        this.params.remove("currency");
        if (currency != null) {
            this.params.setString("currency", currency);
        }
        this.firstLoadData = true;
        this.query();
        LogUtil.afterLog(null, (IObjectPK)pkOut);
    }

    protected ArrayList getPrintGroups() {
        ArrayList<ForPrintClass> printGroups = new ArrayList<ForPrintClass>();
        RptParams para = new RptParams();
        this.prepareRptParams(para);
        para.setString("tempTable", this.getTempTable());
        try {
            IAtTermRptFacade facade = (IAtTermRptFacade)this.getRemoteInstance();
            RptRowSet rrs = facade.getPrintGroups(para);
            ForPrintClass fpc = null;
            while (rrs.next()) {
                fpc = new ForPrintClass(rrs.getString(0), rrs.getString(1), rrs.getString(2), rrs.getString(3), rrs.getString(4));
                printGroups.add(fpc);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        return printGroups;
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        if (this.printVarProvider == null) {
            this.printVarProvider = new PrintExtVarProvider();
        }
        ((PrintExtVarProvider)this.printVarProvider).setExtVarMap(this.preparePrintVariantMap());
        return super.getPrintExtVarProvider();
    }

    protected void prepareTblPrintVarMap(MultiPrint mp) {
        ArrayList tps = this.getPrintGroups();
        mp.getMultiPrintModel().setRequestData((IRequestTableData)this);
        String compName = SysContext.getSysContext().getCurrentFIUnit().getName();
        String calDate = (String)this.params.getObject("calDate");
        ForPrintClass temp = null;
        int n = tps.size();
        for (int i = 0; i < n; ++i) {
            temp = (ForPrintClass)tps.get(i);
            HashMap<String, String> var = new HashMap<String, String>();
            var.put("Company", compName);
            var.put("Currency", temp.getCurrencyName());
            var.put("AsstActType", temp.getAcctType());
            var.put("AsstAct", temp.getAcctName());
            var.put("CalDate", calDate);
            mp.getMultiPrintModel().addVarParser("PrintJob_" + i, var);
            mp.getMultiPrintModel().addTreePath("PrintJob_" + i, (Object)temp);
        }
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        StringBuffer row = new StringBuffer();
        row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_Company"));
        row.append("&[Company] &|  &|");
        row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"CalDate"));
        row.append("&[CalDate]");
        headerModel.addRow(row.toString());
        row.delete(0, row.length());
        row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_Currency"));
        row.append("&[Currency] &| ");
        row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_AsstActType"));
        row.append("&[AsstActType] &|");
        row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_AsstActRange"));
        row.append("&[AsstAct]");
        headerModel.addRow(row.toString());
    }

    protected Map preparePrintVariantMap() {
        Map map = super.preparePrintVariantMap();
        String temp = (String)this.params.getObject("calDate");
        map.put("CalDate", temp);
        temp = this.params.getObject("currency") == null ? EASResource.getString((String)this.getResource(), (String)"PRNT_All") : this.params.getObject("currencyName").toString();
        map.put("Currency", temp);
        temp = this.params.getObject("asstType") == null ? EASResource.getString((String)this.getResource(), (String)"PRNT_All") : this.params.getObject("asstTypeName").toString();
        map.put("AsstActType", temp);
        String asstActRange = null;
        String asstActFromNum = null;
        String asstActFromName = null;
        String asstActToNum = null;
        String asstActToName = null;
        if (this.params.getObject("asstFrom") instanceof DataBaseInfo) {
            DataBaseInfo asstactFrom = (DataBaseInfo)this.params.getObject("asstFrom");
            asstActFromNum = asstactFrom.getNumber();
            asstActFromName = asstactFrom.getName();
        } else if (this.params.getObject("asstFrom") instanceof Object[]) {
            asstActRange = TablePrintUtil.getAsstActMutilSelectedDesc((Object[])this.params.getObject("asstFrom"));
        } else if (this.params.getObject("asstFrom") instanceof String) {
            asstActFromNum = (String)this.params.getObject("asstFromNumber");
            asstActFromName = (String)this.params.getObject("asstFromName");
        } else if (this.params.getObject("asstFrom") instanceof String[]) {
            asstActRange = (String)this.params.getObject("asstFromName");
        }
        if (this.params.getObject("asstTo") instanceof DataBaseInfo) {
            DataBaseInfo asstactTo = (DataBaseInfo)this.params.getObject("asstTo");
            asstActToNum = asstactTo.getNumber();
            asstActToName = asstactTo.getName();
        } else if (this.params.getObject("asstTo") instanceof Object[]) {
            asstActRange = TablePrintUtil.getAsstActMutilSelectedDesc((Object[])this.params.getObject("asstTo"));
        } else if (this.params.getObject("asstTo") instanceof String) {
            asstActToNum = (String)this.params.getObject("asstToNumber");
            asstActToName = (String)this.params.getObject("asstToName");
        } else if (this.params.getObject("asstTo") instanceof String[]) {
            asstActRange = (String)this.params.getObject("asstToName");
        }
        if (StringUtils.isEmpty((String)asstActRange)) {
            asstActRange = TablePrintUtil.getInfoRangeDesc(asstActFromNum, asstActToNum, asstActFromName, asstActToName);
        }
        map.put("AsstAct", asstActRange);
        return map;
    }

    public void requestTableData(Object path) throws Exception {
        this.printRequestTableData(path);
    }

    public void requestTableData(Object path, boolean b) throws Exception {
        this.printRequestTableData(path);
    }

    private void printRequestTableData(Object path) {
        this.firstLoadData = true;
        this.currentAcct = (ForPrintClass)path;
        this.query();
    }

    public void confirmEnd() {
    }

    protected String getResource() {
        return "com.kingdee.eas.fi.ar.client.ArResource";
    }

    @Override
    public void actionContinuousPrint_actionPerformed(ActionEvent e) throws Exception {
        this.isAsynchronism = false;
        this.printTbl(false);
        this.isAsynchronism = true;
    }

    @Override
    public void actionContinuousPrintPreView_actionPerformed(ActionEvent e) throws Exception {
        this.isAsynchronism = false;
        this.printTbl(true);
        this.isAsynchronism = true;
    }

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        ArApReportUIUtil.checkCompany((Component)((Object)this), companyInfo);
        super.onLoad();
        this.btnContinuousPrint.setIcon(EASResource.getIcon((String)"imgTbtn_printcontinue"));
        this.menuItemContinuousPrint.setIcon(EASResource.getIcon((String)"imgTbtn_printcontinue"));
        this.btnContinuousPrintPreView.setIcon(EASResource.getIcon((String)"imgTbtn_printpreview"));
        this.menuItemContinuousPrintPreView.setIcon(EASResource.getIcon((String)"imgTbtn_printpreview"));
        String fmt = CtrlFormatUtilities.getDateFormatString();
        this.tblMain.getColumn("billDate").getStyleAttributes().setNumberFormat(fmt);
        this.tblMain.getColumn("recPayDate").getStyleAttributes().setNumberFormat(fmt);
    }

    protected void initWorkButton() {
        try {
            SystemStatusCtrolInfo cachedSysStatus = ArApBillHelper.getSysStatusCtrolInfo(null, SysContext.getSysContext().getCurrentFIUnit(), this.getSystemEnumForOA());
            if (cachedSysStatus == null || cachedSysStatus.getStartPeriod() == null || cachedSysStatus.getCurrentPeriod() == null) {
                throw new OtherBillBizException(OtherBillBizException.STARTPERIODISNULL, new Object[]{SysContext.getSysContext().getCurrentFIUnit().getName() + this.getSystemEnumForOA().getAlias()});
            }
            if (!SystemStatusCtrolUtils.isStart(null, (SystemEnum)this.getSystemEnumForOA(), (CompanyOrgUnitInfo)SysContext.getSysContext().getCurrentFIUnit())) {
                throw new OtherBillBizException(OtherBillBizException.COMPANYSNOTSTARTED, new Object[]{this.getSystemEnumForOA().getAlias(), SysContext.getSysContext().getCurrentFIUnit().getName()});
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        super.initWorkButton();
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            this.actionViewBill_actionPerformed(null);
        }
    }

    static class ForPrintClass {
        String acctName = null;
        String acctNumber = null;
        String currencyName = null;
        String currencyID = null;
        String acctType = null;

        ForPrintClass(String acctName, String acctID, String currencyName, String currencyID, String acctType) {
            this.acctName = acctName;
            this.acctNumber = acctID;
            this.currencyName = currencyName;
            this.currencyID = currencyID;
            this.acctType = acctType;
        }

        public String getAcctID() {
            return this.acctNumber;
        }

        public String getAcctName() {
            return this.acctName;
        }

        public String getCurrencyID() {
            return this.currencyID;
        }

        public String getCurrencyName() {
            return this.currencyName;
        }

        public String getAcctType() {
            return this.acctType;
        }
    }
}

