/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestListener;
import com.kingdee.bos.ctrl.swing.KDButton;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ap.client.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.ExgRateFacadeFactory;
import com.kingdee.eas.fi.arap.client.AbstractExgRateBillUI;
import com.kingdee.eas.fi.arap.client.ExgRateFilterUI;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.AdvMsgBox;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class ExgRateBillUI
extends AbstractExgRateBillUI {
    private static final Logger logger = CoreUIObject.getLogger(ExgRateBillUI.class);
    private CommonQueryDialog dialog;
    private ExgRateFilterUI userPanel;
    private int allRowCount;
    private boolean isDirectExchange = true;
    private List billIdList = new ArrayList();
    private ExgRateFilterUI filterUI = new ExgRateFilterUI();
    private UserInfo defaultUserInfo;
    private CompanyOrgUnitInfo currentCompany;

    public ExgRateBillUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getDataRequestManager().addDataRequestListener((KDTDataRequestListener)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(1);
        if (this.defaultUserInfo == null) {
            this.defaultUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        }
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    }

    public void onLoad() throws Exception {
        ExchangeRateInfo rateInfo;
        this.actionPageSetup.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionRefresh.setVisible(false);
        this.prmtCurrency.setEnabled(false);
        this.txtExchangeRate.setPrecision(4);
        RptParams rpt = this.getRemoteInstance().init(null);
        RptTableHeader header = (RptTableHeader)rpt.getObject("header");
        this.tblMain.removeHeadRows();
        KDTableUtil.setHeader((RptTableHeader)header, (KDTable)this.tblMain);
        this.tblMain.setRowCount(4);
        super.onLoad();
        RptParams customCondition = this.filterUI.getCustomCondition();
        CurrencyInfo currency = (CurrencyInfo)customCondition.getObject("currency");
        if (currency == null || (rateInfo = BaseDataUtil.getExchangeRate(this.currentCompany, currency)) != null) {
            // empty if block
        }
    }

    @Override
    protected void txtExchangeRate_dataChanged(DataChangeEvent e) throws Exception {
        super.txtExchangeRate_dataChanged(e);
    }

    protected List getSelectedBillIdList() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < this.allRowCount && this.tblMain.getColumn(i) != null; ++i) {
            Boolean isSelected = (Boolean)this.tblMain.getCell(i, 1).getValue();
            if (!isSelected.booleanValue()) continue;
            list.add(this.tblMain.getCell(i, 0).getValue());
        }
        return list;
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.allRowCount && this.tblMain.getColumn(i) != null; ++i) {
            this.tblMain.getCell(i, 1).setValue((Object)Boolean.TRUE);
        }
    }

    @Override
    public void actionSelectNone_actionPerformed(ActionEvent e) throws Exception {
        for (int i = 0; i < this.allRowCount && this.tblMain.getColumn(i) != null; ++i) {
            this.tblMain.getCell(i, 1).setValue((Object)Boolean.FALSE);
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    protected boolean hasForbidExgRateBill() {
        return false;
    }

    private void checkForbidExgRateBill() throws Exception {
        if (this.hasForbidExgRateBill()) {
            AdvMsgBox msgBox = AdvMsgBox.createAdvMsgBox((Component)((Object)this), (String)EASResource.getString((String)"promotInfoBox"), (String)"has not rec bill", (String)"ggg", (int)3, (int)4);
            this.changeAdvButton(msgBox);
            msgBox.show();
            if (msgBox.getResult() == 2) {
                SysUtil.abort();
                this.actionExitCurrent_actionPerformed(null);
            }
        }
    }

    private void changeAdvButton(AdvMsgBox msgBox) {
        KDButton btn = this.getButton((Container)msgBox);
        ActionListener[] listener = btn.getActionListeners();
        btn.removeActionListener(listener[0]);
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    ExgRateBillUI.this.actionAdvance_actionPerformed(arg0);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            }
        });
    }

    protected void actionAdvance_actionPerformed(ActionEvent e) throws Exception {
    }

    private KDButton getButton(Container container) {
        KDDialog dlg = (KDDialog)container;
        return (KDButton)((JPanel)((JPanel)dlg.getContentPane()).getComponent(1)).getComponent(3);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.dialog != null) {
            return this.dialog;
        }
        this.dialog = new CommonQueryDialog();
        this.dialog.addUserPanel((KDPanel)this.getUserPanel());
        this.dialog.setShowFilter(false);
        this.dialog.setShowSorter(false);
        this.dialog.setTitle("");
        return this.dialog;
    }

    public ExgRateFilterUI getUserPanel() {
        if (this.userPanel == null) {
            try {
                this.userPanel = new ExgRateFilterUI();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return this.userPanel;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    protected ICommRptBase getRemoteInstance() throws BOSException {
        return ExgRateFacadeFactory.getRemoteInstance();
    }

    protected KDTable getTableForPrintSetting() {
        return null;
    }

    protected RptParams getParamsForInit() {
        return null;
    }

    protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
        return this.filterUI;
    }

    protected void query() {
        this.tblMain.removeRows();
    }

    public void tableDataRequest(KDTDataRequestEvent e) {
        BigDecimal exchangeRate = this.txtExchangeRate.getBigDecimalValue();
        try {
            int from = e.getFirstRow();
            int len = e.getLastRow() - from + 1;
            RptParams pp = new RptParams();
            pp.setObject("exchangeRate", (Object)exchangeRate);
            pp.setBoolean("isDirectExchange", this.isDirectExchange);
            RptParams rpt = this.getRemoteInstance().query(pp, from, len);
            if (from == 0) {
                this.tblMain.setRowCount(1);
            }
            RptRowSet rs = (RptRowSet)rpt.getObject("rowSet");
            while (rs.next()) {
                rs.setValue("CHECKBOX", (Object)Boolean.TRUE);
                this.billIdList.remove(rs.getString("BILLID"));
                this.billIdList.add(rs.getString("BILLID"));
            }
            rs.moveTo(-1);
            KDTableUtil.insertRows((RptRowSet)rs, (int)from, (KDTable)this.tblMain);
        }
        catch (Exception ex) {
            this.handleException(ex);
        }
    }
}

