/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.client.AbstractInvoiceBatchMakeUI;
import com.kingdee.eas.fi.arap.client.InvoiceBatchMakeHelper;
import com.kingdee.eas.fi.arap.client.InvoiceBatchMakeParam;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class InvoiceBatchMakeUI
extends AbstractInvoiceBatchMakeUI {
    private static final Logger logger = CoreUIObject.getLogger((String)"com.kingdee.eas.fi.arap.client.InvoiceBatchMakeUI");
    private BigDecimal canInvoiceAmt = SysConstant.BIGZERO;
    private EntityViewInfo lastView = null;
    private boolean fAR = false;
    private boolean fConfirm = false;
    private CompanyOrgUnitInfo companyInfo = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnInsRow.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnDelRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        this.tblMain.checkParsed();
        this.lastView = (EntityViewInfo)this.getUIContext().get("lastView");
        this.fAR = (Boolean)this.getUIContext().get("fAR");
        this.tblMain.addRows(3);
        CommonClientUtils.setAsstActTypes(this.comboCussAcctType, this.fAR, this.companyInfo);
        ClientUtils.setCurrencyList((KDComboBox)this.comboCurrency, (boolean)false);
        this.tblMain.setActiveCellStatus(1);
        int precision = 4;
        KDFormattedTextField textField = new KDFormattedTextField();
        textField.setDataType(1);
        textField.setPrecision(precision);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)textField);
        this.tblMain.getColumn(1).setEditor((ICellEditor)editor);
        this.txtNumSum.setHorizontalAlignment(4);
        this.txtNumSum.setPrecision(precision);
        if (this.getUIContext().get("autoParam") != null) {
            InvoiceBatchMakeParam param = (InvoiceBatchMakeParam)this.getUIContext().get("autoParam");
            this.loadPreParam(param);
        }
    }

    private void loadPreParam(InvoiceBatchMakeParam param) {
        List invList;
        if (param.getCussActType() != null) {
            this.comboCussAcctType.setSelectedItem((Object)param.getCussActType());
        }
        if (param.getCussAcctInfo() != null) {
            this.prmtCussAcct.setValue((Object)param.getCussAcctInfo());
        }
        if (param.getCurrencyInfo() != null) {
            this.comboCurrency.setSelectedItem((Object)param.getCurrencyInfo());
        }
        if ((invList = param.getInvList()) != null) {
            this.tblMain.removeRows();
            Object[] invItem = null;
            IRow row = null;
            int n = invList.size();
            for (int i = 0; i < n; ++i) {
                invItem = (Object[])invList.get(i);
                row = this.tblMain.addRow();
                row.getCell(0).setValue(invItem[0]);
                row.getCell(1).setValue(invItem[1]);
            }
        }
    }

    @Override
    public void actionAddRow_actionPerformed(ActionEvent e) throws Exception {
        this.tblMain.addRow();
    }

    @Override
    public void actionInsRow_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain == null) {
            return;
        }
        if (this.tblMain.getSelectManager().size() > 0) {
            int top = this.tblMain.getSelectManager().get().getTop();
            this.tblMain.addRow(top);
        } else {
            this.tblMain.addRow();
        }
    }

    @Override
    public void actionDelRow_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        if (this.tblMain.getSelectManager().size() > 0) {
            KDTSelectBlock block = this.tblMain.getSelectManager().get();
            if (block != null) {
                this.tblMain.removeRow(block.getTop());
            }
        } else if (this.tblMain.getRowCount() > 0) {
            this.tblMain.removeRow(this.tblMain.getRowCount() - 1);
        }
    }

    private String getRes() {
        return "com.kingdee.eas.fi.arap.InvResource";
    }

    @Override
    protected void comboCussAcctType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1) {
            return;
        }
        if (this.comboCussAcctType.getItemCount() == 0 || this.comboCussAcctType.getSelectedItem() == null) {
            this.prmtCussAcct.setEnabled(false);
            return;
        }
        AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.comboCussAcctType.getSelectedItem();
        if (typeInfo != null && typeInfo.getDefaultQueryName() != null) {
            String companyId = this.companyInfo.getId().toString();
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCussAcct, typeInfo, companyId, false);
        } else {
            this.prmtCussAcct.setEnabled(false);
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        this.tblMain_cellValueChanged(e.getRowIndex(), e.getColIndex());
    }

    private void tblMain_cellValueChanged(int row, int col) {
        int rowCount = this.tblMain.getRowCount();
        BigDecimal sum = SysConstant.BIGZERO;
        BigDecimal amt = null;
        for (int i = 0; i < rowCount; ++i) {
            amt = (BigDecimal)this.tblMain.getRow(i).getCell(1).getValue();
            sum = amt == null ? sum : sum.add(amt);
        }
        this.txtNumSum.setValue((Object)sum);
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        AsstActTypeInfo cussAcctType = (AsstActTypeInfo)this.comboCussAcctType.getSelectedItem();
        IObjectValue cussAcctInfo = (IObjectValue)this.prmtCussAcct.getValue();
        CurrencyInfo currInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (cussAcctType == null || cussAcctInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.getRes(), (String)"Auto_CussTypeCussAcctNotNull"));
            SysUtil.abort();
        }
        String cussAcctTypeId = cussAcctType.getId().toString();
        String cussAcctId = cussAcctInfo.getString("id");
        String currId = currInfo.getId().toString();
        this.canInvoiceAmt = InvoiceBatchMakeHelper.getCanInvoiceAmt((EntityViewInfo)this.lastView.clone(), this.fAR, cussAcctTypeId, cussAcctId, currId);
        BigDecimal sum = this.getSpecifiedSum();
        if (sum.signum() == 0) {
            this.showWarnMsg("AutoZeroAmt");
        } else if (sum.signum() > 0 && sum.compareTo(this.canInvoiceAmt) == 1) {
            this.showWarnMsg("AutoAmtLTCanInvoiceAmt");
        } else if (sum.signum() < 0 && sum.abs().compareTo(this.canInvoiceAmt.abs()) == 1) {
            this.showWarnMsg("AutoAmtGTCanInvoiceAmt");
        }
        this.fConfirm = true;
        this.disposeUIWindow();
    }

    private void showWarnMsg(String msgLbl) {
        int iReact = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.getRes(), (String)msgLbl));
        if (iReact == 0) {
            SysUtil.abort();
        } else {
            this.disposeUIWindow();
        }
    }

    private BigDecimal getSpecifiedSum() throws Exception {
        int rows = this.tblMain.getRowCount();
        if (rows == 0) {
            return SysConstant.BIGZERO;
        }
        int preSign = 0;
        BigDecimal amt = SysConstant.BIGZERO;
        IRow row = null;
        BigDecimal rowAmt = null;
        for (int i = 0; i < rows; ++i) {
            row = this.tblMain.getRow(i);
            rowAmt = (BigDecimal)row.getCell(1).getValue();
            if (rowAmt == null) continue;
            if (i > 0 && rowAmt.signum() != 0 && preSign != rowAmt.signum()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.getRes(), (String)"Msg_OnlySameSign"));
                SysUtil.abort();
            }
            amt = amt.add(rowAmt);
            if (rowAmt.signum() == 0) continue;
            preSign = rowAmt.signum();
        }
        return amt;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.fConfirm = false;
        this.disposeUIWindow();
    }

    public boolean isConfirm() {
        return this.fConfirm;
    }

    public InvoiceBatchMakeParam getBatchParam() {
        AsstActTypeInfo cussAcctType = (AsstActTypeInfo)this.comboCussAcctType.getSelectedItem();
        IObjectValue cussAcctInfo = (IObjectValue)this.prmtCussAcct.getValue();
        CurrencyInfo currInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (!this.fConfirm || this.tblMain.getRowCount() == 0 || cussAcctType == null || cussAcctInfo == null || currInfo == null) {
            return null;
        }
        int rows = this.tblMain.getRowCount();
        ArrayList<Object[]> invList = new ArrayList<Object[]>();
        IRow row = null;
        String num = null;
        BigDecimal amt = null;
        for (int i = 0; i < rows; ++i) {
            row = this.tblMain.getRow(i);
            num = (String)row.getCell(0).getValue();
            amt = (BigDecimal)row.getCell(1).getValue();
            if (amt == null || amt.signum() == 0) continue;
            invList.add(new Object[]{num, amt});
        }
        if (invList.size() == 0) {
            return null;
        }
        InvoiceBatchMakeParam batchParam = new InvoiceBatchMakeParam(cussAcctType, cussAcctInfo, currInfo, invList);
        return batchParam;
    }
}

