/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.ApInvoiceCollection;
import com.kingdee.eas.fi.ap.ApInvoiceInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArInvoiceCollection;
import com.kingdee.eas.fi.ar.ArInvoiceInfo;
import com.kingdee.eas.fi.ar.IArApBillBase;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillentryCollection;
import com.kingdee.eas.fi.arap.client.InvoiceBTPUtil;
import com.kingdee.eas.fi.arap.client.InvoiceBatchMakeParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class InvoiceBatchMaker {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.client.InvoiceAutoMaker");
    private static final String ARINVOICE = new ArInvoiceInfo().getBOSType().toString();
    private static final String APINVOICE = new ApInvoiceInfo().getBOSType().toString();
    private Map entryInvdMap = new HashMap();
    private SelectorItemCollection botSelectors = null;
    private boolean fVAT = false;

    public InvoiceBatchMaker(SelectorItemCollection selectors, boolean fIsVAT) {
        this.botSelectors = selectors;
        this.fVAT = fIsVAT;
    }

    private String getDestBosType(boolean fAR) {
        return fAR ? ARINVOICE : APINVOICE;
    }

    public BTPTransformResult batchTransfter(BOTMappingInfo botMappingInfo, EntityViewInfo lastView, InvoiceBatchMakeParam batchParam, boolean fAR) throws BOSException, EASBizException, SQLException {
        if (batchParam == null || batchParam.getCussActType() == null || batchParam.getCussAcctInfo() == null) {
            return null;
        }
        List spInvList = batchParam.getInvList();
        if (spInvList == null || spInvList.size() == 0) {
            return null;
        }
        CoreBillBaseCollection bills = this.getSpecifiedBills(lastView, fAR, batchParam);
        BTPTransformResult rtResult = new BTPTransformResult();
        AbstractObjectCollection destObjs = null;
        destObjs = fAR ? new ArInvoiceCollection() : new ApInvoiceCollection();
        rtResult.setBills((IObjectCollection)destObjs);
        rtResult.setBOTRelationCollection(new BOTRelationCollection());
        String destBosType = this.getDestBosType(fAR);
        Object[] itemArr = null;
        IBTPManager iBTPManager = BTPManagerFactory.getRemoteInstance();
        int n = spInvList.size();
        for (int i = 0; i < n; ++i) {
            itemArr = (Object[])spInvList.get(i);
            if (itemArr[1] == null) continue;
            BigDecimal invAmt = (BigDecimal)itemArr[1];
            CoreBillBaseCollection srcBills = this.getAccordanceBills(bills, invAmt, fAR);
            InvoiceBTPUtil.verifyBillAndBotMapping((IObjectCollection)srcBills, (IObjectPK)new ObjectUuidPK(botMappingInfo.getId()), destBosType);
            BTPTransformResult result = iBTPManager.transformForBotp(srcBills, destBosType, (IObjectPK)new ObjectUuidPK(botMappingInfo.getId()));
            this.setInvoiceNumber((String)itemArr[0], result);
            this.mergeResult(rtResult, result);
        }
        return rtResult;
    }

    private CoreBillBaseCollection getSpecifiedBills(EntityViewInfo view, boolean fAR, InvoiceBatchMakeParam batchParam) throws BOSException, EASBizException, SQLException {
        String cussAcctTypeId = batchParam.getCussActType().getId().toString();
        String cussAcctId = batchParam.getCussAcctInfo().getString("id");
        String currencyId = batchParam.getCurrencyInfo().getId().toString();
        view.getSelector().clear();
        view.getSelector().add("id");
        view.getSelector().add("entry.id");
        view.getSorter().clear();
        view.getSorter().add(new SorterItemInfo("id"));
        view.getSorter().add(new SorterItemInfo("entry.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("asstActType.id", (Object)cussAcctTypeId));
        filter.getFilterItems().add(new FilterItemInfo("asstActID", (Object)cussAcctId));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        view.getFilter().mergeFilter(filter, "and");
        String qry = fAR ? "com.kingdee.eas.fi.ar.app.OtherBill" : "com.kingdee.eas.fi.ap.app.OtherBillQuery";
        IQueryExecutor iQry = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(qry));
        iQry.setObjectView(view);
        IRowSet rs = iQry.executeQuery();
        String id = null;
        String entryId = null;
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> entryIds = new ArrayList<String>();
        IArApBillBase iBill = null;
        iBill = fAR ? OtherBillFactory.getRemoteInstance() : com.kingdee.eas.fi.ap.OtherBillFactory.getRemoteInstance();
        rs.beforeFirst();
        while (rs.next()) {
            id = rs.getString(1);
            entryId = rs.getString(2);
            if (!ids.contains(id)) {
                ids.add(id);
            }
            if (!entryIds.contains(entryId)) continue;
            entryIds.add(entryId);
        }
        FilterInfo filterInfo = new FilterInfo();
        Iterator idIter = ids.iterator();
        int index = 0;
        StringBuffer sbMaskString = new StringBuffer();
        while (idIter.hasNext()) {
            id = idIter.next().toString();
            FilterItemInfo filterItemInfo = new FilterItemInfo("id", (Object)id);
            if (index != 0) {
                sbMaskString.append(" or ");
            }
            sbMaskString.append("#").append(index);
            filterInfo.getFilterItems().add(filterItemInfo);
            ++index;
        }
        filterInfo.setMaskString(sbMaskString.toString());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        if (this.botSelectors != null) {
            entityViewInfo.put("selector", (Object)this.botSelectors);
        }
        CoreBillBaseCollection srcBills = iBill.getCoreBillBaseCollection(entityViewInfo);
        if (entryIds.size() > 0) {
            this.removeUnSelect(entryIds, srcBills);
        }
        return srcBills;
    }

    private void removeUnSelect(List entryIds, CoreBillBaseCollection srcBills) {
        int n = srcBills.size();
        for (int i = 0; i < n; ++i) {
            CoreBillBaseInfo bills = srcBills.get(i);
            boolean isHasSelect = false;
            IObjectCollection entries = (IObjectCollection)bills.get("entry");
            if (entries == null) {
                return;
            }
            Iterator iters = entries.iterator();
            while (iters.hasNext()) {
                CoreBaseInfo cInfo = (CoreBaseInfo)iters.next();
                isHasSelect = false;
                for (int k = 0; k < entryIds.size(); ++k) {
                    if (!cInfo.get("id").toString().equals(entryIds.get(k).toString())) continue;
                    isHasSelect = true;
                    break;
                }
                if (isHasSelect) continue;
                iters.remove();
            }
        }
    }

    private void setInvoiceNumber(String number, BTPTransformResult result) {
        IObjectCollection destObjs = result.getBills();
        if (number != null && destObjs != null && destObjs.size() > 0) {
            destObjs.getObject(0).setString("number", number);
        }
    }

    private CoreBillBaseCollection getAccordanceBills(CoreBillBaseCollection bills, BigDecimal invAmt, boolean fAR) {
        CoreBillBaseCollection rtBills = new CoreBillBaseCollection();
        CoreBillBaseInfo info = null;
        IObjectCollection entries = null;
        BigDecimal sum = SysConstant.BIGZERO;
        int n = bills.size();
        for (int i = 0; i < n; ++i) {
            info = bills.get(i);
            CoreBillBaseInfo srcInfo = (CoreBillBaseInfo)this.copyInfo((AbstractObjectValue)info, fAR);
            entries = (IObjectCollection)info.get("entry");
            sum = this.processEntries(srcInfo, entries, sum, invAmt);
            if (((IObjectCollection)srcInfo.get("entry")).size() > 0) {
                rtBills.add(srcInfo);
            }
            if (sum.compareTo(invAmt) == 0) break;
        }
        if (logger.isDebugEnabled()) {
            IObjectCollection rtEntries = null;
            int n2 = rtBills.size();
            for (int i = 0; i < n2; ++i) {
                CoreBillBaseInfo rtInfo = rtBills.get(i);
                rtEntries = (IObjectCollection)rtInfo.get("entry");
                int m = rtEntries.size();
                for (int j = 0; j < m; ++j) {
                    logger.debug((Object)("\r\n toTransferEntry: " + rtEntries.getObject(i)));
                }
            }
        }
        return rtBills;
    }

    private AbstractObjectValue copyInfo(AbstractObjectValue info, boolean fAR) {
        AbstractObjectValue copyInfo = (AbstractObjectValue)info.clone();
        if (copyInfo.get("entry") != null) {
            if (fAR) {
                copyInfo.put("entry", (Object)new OtherBillentryCollection());
            } else {
                copyInfo.put("entry", (Object)new com.kingdee.eas.fi.ap.OtherBillentryCollection());
            }
        }
        return copyInfo;
    }

    private BigDecimal processEntries(CoreBillBaseInfo srcInfo, IObjectCollection entries, BigDecimal sum, BigDecimal invAmt) {
        ArApBillEntryBaseInfo entryInfo = null;
        int m = entries.size();
        for (int j = 0; j < m; ++j) {
            BigDecimal freeInvAmt;
            int freeInvAmtSign;
            entryInfo = (ArApBillEntryBaseInfo)entries.getObject(j);
            ArApBillEntryBaseInfo srcEntryInfo = (ArApBillEntryBaseInfo)entryInfo.clone();
            if (entryInfo.getRecievePayAmount().signum() != invAmt.signum() || (freeInvAmtSign = (freeInvAmt = this.getFreeInvAmt(entryInfo)).signum()) == 0) continue;
            srcEntryInfo.setRecievePayAmount(freeInvAmt);
            int compareTo = sum.add(srcEntryInfo.getRecievePayAmount()).compareTo(invAmt);
            if (freeInvAmtSign == 1 && compareTo == -1 || freeInvAmtSign == -1 && compareTo == 1) {
                sum = sum.add(srcEntryInfo.getRecievePayAmount());
                this.add2SrcInfo(srcInfo, srcEntryInfo);
                continue;
            }
            if (compareTo == 0) {
                sum = sum.add(srcEntryInfo.getRecievePayAmount());
                this.add2SrcInfo(srcInfo, srcEntryInfo);
                break;
            }
            if ((freeInvAmtSign != 1 || compareTo != 1) && (freeInvAmtSign != -1 || compareTo != -1)) continue;
            BigDecimal amt = invAmt.subtract(sum);
            srcEntryInfo.setRecievePayAmount(amt);
            this.add2SrcInfo(srcInfo, srcEntryInfo);
            sum = invAmt;
            break;
        }
        return sum;
    }

    private BigDecimal getFreeInvAmt(ArApBillEntryBaseInfo entryInfo) {
        BigDecimal invdAmt = (BigDecimal)this.entryInvdMap.get(entryInfo.getId());
        invdAmt = invdAmt == null ? SysConstant.BIGZERO : invdAmt;
        return entryInfo.getRecievePayAmount().subtract(invdAmt);
    }

    private void add2SrcInfo(CoreBillBaseInfo srcInfo, ArApBillEntryBaseInfo srcEntryInfo) {
        this.updateInvdAmt(srcEntryInfo);
        ((IObjectCollection)srcInfo.get("entry")).addObject((IObjectValue)srcEntryInfo);
        logger.debug((Object)("\r\n srcInfoNum: " + srcInfo.getNumber() + ", entryInfo: " + srcEntryInfo));
    }

    private void updateInvdAmt(ArApBillEntryBaseInfo srcEntryInfo) {
        BigDecimal invdAmt;
        BigDecimal unitPriceAmt;
        BigDecimal nowInvAmt = srcEntryInfo.getRecievePayAmount();
        BigDecimal bigDecimal = unitPriceAmt = this.fVAT ? srcEntryInfo.getPrice() : srcEntryInfo.getTaxPrice();
        if (unitPriceAmt != null) {
            BigDecimal quantity = nowInvAmt.divide(unitPriceAmt, 4, 5);
            srcEntryInfo.setQuantity(quantity);
        }
        invdAmt = (invdAmt = (BigDecimal)this.entryInvdMap.get(srcEntryInfo.getId())) == null ? SysConstant.BIGZERO : invdAmt;
        invdAmt = invdAmt.add(nowInvAmt);
        srcEntryInfo.setInvoicedAmt(SysConstant.BIGZERO);
        this.entryInvdMap.put(srcEntryInfo.getId(), invdAmt);
        logger.debug((Object)("\r\n nowInvAmt: " + nowInvAmt + ", accumlatedAmt: " + invdAmt));
    }

    private void mergeResult(BTPTransformResult rtResult, BTPTransformResult result) {
        if (result == null) {
            return;
        }
        IObjectCollection destObjs = rtResult.getBills();
        BOTRelationCollection relation = rtResult.getBOTRelationCollection();
        destObjs.addObjectCollection(result.getBills());
        relation.addObjectCollection((IObjectCollection)result.getBOTRelationCollection());
        rtResult.setBills(destObjs);
        rtResult.setBOTRelationCollection(relation);
    }
}

