/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.fi.arap.InvoiceEntryCollection;
import com.kingdee.eas.fi.arap.InvoiceEntryInfo;
import java.math.BigDecimal;

public class InvoiceGroupHelper {
    private InvoiceGroupHelper() {
    }

    public static InvoiceEntryCollection groupEntries(IObjectCollection entries, boolean fVAT) {
        if (entries == null || entries.size() == 0) {
            return null;
        }
        InvoiceEntryCollection grpEntries = new InvoiceEntryCollection();
        InvoiceEntryInfo entryInfo = null;
        int n = entries.size();
        for (int i = 0; i < n; ++i) {
            entryInfo = (InvoiceEntryInfo)entries.getObject(i);
            InvoiceGroupHelper.sum2Group(grpEntries, entryInfo, fVAT);
        }
        return grpEntries;
    }

    private static void sum2Group(InvoiceEntryCollection grpEntries, InvoiceEntryInfo entryInfo, boolean fVAT) {
        int m = grpEntries.size();
        if (m == 0) {
            grpEntries.addObject((IObjectValue)entryInfo);
            return;
        }
        InvoiceEntryInfo info = null;
        for (int j = 0; j < m; ++j) {
            info = grpEntries.get(j);
            if (InvoiceGroupHelper.isSameGroup(info, entryInfo, fVAT)) {
                InvoiceGroupHelper.sumup(info, entryInfo);
                continue;
            }
            grpEntries.addObject((IObjectValue)entryInfo);
        }
    }

    private static boolean isSameGroup(InvoiceEntryInfo info, InvoiceEntryInfo entryInfo, boolean fVAT) {
        return info.getMaterial().getId().equals((Object)entryInfo.getMaterial().getId()) && info.getMeasureUnit().getId().equals((Object)entryInfo.getMeasureUnit().getId()) && info.getUnitPrice().equals(entryInfo.getUnitPrice()) && (!fVAT || info.getTaxRate().equals(entryInfo.getTaxRate()));
    }

    private static void sumup(InvoiceEntryInfo info, InvoiceEntryInfo entryInfo) {
        BigDecimal qty = info.getQuantity().add(entryInfo.getQuantity());
        info.setQuantity(qty);
        BigDecimal sum = info.getAmount().add(entryInfo.getAmount());
        info.setAmount(sum);
        BigDecimal tAmt = info.getTaxAmount().add(entryInfo.getTaxAmount());
        info.setTaxAmount(tAmt);
    }
}

