/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.ctrl.kdf.data.datasource.BOSQueryDataSource;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvoicePrintQueryDelegate
implements BOSQueryDelegate {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.client.InvoicePrintQueryDelegate");
    private IMetaDataPK qryPK = null;
    private Set ids = null;

    public InvoicePrintQueryDelegate(Set ids, IMetaDataPK pk) {
        this.ids = ids;
        this.qryPK = pk;
    }

    public InvoicePrintQueryDelegate(List ids, IMetaDataPK pk) {
        this.ids = new HashSet(ids);
        this.qryPK = pk;
    }

    public IRowSet execute(BOSQueryDataSource ds) {
        IRowSet rs = null;
        try {
            IQueryExecutor iExec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.qryPK);
            iExec.option().isAutoTranslateEnum = true;
            iExec.option().isAutoTranslateBoolean = true;
            iExec.option().isMultiLanguage = true;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
            view.setFilter(filter);
            iExec.setObjectView(view);
            rs = iExec.executeQuery();
            this.processRowSet(rs);
        }
        catch (Exception e) {
            logger.error((Object)"error, while get the rowset", (Throwable)e);
        }
        return rs;
    }

    private void processRowSet(IRowSet rs) throws Exception {
        while (rs.next()) {
            int precision = rs.getInt("currency.precision");
            this.setRowSetFieldScale(rs, "FTotalAmount", precision);
            this.setRowSetFieldScale(rs, "FAmount", precision);
            this.setRowSetFieldScale(rs, "FTaxAmount", precision);
            this.setRowSetFieldScale(rs, "FWithTaxAmount", precision);
            this.setRowSetFieldScale(rs, "FTaxRate", 2);
            int qtyPrecision = this.getQtyPrecision(rs);
            this.setRowSetFieldScale(rs, "FQuantity", qtyPrecision);
            int pricePrecision = rs.getInt("material.pricePrecision");
            this.setRowSetFieldScale(rs, "FUnitPrice", pricePrecision);
        }
        rs.beforeFirst();
    }

    private int getQtyPrecision(IRowSet rs) throws Exception {
        int precision = 6;
        String materialId = rs.getString("material.id");
        String unitId = rs.getString("measureUnit.id");
        try {
            IMultiMeasureUnit iMultUnit = MultiMeasureUnitFactory.getRemoteInstance();
            MultiMeasureUnitInfo multiUnitInfo = iMultUnit.getMultiUnit(materialId, unitId);
            if (multiUnitInfo != null) {
                precision = multiUnitInfo.getQtyPrecision();
            }
        }
        catch (Exception e) {
            logger.error((Object)"error, while get the qtyPrecision", (Throwable)e);
        }
        return precision;
    }

    private void setRowSetFieldScale(IRowSet rs, String field, int precision) throws SQLException {
        BigDecimal amt = rs.getBigDecimal(field);
        amt = amt.setScale(precision, 4);
        rs.updateBigDecimal(field, amt);
    }
}

