/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.client.util.BaseDataUtil;
import com.kingdee.eas.fi.ar.client.util.CommonClientUtils;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.eas.fi.arap.client.AbstractInvoiceQueryUI;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApQueryUIUtil;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class InvoiceQueryUI
extends AbstractInvoiceQueryUI {
    private static final Logger logger = CoreUIObject.getLogger(InvoiceQueryUI.class);
    private CompanyOrgUnitInfo currentCompany = null;
    private CurrencyInfo baseCurrency = null;
    private PersonInfo curPersonInfo = null;
    private boolean fAR = true;
    private KDTextField txtApDrawer = null;
    private int defaultAsstTypeInd = 0;
    private AsstActTypeInfo allType = new AsstActTypeInfo();
    private InvoiceTypeEnum invoiceType;

    public InvoiceQueryUI() throws Exception {
    }

    public InvoiceQueryUI(boolean fIsAR) throws Exception {
        this.fAR = fIsAR;
    }

    public InvoiceQueryUI(InvoiceTypeEnum type) throws Exception {
        this.invoiceType = type;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.checkCompany();
        this.initCtrlsData();
    }

    private void initCtrlsData() throws BOSException, EASBizException {
        this.prmtCompany.setValue((Object)this.currentCompany);
        this.prmtCompany.setEnabled(false);
        this.prmtCurrency.setValue((Object)this.baseCurrency);
        UserInfo currentUserInfo = SysContext.getSysContext().getCurrentUserInfo();
        CommonClientUtils.setAsstActTypes(this.comboCussAcctType, this.fAR, this.currentCompany);
        this.allType.setName(EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"itemAll"));
        this.comboCussAcctType.addItem((Object)this.allType);
        this.defaultAsstTypeInd = this.comboCussAcctType.getSelectedIndex();
        this.prmtDrawer.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
        this.curPersonInfo = currentUserInfo.getPerson();
        if (this.curPersonInfo != null) {
            String personId = this.curPersonInfo.getString("id");
            if (!StringUtils.isEmpty((String)personId)) {
                this.curPersonInfo = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
            }
            this.prmtDrawer.setValue((Object)this.curPersonInfo);
        }
        SystemEnum sysEnum = this.fAR ? SystemEnum.ACCOUNTSRECEIVABLE : SystemEnum.ACCOUNTSPAYABLE;
        this.pkDateTo.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        this.pkDateFrom.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        this.txtAmtFrom.setPrecision(this.baseCurrency.getPrecision());
        this.txtAmtTo.setPrecision(this.baseCurrency.getPrecision());
        this.txtAmtFrom.setHorizontalAlignment(4);
        this.txtAmtTo.setHorizontalAlignment(4);
        this.txtAmtFrom.setSupportedEmpty(true);
        this.txtAmtTo.setSupportedEmpty(true);
        if (this.invoiceType == null) {
            this.comboBillType.setEnabled(true);
        } else {
            this.comboBillType.setEnabled(false);
            if (InvoiceTypeEnum.GENERAL.equals((Object)this.invoiceType)) {
                this.comboBillType.setSelectedIndex(0);
            } else {
                this.comboBillType.setSelectedIndex(1);
            }
        }
        if (!this.fAR) {
            this.txtApDrawer = new KDTextField();
            this.txtApDrawer.setName("txtApDrawer");
            this.txtApDrawer.setMaxLength(40);
            this.lblContDrawer.setBoundEditor((JComponent)this.txtApDrawer);
        }
    }

    private void checkCompany() throws BOSException, EASBizException {
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        ClientUtils.checkCompany((Component)((Object)this), (CompanyOrgUnitInfo)this.currentCompany);
        if (this.currentCompany.getBaseCurrency() != null) {
            this.baseCurrency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.currentCompany.getBaseCurrency().getId()));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)ArApBillUIUtil.getStrResource("currentBaseCurrencyIsNull"));
            SysUtil.abort();
        }
    }

    @Override
    protected void comboCussAcctType_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1) {
            return;
        }
        if (this.comboCussAcctType.getItemCount() == 0 || this.comboCussAcctType.getSelectedItem() == null) {
            this.prmtCussAcctFrom.setEnabled(false);
            this.prmtCussAcctTo.setEnabled(false);
            return;
        }
        AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.comboCussAcctType.getSelectedItem();
        if (typeInfo != null && !StringUtils.isEmpty((String)typeInfo.getDefaultQueryName())) {
            this.prmtCussAcctFrom.setEnabled(true);
            this.prmtCussAcctTo.setEnabled(true);
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCussAcctFrom, typeInfo, this.currentCompany.getString("id"), true);
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCussAcctTo, typeInfo, this.currentCompany.getString("id"), true);
        } else {
            this.prmtCussAcctFrom.setEnabled(false);
            this.prmtCussAcctTo.setEnabled(false);
        }
        this.prmtCussAcctFrom.setValue(null);
        this.prmtCussAcctTo.setValue(null);
    }

    public FilterInfo getFilterInfo() {
        FilterItemInfo amtFilter;
        FilterItemInfo numFilter;
        FilterItemInfo cussAcctFilter;
        int iStatus;
        FilterItemInfo drawerFilter;
        this.filterInfo = new FilterInfo();
        IObjectValue bizInfo = null;
        int iFldCount = 0;
        StringBuffer maskStr = new StringBuffer();
        FilterItemCollection filterItems = this.filterInfo.getFilterItems();
        String companyId = this.currentCompany.getId().toString();
        FilterItemInfo companyFilter = new FilterItemInfo("company.id", (Object)companyId);
        filterItems.add(companyFilter);
        maskStr.append("#0 ");
        ++iFldCount;
        if (this.prmtCurrency.getValue() != null) {
            bizInfo = (IObjectValue)this.prmtCurrency.getValue();
            FilterItemInfo currFilter = new FilterItemInfo("currency.id", (Object)bizInfo.getString("id"));
            filterItems.add(currFilter);
            maskStr.append(" and #").append(iFldCount);
            ++iFldCount;
        }
        if (this.fAR && this.prmtDrawer.getValue() != null) {
            bizInfo = (IObjectValue)this.prmtDrawer.getValue();
            drawerFilter = new FilterItemInfo("drawer.id", (Object)bizInfo.getString("id"));
            filterItems.add(drawerFilter);
            maskStr.append(" and #").append(iFldCount);
            ++iFldCount;
        } else if (!this.fAR && !StringUtils.isEmpty((String)this.txtApDrawer.getText())) {
            drawerFilter = new FilterItemInfo("drawer", (Object)this.txtApDrawer.getText());
            filterItems.add(drawerFilter);
            maskStr.append(" and #").append(iFldCount);
            ++iFldCount;
        }
        int iType = this.comboBillType.getSelectedIndex();
        if (2 != iType) {
            Integer oType = iType == 0 ? new Integer(1) : new Integer(2);
            FilterItemInfo typeFilter = new FilterItemInfo("billType", (Object)oType);
            filterItems.add(typeFilter);
            maskStr.append(" and #").append(iFldCount);
            ++iFldCount;
        }
        if (3 != (iStatus = this.comboStatus.getSelectedIndex())) {
            Integer oStatus = null;
            if (iStatus == 0) {
                oStatus = new Integer(1);
            } else if (iStatus == 1) {
                oStatus = new Integer(2);
            } else if (iStatus == 2) {
                oStatus = new Integer(-1);
            }
            FilterItemInfo typeFilter = new FilterItemInfo("billStatus", (Object)oStatus);
            filterItems.add(typeFilter);
            maskStr.append(" and #").append(iFldCount);
            ++iFldCount;
        }
        if (this.comboCussAcctType.getSelectedItem() != null && !StringUtils.isEmpty((String)(bizInfo = (IObjectValue)this.comboCussAcctType.getSelectedItem()).getString("id"))) {
            FilterItemInfo cussTypeFilter = new FilterItemInfo("asstActType.id", (Object)bizInfo.getString("id"));
            filterItems.add(cussTypeFilter);
            maskStr.append(" and #").append(iFldCount);
            ++iFldCount;
        }
        boolean fHasFrom = false;
        boolean fHasTo = false;
        bizInfo = (IObjectValue)this.prmtCussAcctFrom.getValue();
        if (bizInfo != null && !StringUtils.isEmpty((String)bizInfo.getString("number"))) {
            cussAcctFilter = new FilterItemInfo("asstActNumber", (Object)bizInfo.getString("number"), CompareType.GREATER_EQUALS);
            filterItems.add(cussAcctFilter);
            fHasFrom = true;
        }
        if ((bizInfo = (IObjectValue)this.prmtCussAcctTo.getValue()) != null && !StringUtils.isEmpty((String)bizInfo.getString("number"))) {
            cussAcctFilter = new FilterItemInfo("asstActNumber", (Object)bizInfo.getString("number"), CompareType.LESS_EQUALS);
            filterItems.add(cussAcctFilter);
            fHasTo = true;
        }
        maskStr.append(this.getMaskStr(fHasFrom, fHasTo, iFldCount));
        iFldCount = fHasFrom ? iFldCount + 1 : iFldCount;
        iFldCount = fHasTo ? iFldCount + 1 : iFldCount;
        fHasFrom = false;
        fHasTo = false;
        if (this.pkDateFrom.getValue() != null) {
            FilterItemInfo fromBillDateFilter = new FilterItemInfo("billDate", (Object)BaseDataUtil.downTimestamp(this.pkDateFrom.getTimestamp()), CompareType.GREATER_EQUALS);
            filterItems.add(fromBillDateFilter);
            fHasFrom = true;
        }
        if (this.pkDateTo.getValue() != null) {
            FilterItemInfo toBillDateFilter = new FilterItemInfo("billDate", (Object)BaseDataUtil.upTimestamp(this.pkDateTo.getTimestamp()), CompareType.LESS);
            filterItems.add(toBillDateFilter);
            fHasTo = true;
        }
        maskStr.append(this.getMaskStr(fHasFrom, fHasTo, iFldCount));
        iFldCount = fHasFrom ? iFldCount + 1 : iFldCount;
        iFldCount = fHasTo ? iFldCount + 1 : iFldCount;
        fHasFrom = false;
        fHasTo = false;
        String sNum = this.txtNumFrom.getText();
        if (!StringUtils.isEmpty((String)sNum)) {
            numFilter = new FilterItemInfo("number", (Object)sNum, CompareType.GREATER_EQUALS);
            filterItems.add(numFilter);
            fHasFrom = true;
        }
        if (!StringUtils.isEmpty((String)(sNum = this.txtNumTo.getText()))) {
            numFilter = new FilterItemInfo("number", (Object)sNum, CompareType.LESS_EQUALS);
            filterItems.add(numFilter);
            fHasTo = true;
        }
        maskStr.append(this.getMaskStr(fHasFrom, fHasTo, iFldCount));
        iFldCount = fHasFrom ? iFldCount + 1 : iFldCount;
        iFldCount = fHasTo ? iFldCount + 1 : iFldCount;
        fHasFrom = false;
        fHasTo = false;
        BigDecimal amt = this.txtAmtFrom.getBigDecimalValue();
        if (amt != null) {
            amtFilter = new FilterItemInfo("totalAmount", (Object)amt, CompareType.GREATER_EQUALS);
            filterItems.add(amtFilter);
            fHasFrom = true;
        }
        if ((amt = this.txtAmtTo.getBigDecimalValue()) != null) {
            amtFilter = new FilterItemInfo("totalAmount", (Object)amt, CompareType.LESS_EQUALS);
            filterItems.add(amtFilter);
            fHasTo = true;
        }
        maskStr.append(this.getMaskStr(fHasFrom, fHasTo, iFldCount));
        this.filterInfo.setMaskString(maskStr.toString());
        return this.filterInfo;
    }

    private String getMaskStr(boolean fHasFrom, boolean fHasTo, int iCount) {
        if (fHasFrom && fHasTo) {
            return " and (#" + iCount + " and #" + (iCount + 1) + ") ";
        }
        if (fHasFrom && !fHasTo || !fHasFrom && fHasTo) {
            return " and #" + iCount + " ";
        }
        return "";
    }

    public void loadData(EntityViewInfo savedView) {
        this.clear();
        this.prmtCurrency.setValue(null);
        this.prmtDrawer.setValue(null);
        this.pkDateFrom.setValue(null);
        this.pkDateTo.setValue(null);
        FilterItemCollection filterItems = savedView.getFilter().getFilterItems();
        DateFormat dtFormat = BOSLocaleUtil.getDateFormat();
        boolean fSpecifiedAsstType = false;
        String propName = null;
        Object compVal = null;
        CompareType comp = null;
        for (int i = 0; i < filterItems.size(); ++i) {
            propName = filterItems.get(i).getPropertyName();
            compVal = filterItems.get(i).getCompareValue();
            comp = filterItems.get(i).getCompareType();
            if ("currency.id".equalsIgnoreCase(propName)) {
                ArApQueryUIUtil.setQueryUIBizPromptData(this.prmtCurrency, compVal.toString(), this);
                continue;
            }
            if ("drawer.id".equalsIgnoreCase(propName)) {
                ArApQueryUIUtil.setQueryUIBizPromptData(this.prmtDrawer, compVal.toString(), this);
                continue;
            }
            if ("drawer".equalsIgnoreCase(propName) && !this.fAR) {
                this.txtApDrawer.setText((String)compVal);
                continue;
            }
            if ("billType".equalsIgnoreCase(propName)) {
                int iType = Integer.parseInt(compVal.toString());
                if (iType == 1) {
                    this.comboBillType.setSelectedIndex(0);
                    continue;
                }
                this.comboBillType.setSelectedIndex(1);
                continue;
            }
            if ("billStatus".equalsIgnoreCase(propName)) {
                int iStatus = Integer.parseInt(compVal.toString());
                if (iStatus == 2) {
                    this.comboStatus.setSelectedIndex(1);
                    continue;
                }
                if (iStatus == -1) {
                    this.comboStatus.setSelectedIndex(2);
                    continue;
                }
                if (iStatus != 1) continue;
                this.comboStatus.setSelectedIndex(0);
                continue;
            }
            if ("asstActType.id".equalsIgnoreCase(propName)) {
                ClientUtils.setSelectedItem((KDComboBox)this.comboCussAcctType, (String)compVal.toString());
                fSpecifiedAsstType = true;
                continue;
            }
            if ("asstActNumber".equalsIgnoreCase(propName)) {
                if (CompareType.GREATER_EQUALS.equals((Object)comp)) {
                    ArApQueryUIUtil.setAsstActDataByNumber(this.prmtCussAcctFrom, compVal, this);
                    continue;
                }
                ArApQueryUIUtil.setAsstActDataByNumber(this.prmtCussAcctTo, compVal, this);
                continue;
            }
            if ("billDate".equalsIgnoreCase(propName)) {
                Date qryDate = new Date(System.currentTimeMillis());
                try {
                    java.util.Date utilDate = dtFormat.parse(compVal.toString());
                    qryDate = new Date(utilDate.getTime());
                }
                catch (ParseException e) {
                    logger.error((Object)("can't parse it, " + compVal), (Throwable)e);
                }
                if (CompareType.GREATER_EQUALS.equals((Object)comp)) {
                    this.pkDateFrom.setValue((Object)qryDate);
                    continue;
                }
                qryDate.setTime(qryDate.getTime() - 86400000L);
                this.pkDateTo.setValue((Object)qryDate);
                continue;
            }
            if ("number".equalsIgnoreCase(propName)) {
                if (CompareType.GREATER_EQUALS.equals((Object)comp)) {
                    this.txtNumFrom.setText((String)compVal);
                    continue;
                }
                this.txtNumTo.setText((String)compVal);
                continue;
            }
            if (!"totalAmount".equalsIgnoreCase(propName)) continue;
            if (CompareType.GREATER_EQUALS.equals((Object)comp)) {
                this.txtAmtFrom.setValue(compVal);
                continue;
            }
            this.txtAmtTo.setValue(compVal);
        }
        if (!fSpecifiedAsstType) {
            this.comboCussAcctType.setSelectedItem((Object)this.allType);
        }
    }

    public boolean verify() {
        Timestamp dateTo;
        Timestamp dateFrom;
        if (this.prmtCompany.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ARResources", (String)"nullCompany"));
            this.prmtCompany.requestFocus();
            return false;
        }
        if (this.pkDateFrom.getValue() != null && this.pkDateTo.getValue() != null && (dateFrom = this.pkDateFrom.getTimestamp()).after((java.util.Date)(dateTo = this.pkDateTo.getTimestamp()))) {
            this.pkDateFrom.requestFocus();
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"204_DateFail"));
            return false;
        }
        return true;
    }

    public void clear() {
        this.prmtCompany.setValue((Object)this.currentCompany);
        this.prmtCurrency.setValue((Object)this.baseCurrency);
        this.prmtDrawer.setValue((Object)this.curPersonInfo);
        if (this.invoiceType == null) {
            this.comboBillType.setSelectedIndex(2);
        }
        this.comboStatus.setSelectedIndex(3);
        this.comboCussAcctType.setSelectedIndex(this.defaultAsstTypeInd);
        this.prmtCussAcctFrom.setValue(null);
        this.prmtCussAcctTo.setValue(null);
        this.pkDateTo.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        this.pkDateFrom.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        this.txtAmtFrom.setText(null);
        this.txtAmtTo.setText(null);
        this.txtNumFrom.setText(null);
        this.txtNumTo.setText(null);
    }
}

