/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTAbstractAction;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.util.CommonPrintIntegrationDataProvider;
import com.kingdee.eas.basedata.assistant.util.PrintIntegrationManager;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyBank;
import com.kingdee.eas.basedata.master.cssp.ICustomerCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyBank;
import com.kingdee.eas.basedata.master.cssp.ISupplierCompanyInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyBankInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUI;
import com.kingdee.eas.basedata.master.material.client.F7MaterialMultiUISelectorAdaptor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.fi.ap.ApInvoiceInfo;
import com.kingdee.eas.fi.ap.client.ApInvoiceNormalEditUI;
import com.kingdee.eas.fi.ap.client.ApInvoiceVATEditUI;
import com.kingdee.eas.fi.ar.AbstractArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArInvoiceInfo;
import com.kingdee.eas.fi.ar.BillStatusEnum;
import com.kingdee.eas.fi.ar.IArApBillEntryBase;
import com.kingdee.eas.fi.ar.client.ArInvoiceNormalEditUI;
import com.kingdee.eas.fi.ar.client.ArInvoiceVATEditUI;
import com.kingdee.eas.fi.arap.ArApFetchData;
import com.kingdee.eas.fi.arap.ArApFetchDataCondition;
import com.kingdee.eas.fi.arap.ArApFetchDataFacadeFactory;
import com.kingdee.eas.fi.arap.IInvoice;
import com.kingdee.eas.fi.arap.InvoiceEntryCollection;
import com.kingdee.eas.fi.arap.InvoiceEntryInfo;
import com.kingdee.eas.fi.arap.InvoiceException;
import com.kingdee.eas.fi.arap.InvoiceInfo;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.eas.fi.arap.client.AbstractInvoiceVATEditUI;
import com.kingdee.eas.fi.arap.client.InvoiceBTPUtil;
import com.kingdee.eas.fi.arap.client.InvoiceBillEditImpl;
import com.kingdee.eas.fi.arap.client.InvoiceGroupHelper;
import com.kingdee.eas.fi.arap.client.InvoicePrintQueryDelegate;
import com.kingdee.eas.fi.arap.client.KDTableUtils;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.client.util.ArApReportUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.fi.arap_tax.TaxRelationInfo;
import com.kingdee.eas.fi.arap_tax.TaxRelationTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.IBTPBillEdit;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.common.client.SCMGroupClientUtils;
import com.kingdee.eas.scm.common.util.MultiDataSourceDataProviderProxy;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.File;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class InvoiceVATEditUI
extends AbstractInvoiceVATEditUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(InvoiceVATEditUI.class);
    protected static final String INVRES = "com.kingdee.eas.fi.arap.InvResource";
    private static final BOSObjectType CUST_TYPE = new CustomerInfo().getBOSType();
    private static final BOSObjectType SUPP_TYPE = new SupplierInfo().getBOSType();
    protected static final IMetaDataPK ARPRINT_QRY = new MetaDataPK("com.kingdee.eas.fi.ar.app.ArInvoicePrintQuery");
    protected static final IMetaDataPK APPRINT_QRY = new MetaDataPK("com.kingdee.eas.fi.ap.app.ApInvoicePrintQuery");
    public static final String COL_MATERIAL = "material";
    public static final String COL_EXPENSEITEM = "expenseItemNumber";
    public static final String COL_EXPENSEITEMNAME = "expenseItemName";
    public static final String COL_TYPE = "materialType";
    public static final String COL_UNIT = "measureUnit";
    public static final String COL_QUANTITY = "quantity";
    public static final String COL_UNITPRICE = "unitPrice";
    public static final String COL_AMT = "amount";
    public static final String COL_TRATE = "taxRate";
    public static final String COL_TAMT = "taxAmount";
    public static final String COL_ACTUALAMT = "actualAmount";
    public static final String FLD_FREEAMT = "canInvAmt";
    protected transient IBTPBillEdit btpEdit = null;
    protected CompanyOrgUnitInfo companyInfo = null;
    protected PeriodInfo startPeriod = null;
    private Map srcEntriesAmtMap = null;
    private String bindProp = "type";
    private static final String[] ENTRY_FIELDS = new String[]{"material", "materialType", "unitPrice", "quantity", "amount", "taxRate", "taxAmount"};
    private static final String[] SUM_COLS = new String[]{"quantity", "amount", "taxAmount", "actualAmount"};
    protected transient KDTEditAdapter kdEntriesEditAdapter = null;
    protected transient KDTAbstractAction kdEntriesDelAction = null;
    private CodingRuleInfo codingRuleInfo = null;
    protected DataChangeListener prmtCusAcctListener = null;
    protected ArApFetchData fetchData = null;
    protected HashMap initFetchParamMap = new HashMap();
    protected File lastFile = null;
    private DataBaseInfo accountCussentInfo = null;

    protected KDBizPromptBox getMainBizOrg() {
        return this.prmptCompany;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnBlankout.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.setButtonDefaultStyl(this.btnBlankout);
        this.menuItemBlankout.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        this.btnGTaxExport.setIcon(EASResource.getIcon((String)"imgTbtn_createtax"));
        this.menuItemGTaxExport.setIcon(EASResource.getIcon((String)"imgTbtn_createtax"));
        this.setButtonDefaultStyl(this.btnGTaxExport);
    }

    public int getBtpCreateFromType() {
        return 1;
    }

    protected final String getResource() {
        return "com.kingdee.eas.fi.ar.client.ArResource";
    }

    protected void showBlankoutSuccessful() {
        this.setNextMessageText(this.getClassAlise() + " " + EASResource.getString((String)INVRES, (String)"Msg_Blankout"));
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    protected String getPermissionItem(String status) {
        return null;
    }

    private void checkBeforeLoad() throws Exception {
        this.companyInfo = SysContext.getSysContext().getCurrentFIUnit();
        ArApReportUIUtil.checkCompany((Component)((Object)this), this.companyInfo);
        if (this.getBOTPViewStatus() != 1) {
            UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
            ObjectUuidPK userPK = new ObjectUuidPK(userInfo.getId());
            ObjectUuidPK compPK = new ObjectUuidPK(this.companyInfo.getId());
            PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)compPK, (String)this.getPermissionItem(this.getOprtState()));
        }
    }

    protected boolean isAutoNumber() {
        return this.codingRuleInfo != null;
    }

    protected boolean isNewNumAddView() {
        return this.codingRuleInfo != null && this.codingRuleInfo.isIsAddView();
    }

    protected boolean isNumIntermitable() {
        return this.codingRuleInfo != null && this.codingRuleInfo.getRuleType() == 0;
    }

    protected boolean isNumAddViewNoBreak() {
        return this.codingRuleInfo != null && this.codingRuleInfo.isIsaddnewbreak();
    }

    protected boolean isNumModifiable() {
        return this.codingRuleInfo != null && this.codingRuleInfo.isIsModifiable();
    }

    protected String getNewNumber(boolean fSubmit) throws Exception {
        if (!this.isAutoNumber()) {
            return null;
        }
        String num = null;
        String companyId = this.companyInfo.getId().toString();
        ICodingRuleManager iCodingRuleMgr = CodingRuleManagerFactory.getRemoteInstance();
        if (this.isNewNumAddView()) {
            num = this.fetchData.getInvoiceBillNumber();
        } else if (this.isNumAddViewNoBreak()) {
            num = this.fetchData.getInvoiceBillNumber();
        } else if (this.isNumIntermitable() && fSubmit) {
            num = iCodingRuleMgr.getNumber((IObjectValue)this.getEditData(), companyId, this.bindProp, "");
        }
        return num;
    }

    protected void rollbackNumber() throws Exception {
        String companyId = this.companyInfo.getId().toString();
        ICodingRuleManager iCodingMgr = CodingRuleManagerFactory.getRemoteInstance();
        if (iCodingMgr.isUseIntermitNumber((IObjectValue)this.getEditData(), companyId, this.bindProp)) {
            iCodingMgr.recycleNumber((IObjectValue)this.getEditData(), companyId, this.bindProp, "", this.getEditData().getNumber());
            logger.info((Object)"recycle the number, the codingRule must be continous.");
        }
    }

    @Override
    public void setOprtState(String oprtType) {
        if (this.getBOTPViewStatus() == 1 && (OprtState.ADDNEW.equals(oprtType) || OprtState.VIEW.equals(oprtType))) {
            super.setOprtState("EDIT");
        } else {
            super.setOprtState(oprtType);
            if ("VIEW".equals(this.oprtState)) {
                this.actionSubmit.setEnabled(false);
                this.actionCancel.setEnabled(false);
                this.actionCancelCancel.setEnabled(false);
                this.actionRemove.setEnabled(false);
                this.actionEdit.setEnabled(false);
                this.actionCopy.setEnabled(false);
            }
        }
    }

    public void onLoad() throws Exception {
        InvoiceInfo invInfo;
        this.checkBeforeLoad();
        if ("ADDNEW".equals(this.getOprtState())) {
            this.getUIContext().remove("IDList");
        }
        this.txtTotalAmount.setHorizontalAlignment(4);
        this.txtTotalAmount.setRemoveingZeroInDispaly(false);
        this.initBtpEdit();
        super.onLoad();
        if (this.getEditData() instanceof InvoiceInfo && (invInfo = (InvoiceInfo)this.getEditData()).getCompany() != null) {
            this.companyInfo = invInfo.getCompany();
        }
        this.initEntryTable();
        this.setNumCtrlStatus();
        this.actionSave.setEnabled(false);
        this.menuItemSave.setVisible(false);
        this.actionAuditResult.setEnabled(false);
        this.actionAuditResult.setVisible(false);
        this.actionCopyLine.setEnabled(false);
        this.actionCopyLine.setVisible(false);
        if (this.prmtCussType.getData() != null) {
            AsstActTypeInfo typeInfo = this.fetchData.getAsstActTypeInfo();
            if (typeInfo != null) {
                typeInfo = AsstActTypeFactory.getRemoteInstance().getAsstActTypeInfo((IObjectPK)new ObjectUuidPK(typeInfo.getId()));
                this.fetchData.setAsstActTypeInfo(typeInfo);
            }
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCusAcct, typeInfo, this.companyInfo, false, this.fetchData.getF7DisplayMode());
        }
        this.setCurrPeriod2Status();
    }

    protected void setCurrPeriod2Status() throws Exception {
        if (this.companyInfo == null) {
            return;
        }
        PeriodInfo currPeriod = this.fetchData.getCacheCurrentPeriod();
        if (currPeriod == null) {
            return;
        }
        String title = EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"StatusCurrPeriod");
        title = MessageFormat.format(title, String.valueOf(currPeriod.getPeriodYear()), String.valueOf(currPeriod.getPeriodNumber()));
        this.getMainStatusBar().setPerTitle(title);
    }

    public IObjectPK runSubmit() throws Exception {
        try {
            return super.runSubmit();
        }
        catch (Exception ex) {
            this.rollbackNumber();
            throw ex;
        }
    }

    protected void setNumCtrlStatus() {
        if ("VIEW".equals(this.getOprtState())) {
            this.txtNumber.setEditable(false);
            return;
        }
        if (this.editData instanceof ArInvoiceInfo && (BillStatusEnum.SUBMITED.equals((Object)((ArInvoiceInfo)this.editData).getBillStatus()) || BillStatusEnum.DELETED.equals((Object)((ArInvoiceInfo)this.editData).getBillStatus()))) {
            this.txtNumber.setEditable(false);
            return;
        }
        if (this.editData instanceof ApInvoiceInfo && (BillStatusEnum.SUBMITED.equals((Object)((ApInvoiceInfo)this.editData).getBillStatus()) || BillStatusEnum.DELETED.equals((Object)((ApInvoiceInfo)this.editData).getBillStatus()))) {
            this.txtNumber.setEditable(false);
            return;
        }
        boolean fNumEnabled = !this.isAutoNumber() || this.isNewNumAddView() && this.isNumModifiable();
        this.txtNumber.setEditable(fNumEnabled);
    }

    protected void setPrmtQuery_Filter() {
        String personQry = "com.kingdee.eas.basedata.person.app.PersonQuery";
        this.setPersonPrmtQuery(personQry);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyInfo.getString("id")));
        view.setFilter(filter);
        this.prmtCompAcctBank.setEntityViewInfo(view);
    }

    protected void setPersonPrmtQuery(String personQry) {
        this.prmtbillHandler.setQueryInfo(personQry);
        this.prmtAuditor.setQueryInfo(personQry);
    }

    private void initEntryTable() throws Exception {
        this.kdtEntries.setActiveCellStatus(1);
        KDTableHelper.updateEnterWithTab((KDTable)this.kdtEntries, (boolean)false);
        KDTableHelper.downArrowAutoAddRow((KDTable)this.kdtEntries, (boolean)false, null);
        this.setMaterialEditor();
        this.setExpenseItemEditor();
        this.setPrecisionAndDisplayFormat();
        this.kdtEntries.getActionMap().remove("Copy");
        this.initTableListener();
    }

    private void setPrecisionAndDisplayFormat() {
        int precision = this.getInfoCurrPrecision();
        this.txtTotalAmount.setPrecision(precision);
        String amtFldsFmt = PrecisionFormatUtils.getFormatString(precision);
        KDFormattedTextField txtAmt = new KDFormattedTextField();
        txtAmt.setDataType(1);
        txtAmt.setPrecision(precision);
        txtAmt.setRemoveingZeroInDispaly(false);
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)txtAmt);
        this.kdtEntries.getColumn(COL_AMT).setEditor((ICellEditor)editor);
        this.kdtEntries.getColumn(COL_ACTUALAMT).setEditor((ICellEditor)editor);
        this.kdtEntries.getColumn(COL_AMT).getStyleAttributes().setNumberFormat(amtFldsFmt);
        this.kdtEntries.getColumn(COL_ACTUALAMT).getStyleAttributes().setNumberFormat(amtFldsFmt);
        this.kdtEntries.getColumn(COL_TAMT).getStyleAttributes().setNumberFormat(amtFldsFmt);
        this.kdtEntries.getColumn(COL_QUANTITY).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntries.getColumn(COL_UNITPRICE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntries.getColumn(COL_AMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntries.getColumn(COL_ACTUALAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntries.getColumn(COL_TAMT).setEditor((ICellEditor)editor);
        KDFormattedTextField txtTrate = new KDFormattedTextField();
        txtTrate.setDataType(1);
        txtTrate.setMaximumValue((Comparable)new BigDecimal("100.00"));
        txtTrate.setMinimumValue((Comparable)SysConstant.BIGZERO);
        txtTrate.setPrecision(2);
        txtTrate.setRemoveingZeroInDispaly(false);
        KDTDefaultCellEditor tRateEditor = new KDTDefaultCellEditor((JTextField)txtTrate);
        this.kdtEntries.getColumn(COL_TRATE).setEditor((ICellEditor)tRateEditor);
        String tRateFormat = PrecisionFormatUtils.getFormatString(2);
        this.kdtEntries.getColumn(COL_TRATE).getStyleAttributes().setNumberFormat(tRateFormat);
        this.kdtEntries.getColumn(COL_TRATE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtEntries.getColumn(COL_TAMT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    protected int getInfoCurrPrecision() {
        int precision = 4;
        if (this.getEditData() != null && ((InvoiceInfo)this.getEditData()).getCurrency() != null) {
            precision = ((InvoiceInfo)this.getEditData()).getCurrency().getPrecision();
        }
        return precision;
    }

    protected void initTableListener() {
        if ("VIEW".equals(this.getOprtState())) {
            return;
        }
        this.kdtEntries.getStyleAttributes().setLocked(false);
        this.kdtEntries.getColumn(COL_TYPE).getStyleAttributes().setLocked(true);
        if (this.kdEntriesEditAdapter == null) {
            this.kdEntriesEditAdapter = new KDTEditAdapter(){

                public void editStopped(KDTEditEvent e) {
                    try {
                        InvoiceVATEditUI.this.tblContentChanged(e);
                    }
                    catch (Exception exc) {
                        InvoiceVATEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        if (this.kdEntriesDelAction == null) {
            this.kdEntriesDelAction = new KDTAbstractAction(this.kdtEntries){

                public void actionPerformed(ActionEvent e) {
                    if (e.getSource() == InvoiceVATEditUI.this.kdtEntries) {
                        InvoiceVATEditUI.this.kdtEntries.getEditHelper().delete();
                        try {
                            KDTSelectManager sm = InvoiceVATEditUI.this.kdtEntries.getSelectManager();
                            IRow curRow = InvoiceVATEditUI.this.kdtEntries.getRow(sm.getActiveRowIndex());
                            String colKey = InvoiceVATEditUI.this.kdtEntries.getColumnKey(sm.getActiveColumnIndex());
                            InvoiceVATEditUI.this.tblValChangeProcess(curRow, colKey);
                        }
                        catch (Exception exc) {
                            InvoiceVATEditUI.this.handUIException(exc);
                        }
                    }
                }
            };
        }
        this.kdtEntries.removeKDTEditListener((KDTEditListener)this.kdEntriesEditAdapter);
        this.kdtEntries.addKDTEditListener((KDTEditListener)this.kdEntriesEditAdapter);
        this.kdtEntries.getActionMap().remove("Delete");
        this.kdtEntries.getActionMap().put("Delete", (Action)this.kdEntriesDelAction);
    }

    protected void setMaterialUnitF7(IRow row, boolean isMaterialChanged) {
        MaterialInfo materialInfo = (MaterialInfo)row.getCell(COL_MATERIAL).getValue();
        if (materialInfo == null || materialInfo.getId() == null) {
            row.getCell(COL_UNIT).setEditor(null);
            return;
        }
        Map materialCollMap = this.fetchData.getMaterialCollMap();
        Map measureUnitCollMap = this.fetchData.getMeasureUnitCollMap();
        if (materialInfo.getName() == null) {
            String materialID = materialInfo.getId().toString();
            materialInfo = (MaterialInfo)materialCollMap.get(materialID);
            try {
                if (materialInfo == null && !materialCollMap.containsKey(materialID)) {
                    IMaterial iMaterial = MaterialFactory.getRemoteInstance();
                    String oql = "select name, number, model, baseUnit.*,pricePrecision where id = '" + materialID + "'";
                    materialInfo = (MaterialInfo)iMaterial.getValue(oql);
                    this.fetchData.getMaterialCollMap().put(materialInfo.getId().toString(), materialInfo);
                }
                row.getCell(COL_MATERIAL).setValue((Object)materialInfo);
                row.getCell(COL_TYPE).setValue((Object)materialInfo.getModel());
                MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)row.getCell(COL_UNIT).getValue();
                if (isMaterialChanged && measureUnitInfo == null) {
                    row.getCell(COL_UNIT).setValue((Object)materialInfo.getBaseUnit());
                } else if (measureUnitInfo != null && measureUnitInfo.getId() != null && measureUnitInfo.getName() == null) {
                    String measureUnitID = measureUnitInfo.getId().toString();
                    if ((measureUnitInfo = (MeasureUnitInfo)measureUnitCollMap.get(measureUnitID)) == null && !measureUnitCollMap.containsKey(measureUnitID)) {
                        IMeasureUnit iMeasureUni = MeasureUnitFactory.getRemoteInstance();
                        measureUnitInfo = iMeasureUni.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measureUnitID));
                        this.fetchData.getMeasureUnitCollMap().put(measureUnitID, measureUnitInfo);
                    }
                    row.getCell(COL_UNIT).setValue((Object)measureUnitInfo);
                }
            }
            catch (Exception e) {
                logger.error((Object)"exception while get material", (Throwable)e);
            }
        }
        KDBizPromptBox unitPrmtBox = new KDBizPromptBox();
        unitPrmtBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MultiMeasureUnitQuery");
        unitPrmtBox.setCommitFormat("$number$");
        unitPrmtBox.setDisplayFormat("$name$");
        unitPrmtBox.setEditFormat("$number$");
        unitPrmtBox.setEditable(true);
        KDTDefaultCellEditor unit_CellEditor = new KDTDefaultCellEditor((IKDEditor)unitPrmtBox);
        row.getCell(COL_UNIT).setEditor((ICellEditor)unit_CellEditor);
        row.getCell(COL_UNIT).getStyleAttributes().setLocked(false);
        SCMClientUtils.setF7MeasureUnit((KDBizPromptBox)unitPrmtBox, (String)materialInfo.getId().toString());
    }

    protected void initBtpEdit() {
        if (this.btpEdit == null) {
            this.btpEdit = new InvoiceBillEditImpl((CoreBillEditUI)this, true);
        }
    }

    private void initCodingRule() {
        try {
            this.codingRuleInfo = this.fetchData.getCodingRuleInfo();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void tblContentChanged(KDTEditEvent e) throws Exception {
        if (ArApBillHelper.objectEquals(e.getOldValue(), e.getValue())) {
            return;
        }
        IRow curRow = this.kdtEntries.getRow(e.getRowIndex());
        int colIndex = e.getColIndex();
        String colKey = this.kdtEntries.getColumn(colIndex).getKey();
        this.tblValChangeProcess(curRow, colKey);
    }

    protected void tblValChangeProcess(IRow curRow, String colKey) throws BOSException, EASBizException {
        if (colKey.equals(COL_MATERIAL)) {
            this.materialChanged(curRow);
        } else if (colKey.equals(COL_EXPENSEITEM)) {
            this.expenseItemChanged(curRow);
        } else if (colKey.equals(COL_UNIT)) {
            this.materialUnitChanged(curRow);
        } else if (colKey.equals(COL_QUANTITY) || colKey.equals(COL_UNITPRICE)) {
            this.quantityUnitPriceChanged(curRow);
        } else if (colKey.equals(COL_AMT)) {
            this.amtChanged(curRow);
        } else if (colKey.equals(COL_TRATE)) {
            this.tRateChanged(curRow);
        } else if (colKey.equals(COL_TAMT)) {
            this.tAmtChanged(curRow);
        } else if (colKey.equals(COL_ACTUALAMT)) {
            this.actualAmtChanged(curRow);
        }
    }

    protected void quantityUnitPriceChanged(IRow curRow) {
        BigDecimal quantity = (BigDecimal)curRow.getCell(COL_QUANTITY).getValue();
        BigDecimal unitPrice = (BigDecimal)curRow.getCell(COL_UNITPRICE).getValue();
        BigDecimal amountTotal = (BigDecimal)curRow.getCell(COL_AMT).getValue();
        int signum = 1;
        if (amountTotal != null) {
            signum = amountTotal.signum();
        }
        BigDecimal one = null;
        one = signum == 1 ? new BigDecimal("1.00") : new BigDecimal("-1.00");
        quantity = quantity == null || quantity.compareTo(SysConstant.BIGZERO) == 0 ? one : quantity;
        unitPrice = unitPrice == null ? SysConstant.BIGZERO : unitPrice;
        BigDecimal tAmt = SysConstant.BIGZERO;
        BigDecimal tFreeAmt = SysConstant.BIGZERO;
        BigDecimal amt = SysConstant.BIGZERO;
        tFreeAmt = quantity.multiply(unitPrice);
        BigDecimal tRate = (BigDecimal)curRow.getCell(COL_TRATE).getValue();
        if (tRate != null) {
            tRate = new BigDecimal(tRate.toString());
            tRate = tRate.multiply(new BigDecimal("0.01"));
            tAmt = tFreeAmt.multiply(tRate);
        }
        int precision = this.getInfoCurrPrecision();
        tFreeAmt = tFreeAmt.setScale(precision, 4);
        tAmt = tAmt.setScale(precision, 4);
        amt = tFreeAmt.add(tAmt);
        amt = amt.setScale(precision, 4);
        BigDecimal canInvAmt = this.getEntryCanInvAmt(curRow);
        if (canInvAmt != null) {
            boolean fInvalid = this.validAmtWithCanInvAmt(amt, canInvAmt);
            if (fInvalid) {
                amt = null;
                curRow.getCell(COL_AMT).setValue((Object)canInvAmt);
                curRow.getCell(COL_TAMT).setValue((Object)SysConstant.BIGZERO);
                curRow.getCell(COL_ACTUALAMT).setValue((Object)canInvAmt);
            } else {
                curRow.getCell(COL_AMT).setValue((Object)tFreeAmt);
                curRow.getCell(COL_TAMT).setValue((Object)tAmt);
                curRow.getCell(COL_ACTUALAMT).setValue((Object)amt);
            }
        }
        this.setBillTotalAmount();
    }

    protected BigDecimal getEntryCanInvAmt(IRow curRow) {
        BigDecimal canInvAmt = SysConstant.BIGZERO;
        InvoiceEntryInfo invEntry = (InvoiceEntryInfo)curRow.getUserObject();
        if (invEntry == null || invEntry.getId() == null) {
            return canInvAmt;
        }
        String destEntryID = invEntry.getId().toString();
        if (this.srcEntriesAmtMap.get(destEntryID) != null) {
            canInvAmt = ((ArApBillEntryBaseInfo)this.srcEntriesAmtMap.get(destEntryID)).getBigDecimal(FLD_FREEAMT);
        }
        return canInvAmt;
    }

    protected void amtChanged(IRow curRow) {
        BigDecimal canInvAmt = this.getEntryCanInvAmt(curRow);
        BigDecimal tFreeAmt = (BigDecimal)curRow.getCell(COL_AMT).getValue();
        tFreeAmt = tFreeAmt == null ? SysConstant.BIGZERO : tFreeAmt;
        BigDecimal unitPrice = (BigDecimal)curRow.getCell(COL_UNITPRICE).getValue();
        unitPrice = unitPrice == null ? SysConstant.BIGZERO : unitPrice;
        BigDecimal tRate = (BigDecimal)curRow.getCell(COL_TRATE).getValue();
        BigDecimal tAmt = tRate == null ? SysConstant.BIGZERO : tFreeAmt.multiply(tRate.multiply(new BigDecimal("0.01")));
        tAmt = tAmt == null ? SysConstant.BIGZERO : tAmt;
        BigDecimal amt = tFreeAmt.add(tAmt);
        int precision = this.getInfoCurrPrecision();
        BigDecimal quantity = SysConstant.BIGZERO;
        int quantityPrecision = 6;
        if (curRow.getCell(COL_QUANTITY).getEditor() != null && curRow.getCell(COL_QUANTITY).getEditor().getComponent() != null) {
            quantityPrecision = ((KDFormattedTextField)curRow.getCell(COL_QUANTITY).getEditor().getComponent()).getPrecision();
        }
        if (unitPrice != SysConstant.BIGZERO) {
            quantity = tFreeAmt.divide(unitPrice, quantityPrecision, 4);
        }
        amt = amt.setScale(precision, 4);
        if (canInvAmt != null) {
            boolean fInvalid = this.validAmtWithCanInvAmt(amt, canInvAmt);
            if (fInvalid) {
                curRow.getCell(COL_AMT).setValue((Object)canInvAmt);
                curRow.getCell(COL_TAMT).setValue((Object)SysConstant.BIGZERO);
                curRow.getCell(COL_ACTUALAMT).setValue((Object)canInvAmt);
            } else {
                curRow.getCell(COL_QUANTITY).setValue((Object)quantity);
                curRow.getCell(COL_TAMT).setValue((Object)tAmt);
                curRow.getCell(COL_ACTUALAMT).setValue((Object)amt);
            }
        }
        this.setBillTotalAmount();
    }

    protected void tRateChanged(IRow curRow) {
        BigDecimal tRate = (BigDecimal)curRow.getCell(COL_TRATE).getValue();
        tRate = tRate == null ? SysConstant.BIGZERO : tRate;
        BigDecimal tFreeAmt = (BigDecimal)curRow.getCell(COL_AMT).getValue();
        tFreeAmt = tFreeAmt == null ? SysConstant.BIGZERO : tFreeAmt;
        BigDecimal tAmt = tFreeAmt.multiply(tRate).multiply(new BigDecimal("0.01"));
        BigDecimal canInvAmt = this.getEntryCanInvAmt(curRow);
        BigDecimal amt = tFreeAmt.add(tAmt);
        int precision = this.getInfoCurrPrecision();
        amt = amt.setScale(precision, 4);
        if (canInvAmt != null) {
            boolean fInvalid = this.validAmtWithCanInvAmt(amt, canInvAmt);
            if (fInvalid) {
                curRow.getCell(COL_TAMT).setValue((Object)canInvAmt.subtract(tFreeAmt));
                curRow.getCell(COL_ACTUALAMT).setValue((Object)canInvAmt);
            } else {
                curRow.getCell(COL_TAMT).setValue((Object)tAmt);
                curRow.getCell(COL_ACTUALAMT).setValue((Object)amt);
            }
        }
        this.setBillTotalAmount();
    }

    protected void tAmtChanged(IRow curRow) {
        BigDecimal tFreeAmt = (BigDecimal)curRow.getCell(COL_AMT).getValue();
        BigDecimal tAmt = (BigDecimal)curRow.getCell(COL_TAMT).getValue();
        tFreeAmt = tFreeAmt == null ? SysConstant.BIGZERO : tFreeAmt;
        tAmt = tAmt == null ? SysConstant.BIGZERO : tAmt;
        BigDecimal canInvAmt = this.getEntryCanInvAmt(curRow);
        BigDecimal amt = tFreeAmt.add(tAmt);
        int precision = this.getInfoCurrPrecision();
        amt = amt.setScale(precision, 4);
        if (canInvAmt != null) {
            boolean fInvalid = this.validAmtWithCanInvAmt(amt, canInvAmt);
            if (fInvalid) {
                curRow.getCell(COL_TAMT).setValue((Object)canInvAmt.subtract(tFreeAmt));
                curRow.getCell(COL_ACTUALAMT).setValue((Object)canInvAmt);
            } else {
                curRow.getCell(COL_ACTUALAMT).setValue((Object)amt);
            }
        }
        this.setBillTotalAmount();
    }

    protected void actualAmtChanged(IRow curRow) {
        BigDecimal amt = (BigDecimal)curRow.getCell(COL_ACTUALAMT).getValue();
        BigDecimal tRate = (BigDecimal)curRow.getCell(COL_TRATE).getValue();
        BigDecimal canInvAmt = this.getEntryCanInvAmt(curRow);
        boolean fInvalid = this.validAmtWithCanInvAmt(amt, canInvAmt);
        BigDecimal bigDecimal = amt = fInvalid ? canInvAmt : amt;
        if (fInvalid) {
            curRow.getCell(COL_ACTUALAMT).setValue((Object)canInvAmt);
            curRow.getCell(COL_TAMT).setValue((Object)SysConstant.BIGZERO);
        } else {
            MaterialInfo materialInfo = (MaterialInfo)curRow.getCell(COL_MATERIAL).getValue();
            int pricePrecision = 6;
            if (materialInfo != null && materialInfo.getPricePrecision() != -1) {
                pricePrecision = materialInfo.getPricePrecision();
            }
            int currPrecision = this.getInfoCurrPrecision();
            InvoiceEntryInfo entryInfo = (InvoiceEntryInfo)curRow.getUserObject();
            BigDecimal quantity = entryInfo.getQuantity();
            BigDecimal unitPrice = SysConstant.BIGZERO;
            if (quantity.compareTo(SysConstant.BIGZERO) != 0) {
                unitPrice = amt.divide(quantity.multiply(tRate.multiply(new BigDecimal("0.01")).add(new BigDecimal("1"))), pricePrecision, 4);
            }
            BigDecimal amount = amt.divide(tRate.multiply(new BigDecimal("0.01")).add(new BigDecimal("1")), currPrecision, 4);
            BigDecimal taxAmount = amt.subtract(amount);
            entryInfo.setTaxRate(tRate);
            entryInfo.setAmount(amount);
            entryInfo.setTaxAmount(taxAmount);
            entryInfo.setUnitPrice(unitPrice);
            curRow.getCell(COL_AMT).setValue((Object)amount);
            curRow.getCell(COL_TAMT).setValue((Object)taxAmount);
            curRow.getCell(COL_UNITPRICE).setValue((Object)unitPrice);
        }
        this.setBillTotalAmount();
    }

    private BigDecimal getTaxFreeAmt(BigDecimal taxedAmt, BigDecimal tRate, int precision) {
        if (tRate == null || tRate.signum() == 0) {
            return taxedAmt;
        }
        BigDecimal tFreeAmt = taxedAmt.multiply(InvoiceBTPUtil.HUNDRED).divide(tRate.add(InvoiceBTPUtil.HUNDRED), 20, 5);
        tFreeAmt = tFreeAmt.setScale(precision, 5);
        return tFreeAmt;
    }

    protected boolean validAmtWithCanInvAmt(BigDecimal amt, BigDecimal canInvAmt) {
        boolean fInvalid = false;
        int amtSign = amt.signum();
        int canInvSign = canInvAmt.signum();
        if (amtSign == 0) {
            String msg = EASResource.getString((String)INVRES, (String)"Msg_AmtZero");
            fInvalid = true;
            this.showInvalidMsg(msg, amt, canInvAmt);
            return fInvalid;
        }
        if (amtSign != canInvSign) {
            String msg = EASResource.getString((String)INVRES, (String)"Msg_AmtSignDiff");
            fInvalid = true;
            this.showInvalidMsg(msg, amt, canInvAmt);
        } else if (amtSign != -1 && amt.compareTo(canInvAmt) == 1) {
            String msg = EASResource.getString((String)INVRES, (String)"Msg_InvAmtLE_SrcInvAmt");
            fInvalid = true;
            this.showInvalidMsg(msg, amt, canInvAmt);
        } else if (amtSign == -1 && amt.compareTo(canInvAmt) == -1) {
            String msg = EASResource.getString((String)INVRES, (String)"Msg_RedInvAmtLT_SrcAmt");
            fInvalid = true;
            this.showInvalidMsg(msg, amt, canInvAmt);
        }
        return fInvalid;
    }

    private void showInvalidMsg(String msg, BigDecimal amt, BigDecimal canInvAmt) {
        this.setShowMessagePolicy(2);
        this.setMessageText(msg);
        this.setIsShowTextOnly(false);
        this.setMessageBgcolor(SHOW_MESSAGE_BG_ERROR);
        this.setMessageIcon(SHOW_MESSAGE_ICON_ERROR);
        this.showMessage();
        logger.warn((Object)(msg + "\r\n amt: " + amt + " canInvAmt: " + canInvAmt));
    }

    private void materialChanged(IRow curRow) throws BOSException, EASBizException {
        MaterialInfo materialInfo = (MaterialInfo)curRow.getCell(COL_MATERIAL).getValue();
        if (materialInfo != null && materialInfo.getBaseUnit() != null) {
            curRow.getCell(COL_TYPE).setValue((Object)materialInfo.getModel());
            this.setMaterialUnitF7(curRow, true);
            MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)curRow.getCell(COL_UNIT).getValue();
            if (measureUnitInfo != null && measureUnitInfo.getId() != null && measureUnitInfo.getName() == null) {
                IMeasureUnit iUnit = MeasureUnitFactory.getRemoteInstance();
                ObjectUuidPK unitPK = new ObjectUuidPK(measureUnitInfo.getId());
                measureUnitInfo = iUnit.getMeasureUnitInfo((IObjectPK)unitPK);
                curRow.getCell(COL_UNIT).setValue((Object)measureUnitInfo);
            } else {
                IMeasureUnit iUnit = MeasureUnitFactory.getRemoteInstance();
                ObjectUuidPK unitPK = new ObjectUuidPK(materialInfo.getBaseUnit().getId());
                measureUnitInfo = iUnit.getMeasureUnitInfo((IObjectPK)unitPK);
                curRow.getCell(COL_UNIT).setValue((Object)measureUnitInfo);
            }
            this.setQuantityPrecision(curRow);
            curRow.getCell(COL_EXPENSEITEM).setValue(null);
            curRow.getCell(COL_EXPENSEITEMNAME).setValue(null);
        } else {
            curRow.getCell(COL_UNIT).setEditor(null);
            curRow.getCell(COL_TYPE).setValue(null);
            curRow.getCell(COL_UNIT).setValue(null);
        }
    }

    private void materialUnitChanged(IRow curRow) throws BOSException, EASBizException {
        this.setQuantityPrecision(curRow);
    }

    protected void loadGroupedEntries(InvoiceEntryCollection grpEntries) {
        if (grpEntries == null || grpEntries.size() == 0) {
            return;
        }
        this.kdtEntries.removeRows();
        InvoiceEntryInfo entryInfo = null;
        IRow row = null;
        int n = grpEntries.size();
        for (int i = 0; i < n; ++i) {
            entryInfo = grpEntries.get(i);
            row = this.kdtEntries.addRow();
            for (int j = 0; j < ENTRY_FIELDS.length; ++j) {
                row.getCell(ENTRY_FIELDS[j]).setValue(entryInfo.get(ENTRY_FIELDS[j]));
            }
        }
    }

    protected InvoiceEntryCollection groupEntries(IObjectCollection entries) {
        return InvoiceGroupHelper.groupEntries(entries, true);
    }

    protected void updateButtonStatus() {
    }

    protected void initDataStatus() {
        boolean fAddNew;
        InvoiceInfo info = (InvoiceInfo)this.dataObjects.get("editData");
        if (info == null) {
            super.initDataStatus();
            return;
        }
        BillStatusEnum status = info.getBillStatus();
        boolean bl = fAddNew = 1 == this.getBOTPViewStatus() && info.getAsstActType() != null && (BillStatusEnum.SAVE.equals((Object)status) || status == null);
        if (fAddNew) {
            super.initDataStatus();
            this.actionSubmit.setEnabled(true);
            this.actionBlankout.setEnabled(false);
            this.actionGTaxExport.setEnabled(false);
            this.actionPrint.setEnabled(false);
            this.actionPrintPreview.setEnabled(false);
            this.actionTraceUp.setEnabled(false);
            this.btnRemoveLine.setVisible(true);
            this.actionRemoveLine.setEnabled(true);
            this.unLockUI();
            this.setEditComponentsStatus(true);
            this.setPrmtQuery_Filter();
        } else {
            this.setEditComponentsStatus(false);
            super.initDataStatus();
            this.actionGTaxExport.setEnabled(!BillStatusEnum.SAVE.equals((Object)status) && !"ADDNEW".equals(this.getOprtState()));
            boolean fSubmited = BillStatusEnum.SUBMITED.equals((Object)status);
            this.actionBlankout.setEnabled(fSubmited);
            this.actionTraceUp.setEnabled(fSubmited);
            this.actionPrint.setEnabled(fSubmited);
            this.actionPrintPreview.setEnabled(fSubmited);
            this.actionSubmit.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            boolean fBlankouted = BillStatusEnum.DELETED.equals((Object)status);
            this.actionAttachment.setEnabled(false);
        }
    }

    protected void setEditComponentsStatus(boolean fEdit) {
        this.txtNumber.setEditable(false);
        this.pkbillDate.setEnabled(fEdit);
        this.prmtAuditor.setEnabled(fEdit);
        this.prmtbillHandler.setEnabled(fEdit);
        this.prmtCompAcctBank.setEnabled(fEdit);
        this.prmtAuditor.setEditable(fEdit);
        this.prmtbillHandler.setEditable(fEdit);
        this.prmtCompAcctBank.setEditable(fEdit);
        this.lockContainer((Container)this.prmptCompany);
        this.lockContainer((Container)this.prmtCussType);
        this.txtAddr.setEnabled(fEdit);
        this.txtAreaRemark.setEnabled(fEdit);
        this.txtPhone.setEnabled(fEdit);
        this.txtBank.setEnabled(false);
        this.prmtBankAcct.setEnabled(fEdit);
        this.kdtEntries.getStyleAttributes().setLocked(!fEdit);
        if (fEdit) {
            this.kdtEntries.getColumn(COL_TYPE).getStyleAttributes().setLocked(true);
        }
    }

    protected Map getSrcEntriesFreeAmount() throws BOSException, EASBizException, SQLException {
        IObjectCollection entries = (IObjectCollection)this.kdtEntries.getUserObject();
        if (entries == null || entries.size() == 0) {
            return null;
        }
        Map map = this.fetchData.getSrcEntryMap();
        return map;
    }

    protected IArApBillEntryBase getSourceEntryInterface() throws BOSException {
        return null;
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.invokePrintFunction(e, true);
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.invokePrintFunction(e, false);
    }

    private void invokePrintFunction(ActionEvent e, boolean fPrint) throws Exception {
        if (this.editData == null || this.editData.getId() == null) {
            return;
        }
        BillStatusEnum billStatus = ((InvoiceInfo)this.editData).getBillStatus();
        if (billStatus == null || !BillStatusEnum.SUBMITED.equals((Object)billStatus)) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(this.editData.getString("id"));
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        InvoicePrintQueryDelegate dataProvider = new InvoicePrintQueryDelegate(ids, this.getPrintQueryPK());
        data.put("MainQuery", (BOSQueryDelegate)dataProvider);
        String resTag = fPrint ? "log_TDPrint" : "log_TDPrintReview";
        KDNoteHelper appHlp = new KDNoteHelper();
        CommonPrintIntegrationDataProvider printQueryData = new CommonPrintIntegrationDataProvider(this.editData.getBOSType().toString(), PrintIntegrationManager.getPrintQueryPK());
        data.put("PrintQuery", (BOSQueryDelegate)printQueryData);
        PrintIntegrationManager.initPrint((KDNoteHelper)appHlp, (BOSObjectType)this.editData.getBOSType(), ids, (String)this.getPrintMetaPath(), (String)ArApBillUIUtil.getStrResource(resTag), (boolean)true);
        if (fPrint) {
            appHlp.print(this.getPrintMetaPath(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(this.getPrintMetaPath(), (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected IMetaDataPK getPrintQueryPK() {
        return null;
    }

    protected String getPrintMetaPath() {
        return null;
    }

    protected void afterSubmitAddNew() {
        this.getUIContext().put("BOTPViewStatus", new Integer(0));
        super.afterSubmitAddNew();
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        BillStatusEnum billStatus;
        if (this.editData != null && ((billStatus = ((InvoiceInfo)this.editData).getBillStatus()) == null || BillStatusEnum.DELETED.equals((Object)billStatus))) {
            return;
        }
        CoreBillBaseInfo info = this.editData;
        if (info != null && info.getId() != null) {
            this.btpEdit.traceUp(info);
        }
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        this.clearBillSRCRelation();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TargetBillType", "InvoiceVATEditUI");
        InvoiceInfo invinfo = (InvoiceInfo)this.getEditData();
        map.put("ARAPCOMPANY", invinfo.getCompany());
        map.put("MAINBIZORG.TYPE", this.getMainBizOrgType());
        Date currentDate = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, -1);
        Date lastMonthDate = calendar.getTime();
        map.put("beginBillDate", lastMonthDate);
        map.put("endBillDate", currentDate);
        this.btpEdit.createFrom(this.getMainOrgContext(), map);
    }

    protected TaxRelationInfo getTaxRelationInfo(TaxRelationTypeEnum type) throws BOSException {
        return null;
    }

    @Override
    public void actionGTaxExport_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionBlankout_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData == null || this.editData.getId() == null || !BillStatusEnum.SUBMITED.equals((Object)((InvoiceInfo)this.editData).getBillStatus())) {
            return;
        }
        boolean fRecycleNum = false;
        int iChoice = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)INVRES, (String)"RecycleNum"));
        if (iChoice == 2) {
            return;
        }
        if (iChoice == 0) {
            fRecycleNum = true;
        }
        ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
        ObjectUuidPK[] pks = new ObjectUuidPK[]{pk};
        ((IInvoice)this.getBizInterface()).blankout((IObjectPK[])pks, fRecycleNum);
        this.setDataObject(this.getValue((IObjectPK)pk));
        this.showMessageForStatus();
        this.showBlankoutSuccessful();
        this.loadFields();
    }

    protected void removeLine(KDTable table) {
        super.removeLine(table);
        this.setBillTotalAmount();
    }

    protected void setTableToSumField() {
        if (this.getDetailTable() != null && this.getSumColNames() != null) {
            this.setTableToSumField(this.getDetailTable(), this.getSumColNames());
        }
    }

    protected String[] getSumColNames() {
        return SUM_COLS;
    }

    protected void storeAssActData(InvoiceInfo invInfo) {
        DataBaseInfo cusAcctInfo = (DataBaseInfo)this.prmtCusAcct.getData();
        if (cusAcctInfo == null) {
            return;
        }
        invInfo.setAsstActID(cusAcctInfo.getId().toString());
        invInfo.setAsstActNumber(cusAcctInfo.getNumber());
        invInfo.setAsstActName(ArApBillUIUtil.getAsstActName((IObjectValue)cusAcctInfo, ArApBillUIUtil.L1), ArApBillUIUtil.L1);
        invInfo.setAsstActName(ArApBillUIUtil.getAsstActName((IObjectValue)cusAcctInfo, ArApBillUIUtil.L2), ArApBillUIUtil.L2);
        invInfo.setAsstActName(ArApBillUIUtil.getAsstActName((IObjectValue)cusAcctInfo, ArApBillUIUtil.L3), ArApBillUIUtil.L3);
    }

    protected void setBillTotalAmount() {
        BigDecimal totalAmount = this.getTotalAmount();
        this.txtTotalAmount.setValue((Object)totalAmount);
        if (totalAmount.signum() == -1) {
            this.txtTotalAmount.setForeground(Color.RED);
        } else {
            this.txtTotalAmount.setForeground(Color.BLACK);
        }
    }

    protected BigDecimal getTotalAmount() {
        BigDecimal totalAmount = SysConstant.BIGZERO;
        BigDecimal amt = SysConstant.BIGZERO;
        for (int rowIndex = 0; rowIndex < this.kdtEntries.getRowCount(); ++rowIndex) {
            IRow row = this.kdtEntries.getRow(rowIndex);
            amt = (BigDecimal)row.getCell(COL_ACTUALAMT).getValue();
            if (amt == null) continue;
            totalAmount = totalAmount.add(amt);
        }
        int precision = this.getInfoCurrPrecision();
        totalAmount = totalAmount.setScale(precision, 4);
        return totalAmount;
    }

    protected void beforeLoadFields() {
        this.removePropertyListener();
        SCMClientUtils.removePropertyListener((KDTable)this.kdtEntries);
        this.deleteControlListener();
    }

    protected void afterLoadFields() {
        this.customizeLoadData();
        this.addControlListener();
        this.addPropertyListener();
    }

    protected void addControlListener() {
        if (this.prmtCusAcctListener == null) {
            this.prmtCusAcctListener = new DataChangeListener(){

                public void dataChanged(DataChangeEvent e) {
                    try {
                        InvoiceVATEditUI.this.prmtCusAcct_dataChanged(e);
                    }
                    catch (Exception exc) {
                        InvoiceVATEditUI.this.handUIException(exc);
                    }
                }
            };
        }
        this.prmtCusAcct.addDataChangeListener(this.prmtCusAcctListener);
    }

    protected void deleteControlListener() {
        if (this.prmtCusAcctListener != null) {
            this.prmtCusAcct.removeDataChangeListener(this.prmtCusAcctListener);
        }
    }

    protected void prmtCusAcct_dataChanged(DataChangeEvent e) throws Exception {
        DataBaseInfo cusAcctInfo = this.getCusAcctInfo();
        if (cusAcctInfo != null) {
            if (cusAcctInfo instanceof CustomerInfo) {
                this.setCustomerData2UI((CustomerInfo)cusAcctInfo, true);
            } else if (cusAcctInfo instanceof SupplierInfo) {
                this.setSupplierData2UI((SupplierInfo)cusAcctInfo, true);
            }
        }
    }

    protected DataBaseInfo getCusAcctInfo() {
        KDBizPromptBox prmtAccountCussent = this.prmtCusAcct;
        Object[] prmtAccountCussent_multicoreBaseInfo = null;
        Object prmtAccountCussent_coreBaseInfo = null;
        boolean isMultiSelection = false;
        if (prmtAccountCussent == null) {
            return null;
        }
        if (prmtAccountCussent.getValue() instanceof Object[]) {
            if (((Object[])prmtAccountCussent.getValue())[0] == null) {
                return null;
            }
            prmtAccountCussent_multicoreBaseInfo = (Object[])prmtAccountCussent.getValue();
            isMultiSelection = true;
        } else {
            if (prmtAccountCussent.getValue() == null) {
                this.accountCussentInfo = null;
                return null;
            }
            isMultiSelection = false;
            prmtAccountCussent_coreBaseInfo = prmtAccountCussent.getValue();
        }
        if (ArApBillHelper.idEquals((CoreBaseInfo)this.accountCussentInfo, (CoreBaseInfo)(isMultiSelection ? prmtAccountCussent_multicoreBaseInfo[0] : prmtAccountCussent_coreBaseInfo))) {
            return null;
        }
        this.accountCussentInfo = (DataBaseInfo)(isMultiSelection ? prmtAccountCussent_multicoreBaseInfo[0] : prmtAccountCussent_coreBaseInfo);
        return this.accountCussentInfo;
    }

    protected void customizeLoadData() {
        InvoiceInfo info = (InvoiceInfo)this.getEditData();
        if (info == null) {
            return;
        }
        boolean fBotNew = this.getBOTPViewStatus() == 1;
        IObjectValue cussAcctInfo = null;
        if (fBotNew || "VIEW".equals(this.getOprtState())) {
            cussAcctInfo = this.fetchData.getCussAcctInfo();
            this.prmtCusAcct.setValue((Object)cussAcctInfo);
        } else {
            this.prmtCusAcct.setValue(null);
        }
        BillStatusEnum status = info.getBillStatus();
        this.setPrecisionAndDisplayFormat();
        int rowCount = this.kdtEntries.getRowCount();
        IRow row = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtEntries.getRow(i);
            if (!fBotNew) continue;
            this.setMaterialUnitF7(row, false);
        }
        this.setEntryPrecisionByMaterial();
        if (cussAcctInfo != null) {
            if (cussAcctInfo instanceof CustomerInfo) {
                this.setCustomerData2UI((CustomerInfo)cussAcctInfo, false);
            } else if (cussAcctInfo instanceof SupplierInfo) {
                this.setSupplierData2UI((SupplierInfo)cussAcctInfo, false);
            } else if (cussAcctInfo instanceof GeneralAsstActTypeInfo) {
                AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.prmtCussType.getData();
                try {
                    ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCusAcct, typeInfo, this.companyInfo, false, this.fetchData.getF7DisplayMode());
                }
                catch (Exception e) {
                    this.handUIException(e);
                }
            }
        }
        if (info.getAsstActType() != null && (BillStatusEnum.SAVE.equals((Object)info.getBillStatus()) || info.getBillStatus() == null)) {
            this.setEditComponentsStatus(true);
        }
        if (!fBotNew || BillStatusEnum.SUBMITED.equals((Object)status) || BillStatusEnum.DELETED.equals((Object)status)) {
            this.appendFootRow(this.getDetailTable());
            return;
        }
        this.initCodingRule();
        info.setCU(this.companyInfo.getCU());
        this.setDefaultPerson2Info(info);
        try {
            this.srcEntriesAmtMap = this.getSrcEntriesFreeAmount();
            this.loadNewNumber();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        for (int i = 0; i < rowCount; ++i) {
            row = this.kdtEntries.getRow(i);
            this.setSpecifiedInvAmt(i);
        }
        this.setBillTotalAmount();
        if (info.getCussAddress() != null) {
            this.txtAddr.setText(info.getCussAddress());
        }
        if (info.getCussPhone() != null) {
            this.txtPhone.setText(info.getCussPhone());
        }
        if (info.getBillDate() != null) {
            this.pkbillDate.setValue((Object)info.getBillDate());
        }
        this.appendFootRow(this.getDetailTable());
    }

    protected void setEntryPrecisionByMaterial() {
        int num = this.kdtEntries.getRowCount();
        String[] unitCols = new String[]{COL_UNIT};
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        for (int i = 0; i < num; ++i) {
            MaterialInfo materialInfo = (MaterialInfo)this.kdtEntries.getRow(i).getCell(COL_MATERIAL).getValue();
            for (int j = 0; j < unitCols.length; ++j) {
                MeasureUnitInfo measureUnitInfo = (MeasureUnitInfo)this.kdtEntries.getCell(i, unitCols[j]).getValue();
                if (measureUnitInfo == null || materialInfo == null) continue;
                Object[] objs = new Object[]{materialInfo.getId(), measureUnitInfo.getId()};
                list.add(objs);
            }
            int pricePrecision = 6;
            if (materialInfo != null && materialInfo.getPricePrecision() != -1) {
                pricePrecision = materialInfo.getPricePrecision();
            }
            KDTableUtils.setBigDecimalCellPrecision(this.kdtEntries.getRow(i), new String[]{COL_UNITPRICE}, pricePrecision, true);
        }
        Map map = this.fetchData.getMeasureUnitMap();
        ArApBillUIUtil.changeTablePrecision(this.kdtEntries, map, COL_MATERIAL, COL_UNIT, new String[]{COL_QUANTITY});
    }

    protected void setDefaultPerson2Info(InvoiceInfo info) {
        UserInfo currUser = SysContext.getSysContext().getCurrentUserInfo();
        PersonInfo currPerson = currUser.getPerson();
        this.prmtDrawer.setValue((Object)currPerson);
        if (info.getAuditPerson() == null) {
            this.prmtAuditor.setValue((Object)currPerson);
            info.setAuditPerson(currPerson);
        }
    }

    private void setQuantityPrecision(IRow row) {
        int qtyPrecs = this.getQtyPrecision(row);
        KDTableUtils.setBigDecimalCellPrecision(row, new String[]{COL_QUANTITY}, qtyPrecs, true);
    }

    private void setUnitPricePrecision(IRow row) {
        MaterialInfo materialInfo = (MaterialInfo)row.getCell(COL_MATERIAL).getValue();
        int pricePrecision = 6;
        if (materialInfo != null && materialInfo.getPricePrecision() != -1) {
            pricePrecision = materialInfo.getPricePrecision();
        }
        KDTableUtils.setBigDecimalFieldsPrecision(pricePrecision, this.kdtEntries, row.getRowIndex(), new String[]{COL_UNITPRICE});
    }

    protected void loadNewNumber() throws Exception {
        if ("VIEW".equals(this.getOprtState())) {
            return;
        }
        InvoiceInfo invInfo = (InvoiceInfo)this.getEditData();
        if (invInfo != null && invInfo.getNumber() != null) {
            this.txtNumber.setText(invInfo.getNumber());
            return;
        }
        boolean fBotNew = this.getBOTPViewStatus() == 1;
        boolean fAutoNum = this.isAutoNumber();
        if (fBotNew && fAutoNum) {
            this.txtNumber.setText(this.getNewNumber(false));
        } else {
            this.txtNumber.setText(null);
        }
    }

    protected void setSpecifiedInvAmt(int i) {
        IRow row = this.kdtEntries.getRow(i);
        MaterialInfo materialInfo = (MaterialInfo)this.kdtEntries.getCell(i, COL_MATERIAL).getValue();
        int pricePrecision = 6;
        if (materialInfo != null && materialInfo.getPricePrecision() != -1) {
            pricePrecision = materialInfo.getPricePrecision();
        }
        int currPrecision = this.getInfoCurrPrecision();
        InvoiceEntryInfo entryInfo = (InvoiceEntryInfo)row.getUserObject();
        BigDecimal canInvAmt = this.getEntryCanInvAmt(row);
        boolean fSrcFirstInv = this.isSrcEntryFirstInv(entryInfo);
        if (!fSrcFirstInv) {
            BigDecimal quantity = entryInfo.getQuantity();
            BigDecimal tRate = entryInfo.getTaxRate();
            BigDecimal unitPrice = SysConstant.BIGZERO;
            if (quantity.compareTo(SysConstant.BIGZERO) != 0) {
                unitPrice = canInvAmt.divide(quantity.multiply(tRate.multiply(new BigDecimal("0.01")).add(new BigDecimal("1"))), pricePrecision, 4);
            }
            BigDecimal amount = canInvAmt.divide(tRate.multiply(new BigDecimal("0.01")).add(new BigDecimal("1")), currPrecision, 4);
            BigDecimal taxAmount = canInvAmt.subtract(amount);
            entryInfo.setTaxRate(tRate);
            entryInfo.setAmount(amount);
            entryInfo.setTaxAmount(taxAmount);
            entryInfo.setUnitPrice(unitPrice);
        }
        entryInfo.setActualAmount(canInvAmt);
        this.separateTaxAmt(i, pricePrecision, fSrcFirstInv);
    }

    protected boolean isSrcEntryFirstInv(InvoiceEntryInfo entryInfo) {
        if (this.srcEntriesAmtMap == null) {
            return true;
        }
        AbstractArApBillEntryBaseInfo srcEntryInfo = null;
        if (this.srcEntriesAmtMap.get(entryInfo.getId().toString()) != null) {
            srcEntryInfo = (ArApBillEntryBaseInfo)this.srcEntriesAmtMap.get(entryInfo.getId().toString());
        }
        if (srcEntryInfo == null) {
            return true;
        }
        return srcEntryInfo.getBigDecimal(FLD_FREEAMT).equals(srcEntryInfo.getRecievePayAmount());
    }

    protected void separateTaxAmt(int iRowInd, int pricePrecision, boolean fSrcFirstInv) {
        BigDecimal tAmt;
        IRow curRow = this.kdtEntries.getRow(iRowInd);
        InvoiceEntryInfo entryInfo = (InvoiceEntryInfo)curRow.getUserObject();
        logger.debug((Object)("\r\n toProcess entryInfo: " + entryInfo));
        BigDecimal amt = entryInfo.getActualAmount();
        if (amt == null) {
            return;
        }
        int amtPrec = this.getInfoCurrPrecision();
        int iAmtSignum = amt.signum();
        this.setAmtCellValueAndEditor(curRow.getCell(COL_ACTUALAMT), amt, iAmtSignum, amtPrec);
        BigDecimal tRate = entryInfo.getTaxRate();
        BigDecimal unitPrice = entryInfo.getUnitPrice();
        BigDecimal tFreeAmt = fSrcFirstInv ? entryInfo.getAmount() : this.getTaxFreeAmt(amt, tRate, amtPrec);
        BigDecimal bigDecimal = tAmt = fSrcFirstInv ? entryInfo.getTaxAmount() : amt.subtract(tFreeAmt);
        if (!fSrcFirstInv) {
            entryInfo.setAmount(tFreeAmt);
            entryInfo.setTaxAmount(tAmt);
        }
        this.setAmtCellValueAndEditor(curRow.getCell(COL_AMT), tFreeAmt, iAmtSignum, amtPrec);
        this.setAmtCellValueAndEditor(curRow.getCell(COL_TAMT), tAmt, iAmtSignum, amtPrec);
        BigDecimal quantity = entryInfo.getQuantity();
        if (quantity == null) {
            return;
        }
        BigDecimal quantitysignum = quantity.multiply(amt);
        int iquantitySignum = quantitysignum.signum();
        this.setAmtCellValueAndEditor(curRow.getCell(COL_UNITPRICE), unitPrice, iquantitySignum, pricePrecision);
        logger.debug((Object)("\r\n sepearted entryInfo: " + entryInfo));
    }

    private void setAmtCellValueAndEditor(ICell cell, BigDecimal amt, int iSignum, int precision) {
        if (cell == null) {
            return;
        }
        KDFormattedTextField txtAmt = new KDFormattedTextField();
        txtAmt.setDataType(1);
        txtAmt.setPrecision(precision);
        txtAmt.setRemoveingZeroInDispaly(false);
        if (iSignum == 0) {
            txtAmt.setMinimumValue((Comparable)SysConstant.BIGZERO);
            txtAmt.setMaximumValue((Comparable)SysConstant.BIGZERO);
        } else if (iSignum == 1) {
            txtAmt.setMinimumValue((Comparable)SysConstant.BIGZERO);
        } else if (iSignum == -1) {
            txtAmt.setMaximumValue((Comparable)SysConstant.BIGZERO);
        }
        KDTDefaultCellEditor editor = new KDTDefaultCellEditor((JTextField)txtAmt);
        cell.setValue((Object)amt);
        cell.setEditor((ICellEditor)editor);
    }

    protected int getQtyPrecision(IRow row) {
        int precision = 9;
        Object objMaterial = row.getCell(COL_MATERIAL).getValue();
        Object objUnit = row.getCell(COL_UNIT).getValue();
        if (objMaterial == null || objUnit == null) {
            return precision;
        }
        try {
            String materialId = ((MaterialInfo)objMaterial).getId().toString();
            String unitId = ((MeasureUnitInfo)objUnit).getId().toString();
            IMultiMeasureUnit iMultUnit = MultiMeasureUnitFactory.getRemoteInstance();
            MultiMeasureUnitInfo multiUnitInfo = iMultUnit.getMultiUnit(materialId, unitId);
            if (multiUnitInfo != null) {
                precision = multiUnitInfo.getQtyPrecision();
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return precision;
    }

    private void setMaterialEditor() throws Exception {
        if (this.kdtEntries.getColumn(COL_MATERIAL) == null || this.kdtEntries.getColumn(COL_MATERIAL).getEditor() != null) {
            return;
        }
        KDBizPromptBox prmtMaterial = new KDBizPromptBox();
        prmtMaterial.setCommitFormat("$number$");
        prmtMaterial.setDisplayFormat("$number$");
        prmtMaterial.setEditFormat("$number$");
        prmtMaterial.setEditable(true);
        boolean onlySupportQueryViaMaterialNumber = ArApBillUIUtil.isOnlySupportQueryViaMaterialNumber();
        if (onlySupportQueryViaMaterialNumber) {
            prmtMaterial.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$", prmtMaterial));
        } else {
            prmtMaterial.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$;$model$;$helpCode$", prmtMaterial));
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)new Integer(1)));
        if (this.companyInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)this.companyInfo.getId(), CompareType.EQUALS));
        }
        viewInfo.setFilter(filter);
        prmtMaterial.setEntityViewInfo(viewInfo);
        int f7DisplayMode = 0;
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        companyOrgUnitInfo = this.prmptCompany.getValue() != null ? (CompanyOrgUnitInfo)this.prmptCompany.getValue() : SysContext.getSysContext().getCurrentFIUnit();
        f7DisplayMode = SCMGroupClientUtils.getF7DisplayMode((String)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString());
        if (f7DisplayMode == 0) {
            String queryInfo = "com.kingdee.eas.basedata.master.material.app.F7MaterialFIQuery";
            SelectorListener[] selectorListener1 = InvoiceVATEditUI.removePrmtAllSelListener(prmtMaterial);
            F7MaterialMultiUISelectorAdaptor selector = new F7MaterialMultiUISelectorAdaptor((KDPromptBox)prmtMaterial, F7MaterialMultiUI.class.getName(), (Object)this.ui, MaterialGroupInfo.getBosType(), queryInfo, "materialGroup.id", "orgUnit.id", "com.kingdee.eas.basedata.master.material.app.F7MaterialFINoGroupQuery");
            prmtMaterial.setSelector((KDPromptSelector)selector);
            selector.setIsMultiSelect(false);
            InvoiceVATEditUI.addPrmtAllSelListener(prmtMaterial, selectorListener1);
            prmtMaterial.addSelectorListener((SelectorListener)selector);
        } else {
            prmtMaterial.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialFINoGroupQuery");
            if (this.companyInfo != null) {
                prmtMaterial.setCurrentMainBizOrgUnit((OrgUnitInfo)companyOrgUnitInfo, OrgType.Company);
            }
            prmtMaterial.setHasCUDefaultFilter(false);
        }
        KDTDefaultCellEditor material_CellEditor = new KDTDefaultCellEditor((IKDEditor)prmtMaterial);
        this.kdtEntries.getColumn(COL_MATERIAL).setEditor((ICellEditor)material_CellEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$name$"));
        this.kdtEntries.getColumn(COL_MATERIAL).setRenderer((IBasicRender)avr);
        this.kdtEntries.getColumn(COL_MATERIAL).setRequired(false);
    }

    private static SelectorListener[] removePrmtAllSelListener(KDBizPromptBox prmtCtrl) {
        SelectorListener[] selListeners = prmtCtrl.getSelectorListeners();
        if (selListeners == null) {
            return selListeners;
        }
        for (int i = 0; i < selListeners.length; ++i) {
            prmtCtrl.removeSelectorListener(selListeners[i]);
        }
        return selListeners;
    }

    private static void addPrmtAllSelListener(KDBizPromptBox prmtCtrl, SelectorListener[] selListeners) {
        if (selListeners == null) {
            return;
        }
        for (int i = 0; i < selListeners.length; ++i) {
            prmtCtrl.addSelectorListener(selListeners[i]);
        }
    }

    private void setExpenseItemEditor() throws Exception {
        KDBizPromptBox expenseItemPrmtBox = new KDBizPromptBox();
        String cuId = null;
        cuId = SysContext.getSysContext().getCurrentCtrlUnit() != null ? SysContext.getSysContext().getCurrentCtrlUnit().getId().toString() : "00000000-0000-0000-0000-000000000000CCE7AED4";
        ArApBillUIUtil.setExpenseItemF7((IUIObject)this, expenseItemPrmtBox, cuId, false);
        KDTDefaultCellEditor expenseItem_CellEditor = new KDTDefaultCellEditor((IKDEditor)expenseItemPrmtBox);
        this.kdtEntries.getColumn(COL_EXPENSEITEM).setEditor((ICellEditor)expenseItem_CellEditor);
        ObjectValueRender avr = new ObjectValueRender();
        avr.setFormat((IDataFormat)new BizDataFormat("$number$"));
        this.kdtEntries.getColumn(COL_EXPENSEITEM).setRenderer((IBasicRender)avr);
        this.kdtEntries.getColumn(COL_EXPENSEITEMNAME).getStyleAttributes().setLocked(true);
    }

    protected void expenseItemChanged(IRow curRow) throws BOSException, EASBizException {
        ExpenseTypeInfo expItemInfo = (ExpenseTypeInfo)curRow.getCell(COL_EXPENSEITEM).getValue();
        if (expItemInfo == null) {
            curRow.getCell(COL_EXPENSEITEMNAME).setValue(null);
            return;
        }
        curRow.getCell(COL_EXPENSEITEMNAME).setValue((Object)expItemInfo.getName());
        this.kdtEntries.getColumn(COL_UNIT).setEditor((ICellEditor)ArApBillUIUtil.getExpenseItemUnitEditor());
        this.kdtEntries.getColumn(COL_UNIT).getStyleAttributes().setLocked(false);
        MeasureUnitInfo unitInfo = expItemInfo.getDefaultUnit();
        if (unitInfo != null) {
            unitInfo = MeasureUnitFactory.getRemoteInstance().getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(unitInfo.getId()));
            curRow.getCell(COL_UNIT).setValue((Object)unitInfo);
        } else {
            curRow.getCell(COL_UNIT).setValue(null);
        }
        this.setQuantityPrecision(curRow);
        this.setUnitPricePrecision(curRow);
        curRow.getCell(COL_MATERIAL).setValue(null);
        curRow.getCell(COL_TYPE).setValue(null);
    }

    protected IObjectValue getCussAcct(String asstActId) {
        if (StringUtils.isEmpty((String)asstActId)) {
            return null;
        }
        try {
            BOSUuid bosId = BOSUuid.read((String)asstActId);
            BOSObjectType bosType = bosId.getType();
            IDynamicObject iDynObj = DynamicObjectFactory.getRemoteInstance();
            SelectorItemCollection selectors = new SelectorItemCollection();
            selectors.add("id");
            selectors.add("name");
            selectors.add("number");
            if (bosType.equals((Object)CUST_TYPE) || bosType.equals((Object)SUPP_TYPE)) {
                selectors.add("address");
                selectors.add("parent.id");
                selectors.add("taxRegisterNo");
            }
            IObjectValue cussAcctInfo = iDynObj.getValue(bosId.getType(), (IObjectPK)new ObjectUuidPK(bosId), selectors);
            return cussAcctInfo;
        }
        catch (Exception e) {
            this.handUIException(e);
            return null;
        }
    }

    protected void setCustomerData2UI(CustomerInfo cussAcctInfo, boolean isChange) {
        this.txtTaxRegNumber.setText(cussAcctInfo.getTaxRegisterNo());
        if (isChange) {
            this.txtAddr.setText(cussAcctInfo.getAddress());
        } else if (StringUtils.isEmpty((String)this.txtAddr.getText()) && !isChange) {
            this.txtAddr.setText(cussAcctInfo.getAddress());
        }
        InvoiceInfo invinfo = (InvoiceInfo)this.getEditData();
        Map customerCompanyInfoCollMap = this.fetchData.getCustomerCompanyInfoCollMap();
        String mapKey = (invinfo != null && invinfo.getCompany() != null ? invinfo.getCompany().getId() : this.companyInfo.getId()) + cussAcctInfo.getString("id");
        CustomerCompanyInfoInfo custCompInfo = (CustomerCompanyInfoInfo)customerCompanyInfoCollMap.get(mapKey);
        try {
            StringBuffer oql = new StringBuffer("");
            EntityViewInfo view = null;
            if (custCompInfo == null && !customerCompanyInfoCollMap.containsKey(mapKey)) {
                oql.append("select bank, bankAccount, phone,companyOrgUnit.id,customer.id where ");
                oql.append(" companyOrgUnit.id = '").append(invinfo != null && invinfo.getCompany() != null ? invinfo.getCompany().getId() : this.companyInfo.getId());
                oql.append("' and customer.id = '");
                oql.append(cussAcctInfo.getString("id")).append("' ");
                view = new EntityViewInfo(oql.toString());
                ICustomerCompanyInfo iCustComp = CustomerCompanyInfoFactory.getRemoteInstance();
                CustomerCompanyInfoCollection infos = iCustComp.getCustomerCompanyInfoCollection(view);
                if (infos != null && infos.size() > 0 && (custCompInfo = infos.get(0)).getCompanyOrgUnit() != null && custCompInfo.getCustomer() != null) {
                    String key = custCompInfo.getCompanyOrgUnit().getId().toString() + custCompInfo.getCustomer().getId().toString();
                    if (!this.fetchData.getCustomerCompanyInfoCollMap().containsKey(key)) {
                        this.fetchData.getCustomerCompanyInfoCollMap().put(key, custCompInfo);
                    }
                }
            }
            String custCompBankQuery = "com.kingdee.eas.fi.arap.app.F7CustomerCompanyInfoBankQuery";
            EntityViewInfo evi = new EntityViewInfo();
            if (custCompInfo != null) {
                if (StringUtils.isEmpty((String)this.txtPhone.getText()) || StringUtils.isEmpty((String)this.txtBank.getText()) || this.prmtBankAcct.getValue() == null) {
                    Map cCBankCollMap = this.fetchData.getCustomerCompanyBankCollMap();
                    CustomerCompanyBankInfo custCompBankInfo = (CustomerCompanyBankInfo)cCBankCollMap.get(custCompInfo.getId().toString());
                    if (custCompBankInfo == null && !cCBankCollMap.containsKey(custCompInfo.getId().toString())) {
                        oql = new StringBuffer("");
                        oql.append("select bank, bankAccount, bankAddress,customerCompanyInfo.id where ");
                        oql.append(" customerCompanyInfo.id= '").append(custCompInfo.getId()).append("' ");
                        InvoiceInfo info = (InvoiceInfo)this.getEditData();
                        String CussAcctBank = info.getCussAcctBank();
                        if (!StringUtils.isEmpty((String)CussAcctBank)) {
                            oql.append(" and bankAccount= '").append(CussAcctBank).append("' ");
                        }
                        view = new EntityViewInfo(oql.toString());
                        SorterItemInfo sorterItemInfo = new SorterItemInfo();
                        sorterItemInfo.setPropertyName("seq");
                        sorterItemInfo.setSortType(SortType.ASCEND);
                        view.getSorter().add(sorterItemInfo);
                        ICustomerCompanyBank iCustCompBank = CustomerCompanyBankFactory.getRemoteInstance();
                        CustomerCompanyBankCollection custCompBankColls = iCustCompBank.getCustomerCompanyBankCollection(view);
                        if (custCompBankColls != null && custCompBankColls.size() > 0 && (custCompBankInfo = custCompBankColls.get(0)).getCustomerCompanyInfo() != null && !this.fetchData.getCustomerCompanyBankCollMap().containsKey(custCompBankInfo.getCustomerCompanyInfo().getId().toString())) {
                            this.fetchData.getCustomerCompanyBankCollMap().put(custCompBankInfo.getCustomerCompanyInfo().getId().toString(), custCompBankInfo);
                        }
                    }
                    if (custCompBankInfo != null) {
                        if (StringUtils.isEmpty((String)this.txtPhone.getText())) {
                            this.txtPhone.setText(custCompInfo.getPhone());
                        }
                        if (StringUtils.isEmpty((String)this.txtBank.getText())) {
                            this.txtBank.setText(custCompBankInfo.getBank());
                        }
                        if (this.prmtBankAcct.getValue() == null) {
                            this.prmtBankAcct.setValue((Object)custCompBankInfo.getBankAccount());
                        }
                    } else {
                        this.txtBank.setText(null);
                        this.prmtBankAcct.setValue(null);
                    }
                }
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("customerCompanyInfo.id", (Object)custCompInfo.getId().toString(), CompareType.EQUALS));
                evi.setFilter(fi);
            }
            this.prmtBankAcct.setQueryInfo(custCompBankQuery);
            this.prmtBankAcct.setEntityViewInfo(evi);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void setSupplierData2UI(SupplierInfo cussAcctInfo, boolean isChange) {
        this.txtTaxRegNumber.setText(cussAcctInfo.getTaxRegisterNo());
        if (isChange) {
            this.txtAddr.setText(cussAcctInfo.getAddress());
        } else if (StringUtils.isEmpty((String)this.txtAddr.getText()) && !isChange) {
            this.txtAddr.setText(cussAcctInfo.getAddress());
        }
        InvoiceInfo invinfo = (InvoiceInfo)this.getEditData();
        Map supplierCompanyInfoCollMap = this.fetchData.getSupplierCompanyInfoCollMap();
        String mapKey = (invinfo != null && invinfo.getCompany() != null ? invinfo.getCompany().getId() : this.companyInfo.getId()) + cussAcctInfo.getId().toString();
        SupplierCompanyInfoInfo supCompInfo = (SupplierCompanyInfoInfo)supplierCompanyInfoCollMap.get(mapKey);
        try {
            StringBuffer oql = new StringBuffer("");
            EntityViewInfo view = null;
            if (supCompInfo == null && !supplierCompanyInfoCollMap.containsKey(mapKey)) {
                oql.append("select bankName, bankAccount, phone,companyOrgUnit.id,supplier.id where ");
                oql.append(" companyOrgUnit.id = '").append(invinfo != null && invinfo.getCompany() != null ? invinfo.getCompany().getId() : this.companyInfo.getId());
                oql.append("' and supplier.id = '");
                oql.append(cussAcctInfo.getString("id")).append("' ");
                view = new EntityViewInfo(oql.toString());
                ISupplierCompanyInfo iCustComp = SupplierCompanyInfoFactory.getRemoteInstance();
                SupplierCompanyInfoCollection infos = iCustComp.getSupplierCompanyInfoCollection(view);
                if (infos != null && infos.size() > 0 && (supCompInfo = infos.get(0)).getCompanyOrgUnit() != null && supCompInfo.getSupplier() != null) {
                    String key = supCompInfo.getCompanyOrgUnit().getId().toString() + supCompInfo.getSupplier().getId().toString();
                    if (!this.fetchData.getSupplierCompanyInfoCollMap().containsKey(key)) {
                        this.fetchData.getSupplierCompanyInfoCollMap().put(key, supCompInfo);
                    }
                }
            }
            String supCompBankQuery = "com.kingdee.eas.fi.arap.app.F7SupplierCompanyInfoBankQuery";
            EntityViewInfo evi = new EntityViewInfo();
            if (supCompInfo != null) {
                if (StringUtils.isEmpty((String)this.txtBank.getText()) || StringUtils.isEmpty((String)this.txtPhone.getText()) || this.prmtBankAcct.getValue() == null) {
                    Map sCBankCollMap = this.fetchData.getSupplierCompanyBankCollMap();
                    SupplierCompanyBankInfo supCompBankInfo = (SupplierCompanyBankInfo)sCBankCollMap.get(supCompInfo.getId().toString());
                    if (supCompBankInfo == null && !sCBankCollMap.containsKey(supCompInfo.getId().toString())) {
                        oql = new StringBuffer();
                        oql.append("select bank, bankAccount, bankAddress,supplierCompanyInfo.id where ");
                        oql.append(" supplierCompanyInfo.id= '").append(supCompInfo.getId()).append("' ");
                        InvoiceInfo info = (InvoiceInfo)this.getEditData();
                        String CussAcctBank = null;
                        if (!isChange) {
                            CussAcctBank = info.getCussAcctBank();
                        }
                        if (!StringUtils.isEmpty(CussAcctBank)) {
                            oql.append(" and bankAccount= '").append(CussAcctBank).append("' ");
                        }
                        view = new EntityViewInfo(oql.toString());
                        SorterItemInfo sorterItemInfo = new SorterItemInfo();
                        sorterItemInfo.setPropertyName("seq");
                        sorterItemInfo.setSortType(SortType.ASCEND);
                        view.getSorter().add(sorterItemInfo);
                        ISupplierCompanyBank iSupCompBank = SupplierCompanyBankFactory.getRemoteInstance();
                        SupplierCompanyBankCollection supCompBankColls = iSupCompBank.getSupplierCompanyBankCollection(view);
                        if (supCompBankColls != null && supCompBankColls.size() > 0 && (supCompBankInfo = supCompBankColls.get(0)).getSupplierCompanyInfo() != null && !this.fetchData.getSupplierCompanyBankCollMap().containsKey(supCompBankInfo.getSupplierCompanyInfo().getId().toString())) {
                            this.fetchData.getSupplierCompanyBankCollMap().put(supCompBankInfo.getSupplierCompanyInfo().getId().toString(), supCompBankInfo);
                        }
                    }
                    if (supCompBankInfo != null) {
                        if (StringUtils.isEmpty((String)this.txtBank.getText())) {
                            this.txtBank.setText(supCompBankInfo.getBank());
                        }
                        if (StringUtils.isEmpty((String)this.txtPhone.getText())) {
                            this.txtPhone.setText(supCompInfo.getPhone());
                        }
                        if (this.prmtBankAcct.getValue() == null) {
                            this.prmtBankAcct.setValue((Object)supCompBankInfo.getBankAccount());
                        }
                    } else {
                        this.txtBank.setText(null);
                        this.prmtBankAcct.setValue(null);
                    }
                }
                FilterInfo fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("supplierCompanyInfo.id", (Object)supCompInfo.getId().toString(), CompareType.EQUALS));
                evi.setFilter(fi);
            }
            this.prmtBankAcct.setQueryInfo(supCompBankQuery);
            this.prmtBankAcct.setEntityViewInfo(evi);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        InvoiceInfo info = (InvoiceInfo)this.getEditData();
        if (info.getCU() == null) {
            info.setCU(this.companyInfo.getCU());
        }
        this.verifyInfo(info);
        IObjectCollection entries = (IObjectCollection)info.get("entries");
        if (entries == null || entries.size() == 0) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.ar.ArApBillResource", (String)"entryIsNull"));
            SysUtil.abort();
        }
        InvoiceEntryInfo entryInfo = null;
        int iColExpense = this.kdtEntries.getColumnIndex(COL_EXPENSEITEM);
        int iColMaterial = this.kdtEntries.getColumnIndex(COL_MATERIAL);
        int iColAmt = this.kdtEntries.getColumnIndex(COL_AMT);
        int iColTaxedAmt = this.kdtEntries.getColumnIndex(COL_ACTUALAMT);
        KDTRow headRow = this.kdtEntries.getHead().getRow(0);
        int n = entries.size();
        for (int i = 0; i < n; ++i) {
            entryInfo = (InvoiceEntryInfo)entries.getObject(i);
            if (entryInfo.getMaterial() == null && entryInfo.getExpenseItem() == null) {
                String colVal = (String)headRow.getCell(iColMaterial).getValue() + ", " + (String)headRow.getCell(iColExpense).getValue();
                this.kdtEntries.getEditManager().editCellAt(i, iColMaterial);
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{colVal});
            }
            if (entryInfo.getMaterial() != null && entryInfo.getExpenseItem() != null) {
                throw new InvoiceException(InvoiceException.MATERIALEXPENSEITEMNOTEXIST);
            }
            if (entryInfo.getAmount() == null || entryInfo.getAmount().signum() == 0) {
                String colVal = (String)headRow.getCell(iColAmt).getValue();
                this.kdtEntries.getEditManager().editCellAt(i, iColAmt);
                throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{colVal});
            }
            if (entryInfo.getActualAmount() != null && entryInfo.getActualAmount().signum() != 0) continue;
            String colVal = (String)headRow.getCell(iColTaxedAmt).getValue();
            this.kdtEntries.getEditManager().editCellAt(i, iColTaxedAmt);
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{colVal});
        }
    }

    protected void verifyInfo(InvoiceInfo invInfo) throws Exception {
        if (this.prmtCussType.getData() != null) {
            AsstActTypeInfo typeInfo = (AsstActTypeInfo)this.prmtCussType.getData();
            ArApBillUIUtil.setAsstActSelector((CoreUIObject)this, this.prmtCusAcct, typeInfo, this.companyInfo, false, this.fetchData.getF7DisplayMode());
        }
        if ((this.isNewNumAddView() || !this.isAutoNumber()) && StringUtils.isEmpty((String)invInfo.getNumber())) {
            this.txtNumber.requestFocus();
            throw new EASBizException(EASBizException.CHECKNUMBLANK);
        }
        if (invInfo.getBillDate() == null) {
            this.pkbillDate.requestFocus();
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{this.contbillDate.getBoundLabelText()});
        }
        if (invInfo.getAuditPerson() == null) {
            this.prmtAuditor.requestFocus();
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{this.lblcontAuditor.getBoundLabelText()});
        }
        if (InvoiceTypeEnum.VAT.equals((Object)invInfo.getType()) && StringUtils.isEmpty((String)invInfo.getTaxRegisterNo())) {
            throw new EASBizException(EASBizException.CHECKBLANK, (Object[])new String[]{this.contTaxRegNumber.getBoundLabelText()});
        }
    }

    public IUIObject getInstance(Map uiContext) {
        Object curId = uiContext.get("ID");
        Object objInfo = uiContext.get("InitDataObject");
        if (curId == null && objInfo == null) {
            return super.getInstance(uiContext);
        }
        try {
            InvoiceInfo info;
            InvoiceInfo invoiceInfo = info = objInfo != null ? (InvoiceInfo)objInfo : (InvoiceInfo)this.getBizInterface().getValue("select id, type where id = '" + curId + "'");
            if (info == null) {
                return super.getInstance(uiContext);
            }
            if (InvoiceTypeEnum.VAT.equals((Object)info.getType())) {
                if (info instanceof ArInvoiceInfo) {
                    return new ArInvoiceVATEditUI();
                }
                return new ApInvoiceVATEditUI();
            }
            if (info instanceof ArInvoiceInfo) {
                return new ArInvoiceNormalEditUI();
            }
            return new ApInvoiceNormalEditUI();
        }
        catch (Exception e) {
            logger.error((Object)"exception , getInstance(uiCtx).", (Throwable)e);
            return super.getInstance(uiContext);
        }
    }

    protected void disposeUIWindow() {
        this.clearBillSRCRelation();
        super.disposeUIWindow();
    }

    @Override
    protected void prmtBankAcct_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtBankAcct.getValue() == null) {
            this.txtBank.setText(null);
            return;
        }
        Object obj = this.prmtBankAcct.getValue();
        if (obj instanceof CustomerCompanyBankInfo) {
            CustomerCompanyBankInfo custCompBankInfo = (CustomerCompanyBankInfo)obj;
            this.txtBank.setText(custCompBankInfo.getBank());
            this.prmtBankAcct.setValue((Object)custCompBankInfo.getBankAccount());
        } else if (obj instanceof SupplierCompanyBankInfo) {
            SupplierCompanyBankInfo supCompBankInfo = (SupplierCompanyBankInfo)obj;
            this.txtBank.setText(supCompBankInfo.getBank());
            this.prmtBankAcct.setValue((Object)supCompBankInfo.getBankAccount());
        }
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.clearBillSRCRelation();
        super.actionAddNew_actionPerformed(e);
    }

    protected void clearBillSRCRelation() {
        try {
            boolean fSavedInv;
            boolean bl = fSavedInv = this.editData != null && this.editData.getId() != null && (((InvoiceInfo)this.editData).getBillStatus() == null || BillStatusEnum.SAVE.equals((Object)((InvoiceInfo)this.editData).getBillStatus()));
            if (fSavedInv) {
                this.getBizInterface().delete((IObjectPK)new ObjectUuidPK(this.editData.getId()));
                this.recycleNumberByOrg((IObjectValue)this.editData, this.companyInfo.getId().toString(), this.editData.getNumber());
                logger.debug((Object)"delete the temp saved invoice");
            }
        }
        catch (Exception ex) {
            logger.error((Object)"can not delete the saved inv ", (Throwable)ex);
        }
    }

    protected void initFetchData() throws Exception {
        ArApFetchDataCondition condition = this.buildCondition();
        if (condition == null) {
            return;
        }
        this.fetchData = ArApFetchDataFacadeFactory.getRemoteInstance().fetchData(condition.toEntiryView(), (Map)this.initFetchParamMap);
    }

    protected ArApFetchDataCondition buildCondition() {
        ArApFetchDataCondition condition = null;
        if (this.isFetchData()) {
            condition = new ArApFetchDataCondition();
            this.setConditionContents(condition);
        }
        return condition;
    }

    protected void setConditionContents(ArApFetchDataCondition condition) {
        InvoiceInfo info;
        AsstActTypeInfo typeInfo;
        if (this.prmtCussType.getData() != null && (typeInfo = (AsstActTypeInfo)this.prmtCussType.getData()) != null) {
            condition.setFetchAsstActTypeInfo(true);
            condition.setAsstActTypeID(typeInfo.getId().toString());
        }
        if (this.companyInfo != null) {
            condition.setFetchCacheCurrentPeriod(true);
            condition.setFetchStartPeriod(true);
            condition.setCompanyOrgID(this.companyInfo.getId().toString());
            condition.setSystemEnum(this.getSystemEnumForOA());
        }
        if ((info = (InvoiceInfo)this.getEditData()) != null) {
            boolean fBotNew;
            boolean bl = fBotNew = this.getBOTPViewStatus() == 1;
            if ((fBotNew || "VIEW".equals(this.getOprtState())) && !StringUtils.isEmpty((String)info.getAsstActID())) {
                condition.setFetchCussAcctInfo(true);
                condition.setAsstActID(info.getAsstActID());
            }
            HashSet<String> materialIDSet = new HashSet<String>();
            HashSet<String> measureUnitIDSet = new HashSet<String>();
            MaterialInfo materialInfo = null;
            MeasureUnitInfo measureUnitInfo = null;
            ArrayList<Object[]> unitList = new ArrayList<Object[]>();
            Object[] objs = null;
            int rowCount = this.kdtEntries.getRowCount();
            for (int i = 0; i < rowCount; ++i) {
                if (!fBotNew) continue;
                materialInfo = (MaterialInfo)this.kdtEntries.getRow(i).getCell(COL_MATERIAL).getValue();
                if (materialInfo != null && materialInfo.getId() != null && materialInfo.getName() == null) {
                    condition.setFetchMaterialColl(true);
                    materialIDSet.add(materialInfo.getId().toString());
                }
                if ((measureUnitInfo = (MeasureUnitInfo)this.kdtEntries.getRow(i).getCell(COL_UNIT).getValue()) != null && measureUnitInfo.getId() != null && measureUnitInfo.getName() == null) {
                    condition.setFetchMeasureUnitColl(true);
                    measureUnitIDSet.add(measureUnitInfo.getId().toString());
                }
                if (measureUnitInfo == null || materialInfo == null) continue;
                objs = new Object[]{materialInfo.getId(), measureUnitInfo.getId()};
                unitList.add(objs);
            }
            if (condition.isFetchMaterialColl() && materialIDSet.size() > 0) {
                condition.setMaterialIDSet(materialIDSet);
            }
            if (condition.isFetchMeasureUnitColl() && measureUnitIDSet.size() > 0) {
                condition.setMeasureUnitIDSet(measureUnitIDSet);
            }
            if (unitList.size() > 0) {
                condition.setFetchMaterialID(true);
                condition.setFetchMeasureUnitID(true);
                condition.setFetchQtyPrecision(true);
                condition.setFetchEntryPrecisionByMaterial(true);
                condition.setMaterialUnitIDList(unitList);
            }
            if (this.prmtCussType.getData() != null) {
                condition.setFetchF7DisplayMode(true);
                if (this.companyInfo.getCU() == null) {
                    this.companyInfo.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
                }
                condition.setCompanyOrgUnitInfo(this.companyInfo);
            }
            BillStatusEnum status = info.getBillStatus();
            if (fBotNew && !BillStatusEnum.SUBMITED.equals((Object)status) && !BillStatusEnum.DELETED.equals((Object)status)) {
                IObjectCollection entries;
                condition.setFetchCodingRuleInfo(true);
                condition.setInvoiceInfo((IObjectValue)info);
                condition.setCompanyOrgID(this.companyInfo.getId().toString());
                if (!"VIEW".equals(this.getOprtState()) && (info == null || info.getNumber() == null) && fBotNew) {
                    condition.setFetchAddInvoiceNewNumber(true);
                }
                if ((entries = (IObjectCollection)this.kdtEntries.getUserObject()) != null && entries.size() > 0) {
                    ArrayList<Object> list = new ArrayList<Object>();
                    for (int i = 0; i < entries.size(); ++i) {
                        list.add(entries.getObject(i).get("id"));
                    }
                    if (list.size() > 0) {
                        condition.setFetchSrcEntryMap(true);
                        condition.setBillEntryIDList(list);
                    }
                }
            }
        }
        if (condition.isFetchCussAcctInfo()) {
            condition.setFetchCustomerCompanyInfoColl(true);
            if (StringUtils.isEmpty((String)this.txtPhone.getText()) || StringUtils.isEmpty((String)this.txtBank.getText()) || this.prmtBankAcct.getValue() == null) {
                condition.setFetchCustomerCompanyBankColl(true);
            }
            condition.setFetchSupplierCompanyInfoColl(true);
            if (StringUtils.isEmpty((String)this.txtBank.getText()) || StringUtils.isEmpty((String)this.txtPhone.getText()) || this.prmtBankAcct.getValue() == null) {
                condition.setFetchSupplierCompanyBankColl(true);
            }
            String companyID = info != null && info.getCompany() != null ? info.getCompany().getId().toString() : this.companyInfo.getId().toString();
            condition.setCompanyOrgID(companyID);
            condition.setCussAcctBank(info.getCussAcctBank());
        }
        if (this.kdtEntries.getColumn(COL_MATERIAL) != null && this.kdtEntries.getColumn(COL_MATERIAL).getEditor() == null) {
            condition.setFetchOnlySupportQueryViaMaterialNumber(true);
        }
        this.initFetchParamMap.put("Condition", condition);
    }

    protected boolean isFetchData() {
        return true;
    }

    protected void recycleNumberByOrg(IObjectValue editData, String companyID, String number) {
        if (!StringUtils.isEmpty((String)number)) {
            try {
                ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                if (!StringUtils.isEmpty((String)companyID) && iCodingRuleManager.isExist(editData, companyID, "type")) {
                    iCodingRuleManager.recycleNumber(editData, companyID, "type", null, number);
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }
}

