/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.eas.fi.arap.util.ArApBaseCalculate;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import com.kingdee.eas.framework.report.util.KDTableInsertHandler;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.client.helper.FormattedEditorFactory;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

public abstract class KDTableUtils {
    public static String getFieldName(KDTable table, int columnIndex) {
        String fieldName = null;
        if (table != null && columnIndex > -1) {
            fieldName = table.getColumnKey(columnIndex);
        }
        return fieldName;
    }

    public static Object getFieldValue(KDTable table, int rowIndex, String fieldName) {
        Object result = null;
        ICell cell = KDTableUtils.getCell(table, rowIndex, fieldName);
        if (cell != null) {
            result = cell.getValue();
        }
        return result;
    }

    public static Object getFieldValue(KDTable table, int rowIndex, int columnIndex) {
        Object result = null;
        ICell cell = KDTableUtils.getCell(table, rowIndex, columnIndex);
        if (cell != null) {
            result = cell.getValue();
        }
        return result;
    }

    public static List getFieldValues(KDTable table, int rowIndex, String[] fieldNames) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (table != null && rowIndex > -1 && fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                values.add(i, KDTableUtils.getFieldValue(table, rowIndex, fieldNames[i]));
            }
        }
        return values;
    }

    public static List getFieldValues(KDTable table, int rowIndex, int[] columnIndexes) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (table != null && rowIndex > -1 && columnIndexes != null) {
            int size = columnIndexes.length;
            for (int i = 0; i < size; ++i) {
                values.add(i, KDTableUtils.getFieldValue(table, rowIndex, columnIndexes[i]));
            }
        }
        return values;
    }

    public static void setFieldValues(KDTable table, int rowIndex, String[] fieldNames, Object[] values) {
        if (fieldNames != null) {
            int vSize = values.length;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                if (i > -1 && i < vSize) {
                    KDTableUtils.setFieldValue(table, rowIndex, fieldNames[i], values[i]);
                    continue;
                }
                KDTableUtils.setFieldValue(table, rowIndex, fieldNames[i], null);
            }
        }
    }

    public static void setFieldValues(KDTable table, int rowIndex, int[] columnIndexes, Object[] values) {
        if (columnIndexes != null) {
            int vSize = values.length;
            int size = columnIndexes.length;
            for (int i = 0; i < size; ++i) {
                if (i > -1 && i < vSize) {
                    KDTableUtils.setFieldValue(table, rowIndex, columnIndexes[i], values[i]);
                    continue;
                }
                KDTableUtils.setFieldValue(table, rowIndex, columnIndexes[i], null);
            }
        }
    }

    public static void setFieldValue(KDTable table, int rowIndex, String fieldName, Object value) {
        ICell cell = KDTableUtils.getCell(table, rowIndex, fieldName);
        if (cell != null) {
            cell.setValue(value);
        }
    }

    public static void setFieldValue(KDTable table, int rowIndex, int columnIndex, Object value) {
        ICell cell = KDTableUtils.getCell(table, rowIndex, columnIndex);
        if (cell != null) {
            cell.setValue(value);
        }
    }

    public static ICell getCell(KDTable table, int rowIndex, String fieldName) {
        ICell cell = null;
        if (table != null && rowIndex > -1 && fieldName != null && fieldName.trim().length() != 0 && table.getRow(rowIndex) != null) {
            cell = table.getRow(rowIndex).getCell(fieldName);
        }
        return cell;
    }

    public static ICell getCell(KDTable table, int rowIndex, int columnIndex) {
        ICell cell = null;
        if (table != null && rowIndex > -1 && columnIndex > -1) {
            cell = table.getRow(rowIndex).getCell(columnIndex);
        }
        return cell;
    }

    public static IColumn getColumn(KDTable table, String fieldName) {
        IColumn column = null;
        if (table != null && fieldName != null && fieldName.trim().length() != 0) {
            column = table.getColumn(fieldName);
        }
        return column;
    }

    public static IColumn getColumn(KDTable table, int columnIndex) {
        IColumn column = null;
        if (table != null && columnIndex > -1) {
            column = table.getColumn(columnIndex);
        }
        return column;
    }

    public static void setHideFields(KDTable table, String[] fieldNames, boolean isHide) {
        if (fieldNames != null) {
            IColumn column = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = KDTableUtils.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                column.getStyleAttributes().setHided(isHide);
                column.getStyleAttributes().setLocked(isHide);
            }
        }
    }

    public static void setColumnHideFields(KDTable table, String[] fieldNames, boolean isHide) {
        if (fieldNames != null) {
            IColumn column = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = KDTableUtils.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                column.getStyleAttributes().setHided(isHide);
                if (isHide) {
                    column.setWidth(-1);
                    column.getKDTColumn().setWidth(-1);
                    continue;
                }
                column.setWidth(100);
                column.getKDTColumn().setWidth(100);
            }
        }
    }

    public static void setLockFields(KDTable table, String[] fieldNames, boolean isLock, int rowIndex) {
        if (fieldNames == null) {
            return;
        }
        if (rowIndex < 0) {
            KDTableUtils.setLockFields(table, fieldNames, isLock);
        } else {
            ICell cell = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                cell = table.getCell(rowIndex, fieldNames[i]);
                if (cell == null) continue;
                cell.getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public static void setLockFields(KDTable table, String[] fieldNames, boolean isLock) {
        if (fieldNames != null) {
            IColumn column = null;
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                column = KDTableUtils.getColumn(table, fieldNames[i]);
                if (column == null) continue;
                column.getStyleAttributes().setLocked(isLock);
            }
        }
    }

    public static void setBigDecimalFieldsPrecision(int precision, KDTable table, String[] fieldNames, boolean isNegative) {
        if (fieldNames != null) {
            int i;
            int size = fieldNames.length;
            for (i = 0; i < size; ++i) {
                KDTableUtils.setBigDecimalFieldsPrecisionByColumn(KDTableUtils.getColumn(table, fieldNames[i]), precision, isNegative);
            }
            size = fieldNames.length;
            for (i = 0; i < size; ++i) {
                for (int rowIndex = 0; rowIndex < table.getRowCount(); ++rowIndex) {
                    ICell cell = table.getCell(rowIndex, fieldNames[i]);
                    KDTableUtils.setBigDecimalFieldsPrecisionByCell(cell, precision, true, isNegative);
                }
            }
        }
    }

    public static void setBigDecimalFieldsPrecision(int precision, KDTable table, String[] fieldNames) {
        if (fieldNames != null) {
            int i;
            int size = fieldNames.length;
            for (i = 0; i < size; ++i) {
                KDTableUtils.setBigDecimalFieldsPrecisionByColumn(KDTableUtils.getColumn(table, fieldNames[i]), precision);
            }
            size = fieldNames.length;
            for (i = 0; i < size; ++i) {
                for (int rowIndex = 0; rowIndex < table.getRowCount(); ++rowIndex) {
                    ICell cell = table.getCell(rowIndex, fieldNames[i]);
                    KDTableUtils.setBigDecimalFieldsPrecisionByCell(cell, precision, true);
                }
            }
        }
    }

    public static void setBigDecimalByColumn(IColumn column, int precision) {
        if (column != null) {
            column.setEditor((ICellEditor)FormattedEditorFactory.getBigDecimalCellEditor((int)precision, (boolean)true));
            column.getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString(precision));
        }
    }

    public static void setBigDecimalRowPrecision(int precision, IRow row, String[] fieldNames) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                ICell cell = row.getCell(fieldNames[i]);
                KDTableUtils.setBigDecimalFieldsPrecisionByCell(cell, precision, true);
            }
        }
    }

    public static void setBigDecimalFieldsPrecision(int precision, KDTable table, int rowIndex, String[] fieldNames, boolean isSetEditor) {
        if (fieldNames != null) {
            int size = fieldNames.length;
            for (int i = 0; i < size; ++i) {
                KDTableUtils.setBigDecimalFieldsPrecisionByCell(KDTableUtils.getCell(table, rowIndex, fieldNames[i]), precision, isSetEditor);
            }
        }
    }

    public static void setBigDecimalFieldsPrecision(int precision, KDTable table, int rowIndex, String[] fieldNames) {
        KDTableUtils.setBigDecimalFieldsPrecision(precision, table, rowIndex, fieldNames, true);
    }

    public static void setBigDecimalFieldsPrecisionByColumn(IColumn column, int precision, boolean isNegative) {
        if (column != null) {
            column.setEditor((ICellEditor)FormattedEditorFactory.getBigDecimalCellEditor((int)precision, (boolean)isNegative));
            column.getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString(precision));
        }
    }

    public static void setBigDecimalFieldsPrecisionByColumn(IColumn column, int precision) {
        if (column != null) {
            column.setEditor((ICellEditor)FormattedEditorFactory.getBigDecimalCellEditor((int)precision, (boolean)true));
            column.getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString(precision));
        }
    }

    public static void setBigDecimalColumnPrecision(KDTable table, String[] colNames, int precision) {
        KDTDefaultCellEditor editor = FormattedEditorFactory.getBigDecimalCellEditor((int)precision, (boolean)true);
        String sFormat = PrecisionFormatUtils.getFormatString(precision);
        for (int i = 0; i < colNames.length; ++i) {
            IColumn column = table.getColumn(colNames[i]);
            if (column == null) continue;
            column.setEditor((ICellEditor)editor);
            column.getStyleAttributes().setNumberFormat(sFormat);
        }
    }

    public static void setBigDecimalFieldsPrecisionByCell(ICell cell, int precision, boolean isSetEditor, boolean isNegative) {
        if (cell != null) {
            if (cell.getValue() instanceof BigDecimal) {
                cell.setValue((Object)((BigDecimal)cell.getValue()).setScale(precision, 4));
            }
            if (isSetEditor) {
                KDFormattedTextField kdFtf = FormattedEditorFactory.getBigDecimalFormattedTextField((int)precision, (boolean)isNegative);
                KDTDefaultCellEditor kdCellEditor = new KDTDefaultCellEditor((JTextField)kdFtf);
                cell.setEditor((ICellEditor)kdCellEditor);
            }
            cell.getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString(precision));
        }
    }

    public static void setBigDecimalFieldsPrecisionByCell(ICell cell, int precision, boolean isSetEditor) {
        if (cell != null) {
            if (cell.getValue() instanceof BigDecimal) {
                cell.setValue((Object)((BigDecimal)cell.getValue()).setScale(precision, 4));
            }
            if (isSetEditor) {
                KDFormattedTextField kdFtf = FormattedEditorFactory.getBigDecimalFormattedTextField((int)precision, (boolean)true);
                KDTDefaultCellEditor kdCellEditor = new KDTDefaultCellEditor((JTextField)kdFtf);
                cell.setEditor((ICellEditor)kdCellEditor);
            }
            cell.getStyleAttributes().setNumberFormat(PrecisionFormatUtils.getFormatString(precision));
        }
    }

    public static KDFormattedTextField getBigDecimalTextField(int precision, boolean isNegatived) {
        KDFormattedTextField colTxtField = FormattedEditorFactory.getBigDecimalFormattedTextField((int)precision, (boolean)isNegatived);
        return colTxtField;
    }

    public static void changeScrollBar(KDTable table) {
        table.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        table.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
    }

    public static void setRedBill(KDTable table, String[] cols, boolean isRedBill) {
        ICell cell = null;
        for (int i = 0; i < cols.length; ++i) {
            table.getColumn(cols[i]).getStyleAttributes().setFontColor(isRedBill ? Color.RED : Color.BLACK);
            for (int rowIndex = 0; rowIndex < table.getRowCount(); ++rowIndex) {
                cell = table.getCell(rowIndex, cols[i]);
                BigDecimal amount = (BigDecimal)cell.getValue();
                if (amount == null || amount.compareTo(ArApBaseCalculate.ZERO) >= 0) continue;
                cell.setValue((Object)amount.abs());
            }
        }
    }

    public static void setRed2Negative(KDTable table, int rowIndex, String[] cols, boolean toNegative) {
        for (int i = 0; i < cols.length; ++i) {
            ICell cell = table.getCell(rowIndex, cols[i]);
            if (cell == null || !(cell.getValue() instanceof BigDecimal)) continue;
            BigDecimal amount = (BigDecimal)cell.getValue();
            cell.setValue((Object)(toNegative ? amount.abs().negate() : amount.abs()));
        }
    }

    public static void setRequiredColor(KDTable table, String[] cols, boolean isRequired) {
        for (int i = 0; i < cols.length; ++i) {
            table.getColumn(cols[i]).getStyleAttributes().setBackground(isRequired ? table.getRequiredColor() : Color.WHITE);
        }
    }

    public static void setRequiredColor(KDTable table, String[] cols, boolean isRequired, int rowIndex) {
        if (cols == null) {
            return;
        }
        if (rowIndex < 0) {
            KDTableUtils.setRequiredColor(table, cols, isRequired);
        } else {
            ICell cell = null;
            for (int i = 0; i < cols.length; ++i) {
                cell = table.getCell(rowIndex, cols[i]);
                if (cell == null) continue;
                cell.getStyleAttributes().setBackground(isRequired ? table.getRequiredColor() : Color.WHITE);
            }
        }
    }

    public static void removeNullRow(KDTable table) {
        int rowCount = table.getRowCount();
        int colCount = table.getColumnCount();
        for (int i = 0; i < rowCount; ++i) {
            boolean isNullRow = true;
            IRow row = table.getRow(i);
            for (int colIndex = 0; isNullRow && colIndex < colCount; ++colIndex) {
                isNullRow = row.getCell(colIndex).getValue() == null;
            }
            if (!isNullRow) continue;
            table.removeRow(i);
            --i;
            --rowCount;
        }
    }

    public static void removeNullRow(KDTable table, String[] colNames) {
        int rowCount = table.getRowCount();
        int colCount = table.getColumnCount();
        if (colNames == null) {
            for (int i = 0; i < rowCount; ++i) {
                boolean isNullRow = true;
                IRow row = table.getRow(i);
                for (int colIndex = 0; isNullRow && colIndex < colCount; ++colIndex) {
                    isNullRow = row.getCell(colIndex).getValue() == null;
                }
                if (!isNullRow) continue;
                table.removeRow(i);
                --i;
                --rowCount;
            }
        } else {
            int colCounts = colNames.length;
            for (int i = 0; i < rowCount; ++i) {
                boolean isNullRow = false;
                IRow row = table.getRow(i);
                for (int colIndex = 0; !isNullRow && colIndex < colCounts; ++colIndex) {
                    isNullRow = row.getCell(colNames[colIndex]).getValue() == null;
                }
                if (!isNullRow) continue;
                table.removeRow(i);
                --i;
                --rowCount;
            }
        }
    }

    public static void lockTable(KDTable table) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            table.getColumn(i).getStyleAttributes().setLocked(true);
        }
    }

    public static void unLockTable(KDTable table) {
        for (int i = 0; i < table.getColumnCount(); ++i) {
            table.getColumn(i).getStyleAttributes().setLocked(false);
        }
    }

    public static void setStrColMaxLength(KDTable kdtEntries, String colName, int length) {
        KDTextField txtField = new KDTextField();
        txtField.setMaxLength(length);
        KDTDefaultCellEditor kdtCellEditor = new KDTDefaultCellEditor((JTextField)txtField);
        kdtEntries.getColumn(colName).setEditor((ICellEditor)kdtCellEditor);
    }

    public static int getCellPrecision(KDTable table, int rowIndex, String colName) {
        int precision = 0;
        KDTDefaultCellEditor editor = (KDTDefaultCellEditor)table.getCell(rowIndex, colName).getEditor();
        if (editor == null) {
            editor = (KDTDefaultCellEditor)table.getColumn(colName).getEditor();
        }
        if (editor != null && editor.getComponent() != null) {
            KDFormattedTextField textField = (KDFormattedTextField)editor.getComponent();
            precision = textField.getPrecision();
        }
        return precision;
    }

    public static void bindCellValue2UserObject(KDTable table) {
        int rowCount = table.getRowCount();
        for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
            int colCount = table.getColumnCount();
            for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                ICell cell = table.getCell(rowIndex, colIndex);
                cell.setUserObject(cell.getValue());
            }
        }
    }

    public static String[] unSpecifyFieldsTables(KDTable table, String[] fieldNames) {
        int length = table.getColumnCount();
        if (length == 0) {
            return null;
        }
        ArrayList<String> allColums = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            if (table.getColumn(i).getKey() == null) continue;
            allColums.add(table.getColumn(i).getKey());
        }
        for (int j = 0; j < fieldNames.length; ++j) {
            if (!allColums.contains(fieldNames[j])) continue;
            allColums.remove(fieldNames[j]);
        }
        return allColums.toArray(new String[0]);
    }

    public static void setBigDecimalColumnPrecision(int precision, KDTable table, String[] fieldNames, Boolean isNegatived) {
        KDTableUtils.setBigDecimalColumnPrecision(precision, table, fieldNames, isNegatived, false);
    }

    public static void setBigDecimalColumnPrecision(int precision, KDTable table, String[] fieldNames, Boolean isNegatived, Boolean withoutZero) {
        if (fieldNames == null || fieldNames != null && fieldNames.length == 0) {
            return;
        }
        String colPrecision = KDTableUtils.getFormatString(precision, withoutZero);
        KDTDefaultCellEditor editor = FormattedEditorFactory.getBigDecimalCellEditor((int)precision, (boolean)isNegatived);
        HashMap<String, IColumn> map = new HashMap<String, IColumn>();
        IColumn iColumn = null;
        int num = fieldNames.length;
        for (int i = 0; i < num; ++i) {
            iColumn = map.containsKey(fieldNames[i]) ? (IColumn)map.get(fieldNames[i]) : table.getColumn(fieldNames[i]);
            if (iColumn == null) continue;
            iColumn.setEditor((ICellEditor)editor);
            iColumn.getStyleAttributes().setNumberFormat(colPrecision);
            map.put(fieldNames[i], iColumn);
        }
        if (precision < 0) {
            precision = 2;
        }
    }

    public static String getFormatString(Integer precision, Boolean withoutZero) {
        String placeHolder;
        String startStr;
        StringBuffer formatStr = new StringBuffer(20);
        if (withoutZero.booleanValue()) {
            startStr = "%{#,###";
            placeHolder = "#";
        } else {
            startStr = "%{#,##0";
            placeHolder = "0";
        }
        formatStr.append(startStr);
        if (precision > 0) {
            formatStr.append(".");
            for (int i = 0; i < precision; ++i) {
                formatStr.append(placeHolder);
            }
        }
        formatStr.append("}f");
        return formatStr.toString();
    }

    public static void setBigDecimalColumnPrecision(int precision, KDTable table, String[] fieldNames) {
        KDTableUtils.setBigDecimalColumnPrecision(precision, table, fieldNames, true);
    }

    public static void setBigDecimalCellPrecision(IRow row, String[] fieldNames, int precision, boolean isNegative) {
        BigDecimal temp = null;
        if (precision < 0) {
            precision = 2;
        }
        if (fieldNames == null || fieldNames != null && fieldNames.length == 0 || row == null) {
            return;
        }
        String colPrecision = PrecisionFormatUtils.getFormatString(precision);
        KDTDefaultCellEditor editor = FormattedEditorFactory.getBigDecimalCellEditor((int)precision, (boolean)isNegative);
        ICell iCell = null;
        int num = fieldNames.length;
        for (int i = 0; i < num; ++i) {
            iCell = row.getCell(fieldNames[i]);
            if (iCell == null) continue;
            iCell.setEditor((ICellEditor)editor);
            iCell.getStyleAttributes().setNumberFormat(colPrecision);
            if (iCell.getValue() == null) continue;
            temp = new BigDecimal(iCell.getValue().toString());
            iCell.setValue(temp == null ? null : temp.setScale(precision, 4));
        }
    }

    public static void insertRows(RptRowSet rs, int insertRowIndex, KDTable table, boolean refreshUI, KDTableInsertHandler handler) {
        table.setRefresh(false);
        while (rs.next()) {
            IRow row = table.setRow(insertRowIndex++);
            handler.setTableRowData(row, rs.toRowArray());
        }
        if (refreshUI) {
            table.setRefresh(true);
        }
        if (rs.getRowCount() > 0) {
            table.reLayoutAndPaint();
        } else {
            table.repaint();
        }
    }
}

