/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import java.math.BigDecimal;

public class ProxyBillBizCaculate {
    private static final BigDecimal ZERO = new BigDecimal("0.00");
    private static final BigDecimal ONE = new BigDecimal("1.00");
    private static final BigDecimal ONEHUNDRED = new BigDecimal("100.00");

    public static BigDecimal calDiscountAmount(BigDecimal taxPrice, BigDecimal quantity, BigDecimal discountRate, int precision) {
        taxPrice = taxPrice == null ? ZERO : taxPrice;
        quantity = quantity == null ? ZERO : quantity;
        discountRate = discountRate == null ? ZERO : discountRate;
        return taxPrice.multiply(quantity).multiply(discountRate).setScale(precision, 4);
    }

    public static BigDecimal calTaxPrice(BigDecimal taxRate, BigDecimal price, int pricePrecision) {
        taxRate = taxRate == null ? new BigDecimal("0.17") : ProxyBillBizCaculate.calRate(taxRate);
        price = price == null ? ZERO : price;
        BigDecimal taxPrice = taxRate.add(ONE).multiply(price);
        taxPrice = taxPrice.setScale(pricePrecision, 4);
        return taxPrice;
    }

    public static BigDecimal calPrice(BigDecimal taxPrice, BigDecimal taxRate, int pricePrecision) {
        taxRate = taxRate == null ? new BigDecimal("0.17") : ProxyBillBizCaculate.calRate(taxRate);
        taxPrice = taxPrice == null ? ZERO : taxPrice.setScale(pricePrecision, 4);
        BigDecimal price = taxPrice.divide(taxRate.add(ONE), pricePrecision, 4);
        return price;
    }

    public static BigDecimal calActualTaxPrice(BigDecimal taxPrice, BigDecimal discountRate, int pricePrecision) {
        BigDecimal actualTaxPrice = ZERO;
        taxPrice = taxPrice == null ? ZERO : taxPrice;
        discountRate = discountRate == null ? ZERO : discountRate;
        actualTaxPrice = ONE.subtract(discountRate).multiply(taxPrice);
        return actualTaxPrice.setScale(pricePrecision, 4);
    }

    public static BigDecimal calAmount(BigDecimal price, BigDecimal quantity, BigDecimal discountRate, int precision) {
        price = price == null ? ZERO : price;
        quantity = quantity == null ? ZERO : quantity;
        discountRate = discountRate == null ? ZERO : discountRate;
        return price.multiply(quantity).multiply(ONE.subtract(discountRate)).setScale(precision, 4);
    }

    public static BigDecimal calTaxAmount(BigDecimal amount, BigDecimal taxRate, int precision) {
        amount = amount == null ? ZERO : amount;
        taxRate = taxRate == null ? new BigDecimal("0.17") : taxRate;
        return amount.multiply(taxRate).setScale(precision, 4);
    }

    public static BigDecimal calTaxAmount(BigDecimal qty, BigDecimal price, BigDecimal taxRate, int precision) {
        qty = qty == null ? ZERO : qty;
        price = price == null ? ZERO : price;
        taxRate = taxRate == null ? new BigDecimal("0.17") : taxRate;
        return qty.multiply(taxRate).multiply(price).setScale(precision, 4);
    }

    public static BigDecimal calRecAmount(BigDecimal amount, BigDecimal taxAmount, int precision) {
        amount = amount == null ? ZERO : amount;
        taxAmount = taxAmount == null ? ZERO : taxAmount;
        return amount.add(taxAmount).setScale(precision, 4);
    }

    public static BigDecimal calRate(BigDecimal ratePercent) {
        BigDecimal rate = null;
        if (ratePercent == null) {
            return new BigDecimal("0.00");
        }
        rate = ratePercent.divide(ONEHUNDRED, ratePercent.scale() + 2, 4);
        return rate;
    }
}

