/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDCheckBoxMenuItem;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.fi.arap.BosTypeEnum;
import com.kingdee.eas.fi.arap.billValidator.BillValidateConfigInfo;
import com.kingdee.eas.fi.arap.billValidator.BillValidateResult;
import com.kingdee.eas.fi.arap.client.AbstractValidateResultNavUI;
import com.kingdee.eas.fi.arap.client.ArApBillListUI;
import com.kingdee.eas.fi.arap.client.RelationShader;
import com.kingdee.eas.fi.arap.client.ValidateResultSchemeNavUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.AbstractCoreBillListUI;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.ListUI;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ValidateResultNavUI
extends AbstractValidateResultNavUI {
    private static final Logger logger = CoreUIObject.getLogger(ValidateResultNavUI.class);
    private static Map<String, String> listUIMap = new HashMap<String, String>();
    private Map<String, Integer> idRowIndexMap = new HashMap<String, Integer>();
    private Map<BosTypeEnum, BosTypeEnum> oppositeTypeMap = new HashMap<BosTypeEnum, BosTypeEnum>();
    private Map valEntryPrefix;
    private BillValidateResult billValidateResult;
    private Map<String, String> errorMsgMap = new HashMap<String, String>();
    private ValidateResultSchemeNavUI.ValidateResultCommunicateSlot communicateSlot;
    private boolean isShowHead = false;
    private final RelationShader relationShader = new RelationShader();

    public void onLoad() throws Exception {
        Map uiContext = this.getUIContext();
        this.communicateSlot = (ValidateResultSchemeNavUI.ValidateResultCommunicateSlot)uiContext.get("COMMUNICATE_SLOT");
        this.billValidateResult = (BillValidateResult)uiContext.get("InitDataObject");
        BillValidateConfigInfo billValidateConfig = this.billValidateResult.getBillValidateConfig();
        if (this.billValidateResult.getErrorMsgMap() != null) {
            this.errorMsgMap = this.billValidateResult.getErrorMsgMap();
        }
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        this.valEntryPrefix = billValidateConfig.getValEntryPrefix(null);
        Set<String> errorSumKeys = this.billValidateResult.getErrorMsgMap().keySet();
        EntityObjectInfo validateBillEntity = loader.getEntity(BOSObjectType.create((String)billValidateConfig.getValidateBill().getValue()));
        Set<String> mainBillIds = this.getIdsFromMap(this.billValidateResult.getMainBillIdMap(), errorSumKeys);
        Set<String> mainBillEntryIds = this.getIdsFromMap(this.billValidateResult.getMainBillEntryIdMap(), errorSumKeys);
        this.mainBillTabPane.addTab(validateBillEntity.getAlias(), (Component)this.createBillPane(this.mainBillTabPane, billValidateConfig.getValidateBill(), validateBillEntity, mainBillIds, mainBillEntryIds, (String)this.valEntryPrefix.get(BillValidateConfigInfo.VAL)));
        EntityObjectInfo compareBillEntity = loader.getEntity(BOSObjectType.create((String)billValidateConfig.getCompareBill().getValue()));
        Set<String> secBillIds = this.getIdsFromMap(this.billValidateResult.getSecBillIdMap(), errorSumKeys);
        Set<String> secBillEntryIds = this.getIdsFromMap(this.billValidateResult.getSecBillEntryIdMap(), errorSumKeys);
        this.secBillTabPane.addTab(compareBillEntity.getAlias(), (Component)this.createBillPane(this.secBillTabPane, billValidateConfig.getCompareBill(), compareBillEntity, secBillIds, secBillEntryIds, (String)this.valEntryPrefix.get(BillValidateConfigInfo.COMP)));
        this.oppositeTypeMap.put(billValidateConfig.getValidateBill(), billValidateConfig.getCompareBill());
        this.oppositeTypeMap.put(billValidateConfig.getCompareBill(), billValidateConfig.getValidateBill());
    }

    private Set<String> getIdsFromMap(Map<String, Set<String>> map, Set<String> sumKeys) {
        HashSet<String> ids = new HashSet<String>();
        if (map != null) {
            if (sumKeys.isEmpty()) {
                sumKeys.addAll(map.keySet());
            }
            for (String sumKey : sumKeys) {
                Set<String> idset = map.get(sumKey);
                if (idset == null) continue;
                ids.addAll(idset);
            }
        }
        return ids;
    }

    private KDPanel createBillPane(KDTabbedPane kdTabbedPane, final BosTypeEnum bosTypeEnum, EntityObjectInfo entity, Set<String> billIds, Set<String> billEntryIds, String entryFieldName) {
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        loader.getEntity(BOSObjectType.create((String)bosTypeEnum.getValue()));
        KDPanel panel = new KDPanel(false);
        panel.setBounds(new Rectangle(10, 10, 780, 570));
        kdTabbedPane.addTab(entity.getAlias(), (Component)panel);
        String listUIName = listUIMap.get(bosTypeEnum.getValue());
        if (null == listUIName) {
            listUIName = entity.getExtendedProperty("listUI");
        }
        boolean bl = this.isShowHead = billEntryIds == null || billEntryIds.isEmpty();
        if (!StringUtils.isEmpty((String)listUIName)) {
            HashMap<String, Object> uiCtx = new HashMap<String, Object>();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            evi.setFilter(fi);
            if (!billEntryIds.isEmpty()) {
                fi.getFilterItems().add(new FilterItemInfo(entryFieldName + ".id", billEntryIds, CompareType.INCLUDE));
            } else if (!billIds.isEmpty()) {
                fi.getFilterItems().add(new FilterItemInfo("id", billIds, CompareType.INCLUDE));
            } else {
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)"NULL", CompareType.EQUALS));
            }
            uiCtx.put("BOTPFilter", evi);
            uiCtx.put("BOTPViewStatus", 1);
            if (this.isShowHead) {
                uiCtx.put("ISUSE_OLD_SHOWEHEAD", true);
            }
            ListUI billListUI = null;
            try {
                String paramCount = ParamManager.getParamValue(null, (String)"BOTP_NAV_MaxReturnRowCount");
                int maxReturnRowCount = new Integer(paramCount);
                uiCtx.put("maxReturnRowCount", maxReturnRowCount);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            panel.setBounds(new Rectangle(10, 10, 780, 570));
            panel.setLayout((LayoutManager)new KDLayout());
            panel.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(10, 10, 1013, 629));
            try {
                billListUI = (ListUI)UIFactoryHelper.initUIObject((String)listUIName, uiCtx, null, (String)"FINDVIEW");
                billListUI.setVisible(true);
                if (this.isShowHead) {
                    if (billListUI instanceof ArApBillListUI) {
                        fi.getFilterItems().add(new FilterItemInfo("id", (Object)"0", CompareType.NOTEQUALS));
                    } else if (billListUI instanceof CoreBillListUI) {
                        Field switchViewField = AbstractCoreBillListUI.class.getDeclaredField("menuItemSwitchView");
                        switchViewField.setAccessible(true);
                        KDCheckBoxMenuItem switchViewMenuItem = (KDCheckBoxMenuItem)switchViewField.get(billListUI);
                        if (null != switchViewMenuItem) {
                            switchViewMenuItem.setSelected(true);
                        }
                    }
                }
                panel.add((Component)billListUI, (Object)new KDLayout.Constraints(10, 10, 996, 610, 15));
                this.relationShader.recordTable(bosTypeEnum, billListUI.getMainTable());
                billListUI.getMainTable().addKDTSelectListener(new KDTSelectListener(){

                    public void tableSelectChanged(KDTSelectEvent e) {
                        ValidateResultNavUI.this.tableSelectChangedHandler(e, bosTypeEnum);
                    }
                });
                billListUI.getMainTable().addKDTDataFillListener(new KDTDataFillListener(){

                    public void afterDataFill(KDTDataRequestEvent e) {
                        ValidateResultNavUI.this.afterDataFillHandler(bosTypeEnum, (KDTable)e.getSource());
                    }
                });
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return panel;
    }

    private void afterDataFillHandler(BosTypeEnum bosTypeEnum, KDTable table) {
        String bosType = bosTypeEnum.getValue();
        boolean isValidateBill = this.billValidateResult.getBillValidateConfig().getValidateBill().getValue().equals(bosType);
        String prefix = isValidateBill ? (String)this.valEntryPrefix.get(BillValidateConfigInfo.VAL) : (String)this.valEntryPrefix.get(BillValidateConfigInfo.COMP);
        String idKey = !this.isShowHead ? prefix + ".id" : "id";
        for (int i = 0; i < table.getRowCount(); ++i) {
            this.relationShader.setOriginColor(table.getRow(i).getStyleAttributes().getBackground());
            this.idRowIndexMap.put(String.valueOf(table.getCell(i, idKey).getValue()), i);
        }
    }

    private void tableSelectChangedHandler(KDTSelectEvent e, BosTypeEnum bosTypeEnum) {
        KDTSelectBlock selectBlock = e.getSelectBlock();
        HashSet<Integer> rowIndexes = new HashSet<Integer>();
        for (int i = selectBlock.getBeginRow(); i <= selectBlock.getEndRow(); ++i) {
            rowIndexes.add(i);
        }
        this.paintRow((KDTable)e.getSource(), rowIndexes, bosTypeEnum);
    }

    private void paintRow(KDTable activeTable, Set<Integer> rowIndexes, BosTypeEnum bosTypeEnum) {
        Map<String, Set<String>> oppositeIdMap;
        Map<String, Set<String>> idMap;
        this.relationShader.recoverTableColor();
        BosTypeEnum oppositeBosType = this.oppositeTypeMap.get((Object)bosTypeEnum);
        KDTable oppositeTable = this.relationShader.getTable(oppositeBosType);
        Map<String, Set<String>> billIdMap = this.billValidateResult.getMainBillIdMap();
        Map<String, Set<String>> billEntryIdMap = this.billValidateResult.getMainBillEntryIdMap();
        Map<String, Set<String>> oppositeBillIdMap = this.billValidateResult.getSecBillIdMap();
        Map<String, Set<String>> oppositeBillEntryIdMap = this.billValidateResult.getSecBillEntryIdMap();
        String entryPrefix = (String)this.valEntryPrefix.get(BillValidateConfigInfo.VAL);
        if (!bosTypeEnum.equals((Object)this.billValidateResult.getBillValidateConfig().getValidateBill())) {
            billIdMap = this.billValidateResult.getSecBillIdMap();
            billEntryIdMap = this.billValidateResult.getSecBillEntryIdMap();
            oppositeBillIdMap = this.billValidateResult.getMainBillIdMap();
            oppositeBillEntryIdMap = this.billValidateResult.getMainBillEntryIdMap();
            entryPrefix = (String)this.valEntryPrefix.get(BillValidateConfigInfo.COMP);
        }
        Map<String, Set<String>> map = idMap = !this.isShowHead ? billEntryIdMap : billIdMap;
        if (idMap == null) {
            idMap = new HashMap<String, Set<String>>();
        }
        Map<String, Set<String>> map2 = oppositeIdMap = !this.isShowHead ? oppositeBillEntryIdMap : oppositeBillIdMap;
        if (oppositeIdMap == null) {
            oppositeIdMap = new HashMap<String, Set<String>>();
        }
        for (Integer rowIndex : new ArrayList<Integer>(rowIndexes)) {
            Map.Entry<String, Set<String>> entry2;
            IRow row = activeTable.getRow(rowIndex.intValue());
            String idKey = !this.isShowHead ? entryPrefix + ".id" : "id";
            String id = String.valueOf(row.getCell(idKey).getValue());
            String sumKey = null;
            HashSet oppositeIdSet = new HashSet();
            HashSet<Integer> oppositeRowIndexes = new HashSet<Integer>();
            for (Map.Entry<String, Set<String>> entry2 : idMap.entrySet()) {
                Set<String> set = entry2.getValue();
                if (!set.contains(id)) continue;
                oppositeIdSet.addAll(oppositeIdMap.get(entry2.getKey()));
                sumKey = (String)entry2.getKey();
            }
            HashSet<Integer> oppositeRecoverRows = new HashSet<Integer>();
            entry2 = oppositeIdSet.iterator();
            while (entry2.hasNext()) {
                String oppositeId = (String)entry2.next();
                Integer rIndex = this.idRowIndexMap.get(oppositeId);
                if (null == rIndex) continue;
                oppositeRecoverRows.add(rIndex);
                oppositeRowIndexes.add(rIndex);
            }
            this.relationShader.recordRecoverRowIndexes(oppositeBosType, oppositeRecoverRows);
            if (idMap.get(sumKey) != null) {
                HashSet<Integer> rowIndexs = new HashSet<Integer>();
                for (String bid : idMap.get(sumKey)) {
                    if (this.idRowIndexMap.get(bid) == null) continue;
                    rowIndexs.add(this.idRowIndexMap.get(bid));
                }
                this.relationShader.recordRecoverRowIndexes(bosTypeEnum, rowIndexs);
                this.relationShader.paintTable(bosTypeEnum, sumKey, rowIndexs);
            }
            if (null != oppositeRowIndexes) {
                this.relationShader.paintTable(oppositeBosType, sumKey, oppositeRowIndexes);
            }
            if (oppositeRowIndexes != null && !oppositeRowIndexes.isEmpty()) {
                oppositeTable.getLayoutManager().scrollRowToShow(new ArrayList<Integer>(oppositeRowIndexes).get(0).intValue());
            }
            if (null == this.communicateSlot) continue;
            this.communicateSlot.reportErrorMessage(this.errorMsgMap.get(sumKey));
        }
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    static {
        listUIMap.put("40284E81", "com.kingdee.eas.fi.cas.client.PaymentBillListUI");
        listUIMap.put("FA44FD5B", "com.kingdee.eas.fi.cas.client.ReceivingBillListUI");
    }
}

