/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client.util;

import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.fi.ar.AccountAgeQueryParam;
import com.kingdee.eas.fi.arap.client.util.TablePrintUtil;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class AgingRptTablePrintUtil {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.client.util.AgingRptTablePrintUtil");

    private AgingRptTablePrintUtil() {
    }

    public static void preparePrintPageHeader(HeadFootModel headerModel, AccountAgeQueryParam param) {
        StringBuffer row = new StringBuffer();
        if (param.getCompanyIds().size() == 1) {
            row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_Company"));
            row.append(" &[Company] &| ");
            headerModel.addRow(row.toString());
            row.delete(0, row.length());
        }
        row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_DateRange"));
        row.append(" &[DateRange] &| ");
        row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_AgingDate"));
        row.append(" &[AgingDate]");
        headerModel.addRow(row.toString());
        row.delete(0, row.length());
        row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_AsstActType"));
        row.append(" &[AsstActType]&|");
        row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_AsstActRange"));
        row.append(" &[AsstActRange]");
        headerModel.addRow(row.toString());
        row.delete(0, row.length());
        boolean fAllCurrency = param.isAllCurrency();
        if (!fAllCurrency) {
            row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_Currency"));
            row.append(" &[Currency]&| ");
            headerModel.addRow(row.toString());
        }
    }

    public static Map preparePrintVarMap(AccountAgeQueryParam param) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (param.getCompanyIds().size() == 1) {
            String companyId = param.getCompanyIds().get(0).toString();
            try {
                ICompanyOrgUnit iComp = CompanyOrgUnitFactory.getRemoteInstance();
                CompanyOrgUnitInfo compInfo = iComp.getCompanyOrgUnitInfo("select id, name where id = '" + companyId + "'");
                map.put("Company", compInfo.getName());
            }
            catch (Exception e) {
                logger.error((Object)"exception, get the company", (Throwable)e);
            }
        }
        String dateRange = TablePrintUtil.getDateRangeDesc(param.getBeginDate(), param.getEndDate());
        map.put("DateRange", dateRange);
        String sAgingDate = TablePrintUtil.getDateFormat().format(param.getAgingCompareDate());
        map.put("AgingDate", sAgingDate);
        if (!param.isAllCurrency()) {
            map.put("Currency", param.getCurrencyInfo().getName());
        }
        map.put("AsstActType", param.getCussAcctTypeInfo().getName());
        String asstActRange = TablePrintUtil.getAsstActRangeDesc(param);
        map.put("AsstActRange", asstActRange);
        return map;
    }
}

