/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.common.DestinationTypeEnum;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.ArApCalculateException;
import com.kingdee.eas.fi.ar.client.ArApBillEditUI;
import com.kingdee.eas.fi.arap.client.KDTableUtils;
import com.kingdee.eas.fi.arap.client.util.CalculateUICondition;
import com.kingdee.eas.fi.arap.util.ArApBaseCalculate;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.CalculateCondition;
import java.awt.Component;
import java.math.BigDecimal;

public abstract class ArApBillUICalculate
extends ArApBaseCalculate {
    private int rowIndex;
    protected KDTable kdtEntry;

    public ArApBillUICalculate(CalculateUICondition cdt) {
        super(cdt);
        if (cdt.getKdtEntry() == null) {
            throw new IllegalArgumentException();
        }
        this.rowIndex = cdt.getRowIndex();
        this.kdtEntry = cdt.getKdtEntry();
    }

    private void initPrecision() {
        Component comp = this.getCellEditorComp(this.rowIndex, "price");
        if (comp != null && comp instanceof KDFormattedTextField) {
            int pricePrecision = ((KDFormattedTextField)comp).getPrecision();
            this.getCondition().setPricePrecision(pricePrecision);
        }
    }

    @Override
    protected void beforeInitData() {
        this.rowIndex = ((CalculateUICondition)this.getCondition()).getRowIndex();
        this.kdtEntry = ((CalculateUICondition)this.getCondition()).getKdtEntry();
        this.qty = this.getBigDecimal("quantity");
        this.recPayAmount = this.getBigDecimal("recPayAmount");
        this.amount = this.getBigDecimal("amount");
        this.isRed = this.qty.signum() == 0 ? (this.getCondition().isInTax() ? this.recPayAmount.signum() < 0 : this.amount.signum() < 0) : this.qty.signum() < 0;
        KDTableUtils.setRed2Negative(this.kdtEntry, this.rowIndex, ArApBillEditUI.getEntryRedCol(), false);
        if (((CalculateUICondition)this.getCondition()).isDebitAdjust()) {
            if (this.qty.compareTo(ZERO) == 0) {
                this.qty = this.isRed ? ONE.negate() : ONE;
                this.isDebitAdjustQtyZero = true;
            }
        } else {
            this.qty = ((CalculateUICondition)this.getCondition()).isAllowanceBill() ? (this.isRed ? ONE.negate() : ONE) : this.getBigDecimal("quantity");
        }
        super.beforeInitData();
    }

    @Override
    protected void initData() {
        this.initPrecision();
        this.realPrice = this.getBigDecimal("realPrice");
        this.amount = this.getBigDecimal("amount");
        if (((CalculateUICondition)this.getCondition()).isDebitAdjust()) {
            if (this.qty.compareTo(ZERO) == 0) {
                this.qty = this.isRed ? ONE.negate() : ONE;
            }
        } else {
            this.qty = ((CalculateUICondition)this.getCondition()).isAllowanceBill() ? (this.isRed ? ONE.negate() : ONE) : this.getBigDecimal("quantity");
        }
        this.actualPrice = this.getBigDecimal("actualPrice");
        this.taxPrice = this.getBigDecimal("taxPrice");
        this.discountRate = this.getBigDecimal("discountRate");
        this.recPayAmount = this.getBigDecimal("recPayAmount");
        this.price = this.getBigDecimal("price");
        this.taxRate = this.getBigDecimal("taxRate");
        this.discountType = (DiscountModeEnum)this.kdtEntry.getCell(this.rowIndex, "discountType").getValue();
        this.taxAmount = this.getBigDecimal("taxAmount");
        this.recPayAmountLocal = this.getBigDecimal("recPayAmountLocal");
        this.taxAmountLocal = this.getBigDecimal("taxAmountLocal");
        this.discountAmount = this.getBigDecimal("discountAmount");
        this.discountAmountLocal = this.getBigDecimal("discountAmountLocal");
        this.amountLocal = this.getBigDecimal("amountLocal");
        this.verifyAmount = this.getBigDecimal("verifyAmount");
        this.verifyAmountLocal = this.getBigDecimal("verifyAmountLocal");
        this.unVerifyAmount = this.getBigDecimal("unVerifyAmount");
        this.unVerifyAmountLocal = this.getBigDecimal("unVerifyAmountLocal");
        if (this.kdtEntry != null && this.kdtEntry.getCell(this.rowIndex, "rowType") != null) {
            this.rowType = (RowTypeInfo)this.kdtEntry.getCell(this.rowIndex, "rowType").getValue();
        }
        if (this.kdtEntry != null && this.kdtEntry.getCell(this.rowIndex, "measureUnit") != null) {
            this.unitInfo = (MeasureUnitInfo)this.kdtEntry.getCell(this.rowIndex, "measureUnit").getValue();
        }
        if (this.kdtEntry != null && this.kdtEntry.getCell(this.rowIndex, "baseUnit") != null) {
            this.baseUnitInfo = (MeasureUnitInfo)this.kdtEntry.getCell(this.rowIndex, "baseUnit").getValue();
        }
        if (this.kdtEntry != null && this.kdtEntry.getCell(this.rowIndex, "materialNumber") != null) {
            if (this.kdtEntry.getCell(this.rowIndex, "materialNumber").getValue() instanceof MaterialInfo) {
                this.materialInfo = (MaterialInfo)this.kdtEntry.getCell(this.rowIndex, "materialNumber").getValue();
            } else if (this.kdtEntry.getCell(this.rowIndex, "materialNumber").getValue() instanceof Object[]) {
                Object[] obj = (Object[])this.kdtEntry.getCell(this.rowIndex, "materialNumber").getValue();
                this.materialInfo = (MaterialInfo)obj[0];
            }
        }
        this.baseQty = ((CalculateUICondition)this.getCondition()).isDebitAdjust() ? (this.isDebitAdjustQtyZero ? (this.isRed ? ONE.negate() : ONE) : (this.qty.compareTo(ZERO) == 0 ? this.getBigDecimal("baseQty") : ArApBillUtil.getBaseUnitQty(this.unitInfo, this.materialInfo, this.qty))) : (((CalculateUICondition)this.getCondition()).isAllowanceBill() ? (this.isRed ? ONE.negate() : ONE) : this.getBigDecimal("baseQty"));
        if (this.kdtEntry != null && this.kdtEntry.getCell(this.rowIndex, "assistUnit") != null) {
            this.assistUnitInfo = (MeasureUnitInfo)this.kdtEntry.getCell(this.rowIndex, "assistUnit").getValue();
        }
        this.assistQty = ((CalculateUICondition)this.getCondition()).isDebitAdjust() ? (this.isDebitAdjustQtyZero ? (this.isRed ? ONE.negate() : ONE) : this.getBigDecimal("assistQty")) : (((CalculateUICondition)this.getCondition()).isAllowanceBill() ? (this.isRed ? ONE.negate() : ONE) : this.getBigDecimal("assistQty"));
    }

    @Override
    public void execute(CalculateCondition cditn) throws EASBizException, BOSException {
        this.init();
        this.initCondition(cditn);
        try {
            this.innerCalculate(cditn);
        }
        catch (ArApCalculateException e) {
            KDTableUtils.setRed2Negative(this.kdtEntry, this.rowIndex, ArApBillEditUI.getEntryRedCol(), this.isRed);
            throw new ArApCalculateException(ArApCalculateException.DATA_INVALID, new Object[]{e.getMessage()});
        }
        this.update();
    }

    @Override
    protected void afterUpdateData() {
        super.afterUpdateData();
        KDTableUtils.setRed2Negative(this.kdtEntry, this.rowIndex, ArApBillEditUI.getEntryRedCol(), this.isRed);
        KDTableUtils.setRed2Negative(this.kdtEntry, this.rowIndex, new String[]{"unApportionAmount", "apportionAmount"}, this.isRed);
    }

    @Override
    protected void updateData() {
        if (((CalculateUICondition)this.getCondition()).isDebitAdjust()) {
            if (this.isDebitAdjustQtyZero) {
                this.qty = ZERO;
                this.baseQty = ZERO;
                this.assistQty = ZERO;
            }
            this.realPrice = this.realPrice.abs();
            this.actualPrice = this.actualPrice.abs();
            this.taxPrice = this.taxPrice.abs();
            this.price = this.price.abs();
        } else if (((CalculateUICondition)this.getCondition()).isAllowanceBill()) {
            this.qty = ZERO;
            this.baseQty = ZERO;
            this.assistQty = ZERO;
            this.realPrice = this.realPrice.abs();
            this.actualPrice = this.actualPrice.abs();
            this.taxPrice = this.taxPrice.abs();
            this.price = this.price.abs();
        }
        this.kdtEntry.getCell(this.rowIndex, "realPrice").setValue((Object)this.realPrice);
        this.kdtEntry.getCell(this.rowIndex, "actualPrice").setValue((Object)this.actualPrice);
        this.kdtEntry.getCell(this.rowIndex, "taxPrice").setValue((Object)this.taxPrice);
        this.kdtEntry.getCell(this.rowIndex, "price").setValue((Object)this.price);
        this.kdtEntry.getCell(this.rowIndex, "amount").setValue((Object)this.amount);
        if (this.kdtEntry.getCell(this.rowIndex, "amountLocal") != null) {
            this.kdtEntry.getCell(this.rowIndex, "amountLocal").setValue((Object)this.amountLocal);
        }
        this.kdtEntry.getCell(this.rowIndex, "taxAmount").setValue((Object)this.taxAmount);
        if (this.kdtEntry.getCell(this.rowIndex, "taxAmountLocal") != null) {
            this.kdtEntry.getCell(this.rowIndex, "taxAmountLocal").setValue((Object)this.taxAmountLocal);
        }
        this.kdtEntry.getCell(this.rowIndex, "discountAmount").setValue((Object)this.discountAmount);
        if (this.kdtEntry.getCell(this.rowIndex, "discountAmountLocal") != null) {
            this.kdtEntry.getCell(this.rowIndex, "discountAmountLocal").setValue((Object)this.discountAmountLocal);
        }
        this.kdtEntry.getCell(this.rowIndex, "discountType").setValue((Object)this.discountType);
        this.kdtEntry.getCell(this.rowIndex, "discountRate").setValue((Object)this.discountRate);
        this.kdtEntry.getCell(this.rowIndex, "recPayAmount").setValue((Object)this.recPayAmount);
        if (this.kdtEntry.getCell(this.rowIndex, "recPayAmountLocal") != null) {
            this.kdtEntry.getCell(this.rowIndex, "recPayAmountLocal").setValue((Object)this.recPayAmountLocal);
        }
        if (this.kdtEntry.getCell(this.rowIndex, "baseQty") != null) {
            this.kdtEntry.getCell(this.rowIndex, "baseQty").setValue((Object)this.baseQty);
        }
        this.kdtEntry.getCell(this.rowIndex, "quantity").setValue((Object)this.qty);
        if (this.condition.isTransBill()) {
            IRow row = this.kdtEntry.getRow(this.rowIndex);
            if (row != null) {
                if (row.getCell("unwriteOffBaseQty") != null) {
                    row.getCell("unwriteOffBaseQty").setValue((Object)ZERO);
                }
                if (row.getCell("wittenOffBaseQty") != null) {
                    row.getCell("wittenOffBaseQty").setValue((Object)this.baseQty);
                }
                if (row.getCell("localUnwriteOffAmount") != null) {
                    row.getCell("localUnwriteOffAmount").setValue((Object)ZERO);
                }
                if (row.getCell("localWrittenOffAmount") != null) {
                    row.getCell("localWrittenOffAmount").setValue((Object)this.amountLocal);
                }
            }
        } else {
            if (this.kdtEntry.getCell(this.rowIndex, "baseQty") != null) {
                this.kdtEntry.getCell(this.rowIndex, "unwriteOffBaseQty").setValue((Object)this.baseQty);
            }
            if (this.kdtEntry.getCell(this.rowIndex, "wittenOffBaseQty") != null) {
                this.kdtEntry.getCell(this.rowIndex, "wittenOffBaseQty").setValue((Object)ZERO);
            }
        }
        if (this.rowType != null && DestinationTypeEnum.COSTS.equals((Object)this.rowType.getDestinationType())) {
            this.kdtEntry.getCell(this.rowIndex, "baseQty").setValue((Object)this.qty);
            this.kdtEntry.getCell(this.rowIndex, "baseUnit").setValue((Object)this.unitInfo);
            this.kdtEntry.getCell(this.rowIndex, "wittenOffBaseQty").setValue((Object)ZERO);
            this.kdtEntry.getCell(this.rowIndex, "unwriteOffBaseQty").setValue((Object)this.qty);
            this.kdtEntry.getCell(this.rowIndex, "localWrittenOffAmount").setValue((Object)ZERO);
            this.kdtEntry.getCell(this.rowIndex, "localUnwriteOffAmount").setValue((Object)this.amountLocal);
        }
        CalculateUICondition conditionUI = (CalculateUICondition)this.condition;
        KDTable entryTable = conditionUI.getKdtEntry();
        if (!(this.condition.isVerifyAmountChanged() || this.kdtEntry.getCell(conditionUI.getRowIndex(), "verifyAmount") == null || (BigDecimal)entryTable.getRow(conditionUI.getRowIndex()).getCell("verifyAmount").getValue() == null || this.condition.isAllowanceBill() || this.condition.isInitializeBill())) {
            this.verifyAmount = (BigDecimal)entryTable.getRow(conditionUI.getRowIndex()).getCell("verifyAmount").getValue();
            this.verifyAmountLocal = (BigDecimal)entryTable.getRow(conditionUI.getRowIndex()).getCell("verifyAmountLocal").getValue();
            this.unVerifyAmount = this.recPayAmount.subtract(this.verifyAmount);
            this.unVerifyAmountLocal = this.recPayAmountLocal.subtract(this.verifyAmountLocal);
        }
        if (this.kdtEntry.getCell(this.rowIndex, "assistQty") != null) {
            this.kdtEntry.getCell(this.rowIndex, "assistQty").setValue((Object)this.assistQty);
        }
        if (this.kdtEntry.getCell(this.rowIndex, "unVerifyAmount") != null) {
            this.kdtEntry.getCell(this.rowIndex, "unVerifyAmount").setValue((Object)this.unVerifyAmount);
        }
        if (this.kdtEntry.getCell(this.rowIndex, "unVerifyAmountLocal") != null) {
            this.kdtEntry.getCell(this.rowIndex, "unVerifyAmountLocal").setValue((Object)this.unVerifyAmountLocal);
        }
        if (this.kdtEntry.getCell(this.rowIndex, "verifyAmount") != null) {
            this.kdtEntry.getCell(this.rowIndex, "verifyAmount").setValue((Object)this.verifyAmount);
        }
        if (this.kdtEntry.getCell(this.rowIndex, "verifyAmountLocal") != null) {
            this.kdtEntry.getCell(this.rowIndex, "verifyAmountLocal").setValue((Object)this.verifyAmountLocal);
        }
        BigDecimal lockAmount = BigDecimal.ZERO;
        BigDecimal lockAmountLoc = BigDecimal.ZERO;
        if (!this.condition.isInitializeBill()) {
            this.setCellValueByName("lockVerifyAmt", lockAmount);
            this.setCellValueByName("lockVerifyAmtLocal", lockAmountLoc);
            this.setCellValueByName("lockUnVerifyAmt", this.recPayAmount.subtract(lockAmount));
            this.setCellValueByName("lockUnVerifyAmtLocal", this.recPayAmountLocal.subtract(lockAmountLoc));
        } else {
            this.setCellValueByName("lockVerifyAmt", this.verifyAmount);
            this.setCellValueByName("lockVerifyAmtLocal", this.verifyAmountLocal);
            this.setCellValueByName("lockUnVerifyAmt", this.unVerifyAmount);
            this.setCellValueByName("lockUnVerifyAmtLocal", this.unVerifyAmountLocal);
        }
        this.setCellValueByName("invoiceReqQty", ZERO);
        this.setCellValueByName("invoiceReqBaseQty", ZERO);
        this.setCellValueByName("unInvoiceReqQty", this.qty);
        this.setCellValueByName("unInvoiceReqBaseQty", this.baseQty);
        this.setCellValueByName("invoiceReqAmount", ZERO);
        this.setCellValueByName("invoiceReqAmountLocal", ZERO);
        this.setCellValueByName("unInvoiceReqAmount", this.recPayAmount);
        this.setCellValueByName("unInvoiceReqAmountLocal", this.recPayAmountLocal);
    }

    protected void setCellValueByName(String cellName, BigDecimal value) {
        if (null != this.kdtEntry.getCell(this.rowIndex, cellName)) {
            this.kdtEntry.getCell(this.rowIndex, cellName).setValue((Object)value);
        }
    }

    private Component getCellEditorComp(int row, String column) {
        ICell cell = this.kdtEntry.getCell(row, column);
        IColumn icolumn = this.kdtEntry.getColumn(column);
        Component editorComp = null;
        if (cell != null && cell.getEditor() != null) {
            editorComp = cell.getEditor().getComponent();
        } else if (cell != null && icolumn.getEditor() != null) {
            editorComp = icolumn.getEditor().getComponent();
        }
        return editorComp;
    }

    public BigDecimal getBigDecimal(String colName) {
        ICell cell = this.kdtEntry.getCell(this.rowIndex, colName);
        if (cell != null && cell.getValue() instanceof BigDecimal) {
            return (BigDecimal)cell.getValue();
        }
        return ZERO;
    }

    public static void main(String[] args) {
    }
}

