/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.client.util;

import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.fi.ar.SummaryRptQueryParam;
import com.kingdee.eas.fi.arap.client.util.TablePrintUtil;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SummRptTablePrintUtil {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.client.util.SummRptTablePrintUtil");

    private SummRptTablePrintUtil() {
    }

    public static void preparePrintPageHeader(HeadFootModel headerModel, SummaryRptQueryParam param) {
        StringBuffer row = new StringBuffer();
        boolean fPrintComp = false;
        if (param.getCompanyIds().size() == 1) {
            fPrintComp = true;
            row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_Company"));
            row.append(" &[Company]&|");
        }
        row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_DateRange"));
        row.append(" &[DateRange]").append(fPrintComp ? "" : " &| ");
        headerModel.addRow(row.toString());
        row.delete(0, row.length());
        row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_AsstActType"));
        row.append(" &[AsstActType]&|");
        row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_AsstActRange"));
        row.append(" &[AsstActRange]");
        headerModel.addRow(row.toString());
        row.delete(0, row.length());
        boolean fAllCurrency = param.isAllCurrency();
        if (!fAllCurrency) {
            row.append(EASResource.getString((String)"com.kingdee.eas.fi.ar.client.ArResource", (String)"PRNT_Currency"));
            row.append(" &[Currency]&| ");
            headerModel.addRow(row.toString());
        }
    }

    public static Map preparePrintVarMap(SummaryRptQueryParam param) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (param.getCompanyIds().size() == 1) {
            String companyId = param.getCompanyIds().get(0).toString();
            try {
                ICompanyOrgUnit iComp = CompanyOrgUnitFactory.getRemoteInstance();
                CompanyOrgUnitInfo compInfo = iComp.getCompanyOrgUnitInfo("select id, name where id = '" + companyId + "'");
                map.put("Company", compInfo.getName());
            }
            catch (Exception e) {
                logger.error((Object)"exception, get the company", (Throwable)e);
            }
        }
        String dateRange = null;
        dateRange = param.isByPeriod() ? TablePrintUtil.getPeriodRangeDesc(param.getStartPeriodYear(), param.getStartPeriodNum(), param.getEndPeriodYear(), param.getEndPeriodNum()) : TablePrintUtil.getDateRangeDesc(param.getBeginDate(), param.getEndDate());
        map.put("DateRange", dateRange);
        if (!param.isAllCurrency()) {
            map.put("Currency", param.getCurrencyInfo().getName());
        }
        map.put("AsstActType", param.getCussAcctTypeInfo().getName());
        String asstActRange = TablePrintUtil.getAsstActRangeDesc(param);
        map.put("AsstActRange", asstActRange);
        return map;
    }
}

