/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.invoiceMatch.client;

import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.fi.ap.client.util.BaseDataUtil;
import com.kingdee.eas.fi.arap.invoiceMatch.client.AbstractIMRecordConditionUI;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchConstant;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchUtils;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class IMRecordConditionUI
extends AbstractIMRecordConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(IMRecordConditionUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCompanyF7();
        this.prmtCompany.setValue((Object)MatchUtils.getPermissionCompany("ap_invoiceMatchRecord_view"));
        this.prmtCompany.setEnabledMultiSelection(true);
        this.prmtSupplier.setEnabledMultiSelection(true);
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public RptParams getCustomCondition() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        RptParams pp = new RptParams();
        if (this.prmtCompany.getValue() != null) {
            pp.setObject("Company", this.prmtCompany.getValue());
        }
        if (this.pkBizDateFrom.getValue() != null) {
            pp.setObject("BizDateFrom", (Object)sdf.format(this.pkBizDateFrom.getValue()));
        } else {
            pp.setObject("BizDateFrom", null);
        }
        if (this.pkBizDateTo.getValue() != null) {
            pp.setObject("BizDateTo", (Object)sdf.format(this.pkBizDateTo.getValue()));
        } else {
            pp.setObject("BizDateTo", null);
        }
        if (this.prmtSupplier.getValue() != null) {
            pp.setObject("Supplier", this.prmtSupplier.getValue());
        } else {
            pp.setObject("Supplier", null);
        }
        if (!StringUtils.isEmpty((String)this.pkDestBillNumber.getText())) {
            pp.setObject("DestBillNumbe", (Object)this.pkDestBillNumber.getText());
        } else {
            pp.setObject("DestBillNumbe", null);
        }
        return pp;
    }

    public void setCustomCondition(RptParams params) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (params.getObject("Company") != null) {
            this.prmtCompany.setValue(params.getObject("Company"));
        }
        try {
            if (params.getObject("BizDateFrom") != null) {
                this.pkBizDateFrom.setValue((Object)sdf.parse(params.getObject("BizDateFrom").toString()));
            } else {
                this.pkBizDateFrom.setValue(null);
            }
            if (params.getObject("BizDateTo") != null) {
                this.pkBizDateTo.setValue((Object)sdf.parse(params.getObject("BizDateTo").toString()));
            } else {
                this.pkBizDateTo.setValue(null);
            }
        }
        catch (ParseException e) {
            this.handUIException(e);
        }
        if (params.getObject("Supplier") != null) {
            this.prmtSupplier.setValue(params.getObject("Supplier"));
        } else {
            this.prmtSupplier.setValue(null);
        }
        if (params.getObject("DestBillNumbe") != null) {
            this.pkDestBillNumber.setText(params.getObject("DestBillNumbe").toString());
        } else {
            this.pkDestBillNumber.setText(null);
        }
    }

    private void initCompanyF7() {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, "ap_invoiceMatchRecord_view");
        this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    public boolean verify() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateFrom = null;
        String dateTo = null;
        if (this.prmtCompany.getText().isEmpty()) {
            MsgBox.showInfo((String)EASResource.getString((String)MatchConstant.INVOICEMATCH_RESOURCE, (String)"Error_CompanyNotNull"));
            return false;
        }
        if (this.pkBizDateFrom.getValue() != null) {
            dateFrom = sdf.format(this.pkBizDateFrom.getValue());
        }
        if (this.pkBizDateTo.getValue() != null) {
            dateTo = sdf.format(this.pkBizDateTo.getValue());
        }
        if (dateFrom != null && dateTo != null && dateTo.compareTo(dateFrom) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)MatchConstant.INVOICEMATCH_RESOURCE, (String)"Error_BizDate"));
            return false;
        }
        return super.verify();
    }

    public void clear() {
        try {
            this.prmtCompany.setValue((Object)MatchUtils.getPermissionCompany("ap_invoiceMatchRecord_view"));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        this.prmtSupplier.setValue(null);
        this.pkBizDateTo.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        this.pkBizDateFrom.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        this.pkDestBillNumber.setText(null);
        super.clear();
    }

    public FilterInfo getFilterInfo() {
        this.filterInfo = new FilterInfo();
        if (!StringUtils.isEmpty((String)this.prmtCompany.getText())) {
            String[] companyFilterStr;
            HashSet<String> companyIdSet = new HashSet<String>();
            for (String str : companyFilterStr = this.prmtCompany.getText().split(";")) {
                companyIdSet.add(str.trim());
            }
            this.filterInfo.getFilterItems().add(new FilterItemInfo("company.number", companyIdSet, CompareType.INCLUDE));
        }
        if (!StringUtils.isEmpty((String)this.prmtSupplier.getText())) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("supplier.number", (Object)("%" + this.prmtSupplier.getText() + "%"), CompareType.LIKE));
        }
        if (!StringUtils.isEmpty((String)this.pkDestBillNumber.getText())) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("destBillNumber", (Object)("%" + this.pkDestBillNumber.getText() + "%"), CompareType.LIKE));
        }
        if (this.pkBizDateFrom.getValue() != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)BaseDataUtil.downTimestamp(this.pkBizDateFrom.getTimestamp()), CompareType.GREATER_EQUALS));
        }
        if (this.pkBizDateTo.getValue() != null) {
            this.filterInfo.getFilterItems().add(new FilterItemInfo("bizDate", (Object)BaseDataUtil.upTimestamp(this.pkBizDateTo.getTimestamp()), CompareType.LESS));
        }
        StringBuffer sbFormula = new StringBuffer();
        if (this.filterInfo.getFilterItems() != null && this.filterInfo.getFilterItems().size() > 0) {
            sbFormula.append("(").append(" ").append("#").append(0).append(" ").append(")").append(" ");
            int size = this.filterInfo.getFilterItems().size();
            for (int i = 1; i < size; ++i) {
                sbFormula.append("and").append(" ").append("(").append(" ").append("#").append(i).append(" ").append(")").append(" ");
            }
        }
        this.filterInfo.setMaskString(sbFormula.toString());
        return this.filterInfo;
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        super.loadData(entityViewInfo);
    }
}

