/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.invoiceMatch.client;

import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.fi.arap.invoiceMatch.client.AbstractIncomeInvoiceConditionUI;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchConstant;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchUtils;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class IncomeInvoiceConditionUI
extends AbstractIncomeInvoiceConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(IncomeInvoiceConditionUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCompanyF7();
        this.prmtCompany.setValue((Object)MatchUtils.getPermissionCompany("ap_invoiceMatch_match"));
        this.prmtCompany.setEnabledMultiSelection(true);
        this.prmtSupplier.setEnabledMultiSelection(true);
    }

    public RptParams getCustomCondition() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        RptParams pp = new RptParams();
        if (this.prmtCompany.getValue() != null) {
            pp.setObject("Company", this.prmtCompany.getValue());
        }
        if (this.comboInvoiceType.getSelectedItem() != null) {
            pp.setObject("InvoiceType", (Object)((PayInvoiceTypeEnum)this.comboInvoiceType.getSelectedItem()).getValue());
        } else {
            pp.setObject("InvoiceType", null);
        }
        if (this.pkInvoiceDateFrom.getValue() != null) {
            pp.setObject("InvoiceDateFrom", (Object)sdf.format(this.pkInvoiceDateFrom.getValue()));
        } else {
            pp.setObject("InvoiceDateFrom", null);
        }
        if (this.pkInvoiceDateTo.getValue() != null) {
            pp.setObject("InvoiceDateTo", (Object)sdf.format(this.pkInvoiceDateTo.getValue()));
        } else {
            pp.setObject("InvoiceDateTo", null);
        }
        if (this.prmtSupplier.getValue() != null) {
            pp.setObject("Supplier", this.prmtSupplier.getValue());
        } else {
            pp.setObject("Supplier", null);
        }
        if (this.txtTaxNumber.getText() != null && !this.txtTaxNumber.getText().isEmpty()) {
            pp.setObject("TaxNumber", (Object)this.txtTaxNumber.getText());
        } else {
            pp.setObject("TaxNumber", null);
        }
        if (this.txtInvoiceNumber.getText() != null && !this.txtInvoiceNumber.getText().isEmpty()) {
            pp.setObject("InvoiceNumber", (Object)this.txtInvoiceNumber.getText());
        } else {
            pp.setObject("InvoiceNumber", null);
        }
        if (this.txtProductName.getText() != null && !this.txtProductName.getText().isEmpty()) {
            pp.setObject("ProductName", (Object)this.txtProductName.getText());
        } else {
            pp.setObject("ProductName", null);
        }
        return pp;
    }

    public void setCustomCondition(RptParams params) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (params.getObject("Company") != null) {
            this.prmtCompany.setValue(params.getObject("Company"));
        }
        if (params.getObject("InvoiceType") != null) {
            this.comboInvoiceType.setSelectedItem((Object)PayInvoiceTypeEnum.getEnum((String)((String)params.getObject("InvoiceType"))));
        } else {
            this.comboInvoiceType.setSelectedItem((Object)PayInvoiceTypeEnum.DEFAULTTYPE);
        }
        try {
            if (params.getObject("InvoiceDateFrom") != null) {
                this.pkInvoiceDateFrom.setValue((Object)sdf.parse(params.getObject("InvoiceDateFrom").toString()));
            } else {
                this.pkInvoiceDateFrom.setValue(null);
            }
            if (params.getObject("InvoiceDateTo") != null) {
                this.pkInvoiceDateTo.setValue((Object)sdf.parse(params.getObject("InvoiceDateTo").toString()));
            } else {
                this.pkInvoiceDateTo.setValue(null);
            }
        }
        catch (ParseException e) {
            this.handUIException(e);
        }
        if (params.getObject("Supplier") != null) {
            this.prmtSupplier.setValue(params.getObject("Supplier"));
        } else {
            this.prmtSupplier.setValue(null);
        }
        if (params.getObject("TaxNumber") != null) {
            this.txtTaxNumber.setText(params.getObject("TaxNumber").toString());
        } else {
            this.txtTaxNumber.setText(null);
        }
        if (params.getObject("InvoiceNumber") != null) {
            this.txtInvoiceNumber.setText(params.getObject("InvoiceNumber").toString());
        } else {
            this.txtInvoiceNumber.setText(null);
        }
        if (params.getObject("ProductName") != null) {
            this.txtProductName.setText(params.getObject("ProductName").toString());
        } else {
            this.txtProductName.setText(null);
        }
    }

    private void initCompanyF7() {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, "ap_invoiceMatch_match");
        this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    public boolean verify() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateFrom = null;
        String dateTo = null;
        if (this.prmtCompany.getText().isEmpty()) {
            MsgBox.showInfo((String)EASResource.getString((String)MatchConstant.INVOICEMATCH_RESOURCE, (String)"Error_CompanyNotNull"));
            return false;
        }
        if (this.pkInvoiceDateFrom.getValue() != null) {
            dateFrom = sdf.format(this.pkInvoiceDateFrom.getValue());
        }
        if (this.pkInvoiceDateTo.getValue() != null) {
            dateTo = sdf.format(this.pkInvoiceDateTo.getValue());
        }
        if (dateFrom != null && dateTo != null && dateTo.compareTo(dateFrom) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)MatchConstant.INVOICEMATCH_RESOURCE, (String)"Error_BizDate"));
            return false;
        }
        return super.verify();
    }

    public void clear() {
        try {
            this.prmtCompany.setValue((Object)MatchUtils.getPermissionCompany("ap_invoiceMatch_match"));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        this.comboInvoiceType.setSelectedItem(null);
        this.pkInvoiceDateFrom.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        this.pkInvoiceDateTo.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        this.prmtSupplier.setValue(null);
        this.txtTaxNumber.setText(null);
        this.txtInvoiceNumber.setText(null);
        this.txtProductName.setText(null);
        super.clear();
    }
}

