/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.invoiceMatch.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.client.ArApCommonQueryProcessor;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.IInvoiceMatchRecord;
import com.kingdee.eas.fi.arap.invoiceMatch.InvoiceMatchRecordFactory;
import com.kingdee.eas.fi.arap.invoiceMatch.client.AbstractInvoiceMatchRecordListUI;
import com.kingdee.eas.fi.arap.invoiceMatch.client.IMRecordConditionUI;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchConstant;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchUtils;
import com.kingdee.eas.fi.arap.util.invoice.IncomeInvoiceClientUtils;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.query.QuickFilteringSupportItems;
import com.kingdee.eas.framework.util.BizOrgEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class InvoiceMatchRecordListUI
extends AbstractInvoiceMatchRecordListUI {
    private static final Logger logger = CoreUIObject.getLogger(InvoiceMatchRecordListUI.class);
    private CommonQueryDialog commonQueryDialog = null;
    private IMRecordConditionUI filterUI = null;
    protected ArApSysParamInfo cache = null;
    private static final String NUMFORMAT = "###,##0.##########";
    private QuickFilteringSupportItems qfsi = new QuickFilteringSupportItems(true, true);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemAddNew.setVisible(false);
        this.menuEdit.setVisible(false);
        this.menuItemPrint.setVisible(false);
        this.menuItemPrintPreview.setVisible(false);
        this.menuItemView.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnEdit.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnView.setVisible(false);
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionAntiMatch_actionPerformed(ActionEvent e) throws Exception {
        if (!IncomeInvoiceClientUtils.isSupport()) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ARAPAutoGenerateResource", (String)"LackTaxSupport"));
            this.abort();
        }
        this.checkSelected();
        ArrayList ids = this.getSelectedIdValues();
        try {
            MatchUtils.tryLock(ids);
            if (MsgBox.isYes((int)MsgBox.showConfirm2((String)EASResource.getString((String)MatchConstant.INVOICEMATCH_RESOURCE, (String)"Msg_ComfirmAntiMatch")))) {
                Map ret = InvoiceMatchRecordFactory.getRemoteInstance().antiMatch(ids);
                int successed = (Integer)ret.get("successed");
                int failed = (Integer)ret.get("failed");
                String msg = EASResource.getString((String)MatchConstant.INVOICEMATCH_RESOURCE, (String)"Msg_AntiMatchResult", (Object[])new Object[]{successed, failed});
                if (failed > 0) {
                    MsgBox.showDetailAndOK(null, (String)msg, (String)ret.get("errMsg").toString(), (int)1);
                } else {
                    MsgBox.showInfo((String)msg);
                }
            } else {
                return;
            }
            this.refreshList();
        }
        finally {
            MatchUtils.releaseLock(ids);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InvoiceMatchRecordFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.setDefaultQuickFilterInfo();
        this.tblMain.checkParsed();
        this.initTable();
        this.setMergeColumn();
        super.onLoad();
    }

    private void initTable() {
        this.tblMain.getColumn("entry.matchedQty").getStyleAttributes().setNumberFormat(NUMFORMAT);
        this.tblMain.getColumn("entry.matchedAmt").getStyleAttributes().setNumberFormat(NUMFORMAT);
    }

    private void setMergeColumn() {
        String[] mergeColumnKeys = this.getMergeColumnKeys();
        if (mergeColumnKeys != null && mergeColumnKeys.length > 0) {
            this.tblMain.getGroupManager().setGroup(true);
            IColumn col = null;
            for (int i = 0; i < mergeColumnKeys.length; ++i) {
                col = this.tblMain.getColumn(mergeColumnKeys[i]);
                if (col != null) {
                    col.setGroup(true);
                    col.setMergeable(true);
                    continue;
                }
                logger.info((Object)("mergeColumn no found:" + mergeColumnKeys[i]));
            }
        }
    }

    protected String[] getMergeColumnKeys() {
        String[] columns = new String[]{"id", "number", "bizDate", "company.number", "company.name", "supplier.number", "supplier.name", "supplier.taxRegisterNo", "isCompletely", "srcSystem", "entry.stepSeq", "destBillNumber", "recordMatchType"};
        return columns;
    }

    protected boolean isOrderByIDForBill() {
        return false;
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected boolean isFootVisible() {
        return false;
    }

    protected QuickFilteringSupportItems getQuickFilteringSupport() {
        this.qfsi.supportExecutionWithoutFilters();
        try {
            CompanyOrgUnitInfo company = MatchUtils.getPermissionCompany("ap_invoiceMatchRecord_view");
            return this.qfsi.supportSingleMainOrg((OrgUnitInfo)company);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
            return this.qfsi;
        }
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.commonQueryDialog == null) {
            if (this.mainQuery == null) {
                this.mainQuery = new EntityViewInfo();
            }
            this.commonQueryDialog = super.initCommonQueryDialog();
            if (this.getUIContext().get("OwnerWindow") == null) {
                this.commonQueryDialog.setOwner((Component)((Object)this));
            }
            try {
                this.commonQueryDialog.setProcessor((IProcessor)new ArApCommonQueryProcessor());
                this.commonQueryDialog.addUserPanel((KDPanel)this.getFilterUI());
            }
            catch (Exception e) {
                this.handUIException(e);
                SysUtil.abort();
            }
            this.commonQueryDialog.setWidth(510);
            this.commonQueryDialog.setHeight(300);
        }
        return this.commonQueryDialog;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return this.getHasPermissionOrgFilterForQuery();
    }

    public FilterInfo getHasPermissionOrgFilterForQuery() {
        OrgUnitCollection authorizedMainOrgs = null;
        FilterInfo filterInfo = new FilterInfo();
        try {
            if (authorizedMainOrgs == null) {
                IInvoiceMatchRecord iBiz = (IInvoiceMatchRecord)this.getBizInterface();
                authorizedMainOrgs = iBiz.getAuthOrgsByType(this.getMainBizOrgType(), "ap_invoiceMatchRecord_view");
            }
            HashSet<String> keys = new HashSet<String>();
            String propertyOfBizOrg = this.getPropertyOfBizOrg(this.getMainBizOrgType());
            if (authorizedMainOrgs != null && authorizedMainOrgs.size() > 0) {
                for (int i = 0; i < authorizedMainOrgs.size(); ++i) {
                    keys.add(authorizedMainOrgs.get(i).getId().toString());
                }
                filterInfo.getFilterItems().add(new FilterItemInfo(propertyOfBizOrg, keys, CompareType.INCLUDE));
                return filterInfo;
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return filterInfo;
    }

    protected String getPropertyOfBizOrg(OrgType orgType) {
        return "company.id";
    }

    protected void setDefaultQuickFilterInfo() throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = MatchUtils.getPermissionCompany("ap_invoiceMatchRecord_view");
        QuickFilteringSupportItems qfsi = this.getQuickFilteringSupport();
        if (qfsi != null) {
            if (company != null) {
                qfsi.getSystemSolutionItem().getDefaultFilter().add("company.id", CompareType.EQUALS, (Object)company.getId().toString());
            } else {
                qfsi.getSystemSolutionItem().getDefaultFilter().add("company.id", CompareType.EQUALS, (Object)BizOrgEnum.DEFAULTMAINORG);
            }
            qfsi.getSystemSolutionItem().getDefaultFilter().add("bizDate", CompareType.GREATER_EQUALS, (Object)SCMUtils.getSCMQueryTime((Date)new Date(), (String)"startDate")).add("bizDate", CompareType.LESS_EQUALS, (Object)SCMUtils.getSCMQueryTime((Date)new Date(), (String)"endDate"));
        }
    }

    private CustomerQueryPanel getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new IMRecordConditionUI();
        }
        return this.filterUI;
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }
}

