/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.invoiceMatch.client;

import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.fi.arap.invoiceMatch.client.AbstractPurOrderConditionUI;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchConstant;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchUtils;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.apache.log4j.Logger;

public class PurOrderConditionUI
extends AbstractPurOrderConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(PurOrderConditionUI.class);

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onInit(RptParams initParams) throws Exception {
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initCompanyF7();
        this.prmtCompany.setValue((Object)MatchUtils.getPermissionCompany("ap_invoiceMatch_match"));
        this.prmtCompany.setEnabledMultiSelection(true);
        this.prmtSupplier.setEnabledMultiSelection(true);
        this.prmtMaterial.setEnabledMultiSelection(true);
    }

    public RptParams getCustomCondition() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        RptParams pp = new RptParams();
        if (this.prmtCompany.getValue() != null) {
            pp.setObject("Company", this.prmtCompany.getValue());
        }
        if (this.pkBizDateFrom.getValue() != null) {
            pp.setObject("BizDateFrom", (Object)sdf.format(this.pkBizDateFrom.getValue()));
        } else {
            pp.setObject("BizDateFrom", null);
        }
        if (this.pkBizDateTo.getValue() != null) {
            pp.setObject("BizDateTo", (Object)sdf.format(this.pkBizDateTo.getValue()));
        } else {
            pp.setObject("BizDateTo", null);
        }
        if (this.prmtSupplier.getValue() != null) {
            pp.setObject("Supplier", this.prmtSupplier.getValue());
        } else {
            pp.setObject("Supplier", null);
        }
        if (this.prmtMaterial.getValue() != null) {
            pp.setObject("Material", this.prmtMaterial.getValue());
        } else {
            pp.setObject("Material", null);
        }
        if (this.txtNumber.getText() != null && !this.txtNumber.getText().isEmpty()) {
            pp.setObject("number", (Object)this.txtNumber.getText());
        } else {
            pp.setObject("number", null);
        }
        return pp;
    }

    public void setCustomCondition(RptParams params) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (params.getObject("Company") != null) {
            this.prmtCompany.setValue(params.getObject("Company"));
        }
        try {
            if (params.getObject("BizDateFrom") != null) {
                this.pkBizDateFrom.setValue((Object)sdf.parse(params.getObject("BizDateFrom").toString()));
            } else {
                this.pkBizDateFrom.setValue(null);
            }
            if (params.getObject("BizDateTo") != null) {
                this.pkBizDateTo.setValue((Object)sdf.parse(params.getObject("BizDateTo").toString()));
            } else {
                this.pkBizDateTo.setValue(null);
            }
        }
        catch (ParseException e) {
            this.handUIException(e);
        }
        if (params.getObject("Supplier") != null) {
            this.prmtSupplier.setValue(params.getObject("Supplier"));
        } else {
            this.prmtSupplier.setValue(null);
        }
        if (params.getObject("Material") != null) {
            this.prmtMaterial.setValue(params.getObject("Material"));
        } else {
            this.prmtMaterial.setValue(null);
        }
        if (params.getObject("number") != null) {
            this.txtNumber.setText(params.getObject("number").toString());
        } else {
            this.txtNumber.setText(null);
        }
    }

    private void initCompanyF7() {
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, "ap_invoiceMatch_match");
        this.prmtCompany.setFilterInfoProducer((IFilterInfoProducer)iProducer);
    }

    public boolean verify() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateFrom = null;
        String dateTo = null;
        if (this.prmtCompany.getText().isEmpty()) {
            MsgBox.showInfo((String)EASResource.getString((String)MatchConstant.INVOICEMATCH_RESOURCE, (String)"Error_CompanyNotNull"));
            return false;
        }
        if (this.pkBizDateFrom.getValue() != null) {
            dateFrom = sdf.format(this.pkBizDateFrom.getValue());
        }
        if (this.pkBizDateTo.getValue() != null) {
            dateTo = sdf.format(this.pkBizDateTo.getValue());
        }
        if (dateFrom != null && dateTo != null && dateTo.compareTo(dateFrom) < 0) {
            MsgBox.showInfo((String)EASResource.getString((String)MatchConstant.INVOICEMATCH_RESOURCE, (String)"Error_BizDate"));
            return false;
        }
        return super.verify();
    }

    public void clear() {
        try {
            this.prmtCompany.setValue((Object)MatchUtils.getPermissionCompany("ap_invoiceMatch_match"));
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        this.prmtSupplier.setValue(null);
        this.prmtMaterial.setValue(null);
        this.pkBizDateTo.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"endDate"));
        this.pkBizDateFrom.setValue((Object)SCMUtils.getSCMQueryTime(null, (String)"startDate"));
        this.txtNumber.setText(null);
        super.clear();
    }
}

