/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.invoiceMatch.config;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.fi.arap.invoiceMatch.config.AbstractConfigHelper;
import com.kingdee.eas.fi.arap.invoiceMatch.util.HeaderInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchConstant;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchUtils;
import com.kingdee.eas.fi.arap.util.invoice.InvoiceUtils;
import java.util.Locale;

public class IncomeInvoiceConfigHelper
extends AbstractConfigHelper {
    public IncomeInvoiceConfigHelper() {
    }

    public IncomeInvoiceConfigHelper(Locale locale) {
        super(locale);
    }

    @Override
    protected void initFields() {
        this.fields.add(new HeaderInfo(MatchConstant.TB_FSELECTED, "int", this.getResource("TB_FSelected"), false, 40, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FCOMPANYNAME, "nvarchar(80)", this.getResource("TB_FCompanyName"), false, 100, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FCOMPANYID, "varchar(44)", "FCompanyID", true, -1, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FSUPPLIERNAME, "nvarchar(200)", this.getResource("TB_FSupplierName"), false, 100, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FSUPPLIERID, "varchar(44)", "FSupplierID", true, -1, null, 0));
        this.fields.add(new HeaderInfo("FBillingCompany", "nvarchar(255)", this.getResource("TB_FBillingCompany"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FInvoiceCode", "nvarchar(80)", this.getResource("TB_FInvoiceCode"), true, 100, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FNUMBER, "nvarchar(80)", this.getResource("TB_FInvoiceNumber"), false, 100, null, 0));
        this.fields.add(new HeaderInfo("FBizDate", "DateTime", this.getResource("TB_FInvoiceDate"), false, 100, "yyyy-MM-dd", 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FNAME, "nvarchar(80)", this.getResource("TB_FProductName"), false, 100, null, 0));
        this.fields.add(new HeaderInfo("FSpecs", "nvarchar(255)", this.getResource("TB_FModel"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FUnit", "nvarchar(255)", this.getResource("TB_FUnitName"), true, 100, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FQTY, "Decimal(28,10)", this.getResource("TB_FQty"), false, 100, null, 2));
        this.fields.add(new HeaderInfo("FTaxExcluded", "Decimal(28,10)", this.getResource("TB_FTaxExcluded"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FTaxPrice", "Decimal(28,10)", this.getResource("TB_FTaxPrice"), false, 100, null, 2));
        this.fields.add(new HeaderInfo("FMoney", "Decimal(28,10)", this.getResource("TB_FMoney"), false, 100, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FTaxRate, "Decimal(28,10)", this.getResource("TB_FTaxRate"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FTaxAmt", "Decimal(28,10)", this.getResource("TB_FTaxAmt"), false, 100, null, 2));
        this.fields.add(new HeaderInfo("FTaxTotal", "Decimal(28,10)", this.getResource("TB_FTaxAmount"), false, 100, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FUNMATCHEDQTY, "Decimal(28,10)", this.getResource("TB_FUnMatchedQty"), false, 100, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FUNMATCHEDAMT, "Decimal(28,10)", this.getResource("TB_FUnMatchedAmt"), false, 100, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FQTYTOMATCH, "Decimal(28,10)", this.getResource("TB_FQtyToMatch"), false, 120, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FAMTTOMATCH, "Decimal(28,10)", this.getResource("TB_FAmtToMatch"), false, 120, null, 2));
        this.fields.add(new HeaderInfo("FDescription", "nvarchar(300)", this.getResource("TB_FRemark"), false, 100, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FBILLID, "varchar(44)", "FBillID", true, -1, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FBILLENTRYID, "varchar(44)", "FBillEntryID", true, -1, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FENTRYSEQ, "int", "FEntrySeq", true, -1, null, 0));
    }

    @Override
    public String[] getSumFields() {
        String[] sumFields = new String[]{MatchConstant.TB_FQTYTOMATCH, MatchConstant.TB_FAMTTOMATCH};
        return sumFields;
    }

    @Override
    public IMetaDataPK getQueryMetaDataPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.tm.im.app.IncomeInvoiceQuery");
    }

    @Override
    public String initTableDataSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ");
        sql.append(this.tempTable);
        sql.append(this.getIncomeInvoiceDataSql());
        Class fullElectricInvoiceInfoClass = InvoiceUtils.getClass("com.kingdee.eas.tm.common.invoicePool.FullElectricInvoiceInfo");
        if (fullElectricInvoiceInfoClass != null) {
            sql.append(" union all ").append('\n');
            sql.append(this.getFullElectricInvoiceDataSql());
        }
        return sql.toString();
    }

    public String getIncomeInvoiceDataSql() {
        Object[] supplierIds;
        StringBuffer sql = new StringBuffer();
        sql.append(" Select ");
        sql.append(" company.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" company.FID, ").append('\n');
        sql.append(" supplier.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" supplier.FID, ").append('\n');
        sql.append(" to_char(parent.FBillingCompany), ").append('\n');
        sql.append(" to_char(parent.FInvoiceCode), ").append('\n');
        sql.append(" to_char(parent.FInvoiceNumber), ").append('\n');
        sql.append(" parent.FBizDate, ").append('\n');
        sql.append(" to_char(entry.FProductName), ").append('\n');
        sql.append(" to_char(entry.FSpecs), ").append('\n');
        sql.append(" to_char(entry.FUnitName), ").append('\n');
        sql.append(" entry.FQuantity, ").append('\n');
        sql.append(" entry.FTaxExcluded, ").append('\n');
        sql.append(" to_char(entry.FTaxPrice), ").append('\n');
        sql.append(" entry.FMoney, ").append('\n');
        sql.append(" entry.FTaxRate * 100, ").append('\n');
        sql.append(" entry.FTaxAmt, ").append('\n');
        sql.append(" entry.FTaxTotal, ").append('\n');
        sql.append(" entry.FQuantity, ").append('\n');
        sql.append(" entry.FTaxTotal, ").append('\n');
        sql.append(" entry.FQuantity, ").append('\n');
        sql.append(" entry.FTaxTotal, ").append('\n');
        sql.append(" to_char(parent.FDescription), ").append('\n');
        sql.append(" parent.FID, ").append('\n');
        sql.append(" entry.FID, ").append('\n');
        sql.append(" entry.FSeq ").append('\n');
        sql.append(" From T_IM_IncomeInvoice parent ").append('\n');
        sql.append(" Left Join T_IM_IncomeInvoiceEntry entry on parent.FID = entry.FIncomeInvoiceID ").append('\n');
        sql.append(" Inner Join T_BD_Supplier supplier on supplier.FID = parent.FCurrAcctSupplierID ").append('\n');
        sql.append(" Left Join T_ORG_Company company on company.FID = parent.FCompanyID ").append('\n');
        sql.append(" where parent.FStatus in ('0', '4') ").append('\n');
        if (this.otherParams.containsKey(MatchConstant.BIZDESTBOSTYPE) && MatchConstant.BOSTYPE_PAYREQUESTBILL.equals(this.otherParams.get(MatchConstant.BIZDESTBOSTYPE))) {
            sql.append(" and parent.FBizBIllTypeID is null ").append('\n');
        } else {
            sql.append(" and (parent.FBizBIllTypeID is null or parent.FBizBIllTypeID = '").append(MatchConstant.TYPEID_PAYREQUESTBILL).append("')").append('\n');
        }
        sql.append(" and parent.FIsAccept = '1' ").append('\n');
        Object[] companyIds = MatchUtils.getIdArray(this.condition.getObject("Company"));
        if (companyIds != null) {
            sql.append(" and ").append(MatchUtils.buildIn("company.fid", companyIds)).append('\n');
        }
        if (this.condition.getObject("InvoiceType") != null && !"-1".equals(this.condition.getObject("InvoiceType").toString())) {
            sql.append(" and parent.FInvoiceType = '").append(this.condition.getObject("InvoiceType").toString()).append("' ").append('\n');
        }
        if (this.condition.getObject("InvoiceDateFrom") != null) {
            sql.append(" and parent.FBIZDATE >= {ts'").append(this.condition.getObject("InvoiceDateFrom").toString()).append(" 00:00:00'} ").append('\n');
        }
        if (this.condition.getObject("InvoiceDateTo") != null) {
            sql.append(" and parent.FBIZDATE <= {ts'").append(this.condition.getObject("InvoiceDateTo").toString()).append(" 23:59:59'} ").append('\n');
        }
        if ((supplierIds = MatchUtils.getIdArray(this.condition.getObject("Supplier"))) != null) {
            sql.append(" and ").append(MatchUtils.buildIn("supplier.fid", supplierIds)).append('\n');
        }
        if (this.condition.getObject("TaxNumber") != null) {
            sql.append(" and ").append(MatchUtils.buildLike("parent.FTaxNumber", this.condition.getObject("TaxNumber").toString())).append('\n');
        }
        if (this.condition.getObject("InvoiceNumber") != null) {
            sql.append(" and ").append(MatchUtils.buildLike("parent.FInvoiceNumber", this.condition.getObject("InvoiceNumber").toString())).append('\n');
        }
        if (this.condition.getObject("ProductName") != null) {
            sql.append(" and ").append(MatchUtils.buildLike("entry.FProductName", this.condition.getObject("ProductName").toString())).append('\n');
        }
        return sql.toString();
    }

    public String getFullElectricInvoiceDataSql() {
        Object[] supplierIds;
        StringBuffer sql = new StringBuffer();
        sql.append(" Select ");
        sql.append(" company.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" company.FID, ").append('\n');
        sql.append(" supplier.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" supplier.FID, ").append('\n');
        sql.append(" to_char(parent.FSalerName), ").append('\n');
        sql.append(" to_char(parent.FInvoiceCode), ").append('\n');
        sql.append(" to_char(parent.FInvoiceNo), ").append('\n');
        sql.append(" parent.FINVOICEDATE, ").append('\n');
        sql.append(" to_char(entry.FGoodsName), ").append('\n');
        sql.append(" to_char(entry.FSpecModel), ").append('\n');
        sql.append(" to_char(entry.FUnit), ").append('\n');
        sql.append(" entry.FNum, ").append('\n');
        sql.append(" entry.FUnitPrice, ").append('\n');
        sql.append(" to_char(''), ").append('\n');
        sql.append(" entry.FDetailAmount, ").append('\n');
        sql.append(" entry.FTaxRate * 100, ").append('\n');
        sql.append(" entry.FTaxAmount, ").append('\n');
        sql.append(" entry.FAmount, ").append('\n');
        sql.append(" entry.FNum, ").append('\n');
        sql.append(" entry.FAmount, ").append('\n');
        sql.append(" entry.FNum, ").append('\n');
        sql.append(" entry.FAmount, ").append('\n');
        sql.append(" to_char(parent.FDescription), ").append('\n');
        sql.append(" parent.FID, ").append('\n');
        sql.append(" entry.FID, ").append('\n');
        sql.append(" entry.FSeq ").append('\n');
        sql.append(" From T_TM_FullElectricInvoice parent ").append('\n');
        sql.append(" Left Join T_TM_FullElectricInvoiceEntry entry on parent.FID = entry.FParentID ").append('\n');
        sql.append(" Inner Join T_BD_Supplier supplier on supplier.FID = parent.FCurrAcctSupplierID ").append('\n');
        sql.append(" Left Join T_ORG_Company company on company.FID = parent.FCompanyID ").append('\n');
        sql.append(" where parent.FInvoiceStatus in ('0', '3') ").append('\n');
        if (this.otherParams.containsKey(MatchConstant.BIZDESTBOSTYPE) && MatchConstant.BOSTYPE_PAYREQUESTBILL.equals(this.otherParams.get(MatchConstant.BIZDESTBOSTYPE))) {
            sql.append(" and parent.FBizBIllTypeID is null ").append('\n');
        } else {
            sql.append(" and (parent.FBizBIllTypeID is null or parent.FBizBIllTypeID = '").append(MatchConstant.TYPEID_PAYREQUESTBILL).append("')").append('\n');
        }
        sql.append(" and parent.FIsAccept = '1' ").append('\n');
        Object[] companyIds = MatchUtils.getIdArray(this.condition.getObject("Company"));
        if (companyIds != null) {
            sql.append(" and ").append(MatchUtils.buildIn("company.fid", companyIds)).append('\n');
        }
        if (this.condition.getObject("InvoiceType") != null && !"-1".equals(this.condition.getObject("InvoiceType").toString())) {
            String invoiceType = MatchUtils.convertPayInvoiceTypeEnumToTMInvoiceType(this.condition.getObject("InvoiceType").toString());
            sql.append(" and parent.FInvoiceType = '").append(invoiceType).append("' ").append('\n');
        }
        if (this.condition.getObject("InvoiceDateFrom") != null) {
            sql.append(" and parent.FINVOICEDATE >= {ts'").append(this.condition.getObject("InvoiceDateFrom").toString()).append(" 00:00:00'} ").append('\n');
        }
        if (this.condition.getObject("InvoiceDateTo") != null) {
            sql.append(" and parent.FINVOICEDATE <= {ts'").append(this.condition.getObject("InvoiceDateTo").toString()).append(" 23:59:59'} ").append('\n');
        }
        if ((supplierIds = MatchUtils.getIdArray(this.condition.getObject("Supplier"))) != null) {
            sql.append(" and ").append(MatchUtils.buildIn("supplier.fid", supplierIds)).append('\n');
        }
        if (this.condition.getObject("TaxNumber") != null) {
            sql.append(" and ").append(MatchUtils.buildLike("parent.FsalerTaxNo", this.condition.getObject("TaxNumber").toString())).append('\n');
        }
        if (this.condition.getObject("InvoiceNumber") != null) {
            sql.append(" and ").append(MatchUtils.buildLike("parent.FInvoiceNo", this.condition.getObject("InvoiceNumber").toString())).append('\n');
        }
        if (this.condition.getObject("ProductName") != null) {
            sql.append(" and ").append(MatchUtils.buildLike("entry.FgoodsName", this.condition.getObject("ProductName").toString())).append('\n');
        }
        return sql.toString();
    }

    @Override
    public String getOrderBySql() {
        return " order by FCompanyID, FSupplierID, FBizDate DESC, FInvoiceCode, FNumber, FEntrySeq ";
    }

    @Override
    public String getCustomerPanel() {
        return "com.kingdee.eas.fi.arap.invoiceMatch.client.IncomeInvoiceConditionUI";
    }

    @Override
    public String[] getEntrieNames() {
        return null;
    }
}

