/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.invoiceMatch.config;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.fi.arap.invoiceMatch.config.AbstractConfigHelper;
import com.kingdee.eas.fi.arap.invoiceMatch.util.HeaderInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchConstant;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchUtils;
import java.util.Locale;

public class PurInWarehs2APConfigHelper
extends AbstractConfigHelper {
    public PurInWarehs2APConfigHelper() {
    }

    public PurInWarehs2APConfigHelper(Locale locale) {
        super(locale);
    }

    @Override
    protected void initFields() {
        this.fields.add(new HeaderInfo(MatchConstant.TB_FSELECTED, "int", this.getResource("TB_FSelected"), false, 40, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FCOMPANYNAME, "nvarchar(80)", this.getResource("TB_FCompanyName"), false, 100, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FCOMPANYID, "varchar(44)", "FCompanyID", true, -1, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FSUPPLIERNAME, "nvarchar(255)", this.getResource("TB_FSupplierName"), false, 100, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FSUPPLIERID, "varchar(44)", "FSupplierID", true, -1, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FNUMBER, "nvarchar(80)", this.getResource("TB_FBillNumber"), false, 100, null, 0));
        this.fields.add(new HeaderInfo("FBizDate", "DateTime", this.getResource("TB_FBizDate"), false, 100, "yyyy-MM-dd", 0));
        this.fields.add(new HeaderInfo("FCoreNumber", "nvarchar(80)", this.getResource("TB_FCoreNumber"), false, 100, null, 0));
        this.fields.add(new HeaderInfo("FCoreEntrySeq", "int", this.getResource("TB_FCoreEntrySeq"), false, 100, null, 0));
        this.fields.add(new HeaderInfo("FMaterialNumber", "nvarchar(80)", this.getResource("TB_FMaterialNumber"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FName", "nvarchar(255)", this.getResource("TB_MaterialName"), false, 100, null, 0));
        this.fields.add(new HeaderInfo("FModel", "nvarchar(255)", this.getResource("TB_FModel"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FUnit", "nvarchar(255)", this.getResource("TB_FUnit"), true, 100, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FQTY, "Decimal(28,10)", this.getResource("TB_FQty"), false, 100, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FTaxRate, "Decimal(28,10)", this.getResource("TB_FTaxRate"), true, 100, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FTaxPrice, "Decimal(28,10)", this.getResource("TB_FTaxPrice"), false, 100, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FTaxAmount, "Decimal(28,10)", this.getResource("TB_FTaxAmount"), false, 100, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FUNMATCHEDQTY, "Decimal(28,10)", this.getResource("TB_FUnMatchedQty"), false, 100, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FUNMATCHEDAMT, "Decimal(28,10)", this.getResource("TB_FUnMatchedAmt"), true, -1, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FQTYTOMATCH, "Decimal(28,10)", this.getResource("TB_FQtyToMatch"), false, 120, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FAMTTOMATCH, "Decimal(28,10)", this.getResource("TB_FAmtToMatch"), false, 120, null, 2));
        this.fields.add(new HeaderInfo("FDescription", "nvarchar(300)", this.getResource("TB_FDescription"), false, 100, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FBILLID, "varchar(44)", "FBillID", true, -1, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FBILLENTRYID, "varchar(44)", "FBillEntryID", true, -1, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FENTRYSEQ, "int", "FEntrySeq", true, -1, null, 0));
        this.fields.add(new HeaderInfo("FInvUpdateTypeID", "nvarchar(255)", this.getResource("FInvUpdateTypeID"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FLot", "nvarchar(80)", this.getResource("FLot"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FMfg", "DateTime", this.getResource("FMfg"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FExp", "DateTime", this.getResource("FExp"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FCostCenterOrgUnit", "nvarchar(255)", this.getResource("FCostCenterOrgUnit"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FAssistProperty", "nvarchar(255)", this.getResource("FAssistProperty"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FWarehouse", "nvarchar(255)", this.getResource("FWarehouse"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FLocation", "nvarchar(255)", this.getResource("FLocation"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FSupplierLotNo", "nvarchar(255)", this.getResource("FSupplierLotNo"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FBaseUnit", "nvarchar(255)", this.getResource("FBaseUnit"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FBaseQty", "Decimal(28,10)", this.getResource("FBaseQty"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FAssistUnit", "nvarchar(255)", this.getResource("FAssistUnit"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FAssistQty", "Decimal(28,10)", this.getResource("FAssistQty"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FStocker", "nvarchar(255)", this.getResource("FStocker"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FCustomer", "nvarchar(255)", this.getResource("FCustomer"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FIsPresent", "int", this.getResource("FIsPresent"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FUnitStandardCost", "Decimal(28,10)", this.getResource("FUnitStandardCost"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FStandardCost", "Decimal(28,10)", this.getResource("FStandardCost"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FUnitPurchaseCost", "Decimal(28,10)", this.getResource("FUnitPurchaseCost"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FPurchaseCost", "Decimal(28,10)", this.getResource("FPurchaseCost"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FPurchaseFee", "Decimal(28,10)", this.getResource("FPurchaseFee"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FUnitActualCost", "Decimal(28,10)", this.getResource("FUnitActualCost"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FActualCost", "Decimal(28,10)", this.getResource("FActualCost"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FImputedCost", "Decimal(28,10)", this.getResource("FImputedCost"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FPrice", "Decimal(28,10)", this.getResource("FPrice"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FDiscountRate", "Decimal(28,10)", this.getResource("FDiscountRate"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FActualPrice", "Decimal(28,10)", this.getResource("FActualPrice"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FActualTaxPrice", "Decimal(28,10)", this.getResource("FActualTaxPrice"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FDiscountAmount", "Decimal(28,10)", this.getResource("FDiscountAmount"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FAmount", "Decimal(28,10)", this.getResource("FAmount"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FTax", "Decimal(28,10)", this.getResource("FTax"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FLocalTax", "Decimal(28,10)", this.getResource("FLocalTax"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FLocalTaxAmount", "Decimal(28,10)", this.getResource("FLocalTaxAmount"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FIsFullWriteOff", "int", this.getResource("FIsFullWriteOff"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FWrittenOffQty", "Decimal(28,10)", this.getResource("FWrittenOffQty"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FWrittenOffAmount", "Decimal(28,10)", this.getResource("FWrittenOffAmount"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FUnWriteOffQty", "Decimal(28,10)", this.getResource("FUnWriteOffQty"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FUnWriteOffAmount", "Decimal(28,10)", this.getResource("FUnWriteOffAmount"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FReverseQty", "Decimal(28,10)", this.getResource("FReverseQty"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FReturnsQty", "Decimal(28,10)", this.getResource("FReturnsQty"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FDrewQty", "Decimal(28,10)", this.getResource("FDrewQty"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FCoreBillType", "nvarchar(255)", this.getResource("FCoreBillType"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FPurOrderNumber", "nvarchar(255)", this.getResource("FPurOrderNumber"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FPurOrderEntrySeq", "nvarchar(255)", this.getResource("FPurOrderEntrySeq"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FProject", "nvarchar(255)", this.getResource("FProject"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FTrackNumber", "nvarchar(255)", this.getResource("FTrackNumber"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FContractNumber", "nvarchar(255)", this.getResource("FContractNumber"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FPurchaseOrgUnit", "nvarchar(255)", this.getResource("FPurchaseOrgUnit"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FPurchasePerson", "nvarchar(255)", this.getResource("FPurchasePerson"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FBalanceSupplier", "nvarchar(255)", this.getResource("FBalanceSupplier"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FRemark", "nvarchar(255)", this.getResource("FRemark"), true, 100, null, 0));
    }

    @Override
    public String[] getSumFields() {
        String[] sumFields = new String[]{MatchConstant.TB_FQTYTOMATCH, MatchConstant.TB_FAMTTOMATCH};
        return sumFields;
    }

    @Override
    public IMetaDataPK getQueryMetaDataPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.scm.im.inv.PurInWarehsQuery");
    }

    @Override
    public String initTableDataSql() {
        Object[] matIds;
        Object[] supplierIds;
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ");
        sql.append(this.tempTable);
        sql.append(" Select ").append('\n');
        sql.append(" company.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" company.FID, ").append('\n');
        sql.append(" supplier.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" supplier.FID, ").append('\n');
        sql.append(" parent.FNumber, ").append('\n');
        sql.append(" parent.FBizDate, ").append('\n');
        sql.append(" entry.FPurOrderNumber, ").append('\n');
        sql.append(" entry.FPurOrderEntrySeq, ").append('\n');
        sql.append(" material.FNumber, ").append('\n');
        sql.append(" material.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" material.FModel, ").append('\n');
        sql.append(" unit.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" entry.FQty, ").append('\n');
        sql.append(" entry.FTaxRate, ").append("\n");
        sql.append(" entry.FTaxPrice, ").append('\n');
        sql.append(" entry.FTaxAmount, ").append('\n');
        sql.append(" entry.FQty, ").append('\n');
        sql.append(" entry.FTaxAmount, ").append('\n');
        sql.append(" entry.FQty, ").append('\n');
        sql.append(" entry.FTaxAmount, ").append('\n');
        sql.append(" parent.FDescription, ").append('\n');
        sql.append(" parent.FID, ").append('\n');
        sql.append(" entry.FID, ").append('\n');
        sql.append(" entry.FSeq, ").append('\n');
        sql.append(" updateType.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" entry.FLot, ").append('\n');
        sql.append(" entry.FMfg, ").append('\n');
        sql.append(" entry.FExp, ").append('\n');
        sql.append(" costCenterOrgUnit.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" assistProperty.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" warehouse.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" location.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" entry.FSupplierLotNo, ").append('\n');
        sql.append(" baseUnit.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" entry.FBaseQty, ").append('\n');
        sql.append(" assistUnit.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" entry.FAssistQty, ").append('\n');
        sql.append(" stocker.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" customer.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" entry.FIsPresent, ").append('\n');
        sql.append(" entry.FUnitStandardCost, ").append('\n');
        sql.append(" entry.FStandardCost, ").append('\n');
        sql.append(" entry.FUnitPurchaseCost, ").append('\n');
        sql.append(" entry.FPurchaseCost, ").append('\n');
        sql.append(" entry.FPurchaseFee, ").append('\n');
        sql.append(" entry.FUnitActualCost, ").append('\n');
        sql.append(" entry.FActualCost, ").append('\n');
        sql.append(" entry.FImputedCost, ").append('\n');
        sql.append(" entry.FPrice, ").append('\n');
        sql.append(" entry.FDiscountRate, ").append('\n');
        sql.append(" entry.FActualPrice, ").append('\n');
        sql.append(" entry.FActualTaxPrice, ").append('\n');
        sql.append(" entry.FDiscountAmount, ").append('\n');
        sql.append(" entry.FAmount, ").append('\n');
        sql.append(" entry.FTax, ").append('\n');
        sql.append(" entry.FLocalTax, ").append('\n');
        sql.append(" entry.FLocalTaxAmount, ").append('\n');
        sql.append(" entry.FIsFullWriteOff, ").append('\n');
        sql.append(" entry.FWrittenOffQty, ").append('\n');
        sql.append(" entry.FWrittenOffAmount, ").append('\n');
        sql.append(" entry.FUnWriteOffQty, ").append('\n');
        sql.append(" entry.FUnWriteOffAmount, ").append('\n');
        sql.append(" entry.FReverseQty, ").append('\n');
        sql.append(" entry.FReturnsQty, ").append('\n');
        sql.append(" entry.FDrewQty, ").append('\n');
        sql.append(" coreBillType.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" entry.FPurOrderNumber, ").append('\n');
        sql.append(" entry.FPurOrderEntrySeq, ").append('\n');
        sql.append(" project.FNumber, ").append('\n');
        sql.append(" trackNumber.FNumber, ").append('\n');
        sql.append(" entry.FContractNumber, ").append('\n');
        sql.append(" purchaseOrgUnit.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" purchasePerson.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" balanceSupplier.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" entry.FRemark ");
        sql.append(" From T_IM_PurInWarehsBill parent ").append('\n');
        sql.append(" Left Join T_IM_PurInWarehsEntry entry on parent.FID = entry.FParentID ").append('\n');
        sql.append(" Left Join T_BD_Supplier supplier on supplier.FID = parent.FSupplierID ").append('\n');
        sql.append(" Left Join T_BD_Material material on material.FID = entry.FMaterialID ").append('\n');
        sql.append(" left join T_BD_MeasureUnit unit on material.FBaseUnit = unit.FID ").append('\n');
        sql.append(" Left Join T_ORG_Company company on company.FID = entry.FCompanyOrgUnitID ").append('\n');
        sql.append(" Left Join T_IM_InvUpdateType updateType on updateType.FID = entry.FInvUpdateTypeID ").append('\n');
        sql.append(" Left Join T_ORG_CostCenter costCenterOrgUnit on costCenterOrgUnit.FID = entry.FCostCenterOrgUnitID ").append('\n');
        sql.append(" Left Join T_BD_AsstAttrValue assistProperty on assistProperty.FID = entry.FAssistPropertyID ").append('\n');
        sql.append(" Left Join T_DB_WAREHOUSE warehouse on warehouse.FID = entry.FWarehouseID ").append('\n');
        sql.append(" Left Join T_DB_LOCATION location on location.FID = entry.FLocationID ").append('\n');
        sql.append(" Left Join T_BD_MeasureUnit baseUnit on baseUnit.FID = entry.FBaseUnitID ").append('\n');
        sql.append(" Left Join T_BD_MeasureUnit assistUnit on assistUnit.FID = entry.FAssistUnitID ").append('\n');
        sql.append(" Left Join T_BD_Person stocker on stocker.FID = entry.FStockerID ").append('\n');
        sql.append(" Left Join T_BD_Customer customer on customer.FID = entry.FCustomerID ").append('\n');
        sql.append(" Left Join T_SCM_BillType coreBillType on coreBillType.FID = entry.FCoreBillTypeID ").append('\n');
        sql.append(" Left Join T_MM_Project project on project.FID = entry.FProjectID ").append('\n');
        sql.append(" Left Join T_MM_TrackNumber trackNumber on trackNumber.FID = entry.FTrackNumberID ").append('\n');
        sql.append(" Left Join T_ORG_PURCHASE purchaseOrgUnit on purchaseOrgUnit.FID = entry.FPurchaseOrgUnitID ").append('\n');
        sql.append(" Left Join T_BD_Person purchasePerson on purchasePerson.FID = entry.FPurchasePersonID ").append('\n');
        sql.append(" Left Join T_BD_Supplier balanceSupplier on balanceSupplier.FID = entry.FBalanceSupplierID ").append('\n');
        sql.append(" where parent.FBaseStatus = 4 ").append('\n');
        sql.append(" and entry.FUnWriteOffAmount != 0 ").append('\n');
        Object[] companyIds = MatchUtils.getIdArray(this.condition.getObject("Company"));
        if (companyIds != null) {
            sql.append(" and ").append(MatchUtils.buildIn("company.FID", companyIds)).append('\n');
        }
        if (this.condition.getObject("BizDateFrom") != null) {
            sql.append(" and parent.FBIZDATE >= {ts'").append(this.condition.getObject("BizDateFrom").toString()).append(" 00:00:00'} ").append('\n');
        }
        if (this.condition.getObject("BizDateTo") != null) {
            sql.append(" and parent.FBIZDATE <= {ts'").append(this.condition.getObject("BizDateTo").toString()).append(" 23:59:59'} ").append('\n');
        }
        if ((supplierIds = MatchUtils.getIdArray(this.condition.getObject("Supplier"))) != null) {
            sql.append(" and ").append(MatchUtils.buildIn("supplier.FID", supplierIds)).append('\n');
        }
        if ((matIds = MatchUtils.getIdArray(this.condition.getObject("Material"))) != null) {
            sql.append(" and ").append(MatchUtils.buildIn("material.FID", matIds)).append('\n');
        }
        if (this.condition.getObject("number") != null) {
            sql.append(" and ").append(MatchUtils.buildLike("parent.FNumber", this.condition.getObject("number").toString())).append('\n');
        }
        sql.append(" ;\n ");
        sql.append(" update ");
        sql.append(this.tempTable);
        sql.append(" t set FUnMatchedQty = FUnMatchedQty - ");
        sql.append(" ( select isNull(sum(isNull(FMatchedQty,0)),0) from T_ARAP_InvoiceMatchRecordEntry where FBillEntryID = t.FBillEntryID) ");
        sql.append(" ;\n ");
        sql.append(" delete from ");
        sql.append(this.tempTable);
        sql.append(" where FUnMatchedQty = 0 ");
        sql.append(" ;\n ");
        sql.append(" update ");
        sql.append(this.tempTable);
        sql.append(" set FQtyToMatch = FUnMatchedQty, FAmtToMatch = round(FUnMatchedQty * FTaxPrice,2) ");
        return sql.toString();
    }

    @Override
    public String getOrderBySql() {
        return " order by FCompanyID, FSupplierID, FNumber, FEntrySeq ";
    }

    @Override
    public String getCustomerPanel() {
        return "com.kingdee.eas.fi.arap.invoiceMatch.client.PurInWarehsConditionUI";
    }

    @Override
    public String[] getEntrieNames() {
        String[] entrieNames = new String[]{"entry"};
        return entrieNames;
    }
}

