/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.invoiceMatch.config;

import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.fi.arap.invoiceMatch.config.AbstractConfigHelper;
import com.kingdee.eas.fi.arap.invoiceMatch.util.HeaderInfo;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchConstant;
import com.kingdee.eas.fi.arap.invoiceMatch.util.MatchUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PurOrder2PrePayConfigHelper
extends AbstractConfigHelper {
    public PurOrder2PrePayConfigHelper() {
    }

    public PurOrder2PrePayConfigHelper(Locale locale) {
        super(locale);
    }

    @Override
    protected void initFields() {
        this.fields.add(new HeaderInfo(MatchConstant.TB_FSELECTED, "int", this.getResource("TB_FSelected"), false, 40, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FCOMPANYNAME, "nvarchar(80)", this.getResource("TB_FCompanyName"), false, 100, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FCOMPANYID, "varchar(44)", "FCompanyID", true, -1, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FSUPPLIERNAME, "nvarchar(255)", this.getResource("TB_FSupplierName"), false, 100, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FSUPPLIERID, "varchar(44)", "FSupplierID", true, -1, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FNUMBER, "nvarchar(80)", this.getResource("TB_FBillNumber"), false, 100, null, 0));
        this.fields.add(new HeaderInfo("FBizDate", "DateTime", this.getResource("TB_FOrderDate"), false, 100, "yyyy-MM-dd", 0));
        this.fields.add(new HeaderInfo("FMaterialNumber", "nvarchar(80)", this.getResource("TB_FMaterialNumber"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FName", "nvarchar(255)", this.getResource("TB_MaterialName"), false, 100, null, 0));
        this.fields.add(new HeaderInfo("FModel", "nvarchar(255)", this.getResource("TB_FModel"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FUnit", "nvarchar(255)", this.getResource("TB_FUnit"), true, 100, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FQTY, "Decimal(28,10)", this.getResource("TB_FQty"), false, 100, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FTaxRate, "Decimal(28,10)", this.getResource("TB_FTaxRate"), true, 100, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FTaxPrice, "Decimal(28,10)", this.getResource("TB_FTaxPrice"), false, 100, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FTaxAmount, "Decimal(28,10)", this.getResource("TB_FTaxAmount"), false, 100, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FUNMATCHEDQTY, "Decimal(28,10)", this.getResource("TB_FUnMatchedQty"), true, -1, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FUNMATCHEDAMT, "Decimal(28,10)", this.getResource("TB_FUnPrePayAmt"), false, 100, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FQTYTOMATCH, "Decimal(28,10)", this.getResource("TB_FQtyToMatch"), true, -1, null, 2));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FAMTTOMATCH, "Decimal(28,10)", this.getResource("TB_FAmtToMatch"), false, 120, null, 2));
        this.fields.add(new HeaderInfo("FDescription", "nvarchar(300)", this.getResource("TB_FDescription"), false, 100, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FBILLID, "varchar(44)", "FBillID", true, -1, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FBILLENTRYID, "varchar(44)", "FBillEntryID", true, -1, null, 0));
        this.fields.add(new HeaderInfo(MatchConstant.TB_FENTRYSEQ, "int", "FEntrySeq", true, -1, null, 0));
        this.fields.add(new HeaderInfo("FTotalReceiptQty", "Decimal(28,10)", this.getResource("FTotalReceiptQty"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FProject", "nvarchar(255)", this.getResource("FProject"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FTrackNo", "nvarchar(255)", this.getResource("FTrackNo"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FTotalPaidAmount", "Decimal(28,10)", this.getResource("FTotalPaidAmount"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FRowType", "nvarchar(255)", this.getResource("FRowType"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FAssistProperty", "nvarchar(255)", this.getResource("FAssistProperty"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FIsPresent", "int", this.getResource("FIsPresent"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FBaseStatus", "nvarchar(255)", this.getResource("FBaseStatus"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FReasonCode", "nvarchar(255)", this.getResource("FReasonCode"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FBaseUnit", "nvarchar(255)", this.getResource("FBaseUnit"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FBaseQty", "Decimal(28,10)", this.getResource("FBaseQty"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FAssistUnit", "nvarchar(255)", this.getResource("FAssistUnit"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FAssistQty", "Decimal(28,10)", this.getResource("FAssistQty"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FRequestOrgUnit", "nvarchar(255)", this.getResource("FRequestOrgUnit"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FStorageOrgUnit", "nvarchar(255)", this.getResource("FStorageOrgUnit"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FAdminOrgUnit", "nvarchar(255)", this.getResource("FAdminOrgUnit"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FUseAdminOrgUnit", "nvarchar(255)", this.getResource("FUseAdminOrgUnit"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FDeliveryAddress", "nvarchar(255)", this.getResource("FDeliveryAddress"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FDeliveryDate", "DateTime", this.getResource("FDeliveryDate"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FPrice", "Decimal(28,10)", this.getResource("FPrice"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FDiscountRate", "Decimal(28,10)", this.getResource("FDiscountRate"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FActualTaxPrice", "Decimal(28,10)", this.getResource("FActualTaxPrice"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FDiscountAmount", "Decimal(28,10)", this.getResource("FDiscountAmount"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FAmount", "Decimal(28,10)", this.getResource("FAmount"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FLocalAmount", "Decimal(28,10)", this.getResource("FLocalAmount"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FTax", "Decimal(28,10)", this.getResource("FTax"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FTotalExpense", "Decimal(28,10)", this.getResource("FTotalExpense"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FSaleOrderNumber", "nvarchar(255)", this.getResource("FSaleOrderNumber"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FPurContract", "nvarchar(255)", this.getResource("FPurContract"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FDeliverAdvanceDay", "Decimal(28,10)", this.getResource("FDeliverAdvanceDay"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FDeliverDeferralDay", "Decimal(28,10)", this.getResource("FDeliverDeferralDay"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FReceiveOverRate", "Decimal(28,10)", this.getResource("FReceiveOverRate"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FReceiveOwingRate", "Decimal(28,10)", this.getResource("FReceiveOwingRate"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FIsQuantityUnCtrl", "Decimal(28,10)", this.getResource("FIsQuantityUnCtrl"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FIsTimeUnCtrl", "Decimal(28,10)", this.getResource("FIsTimeUnCtrl"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FTotalReceiveQty", "Decimal(28,10)", this.getResource("FTotalReceiveQty"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FPlanReceiveQty", "Decimal(28,10)", this.getResource("FPlanReceiveQty"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FTotalReturnedQty", "Decimal(28,10)", this.getResource("FTotalReturnedQty"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FTotalCancelledStockQty", "Decimal(28,10)", this.getResource("FTotalCancelledStockQty"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FTotalInvoicedQty", "Decimal(28,10)", this.getResource("FTotalInvoicedQty"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FTotalInvoicedAmount", "Decimal(28,10)", this.getResource("FTotalInvoicedAmount"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FTotalReqPayAmt", "Decimal(28,10)", this.getResource("FTotalReqPayAmt"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FRemark", "nvarchar(255)", this.getResource("FRemark"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FLocalTax", "Decimal(28,10)", this.getResource("FLocalTax"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FLocalTaxAmount", "Decimal(28,10)", this.getResource("FLocalTaxAmount"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FTotalInvoicedAmt", "Decimal(28,10)", this.getResource("FTotalInvoicedAmt"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FTotalPrePayAmt", "Decimal(28,10)", this.getResource("FTotalPrePayAmt"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FPrepayment", "Decimal(28,10)", this.getResource("FPrepayment"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FPreReceived", "Decimal(28,10)", this.getResource("FPreReceived"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FUnPrereceivedAm", "Decimal(28,10)", this.getResource("FUnPrereceivedAm"), true, 100, null, 2));
        this.fields.add(new HeaderInfo("FDestinationType", "nvarchar(255)", this.getResource("FDestinationType"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FWarehouse", "nvarchar(255)", this.getResource("FWarehouse"), true, 100, null, 0));
        this.fields.add(new HeaderInfo("FTotalSupplyStockQty", "Decimal(28,10)", this.getResource("FTotalSupplyStockQty"), true, 100, null, 2));
    }

    @Override
    public String[] getSumFields() {
        String[] sumFields = new String[]{MatchConstant.TB_FQTYTOMATCH, MatchConstant.TB_FAMTTOMATCH};
        return sumFields;
    }

    @Override
    public IMetaDataPK getQueryMetaDataPK() {
        return MetaDataPK.create((String)"com.kingdee.eas.scm.sm.pur.app.PurOrderQuery");
    }

    @Override
    public String initTableDataSql() {
        Object[] matIds;
        Object[] supplierIds;
        StringBuffer sql = new StringBuffer();
        sql.append(" insert into ");
        sql.append(this.tempTable);
        sql.append(" Select ").append('\n');
        sql.append(" company.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" company.FID, ").append('\n');
        sql.append(" supplier.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" supplier.FID, ").append('\n');
        sql.append(" parent.FNumber, ").append('\n');
        sql.append(" parent.FBizDate, ").append('\n');
        sql.append(" material.FNumber, ").append('\n');
        sql.append(" material.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" material.FModel, ").append('\n');
        sql.append(" unit.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" entry.FQty, ").append('\n');
        sql.append(" entry.FTaxRate,").append("\n");
        sql.append(" entry.FTaxPrice, ").append('\n');
        sql.append(" entry.FTaxAmount, ").append('\n');
        sql.append(" entry.FQty, ").append('\n');
        sql.append(" entry.FPrepayment - entry.FTotalPrePayAmt, ").append('\n');
        sql.append(" entry.FQty, ").append('\n');
        sql.append(" entry.FPrepayment - entry.FTotalPrePayAmt, ").append('\n');
        sql.append(" parent.FDescription, ").append('\n');
        sql.append(" parent.FID, ").append('\n');
        sql.append(" entry.FID, ").append('\n');
        sql.append(" entry.FSeq, ").append('\n');
        sql.append(" entry.FTotalReceiptQty, ").append('\n');
        sql.append(" project.FNumber, ").append('\n');
        sql.append(" trackNo.FNumber, ").append('\n');
        sql.append(" entry.FTotalPaidAmount, ").append('\n');
        sql.append(" rowType.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" assistProperty.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" entry.FIsPresent, ").append('\n');
        sql.append(" entry.FBaseStatus, ").append('\n');
        sql.append(" reasonCode.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" baseUnit.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" entry.FBaseQty, ").append('\n');
        sql.append(" assistUnit.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" entry.FAssistQty, ").append('\n');
        sql.append(" requestOrgUnit.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" storageOrgUnit.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" adminOrgUnit.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" useAdminOrgUnit.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" entry.FDeliveryAddress, ").append('\n');
        sql.append(" entry.FDeliveryDate, ").append('\n');
        sql.append(" entry.FPrice, ").append('\n');
        sql.append(" entry.FDiscountRate, ").append('\n');
        sql.append(" entry.FActualTaxPrice, ").append('\n');
        sql.append(" entry.FDiscountAmount, ").append('\n');
        sql.append(" entry.FAmount, ").append('\n');
        sql.append(" entry.FLocalAmount, ").append('\n');
        sql.append(" entry.FTax, ").append('\n');
        sql.append(" entry.FTotalExpense, ").append('\n');
        sql.append(" entry.FSaleOrderNumber, ").append('\n');
        sql.append(" purContractID.FNumber, ").append('\n');
        sql.append(" entry.FDeliverAdvanceDay, ").append('\n');
        sql.append(" entry.FDeliverDeferralDay, ").append('\n');
        sql.append(" entry.FReceiveOverRate, ").append('\n');
        sql.append(" entry.FReceiveOwingRate, ").append('\n');
        sql.append(" entry.FIsQuantityUnCtrl, ").append('\n');
        sql.append(" entry.FIsTimeUnCtrl, ").append('\n');
        sql.append(" entry.FTotalReceiveQty, ").append('\n');
        sql.append(" entry.FPlanReceiveQty, ").append('\n');
        sql.append(" entry.FTotalReturnedQty, ").append('\n');
        sql.append(" entry.FTotalCancelledStockQty, ").append('\n');
        sql.append(" entry.FTotalInvoicedQty, ").append('\n');
        sql.append(" entry.FTotalInvoicedAmount, ").append('\n');
        sql.append(" entry.FTotalReqPayAmt, ").append('\n');
        sql.append(" entry.FRemark, ").append('\n');
        sql.append(" entry.FLocalTax, ").append('\n');
        sql.append(" entry.FLocalTaxAmount, ").append('\n');
        sql.append(" entry.FTotalInvoicedAmt, ").append('\n');
        sql.append(" entry.FTotalPrePayAmt, ").append('\n');
        sql.append(" entry.FPrepayment, ").append('\n');
        sql.append(" entry.FPreReceived, ").append('\n');
        sql.append(" entry.FUnPrereceivedAm, ").append('\n');
        sql.append(" entry.FDestinationType, ").append('\n');
        sql.append(" wareHouse.FName").append("_").append(this.locale.toString()).append(", ").append('\n');
        sql.append(" entry.FTotalSupplyStockQty ").append('\n');
        sql.append(" from T_SM_PURORDER parent ").append('\n');
        sql.append(" left join T_SM_PURORDERENTRY entry on parent.FID = entry.FParentID ").append('\n');
        sql.append(" left join T_BD_Supplier supplier on supplier.FID = parent.fsupplierID ").append('\n');
        sql.append(" left join T_BD_Material material on material.FID = entry.fmaterialID ").append('\n');
        sql.append(" left join T_BD_MeasureUnit unit on material.FBaseUnit = unit.FID ").append('\n');
        sql.append(" left join T_ORG_Company company on company.FID = parent.FCompanyOrgUnitID ").append('\n');
        sql.append(" Left Join T_MM_Project project on project.FID = entry.FProjectID ").append('\n');
        sql.append(" Left Join T_MM_TrackNumber trackNo on trackNo.FID = entry.FTrackNoID ").append('\n');
        sql.append(" Left Join T_SCM_RowType rowType on rowType.FID = entry.FRowTypeID ").append('\n');
        sql.append(" Left Join T_BD_AsstAttrValue assistProperty on assistProperty.FID = entry.FAssistPropertyID ").append('\n');
        sql.append(" Left Join T_SCM_ReasonCode reasonCode on reasonCode.FID = entry.FReasonCodeID ").append('\n');
        sql.append(" Left Join T_BD_MeasureUnit baseUnit on baseUnit.FID = entry.FBaseUnitID ").append('\n');
        sql.append(" Left Join T_BD_MeasureUnit assistUnit on assistUnit.FID = entry.FAssistUnitID ").append('\n');
        sql.append(" Left Join T_ORG_Storage requestOrgUnit on requestOrgUnit.FID = entry.FRequestOrgUnitID ").append('\n');
        sql.append(" Left Join T_ORG_Storage storageOrgUnit on storageOrgUnit.FID = entry.FStorageOrgUnitID ").append('\n');
        sql.append(" Left Join T_ORG_Admin adminOrgUnit on adminOrgUnit.FID = entry.FAdminOrgUnitID ").append('\n');
        sql.append(" Left Join T_ORG_Admin useAdminOrgUnit on useAdminOrgUnit.FID = entry.FUseAdminOrgUnitID ").append('\n');
        sql.append(" Left Join T_SM_PurContract purContractID on purContractID.FID = entry.FPurContractID ").append('\n');
        sql.append(" Left Join T_DB_WAREHOUSE wareHouse on wareHouse.FID = entry.FWareHouseID ").append('\n');
        sql.append(" where parent.FIsSysBill = 0 ").append('\n');
        sql.append(" and parent.FBaseStatus in ('4','7') ").append('\n');
        sql.append(" and entry.FPrepayment - entry.FTotalPrePayAmt > 0 ").append('\n');
        Object[] companyIds = MatchUtils.getIdArray(this.condition.getObject("Company"));
        if (companyIds != null) {
            sql.append(" and ").append(MatchUtils.buildIn("company.FID", companyIds)).append('\n');
        }
        if (this.condition.getObject("BizDateFrom") != null) {
            sql.append(" and parent.FBIZDATE >= {ts'").append(this.condition.getObject("BizDateFrom").toString()).append(" 00:00:00'} ").append('\n');
        }
        if (this.condition.getObject("BizDateTo") != null) {
            sql.append(" and parent.FBIZDATE <= {ts'").append(this.condition.getObject("BizDateTo").toString()).append(" 23:59:59'} ").append('\n');
        }
        if ((supplierIds = MatchUtils.getIdArray(this.condition.getObject("Supplier"))) != null) {
            sql.append(" and ").append(MatchUtils.buildIn("supplier.FID", supplierIds)).append('\n');
        }
        if ((matIds = MatchUtils.getIdArray(this.condition.getObject("Material"))) != null) {
            sql.append(" and ").append(MatchUtils.buildIn("material.FID", matIds)).append('\n');
        }
        if (this.condition.getObject("number") != null) {
            sql.append(" and ").append(MatchUtils.buildLike("parent.FNumber", this.condition.getObject("number").toString())).append('\n');
        }
        return sql.toString();
    }

    @Override
    public String getOrderBySql() {
        return " order by FCompanyID, FSupplierID, FNumber, FEntrySeq ";
    }

    @Override
    public String getCustomerPanel() {
        return "com.kingdee.eas.fi.arap.invoiceMatch.client.PurOrderConditionUI";
    }

    @Override
    public String[] getEntrieNames() {
        String[] entrieNames = new String[]{"entries"};
        return entrieNames;
    }

    @Override
    public Map getEnumFields() {
        HashMap<String, String> enumFields = new HashMap<String, String>();
        enumFields.put("FBaseStatus", "com.kingdee.eas.scm.common.EntryBaseStatusEnum");
        enumFields.put("FDestinationType", "com.kingdee.eas.basedata.scm.common.DestinationTypeEnum");
        return enumFields;
    }
}

