/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.rptformula.calculater;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.CellBlock;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodBatchQuery;
import com.kingdee.bos.ctrl.excel.model.struct.IMethodFillParameter;
import com.kingdee.bos.ctrl.excel.model.struct.INeedSheetInfo;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.rptformula.calculater.ARAPAmountBatchCalculater;
import com.kingdee.eas.fi.arap.rptformula.calculater.AcctAPAgingAmountBatchCalculater;
import com.kingdee.eas.fi.arap.rptformula.calculater.AcctAPBalanceAmountBatchCalculater;
import com.kingdee.eas.fi.arap.rptformula.calculater.AcctARAgingAmountBatchCalculater;
import com.kingdee.eas.fi.arap.rptformula.calculater.AcctARBalanceAmountBatchCalculater;
import com.kingdee.eas.fi.arap.rptformula.calculater.AcctCollectionAmountBatchCalculater;
import com.kingdee.eas.fi.arap.rptformula.calculater.AcctPayableAmountBatchCalculater;
import com.kingdee.eas.fi.arap.rptformula.calculater.AcctPaymentAmountBatchCalculater;
import com.kingdee.eas.fi.arap.rptformula.calculater.AcctReceivableAmountBatchCalculater;
import com.kingdee.eas.fi.newrpt.formula.FormulaMoverFactory;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.ICalculator;
import com.kingdee.eas.fi.rpt.BizFormulaMover;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Map;

public class ARAPReportBatchCalculatorImpl
implements IMethodBatchQuery,
INeedSheetInfo,
IMethodFillParameter,
ICalculator {
    protected static final String _BAD_FUNCTION_ = "#BAD FUNCTION: ";
    private String sheetName = null;
    private ICalculateContextProvider contextProvider = null;

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public void initCalculateContext(ICalculateContextProvider contextProvider) {
        this.contextProvider = contextProvider;
    }

    public boolean batchQuery(Map methodMap) {
        for (Map.Entry entry : methodMap.entrySet()) {
            String methodName = (String)entry.getKey();
            SortedParameterArray methodParams = (SortedParameterArray)entry.getValue();
            this.batchMethodQuery(this.contextProvider, methodName, methodParams);
        }
        return true;
    }

    public boolean batchMethodQuery(ICalculateContextProvider contextProvider, String methodName, SortedParameterArray methodParams) {
        ARAPAmountBatchCalculater batcher = null;
        if (methodName.equalsIgnoreCase("AcctReceivable")) {
            batcher = new AcctReceivableAmountBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("AcctPayable")) {
            batcher = new AcctPayableAmountBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("AcctCollection")) {
            batcher = new AcctCollectionAmountBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("AcctPayment")) {
            batcher = new AcctPaymentAmountBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("AcctARBalance")) {
            batcher = new AcctARBalanceAmountBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("AcctAPBalance")) {
            batcher = new AcctAPBalanceAmountBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("AcctARAging")) {
            batcher = new AcctARAgingAmountBatchCalculater(contextProvider);
        } else if (methodName.equalsIgnoreCase("AcctApAging")) {
            batcher = new AcctAPAgingAmountBatchCalculater(contextProvider);
        }
        boolean isFound = false;
        if (batcher != null) {
            isFound = true;
            batcher.initResource();
            batcher.execute(methodParams);
            batcher.clearResource();
        } else {
            String value = _BAD_FUNCTION_ + methodName;
            for (int i = 0; i < methodParams.size(); ++i) {
                methodParams.getParameter(i).setValue((Object)value);
            }
        }
        return false;
    }

    public boolean getTrendParameters(Map info) {
        String methodName = (String)info.get("Method_Name");
        Object[] methodParameters = (Object[])info.get("Parameters");
        if (methodName != null && methodParameters != null) {
            CellBlock fromCellBlock = (CellBlock)info.get("Block_From");
            CellBlock toCellBlock = (CellBlock)info.get("Block_To");
            int dragDirection = this.getDragDirection(fromCellBlock, toCellBlock);
            BizFormulaMover bizFormulaMover = FormulaMoverFactory.getFormulaMover((Map)info);
            Object[] newParameters = null;
            if (methodParameters[0] != null) {
                int len = ((Object[])methodParameters[0]).length;
                newParameters = new Object[len];
                System.arraycopy((Object[])methodParameters[0], 0, newParameters, 0, len);
            } else {
                newParameters = new Object[]{};
            }
            int[] hasChangedParas = bizFormulaMover.getModifiedParasIndexs();
            int n = methodParameters.length;
            for (int i = 0; i < n; ++i) {
                bizFormulaMover.move(dragDirection, methodName, Arrays.asList(newParameters));
                int index = 0;
                index = dragDirection == 4 || dragDirection == 1 ? n - 1 - i : i;
                int m = hasChangedParas.length;
                for (int j = 0; j < m; ++j) {
                    ((Object[])methodParameters[index])[hasChangedParas[j]] = new Variant(newParameters[hasChangedParas[j]], 11);
                }
            }
            return true;
        }
        return false;
    }

    protected int getDragDirection(CellBlock fromCellBlock, CellBlock toCellBlock) {
        if (fromCellBlock != null && toCellBlock != null) {
            int fromCol1 = fromCellBlock.getCol();
            int fromCol2 = fromCellBlock.getCol2();
            int fromRow1 = fromCellBlock.getRow();
            int fromRow2 = fromCellBlock.getRow2();
            int toCol1 = toCellBlock.getCol();
            int toCol2 = toCellBlock.getCol2();
            int toRow1 = toCellBlock.getRow();
            int toRow2 = toCellBlock.getRow2();
            if (fromRow1 > toRow1) {
                return 1;
            }
            if (fromRow2 < toRow2) {
                return 3;
            }
            if (fromCol1 > toCol1) {
                return 4;
            }
            if (fromCol2 < toCol2) {
                return 2;
            }
        }
        return 0;
    }

    public BigDecimal AcctReceivable(String company, String asstActType, String asstActGroup, String asstAct, String currency, Timestamp startTime, Timestamp endTime, String adminOrgUnit, String person, String materialGroup, String material, String billType, String payType, String saleOrgUnit, String expenseItem, String costCenter, String arapFetchType, String bizType) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal AcctPayable(String company, String asstActType, String asstActGroup, String asstAct, String currency, Timestamp startTime, Timestamp endTime, String adminOrgUnit, String person, String materialGroup, String material, String billType, String payType, String purchaseOrgUnit, String expenseItem, String costCenter, String arapFetchType, String bizType) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal AcctCollection(String company, String asstActType, String payType, String asstActGroup, String asstAct, String currency, Timestamp startTime, Timestamp endTime, String adminOrgUnit, String person, String receivingType, String SettlementType, String SettBizType, String costCenter, String arapFetchType) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal AcctPayment(String company, String asstActType, String payType, String asstActGroup, String asstAct, String currency, Timestamp startTime, Timestamp endTime, String adminOrgUnit, String person, String PaymentBillType, String SettlementType, String SettBizType, String costCenter, String arapFetchType) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal AcctARBalance(String company, String year, String period, String asstActType, String asstActGroup, String asstAct, String currency, String arBalaceFetchType) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal AcctAPBalance(String company, String year, String period, String asstActType, String asstActGroup, String asstAct, String currency, String apBalaceFetchType) throws BOSException, EASBizException {
        return null;
    }

    public BigDecimal AcctARAging(String company, Timestamp beginBillDate, Timestamp endBillDate, String asstActType, String asstActGroup, String asstAct, String currency, String analyseObj, String analyseDir, Timestamp agingCompareDate, String agingDateFld, String adminOrg, String person, String recPayBillType, String billType, String endDateBal, String bizcheck, String paymentType, String agingDue, String agingDueGroup) {
        return null;
    }

    public BigDecimal AcctAPAging(String company, Timestamp beginBillDate, Timestamp endBillDate, String asstActType, String asstActGroup, String asstAct, String currency, String analyseObj, String analyseDir, Timestamp agingCompareDate, String agingDateFld, String adminOrg, String person, String recPayBillType, String billType, String endDateBal, String bizcheck, String paymentType, String agingDue, String agingDueGroup) {
        return null;
    }
}

