/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.rptformula.calculater;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.fi.arap.rptformula.calculater.ARAPAmountBatchCalculater;
import com.kingdee.eas.fi.arap.rptformula.parambean.ARAPGetAmountParamBean;
import com.kingdee.eas.fi.arap.rptformula.parambean.AcctCollectionParamBean;
import com.kingdee.eas.fi.arap.rptformula.util.ARAPReportBatchUtils;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.batch.DiscreteAcctBackfill;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fm.fs.SettBizTypeCollection;
import com.kingdee.eas.fm.fs.SettBizTypeInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.util.SCMUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class AcctCollectionAmountBatchCalculater
extends ARAPAmountBatchCalculater {
    protected String receivingType = null;
    protected String settlementType = null;
    protected String settBizType = null;
    protected String reveivingFetchType = null;
    protected String asstActType = null;
    private String returnType = "";
    private String returnField = "";
    protected String currency = "";
    protected String payType = "";
    protected String asstActTypeId = "";
    private String asstActGroup = "";
    private AsstActTypeInfo asstActTypeInfo = null;
    private String[] CanMutiSelect = new String[]{"Company", "ReceivingType", "SettlementType", "SettBizType", "AdminOrgUnit", "Person", "AsstAct", "CostCenter"};
    private String[] CanMutiSelectSplit = new String[]{";", ";", ";", ";", ";", ";", ";", ";"};

    public AcctCollectionAmountBatchCalculater(ICalculateContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    protected String[] getCanMutiSelect() {
        return this.CanMutiSelect;
    }

    @Override
    protected String[] getCanMutiSelectSplit() {
        return this.CanMutiSelectSplit;
    }

    @Override
    protected String getDetailTableName() {
        return "t_cas_receivingbillentry";
    }

    @Override
    protected String getHeadTableName() {
        return "t_cas_receivingbill";
    }

    @Override
    protected void innerLoadNumberID(int index, HashMap map, Set numberSet) throws Exception {
        block12: {
            CostCenterOrgUnitCollection cc;
            EntityViewInfo ev;
            Context ctx;
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block11: {
                                    ctx = this.contextProvider.getServerContext();
                                    ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
                                    if (index != 0) break block11;
                                    CompanyOrgUnitCollection ouc = ARAPReportBatchUtils.getCompanyOrgUnitCollection(ctx, ev);
                                    if (ouc == null || ouc.size() <= 0) break block12;
                                    int n = ouc.size();
                                    for (int i = 0; i < n; ++i) {
                                        CompanyOrgUnitInfo info = ouc.get(i);
                                        String number = info.getNumber();
                                        String id = info.getId().toString();
                                        map.put(number, id);
                                    }
                                    break block12;
                                }
                                if (index != 1) break block13;
                                ReceivingBillTypeCollection ouc = ARAPReportBatchUtils.getReceivingBillTypeCollection(ctx, ev);
                                if (ouc == null || ouc.size() <= 0) break block12;
                                int n = ouc.size();
                                for (int i = 0; i < n; ++i) {
                                    ReceivingBillTypeInfo info = ouc.get(i);
                                    String number = info.getNumber();
                                    String id = info.getId().toString();
                                    map.put(number, id);
                                }
                                break block12;
                            }
                            if (index != 2) break block14;
                            SettlementTypeCollection ouc = ARAPReportBatchUtils.getSettlementTypeCollection(ctx, ev);
                            if (ouc == null || ouc.size() <= 0) break block12;
                            int n = ouc.size();
                            for (int i = 0; i < n; ++i) {
                                SettlementTypeInfo info = ouc.get(i);
                                String number = info.getNumber();
                                String id = info.getId().toString();
                                map.put(number, id);
                            }
                            break block12;
                        }
                        if (index != 3) break block15;
                        SettBizTypeCollection ouc = ARAPReportBatchUtils.getSettBizTypeCollection(ctx, ev);
                        if (ouc == null || ouc.size() <= 0) break block12;
                        int n = ouc.size();
                        for (int i = 0; i < n; ++i) {
                            SettBizTypeInfo info = ouc.get(i);
                            String number = info.getNumber();
                            String id = info.getId().toString();
                            map.put(number, id);
                        }
                        break block12;
                    }
                    if (index != 4) break block16;
                    AdminOrgUnitCollection ouc = ARAPReportBatchUtils.getAdminOrgUnitCollection(ctx, ev);
                    if (ouc == null || ouc.size() <= 0) break block12;
                    int n = ouc.size();
                    for (int i = 0; i < n; ++i) {
                        AdminOrgUnitInfo info = ouc.get(i);
                        String number = info.getNumber();
                        String id = info.getId().toString();
                        map.put(number, id);
                    }
                    break block12;
                }
                if (index != 5) break block17;
                PersonCollection ouc = ARAPReportBatchUtils.getPersonCollection(ctx, ev);
                if (ouc == null || ouc.size() <= 0) break block12;
                int n = ouc.size();
                for (int i = 0; i < n; ++i) {
                    PersonInfo info = ouc.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
                break block12;
            }
            if (index == 6) {
                DataBaseCollection infoColl = ARAPReportBatchUtils.getAsstActCollection(ctx, this.asstActTypeInfo, ev);
                for (int i = 0; i < infoColl.size(); ++i) {
                    DataBaseInfo info = infoColl.get(i);
                    if (info == null || info.getId() == null) continue;
                    map.put(info.getNumber(), info.getId().toString());
                }
            } else if (index == 7 && (cc = ARAPReportBatchUtils.getCostCenterOrgUnitCollection(ctx, ev)) != null && cc.size() > 0) {
                int n = cc.size();
                for (int i = 0; i < n; ++i) {
                    CostCenterOrgUnitInfo info = cc.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
            }
        }
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        int querySize = paramArray.size();
        int queryIndex = 0;
        Context ctx = this.contextProvider.getServerContext();
        ReportVariables reportVariables = this.contextProvider.getReportVariables();
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        while (queryIndex < querySize) {
            int i = 0;
            while (i < 3000 && queryIndex < querySize) {
                this.params.clear();
                Parameter param = paramArray.getParameter(queryIndex);
                AcctCollectionParamBean formulaParam = new AcctCollectionParamBean(param);
                this.initParam(formulaParam);
                if ("REBATE".equalsIgnoreCase(formulaParam.getReveivingFetchType())) {
                    this.setReturnType("ENTRY.FRebate");
                    this.setReturnField("FRebate");
                } else if ("REBATELOCAL".equalsIgnoreCase(formulaParam.getReveivingFetchType())) {
                    this.setReturnType("ENTRY.FRebateLocAmt");
                    this.setReturnField("FRebateLocAmt");
                } else if ("AMOUNT".equalsIgnoreCase(formulaParam.getReveivingFetchType())) {
                    this.setReturnType("ENTRY.FAmount");
                    this.setReturnField("FAmount");
                } else if ("AMOUNTLOCAL".equalsIgnoreCase(formulaParam.getReveivingFetchType())) {
                    this.setReturnType("ENTRY.FLocalAmount");
                    this.setReturnField("FLocalAmount");
                } else if ("ACTUALAMOUNT".equalsIgnoreCase(formulaParam.getReveivingFetchType())) {
                    this.setReturnType("ENTRY.FActualAmt");
                    this.setReturnField("FActualAmt");
                } else if ("ACTUALAMOUNTLOCAL".equalsIgnoreCase(formulaParam.getReveivingFetchType())) {
                    this.setReturnType("ENTRY.FActualLocAmt");
                    this.setReturnField("FActualLocAmt");
                } else if ("VERIFYAMT".equalsIgnoreCase(formulaParam.getReveivingFetchType())) {
                    this.setReturnType("ENTRY.FAmountVc");
                    this.setReturnField("FAmountVc");
                } else if ("VERIFYAMTLOC".equalsIgnoreCase(formulaParam.getReveivingFetchType())) {
                    this.setReturnType("ENTRY.FLocalAmtVc");
                    this.setReturnField("FLocalAmtVc");
                } else if ("UNVERIFYAMT".equalsIgnoreCase(formulaParam.getReveivingFetchType())) {
                    this.setReturnType("ENTRY.FUnVcAmount");
                    this.setReturnField("FUnVcAmount");
                } else if ("UNVERIFYAMTLOC".equalsIgnoreCase(formulaParam.getReveivingFetchType())) {
                    this.setReturnType("ENTRY.FUnVcLocAmount");
                    this.setReturnField("FUnVcLocAmount");
                }
                this.setCurrencyId(formulaParam.getCurrency());
                this.setAsstActTypeId(formulaParam.getAsstActType());
                this.setAsstActGroup(ctx, formulaParam.getAsstActGroup());
                this.setPayType(formulaParam.getPayType());
                formulaParam.setBackFiller((IBackfillHandler)new DiscreteAcctBackfill(param));
                String sheetName = param.getSheetName();
                try {
                    ARAPReportBatchUtils.reviseAcctCollectionParameters(ctx, formulaParam, sheetName, reportVariables, reportAdapter);
                    i += this.addParam(formulaParam);
                    this.innerExecute();
                }
                catch (Exception e) {
                    Logger.error((Throwable)e);
                    FormulaValueBackfill.setException((Parameter)param, (Throwable)e);
                }
                ++queryIndex;
            }
        }
    }

    @Override
    protected String getSql(int group) {
        return null;
    }

    @Override
    protected String getSqlByID(int group) {
        StringBuilder sql = new StringBuilder(500);
        sql.append("select SUM(").append(this.getReturnType()).append(") ").append(this.getReturnField());
        sql.append(" from ").append(this.getHeadTableName()).append(" BILL");
        sql.append(" inner join ").append(this.getDetailTableName()).append(" ENTRY on ENTRY.FReceivingBillID = BILL.fid ");
        sql.append(" left join T_ORG_Company company on company.fid = BILL.FCompanyID");
        sql.append(" left join T_BD_Currency currency on currency.fid = bill.FCurrencyID");
        if (this.asstActTypeInfo != null) {
            sql.append(" left join ").append(this.asstActTypeInfo.getRealtionDataObject()).append(" AsstAct on AsstAct.fid = BILL.FPayerID ");
        }
        sql.append(ARAPReportBatchUtils.getAsstActGroupSql(this.asstActTypeInfo, this.asstActGroup));
        sql.append(" left join T_ORG_Admin admin on admin.fid = bill.FAdminOrgUnitID ");
        sql.append(" left join T_BD_Person person on person.fid = bill.FPersonId");
        sql.append(" left join T_CAS_ReceivingBillType ReceivingBillType on ReceivingBillType.fid = bill.FRecBillTypeID ");
        sql.append(" left join T_BD_SettlementType SettlementType on SettlementType.fid = bill.FSettlementTypeID");
        sql.append(" left join T_FS_SettBizType SettBizType on SettBizType.fid = bill.FBizTypeID ");
        sql.append(" where (BILL.FBizDate>=? and BILL.FBizDate<?) and BILL.FbillStatus = 14  ");
        sql.append(this.getCompany(group));
        sql.append(this.getReceivingBillType(group));
        sql.append(this.getSettlementType(group));
        sql.append(this.getSettBizType(group));
        sql.append(this.getAdminOrgUnit(group));
        sql.append(this.getPerson(group));
        sql.append(this.getAsstActTypeId());
        sql.append(this.getAsstActGroup());
        sql.append(this.getAsstActId(group));
        sql.append(this.getCurrencyId());
        sql.append(this.getPayType());
        sql.append(this.getSourceType());
        sql.append(super.getCostCenterId(group, 7));
        return sql.toString();
    }

    protected String getSourceType() {
        return " and bill.FSourceType = 100";
    }

    protected String getPayType() {
        if (!StringUtil.isEmpty((String)this.payType)) {
            return " and bill.FPaymentTypeID = '" + this.payType + "'";
        }
        return " ";
    }

    @Override
    protected int setFixedSqlParams(PreparedStatement pstmt, ARAPGetAmountParamBean paramBean, int paramIndex) throws SQLException {
        if (paramBean == null) {
            return 0;
        }
        AcctCollectionParamBean paramsBean = (AcctCollectionParamBean)paramBean;
        pstmt.setTimestamp(paramIndex++, paramsBean.getStartTime());
        Timestamp endTime = SCMUtils.getDayStartTime((Date)DateUtil.getAfterDay((Date)paramsBean.getEndTime()));
        pstmt.setTimestamp(paramIndex++, endTime);
        return paramIndex;
    }

    public void setReturnField(String returnField) {
        this.returnField = returnField;
    }

    @Override
    public String getReturnField() {
        return this.returnField;
    }

    public void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    public String getReturnType() {
        return this.returnType;
    }

    public String getAsstActType() {
        return this.asstActType;
    }

    public void setAsstActType(String asstActType) {
        this.asstActType = asstActType;
    }

    protected void setCurrencyId(String currencyNumber) {
        try {
            this.currency = null;
            HashSet<String> numberSet = new HashSet<String>();
            EntityViewInfo ev = null;
            if (StringUtil.isEmpty((String)currencyNumber)) {
                return;
            }
            numberSet.add(currencyNumber);
            if (numberSet != null) {
                ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
            }
            if (ev == null) {
                return;
            }
            Context ctx = this.contextProvider.getServerContext();
            ICurrency iCurrency = null;
            iCurrency = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
            CurrencyInfo currencyInfo = iCurrency.getCurrencyCollection(ev).get(0);
            if (currencyInfo.getId() != null) {
                this.currency = currencyInfo.getId().toString();
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
    }

    protected String getCurrencyId() {
        if (this.currency != null && this.currency.trim().length() > 0) {
            return " and currency.fid  = '" + this.currency + "'";
        }
        return " ";
    }

    protected String getAsstActTypeId() {
        if (!StringUtil.isEmpty((String)this.asstActTypeId)) {
            return " and bill.FPayerTypeID = '" + this.asstActTypeId + "'";
        }
        return " ";
    }

    protected void setAsstActTypeId(String number) {
        try {
            this.asstActTypeId = "";
            this.asstActTypeInfo = null;
            HashSet<String> numberSet = new HashSet<String>();
            EntityViewInfo ev = null;
            if (StringUtil.isEmpty((String)number)) {
                return;
            }
            numberSet.add(number);
            if (numberSet != null) {
                ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
            }
            if (ev == null) {
                return;
            }
            IAsstActType iAsstActType = null;
            Context ctx = this.contextProvider.getServerContext();
            iAsstActType = ctx == null ? AsstActTypeFactory.getRemoteInstance() : AsstActTypeFactory.getLocalInstance((Context)ctx);
            this.asstActTypeInfo = iAsstActType.getAsstActTypeCollection(ev).get(0);
            if (this.asstActTypeInfo != null && this.asstActTypeInfo.getId() != null) {
                this.asstActTypeId = this.asstActTypeInfo.getId().toString();
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
    }

    protected void setPayType(String payType) {
        try {
            this.payType = null;
            HashSet<String> numberSet = new HashSet<String>();
            EntityViewInfo ev = null;
            if (StringUtil.isEmpty((String)payType)) {
                return;
            }
            numberSet.add(payType);
            if (numberSet != null) {
                ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
            }
            if (ev == null) {
                return;
            }
            Context ctx = this.contextProvider.getServerContext();
            IPaymentType iPaymentType = null;
            iPaymentType = ctx == null ? PaymentTypeFactory.getRemoteInstance() : PaymentTypeFactory.getLocalInstance((Context)ctx);
            PaymentTypeInfo paymentTypeInfo = iPaymentType.getPaymentTypeCollection(ev).get(0);
            if (paymentTypeInfo.getId() != null) {
                this.payType = paymentTypeInfo.getId().toString();
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
    }

    protected String getAsstActId(int group) {
        if (AcctCollectionAmountBatchCalculater.checkBit(group, 6)) {
            return " and AsstAct.Fid = ? ";
        }
        return "";
    }

    protected String getPerson(int group) {
        if (AcctCollectionAmountBatchCalculater.checkBit(group, 5)) {
            return " and person.Fid = ? ";
        }
        return "";
    }

    protected String getAdminOrgUnit(int group) {
        if (AcctCollectionAmountBatchCalculater.checkBit(group, 4)) {
            return " and admin.Fid = ? ";
        }
        return "";
    }

    private String getCompany(int group) {
        if (AcctCollectionAmountBatchCalculater.checkBit(group, 0)) {
            return " and company.Fid = ? ";
        }
        return "";
    }

    private String getReceivingBillType(int group) {
        if (AcctCollectionAmountBatchCalculater.checkBit(group, 1)) {
            return " and receivingBillType.Fid = ? ";
        }
        return "";
    }

    private String getSettlementType(int group) {
        if (AcctCollectionAmountBatchCalculater.checkBit(group, 2)) {
            return " and settlementType.Fid = ? ";
        }
        return "";
    }

    private String getSettBizType(int group) {
        if (AcctCollectionAmountBatchCalculater.checkBit(group, 3)) {
            return " and SettBizType.Fid = ? ";
        }
        return "";
    }

    protected void setAsstActGroup(Context ctx, String asstActGroup) {
        String groupTable = null;
        if (this.asstActTypeInfo != null) {
            groupTable = this.asstActTypeInfo.getGroupTableName();
        }
        try {
            this.asstActGroup = ARAPReportBatchUtils.getAsstActGroupIDByNumber(ctx, asstActGroup, groupTable, this.asstActTypeInfo);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    protected String getAsstActGroup() {
        if (!StringUtil.isEmpty((String)this.asstActGroup) || this.asstActGroup != null) {
            return " and AsstActGroup.fid = '" + this.asstActGroup + "'";
        }
        return " ";
    }
}

