/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.rptformula.calculater;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPaymentType;
import com.kingdee.eas.basedata.assistant.PaymentTypeFactory;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.IAsstActType;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeCollection;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.cp.bc.ExpenseTypeCollection;
import com.kingdee.eas.cp.bc.ExpenseTypeFactory;
import com.kingdee.eas.cp.bc.IExpenseType;
import com.kingdee.eas.fi.arap.rptformula.calculater.ARAPAmountBatchCalculater;
import com.kingdee.eas.fi.arap.rptformula.parambean.ARAPGetAmountParamBean;
import com.kingdee.eas.fi.arap.rptformula.parambean.ArOtherBillParamBean;
import com.kingdee.eas.fi.arap.rptformula.util.ARAPReportBatchUtils;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.IBackfillHandler;
import com.kingdee.eas.fi.rpt.batch.DiscreteAcctBackfill;
import com.kingdee.eas.fi.rpt.batch.FormulaValueBackfill;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.util.SCMUtils;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class AcctReceivableAmountBatchCalculater
extends ARAPAmountBatchCalculater {
    private String[] canMutiSelect = new String[]{"Company", "SaleOrgUnit", "AdminOrgUnit", "Person", "Material", "AsstAct", "BizType", "CostCenter"};
    private String[] canMutiSelectSplit = new String[]{";", ";", ";", ";", ";", ";", ";", ";"};
    private String billType = " ";
    private String returnType = " ";
    private String returnField = " ";
    private String asstActTypeId = "";
    private String payType = " ";
    private String asstActGroup = " ";
    private String materialGroup = "";
    private String currency = "";
    private AsstActTypeInfo asstActTypeInfo = null;
    private String expenseItem = "";

    public AcctReceivableAmountBatchCalculater(ICalculateContextProvider contextProvider) {
        super(contextProvider);
    }

    @Override
    protected void innerLoadNumberID(int index, HashMap map, Set numberSet) throws Exception {
        block11: {
            CostCenterOrgUnitCollection cc;
            EntityViewInfo ev;
            Context ctx;
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block10: {
                                        ctx = this.contextProvider.getServerContext();
                                        ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
                                        if (ev == null || ev.getFilter() == null || ev.getFilter().getFilterItems().size() == 0) {
                                            return;
                                        }
                                        if (index != 0) break block10;
                                        CompanyOrgUnitCollection ouc = ARAPReportBatchUtils.getCompanyOrgUnitCollection(ctx, ev);
                                        if (ouc == null || ouc.size() <= 0) break block11;
                                        int n = ouc.size();
                                        for (int i = 0; i < n; ++i) {
                                            CompanyOrgUnitInfo info = ouc.get(i);
                                            String number = info.getNumber();
                                            String id = info.getId().toString();
                                            map.put(number, id);
                                        }
                                        break block11;
                                    }
                                    if (index != 1) break block12;
                                    SaleOrgUnitCollection ouc = ARAPReportBatchUtils.getSaleOrgUnitCollection(ctx, ev);
                                    if (ouc == null || ouc.size() <= 0) break block11;
                                    int n = ouc.size();
                                    for (int i = 0; i < n; ++i) {
                                        SaleOrgUnitInfo info = ouc.get(i);
                                        String number = info.getNumber();
                                        String id = info.getId().toString();
                                        map.put(number, id);
                                    }
                                    break block11;
                                }
                                if (index != 2) break block13;
                                AdminOrgUnitCollection ouc = ARAPReportBatchUtils.getAdminOrgUnitCollection(ctx, ev);
                                if (ouc == null || ouc.size() <= 0) break block11;
                                int n = ouc.size();
                                for (int i = 0; i < n; ++i) {
                                    AdminOrgUnitInfo info = ouc.get(i);
                                    String number = info.getNumber();
                                    String id = info.getId().toString();
                                    map.put(number, id);
                                }
                                break block11;
                            }
                            if (index != 3) break block14;
                            PersonCollection ouc = ARAPReportBatchUtils.getPersonCollection(ctx, ev);
                            if (ouc == null || ouc.size() <= 0) break block11;
                            int n = ouc.size();
                            for (int i = 0; i < n; ++i) {
                                PersonInfo info = ouc.get(i);
                                String number = info.getNumber();
                                String id = info.getId().toString();
                                map.put(number, id);
                            }
                            break block11;
                        }
                        if (index != 4) break block15;
                        MaterialCollection ouc = ARAPReportBatchUtils.getMaterialCollection(ctx, ev);
                        if (ouc == null || ouc.size() <= 0) break block11;
                        int n = ouc.size();
                        for (int i = 0; i < n; ++i) {
                            MaterialInfo info = ouc.get(i);
                            String number = info.getNumber();
                            String id = info.getId().toString();
                            map.put(number, id);
                        }
                        break block11;
                    }
                    if (index != 5) break block16;
                    DataBaseCollection infoColl = ARAPReportBatchUtils.getAsstActCollection(ctx, this.asstActTypeInfo, ev);
                    for (int i = 0; i < infoColl.size(); ++i) {
                        DataBaseInfo info = infoColl.get(i);
                        if (info == null || info.getId() == null) continue;
                        map.put(info.getNumber(), info.getId().toString());
                    }
                    break block11;
                }
                if (index != 6) break block17;
                BizTypeCollection ouc = ARAPReportBatchUtils.getBizTypeCollection(ctx, ev);
                if (ouc == null || ouc.size() <= 0) break block11;
                int n = ouc.size();
                for (int i = 0; i < n; ++i) {
                    BizTypeInfo info = ouc.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
                break block11;
            }
            if (index == 7 && (cc = ARAPReportBatchUtils.getCostCenterOrgUnitCollection(ctx, ev)) != null && cc.size() > 0) {
                int n = cc.size();
                for (int i = 0; i < n; ++i) {
                    CostCenterOrgUnitInfo info = cc.get(i);
                    String number = info.getNumber();
                    String id = info.getId().toString();
                    map.put(number, id);
                }
            }
        }
    }

    @Override
    public void execute(SortedParameterArray paramArray) {
        int querySize = paramArray.size();
        int queryIndex = 0;
        Context ctx = this.contextProvider.getServerContext();
        ReportVariables reportVariables = this.contextProvider.getReportVariables();
        IReportPropertyAdapter reportAdapter = this.contextProvider.getReportAdapter();
        while (queryIndex < querySize) {
            int i = 0;
            while (i < 3000 && queryIndex < querySize) {
                this.params.clear();
                Parameter param = paramArray.getParameter(queryIndex);
                ArOtherBillParamBean formulaParam = new ArOtherBillParamBean(param);
                this.initParam(formulaParam);
                if ("taxAmountTotal".equalsIgnoreCase(formulaParam.getFetchType())) {
                    this.setReturnType("ENTRY.FRecievePayAmount");
                    this.setReturnField("FRecievePayAmount");
                } else if ("taxAmountTotalLocal".equalsIgnoreCase(formulaParam.getFetchType())) {
                    this.setReturnType("ENTRY.FRecievePayAmountLocal");
                    this.setReturnField("FRecievePayAmountLocal");
                } else if ("amount".equalsIgnoreCase(formulaParam.getFetchType())) {
                    this.setReturnType("ENTRY.FAmount");
                    this.setReturnField("FAmount");
                } else if ("amountLocal".equalsIgnoreCase(formulaParam.getFetchType())) {
                    this.setReturnType("ENTRY.FAmountLocal");
                    this.setReturnField("FAmountLocal");
                } else if ("taxAmount".equalsIgnoreCase(formulaParam.getFetchType())) {
                    this.setReturnType("ENTRY.FTaxAmount");
                    this.setReturnField("FTaxAmount");
                } else if ("taxAmountLocal".equalsIgnoreCase(formulaParam.getFetchType())) {
                    this.setReturnType("ENTRY.FTaxAmountLocal");
                    this.setReturnField("FTaxAmountLocal");
                } else if ("quantity".equalsIgnoreCase(formulaParam.getFetchType())) {
                    this.setReturnType("ENTRY.FQuantity");
                    this.setReturnField("FQuantity");
                } else if ("verifyAmt".equalsIgnoreCase(formulaParam.getFetchType())) {
                    this.setReturnType("ENTRY.FVerifyAmount");
                    this.setReturnField("FVerifyAmount");
                } else if ("verifyAmtLoc".equalsIgnoreCase(formulaParam.getFetchType())) {
                    this.setReturnType("ENTRY.FVerifyAmountLocal");
                    this.setReturnField("FVerifyAmountLocal");
                } else if ("unVerifyAmt".equalsIgnoreCase(formulaParam.getFetchType())) {
                    this.setReturnType("ENTRY.FUnVerifyAmount");
                    this.setReturnField("FUnVerifyAmount");
                } else if ("unVerifyAmtLoc".equalsIgnoreCase(formulaParam.getFetchType())) {
                    this.setReturnType("ENTRY.FUnVerifyAmountLocal");
                    this.setReturnField("FUnVerifyAmountLocal");
                }
                if ("OtherReceivable".equals(formulaParam.getBillType())) {
                    this.setBillType(" AND BILL.FBillType = 101");
                } else if ("ExpenseInvoice".equals(formulaParam.getBillType())) {
                    this.setBillType(" AND BILL.FBillType = 103");
                } else if ("InvoiceBill".equals(formulaParam.getBillType())) {
                    this.setBillType(" AND BILL.FBillType = 102");
                } else if ("DebitAdjust".equals(formulaParam.getBillType())) {
                    this.setBillType(" AND BILL.FBillType = 104");
                } else {
                    this.setBillType(" ");
                }
                this.setCurrencyId(formulaParam.getCurrency());
                this.setMaterialGroupid(ctx, formulaParam.getMaterialGroup());
                this.setAsstActTypeId(formulaParam.getAsstActType());
                this.setAsstActGroup(ctx, formulaParam.getAsstActGroup());
                this.setPayType(formulaParam.getPayType());
                this.setExpenseItemId(formulaParam.getExpenseItem());
                formulaParam.setBackFiller((IBackfillHandler)new DiscreteAcctBackfill(param));
                String sheetName = param.getSheetName();
                try {
                    ARAPReportBatchUtils.reviseArOtherBillParameters(ctx, formulaParam, sheetName, reportVariables, reportAdapter);
                    i += this.addParam(formulaParam);
                    this.innerExecute();
                }
                catch (Exception e) {
                    Logger.error((Throwable)e);
                    FormulaValueBackfill.setException((Parameter)param, (Throwable)e);
                }
                ++queryIndex;
            }
        }
    }

    @Override
    protected String getSql(int group) {
        return null;
    }

    @Override
    protected String getSqlByID(int group) {
        StringBuilder sql = new StringBuilder(500);
        sql.append("select SUM(").append(this.getReturnType()).append(") ").append(this.getReturnField());
        sql.append(" from ").append(this.getDetailTableName()).append(" ENTRY");
        sql.append(" inner join ").append(this.getHeadTableName()).append(" BILL on ENTRY.fparentid = BILL.fid ");
        sql.append(" left join T_ORG_Sale sale on sale.fid = BILL.FSaleOrgID ");
        sql.append(" left join T_ORG_Company company on company.fid = BILL.FCompanyID");
        sql.append(" left join T_BD_Currency currency on currency.fid = bill.FCurrencyID");
        sql.append(" left join T_BD_Material material on material.fid = ENTRY.FMaterialID ");
        if (this.materialGroup != null && this.materialGroup.trim().length() > 0) {
            sql.append(" LEFT JOIN T_BD_MaterialGroupDetial AS MGD on MGD.FMaterialID = material.fid");
        }
        sql.append(" left join T_BD_MaterialGroup materialGroup on materialGroup.fid = material.FMaterialGroupID ");
        if (this.asstActTypeInfo != null) {
            sql.append(" left join ").append(this.asstActTypeInfo.getRealtionDataObject()).append(" AsstAct on AsstAct.fid = BILL.FAsstActID ");
        }
        sql.append(ARAPReportBatchUtils.getAsstActGroupSql(this.asstActTypeInfo, this.asstActGroup));
        sql.append(" left join T_ORG_Admin admin on admin.fid = bill.FAdminOrgUnitID ");
        sql.append(" left join T_BD_Person person on person.fid = bill.FPersonId");
        sql.append(" left join T_SCM_BizType bizType on bizType.fid = bill.FBizTypeID ");
        sql.append(" where (ENTRY.FBillDate>=? and ENTRY.FBillDate<?) and BILL.FbillStatus = 3 ");
        sql.append(this.getCompany(group));
        sql.append(this.getSaleOrg(group));
        sql.append(this.getBillType());
        sql.append(this.getAdminOrgUnit(group));
        sql.append(this.getPerson(group));
        sql.append(this.getMaterialGroupid());
        sql.append(this.getMaterial(group));
        sql.append(this.getCurrencyId());
        sql.append(this.getAsstActTypeId());
        sql.append(this.getAsstActGroup());
        sql.append(this.getAsstActId(group));
        sql.append(this.getPayType());
        sql.append(this.getExpenseItemId());
        sql.append(this.getBizType(group));
        sql.append(super.getCostCenterId(group, 7));
        return sql.toString();
    }

    protected String getBizType(int group) {
        if (AcctReceivableAmountBatchCalculater.checkBit(group, 6)) {
            return " and bizType.Fid = ? ";
        }
        return "";
    }

    protected String getPayType() {
        if (!StringUtil.isEmpty((String)this.payType)) {
            return " and bill.FPaymentTypeID = '" + this.payType + "'";
        }
        return " ";
    }

    protected void setPayType(String payType) {
        try {
            this.payType = null;
            HashSet<String> numberSet = new HashSet<String>();
            EntityViewInfo ev = null;
            if (StringUtil.isEmpty((String)payType)) {
                return;
            }
            numberSet.add(payType);
            if (numberSet != null) {
                ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
            }
            if (ev == null) {
                return;
            }
            Context ctx = this.contextProvider.getServerContext();
            IPaymentType iPaymentType = null;
            iPaymentType = ctx == null ? PaymentTypeFactory.getRemoteInstance() : PaymentTypeFactory.getLocalInstance((Context)ctx);
            PaymentTypeInfo paymentTypeInfo = iPaymentType.getPaymentTypeCollection(ev).get(0);
            if (paymentTypeInfo.getId() != null) {
                this.payType = paymentTypeInfo.getId().toString();
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
    }

    @Override
    protected int setFixedSqlParams(PreparedStatement pstmt, ARAPGetAmountParamBean paramBean, int paramIndex) throws SQLException {
        if (paramBean == null) {
            return 0;
        }
        ArOtherBillParamBean paramsBean = (ArOtherBillParamBean)paramBean;
        pstmt.setTimestamp(paramIndex++, paramsBean.getStartTime());
        Timestamp endTime = SCMUtils.getDayStartTime((Date)DateUtil.getAfterDay((Date)paramsBean.getEndTime()));
        pstmt.setTimestamp(paramIndex++, endTime);
        return paramIndex;
    }

    protected String getAsstActTypeId() {
        if (!StringUtil.isEmpty((String)this.asstActTypeId)) {
            return " and bill.fasstActTypeId = '" + this.asstActTypeId + "'";
        }
        return " ";
    }

    protected void setAsstActTypeId(String number) {
        try {
            this.asstActTypeInfo = null;
            this.asstActTypeId = "";
            HashSet<String> numberSet = new HashSet<String>();
            EntityViewInfo ev = null;
            if (StringUtil.isEmpty((String)number)) {
                return;
            }
            numberSet.add(number);
            if (numberSet != null) {
                ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
            }
            if (ev == null) {
                return;
            }
            IAsstActType iAsstActType = null;
            Context ctx = this.contextProvider.getServerContext();
            iAsstActType = ctx == null ? AsstActTypeFactory.getRemoteInstance() : AsstActTypeFactory.getLocalInstance((Context)ctx);
            this.asstActTypeInfo = iAsstActType.getAsstActTypeCollection(ev).get(0);
            if (this.asstActTypeInfo != null && this.asstActTypeInfo.getId() != null) {
                this.asstActTypeId = this.asstActTypeInfo.getId().toString();
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
    }

    protected String getMaterialGroupid() {
        if (this.materialGroup != null && this.materialGroup.trim().length() > 0) {
            return " and MGD.FMATERIALGROUPID in (" + this.materialGroup + ")";
        }
        return " ";
    }

    protected void setMaterialGroupid(Context ctx, String longNumber) {
        this.materialGroup = null;
        if (StringUtil.isEmpty((String)longNumber)) {
            return;
        }
        StringBuffer str = new StringBuffer();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String[] longNumberArray = longNumber.split(";");
        if (longNumberArray.length > 1) {
            String materialGroupId = longNumberArray[1];
            this.materialGroup = "'" + materialGroupId + "'";
            return;
        }
        if (!StringUtil.isEmpty((String)longNumber)) {
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longNumber + "!%"), CompareType.LIKE));
            filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longNumber, CompareType.EQUALS));
            filter.setMaskString("#0 or #1");
            viewInfo.setFilter(filter);
        }
        MaterialGroupCollection col = null;
        try {
            IMaterialGroup iMaterialGroup = null;
            iMaterialGroup = ctx == null ? MaterialGroupFactory.getRemoteInstance() : MaterialGroupFactory.getLocalInstance((Context)ctx);
            col = iMaterialGroup.getMaterialGroupCollection(viewInfo);
            if (col != null) {
                for (int i = 0; i < col.size(); ++i) {
                    if (i != col.size() - 1) {
                        str.append("'" + col.get(i).getId() + "',");
                        continue;
                    }
                    str.append("'" + col.get(i).getId() + "'");
                }
            }
        }
        catch (BOSException e1) {
            Logger.error((Throwable)e1);
        }
        this.materialGroup = str.toString();
    }

    protected void setCurrencyId(String currencyNumber) {
        try {
            this.currency = null;
            HashSet<String> numberSet = new HashSet<String>();
            EntityViewInfo ev = null;
            if (StringUtil.isEmpty((String)currencyNumber)) {
                return;
            }
            numberSet.add(currencyNumber);
            if (numberSet != null) {
                ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
            }
            if (ev == null) {
                return;
            }
            Context ctx = this.contextProvider.getServerContext();
            ICurrency iCurrency = null;
            iCurrency = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
            CurrencyInfo currencyInfo = iCurrency.getCurrencyCollection(ev).get(0);
            if (currencyInfo.getId() != null) {
                this.currency = currencyInfo.getId().toString();
            }
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
    }

    protected String getCurrencyId() {
        if (this.currency != null && this.currency.trim().length() > 0) {
            return " and currency.fid  = '" + this.currency + "'";
        }
        return " ";
    }

    @Override
    protected String getHeadTableName() {
        return "T_AR_OTHERBILL";
    }

    @Override
    protected String getDetailTableName() {
        return "T_AR_OTHERBILLENTRY";
    }

    @Override
    protected String[] getCanMutiSelect() {
        return this.canMutiSelect;
    }

    @Override
    protected String[] getCanMutiSelectSplit() {
        return this.canMutiSelectSplit;
    }

    protected String getBillType() {
        return this.billType;
    }

    protected void setBillType(String billType) {
        this.billType = billType;
    }

    @Override
    protected String getReturnField() {
        return this.returnField.trim();
    }

    protected void setReturnField(String returnField) {
        this.returnField = returnField;
    }

    protected String getReturnType() {
        return this.returnType;
    }

    protected void setReturnType(String returnType) {
        this.returnType = returnType;
    }

    private String getCompany(int group) {
        if (AcctReceivableAmountBatchCalculater.checkBit(group, 0)) {
            return " and company.Fid = ? ";
        }
        return "";
    }

    private String getSaleOrg(int group) {
        if (AcctReceivableAmountBatchCalculater.checkBit(group, 1)) {
            return " and sale.Fid = ? ";
        }
        return "";
    }

    protected String getAdminOrgUnit(int group) {
        if (AcctReceivableAmountBatchCalculater.checkBit(group, 2)) {
            return " and admin.Fid = ? ";
        }
        return "";
    }

    protected String getPerson(int group) {
        if (AcctReceivableAmountBatchCalculater.checkBit(group, 3)) {
            return " and person.Fid = ? ";
        }
        return "";
    }

    protected String getMaterial(int group) {
        if (AcctReceivableAmountBatchCalculater.checkBit(group, 4)) {
            return " and material.Fid = ? ";
        }
        return "";
    }

    protected String getAsstActId(int group) {
        if (AcctReceivableAmountBatchCalculater.checkBit(group, 5)) {
            return " and AsstAct.Fid = ? ";
        }
        return "";
    }

    protected void setAsstActGroup(Context ctx, String asstActGroup) {
        String groupTable = null;
        if (this.asstActTypeInfo != null) {
            groupTable = this.asstActTypeInfo.getGroupTableName();
        }
        try {
            this.asstActGroup = ARAPReportBatchUtils.getAsstActGroupIDByNumber(ctx, asstActGroup, groupTable, this.asstActTypeInfo);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    protected String getAsstActGroup() {
        if (!StringUtil.isEmpty((String)this.asstActGroup) || this.asstActGroup != null) {
            return " and AsstActGroup.fid = '" + this.asstActGroup + "'";
        }
        return " ";
    }

    protected void setExpenseItemId(String expenseItemNumber) {
        try {
            this.expenseItem = null;
            HashSet<String> numberSet = new HashSet<String>();
            EntityViewInfo ev = null;
            if (StringUtil.isEmpty((String)expenseItemNumber)) {
                return;
            }
            String[] arr = expenseItemNumber.split(";");
            int len = arr.length;
            for (int i = 0; i < len; ++i) {
                numberSet.add(arr[i]);
            }
            if (numberSet != null) {
                ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
            }
            if (ev == null) {
                return;
            }
            Context ctx = this.contextProvider.getServerContext();
            IExpenseType iExpenseItem = null;
            iExpenseItem = ctx == null ? ExpenseTypeFactory.getRemoteInstance() : ExpenseTypeFactory.getLocalInstance((Context)ctx);
            ExpenseTypeCollection col = iExpenseItem.getExpenseTypeCollection(ev);
            StringBuffer str = new StringBuffer();
            if (col != null) {
                for (int i = 0; i < col.size(); ++i) {
                    if (i != col.size() - 1) {
                        str.append("'" + col.get(i).getId() + "',");
                        continue;
                    }
                    str.append("'" + col.get(i).getId() + "'");
                }
            }
            this.expenseItem = str.toString();
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
    }

    protected String getExpenseItemId() {
        if (!StringUtil.isEmpty((String)this.expenseItem)) {
            return " and Entry.FExpenseItemID in(" + this.expenseItem + ")";
        }
        return " ";
    }
}

