/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.rptformula.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.BankCollection;
import com.kingdee.eas.basedata.assistant.BankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.IBank;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IPeriod;
import com.kingdee.eas.basedata.assistant.ISettlementType;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeCollection;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.IGeneralAsstActType;
import com.kingdee.eas.basedata.master.cssp.CSSPGroupFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICSSPGroup;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.ISupplier;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMaterialGroup;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupCollection;
import com.kingdee.eas.basedata.master.material.MaterialGroupFactory;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.util.StringUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.basedata.org.IProfitCenterOrgUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.ProfitCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeCollection;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.IBizType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.ar.util.ListUtil;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.arap.rptformula.parambean.ARAPGetAmountParamBean;
import com.kingdee.eas.fi.arap.rptformula.parambean.AcctCollectionParamBean;
import com.kingdee.eas.fi.arap.rptformula.parambean.AcctPaymentParamBean;
import com.kingdee.eas.fi.arap.rptformula.parambean.ApOtherBillParamBean;
import com.kingdee.eas.fi.arap.rptformula.parambean.ArAgingBalanceParamBean;
import com.kingdee.eas.fi.arap.rptformula.parambean.ArOtherBillParamBean;
import com.kingdee.eas.fi.arap.util.ArApBillHelper;
import com.kingdee.eas.fi.cas.IPaymentBillType;
import com.kingdee.eas.fi.cas.IReceivingBillType;
import com.kingdee.eas.fi.cas.PaymentBillTypeCollection;
import com.kingdee.eas.fi.cas.PaymentBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeCollection;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.rpt.util.ReportVariables;
import com.kingdee.eas.fm.fs.IInnerAccount;
import com.kingdee.eas.fm.fs.ISettBizType;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountFactory;
import com.kingdee.eas.fm.fs.SettBizTypeCollection;
import com.kingdee.eas.fm.fs.SettBizTypeFactory;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ARAPReportBatchUtils {
    private static final Integer CUSTOM_TYPE = 1;
    private static final Integer SUPPLIER_TYPE = 2;
    private static final Integer COMMON_TYPE = 0;

    private ARAPReportBatchUtils() {
    }

    public static void reviseArOtherBillParameters(Context ctx, ArOtherBillParamBean paramBean, String sheetName, ReportVariables reportVariables, IReportPropertyAdapter adapter) throws EASBizException, BOSException {
        if (sheetName == null || adapter == null) {
            return;
        }
        String company = paramBean.getCompany();
        String currency = paramBean.getCurrency();
        Timestamp startTime = paramBean.getStartTime();
        Timestamp endTime = paramBean.getEndTime();
        try {
            if (endTime == null) {
                endTime = ArApBillHelper.getServerDate();
            }
            if (startTime != null) {
                startTime.setHours(0);
                startTime.setMinutes(0);
                startTime.setSeconds(0);
                startTime.setNanos(0);
            }
            if (endTime != null) {
                endTime.setHours(23);
                endTime.setMinutes(59);
                endTime.setSeconds(59);
                endTime.setNanos(999999999);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String _companyNumber = (String)adapter.getReportProperty("Company.Number");
        Integer _sourceType = (Integer)adapter.getReportProperty("Report.SourceType");
        if (StringUtils.isEmpty((String)company) && _companyNumber != null) {
            if (_sourceType == null) {
                company = _companyNumber;
            } else {
                switch (_sourceType) {
                    case 2: 
                    case 3: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    default: {
                        company = _companyNumber;
                    }
                }
            }
        }
        if (StringUtils.isEmpty((String)currency)) {
            if (reportVariables != null) {
                currency = reportVariables.getStringValue("Currency", sheetName);
            }
            if (StringUtils.isEmpty((String)currency)) {
                currency = (String)adapter.getReportProperty("Currency.Number");
            }
        }
        paramBean.setCompany(company);
        paramBean.setCurrency(currency);
        paramBean.setStartTime(startTime);
        paramBean.setEndTime(endTime);
    }

    public static void reviseArApBalanceParameters(Context ctx, ARAPGetAmountParamBean paramBean, String sheetName, ReportVariables reportVariables, IReportPropertyAdapter adapter) throws EASBizException, BOSException {
        if (sheetName == null || adapter == null) {
            return;
        }
        String company = paramBean.getCompany();
        String currency = paramBean.getCurrency();
        String _companyNumber = (String)adapter.getReportProperty("Company.Number");
        Integer _sourceType = (Integer)adapter.getReportProperty("Report.SourceType");
        if (StringUtils.isEmpty((String)company) && _companyNumber != null) {
            if (_sourceType == null) {
                company = _companyNumber;
            } else {
                switch (_sourceType) {
                    case 2: 
                    case 3: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    default: {
                        company = _companyNumber;
                    }
                }
            }
        }
        if (StringUtils.isEmpty((String)currency)) {
            if (reportVariables != null) {
                currency = reportVariables.getStringValue("Currency", sheetName);
            }
            if (StringUtils.isEmpty((String)currency)) {
                currency = (String)adapter.getReportProperty("Currency.Number");
            }
        }
        paramBean.setCompany(company);
        paramBean.setCurrency(currency);
    }

    public static void reviseApOtherBillParameters(Context ctx, ApOtherBillParamBean paramBean, String sheetName, ReportVariables reportVariables, IReportPropertyAdapter adapter) throws EASBizException, BOSException {
        if (sheetName == null || adapter == null) {
            return;
        }
        String company = paramBean.getCompany();
        String currency = paramBean.getCurrency();
        Timestamp startTime = paramBean.getStartTime();
        Timestamp endTime = paramBean.getEndTime();
        try {
            if (endTime == null) {
                Calendar cal = Calendar.getInstance();
                endTime = new Timestamp(cal.getTimeInMillis());
            }
            if (startTime != null) {
                startTime.setHours(0);
                startTime.setMinutes(0);
                startTime.setSeconds(0);
                startTime.setNanos(0);
            }
            if (endTime != null) {
                endTime.setHours(23);
                endTime.setMinutes(59);
                endTime.setSeconds(59);
                endTime.setNanos(999999999);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String _companyNumber = (String)adapter.getReportProperty("Company.Number");
        Integer _sourceType = (Integer)adapter.getReportProperty("Report.SourceType");
        if (StringUtils.isEmpty((String)company) && _companyNumber != null) {
            if (_sourceType == null) {
                company = _companyNumber;
            } else {
                switch (_sourceType) {
                    case 2: 
                    case 3: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    default: {
                        company = _companyNumber;
                    }
                }
            }
        }
        if (StringUtils.isEmpty((String)currency)) {
            if (reportVariables != null) {
                currency = reportVariables.getStringValue("Currency", sheetName);
            }
            if (StringUtils.isEmpty((String)currency)) {
                currency = (String)adapter.getReportProperty("Currency.Number");
            }
        }
        paramBean.setCompany(company);
        paramBean.setCurrency(currency);
    }

    public static void reviseAcctPaymentParameters(Context ctx, AcctPaymentParamBean paramBean, String sheetName, ReportVariables reportVariables, IReportPropertyAdapter adapter) throws EASBizException, BOSException {
        if (sheetName == null || adapter == null) {
            return;
        }
        String company = paramBean.getCompany();
        String currency = paramBean.getCurrency();
        Timestamp startTime = paramBean.getStartTime();
        Timestamp endTime = paramBean.getEndTime();
        try {
            if (endTime == null) {
                endTime = ArApBillHelper.getServerDate();
            }
            if (startTime != null) {
                startTime.setHours(0);
                startTime.setMinutes(0);
                startTime.setSeconds(0);
                startTime.setNanos(0);
            }
            if (endTime != null) {
                endTime.setHours(23);
                endTime.setMinutes(59);
                endTime.setSeconds(59);
                endTime.setNanos(999999999);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String _companyNumber = (String)adapter.getReportProperty("Company.Number");
        Integer _sourceType = (Integer)adapter.getReportProperty("Report.SourceType");
        if (StringUtils.isEmpty((String)company) && _companyNumber != null) {
            if (_sourceType == null) {
                company = _companyNumber;
            } else {
                switch (_sourceType) {
                    case 2: 
                    case 3: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    default: {
                        company = _companyNumber;
                    }
                }
            }
        }
        if (StringUtils.isEmpty((String)currency)) {
            if (reportVariables != null) {
                currency = reportVariables.getStringValue("Currency", sheetName);
            }
            if (StringUtils.isEmpty((String)currency)) {
                currency = (String)adapter.getReportProperty("Currency.Number");
            }
        }
        paramBean.setCompany(company);
        paramBean.setCurrency(currency);
        paramBean.setStartTime(startTime);
        paramBean.setEndTime(endTime);
    }

    public static void reviseAcctCollectionParameters(Context ctx, AcctCollectionParamBean paramBean, String sheetName, ReportVariables reportVariables, IReportPropertyAdapter adapter) throws EASBizException, BOSException {
        if (sheetName == null || adapter == null) {
            return;
        }
        String company = paramBean.getCompany();
        String currency = paramBean.getCurrency();
        Timestamp startTime = paramBean.getStartTime();
        Timestamp endTime = paramBean.getEndTime();
        try {
            if (endTime == null) {
                endTime = ArApBillHelper.getServerDate();
            }
            if (startTime != null) {
                startTime.setHours(0);
                startTime.setMinutes(0);
                startTime.setSeconds(0);
                startTime.setNanos(0);
            }
            if (endTime != null) {
                endTime.setHours(23);
                endTime.setMinutes(59);
                endTime.setSeconds(59);
                endTime.setNanos(999999999);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        String _companyNumber = (String)adapter.getReportProperty("Company.Number");
        Integer _sourceType = (Integer)adapter.getReportProperty("Report.SourceType");
        if (StringUtils.isEmpty((String)company) && _companyNumber != null) {
            if (_sourceType == null) {
                company = _companyNumber;
            } else {
                switch (_sourceType) {
                    case 2: 
                    case 3: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    default: {
                        company = _companyNumber;
                    }
                }
            }
        }
        if (StringUtils.isEmpty((String)currency)) {
            if (reportVariables != null) {
                currency = reportVariables.getStringValue("Currency", sheetName);
            }
            if (StringUtils.isEmpty((String)currency)) {
                currency = (String)adapter.getReportProperty("Currency.Number");
            }
        }
        paramBean.setCompany(company);
        paramBean.setCurrency(currency);
        paramBean.setStartTime(startTime);
        paramBean.setEndTime(endTime);
    }

    public static void reviseAcctArAgingParameters(Context ctx, ArAgingBalanceParamBean paramBean, String sheetName, ReportVariables reportVariables, IReportPropertyAdapter adapter) throws EASBizException, BOSException {
        if (sheetName == null || adapter == null) {
            return;
        }
        String company = paramBean.getCompany();
        String currency = paramBean.getCurrency();
        String _companyNumber = (String)adapter.getReportProperty("Company.Number");
        Integer _sourceType = (Integer)adapter.getReportProperty("Report.SourceType");
        if (StringUtils.isEmpty((String)company) && _companyNumber != null) {
            if (_sourceType == null) {
                company = _companyNumber;
            } else {
                switch (_sourceType) {
                    case 2: 
                    case 3: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    default: {
                        company = _companyNumber;
                    }
                }
            }
        }
        if (StringUtils.isEmpty((String)currency)) {
            if (reportVariables != null) {
                currency = reportVariables.getStringValue("Currency", sheetName);
            }
            if (StringUtils.isEmpty((String)currency)) {
                currency = (String)adapter.getReportProperty("Currency.Number");
            }
        }
        paramBean.setCompany(company);
        paramBean.setCurrency(currency);
    }

    public static Date getBeginDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static String convertToString(Collection collection, String split) {
        StringBuffer sb = new StringBuffer();
        if (split == null) {
            split = ",";
        }
        Iterator itr = collection.iterator();
        boolean hasValidValue = false;
        while (itr.hasNext()) {
            if (hasValidValue) {
                sb.append(split);
            }
            sb.append(itr.next());
            hasValidValue = true;
        }
        return sb.toString();
    }

    public static EntityViewInfo getMultiEqualEntityView(String fieldName, Set valueSet) {
        return ARAPReportBatchUtils.getMultiEqualEntityView(null, fieldName, valueSet);
    }

    public static EntityViewInfo getMultiEqualEntityView(EntityViewInfo ev, String fieldName, Set valueSet) {
        if (ev == null) {
            ev = new EntityViewInfo();
            ev.setFilter(new FilterInfo());
        } else if (ev.getFilter() == null) {
            ev.setFilter(new FilterInfo());
        }
        if (!StringUtils.isEmpty((String)fieldName) && valueSet != null && valueSet.size() > 0) {
            fieldName = fieldName.trim();
            StringBuffer maskString = new StringBuffer();
            int index = 0;
            boolean hasValidFieldValue = false;
            Iterator it = valueSet.iterator();
            while (it.hasNext()) {
                String fieldValue = it.next().toString().trim();
                if (StringUtils.isEmpty((String)fieldValue)) continue;
                ev.getFilter().getFilterItems().add(new FilterItemInfo(fieldName, (Object)fieldValue, CompareType.EQUALS));
                if (!hasValidFieldValue) {
                    maskString.append("#" + index++);
                } else {
                    maskString.append(" or #" + index++);
                }
                hasValidFieldValue = true;
            }
            if (hasValidFieldValue) {
                ev.getFilter().setMaskString(maskString.toString());
            }
        }
        return ev;
    }

    public static String getMultiEqualCondSql(String fieldName, String fieldLongValue) {
        return ARAPReportBatchUtils.getMultiEqualCondSql(fieldName, fieldLongValue, ";");
    }

    public static String getMultiEqualCondSql(String fieldName, String fieldLongValue, String splitString) {
        if (!StringUtils.isEmpty((String)fieldName) && !StringUtils.isEmpty((String)fieldLongValue)) {
            fieldName = fieldName.trim();
            fieldLongValue = fieldLongValue.trim();
            StringBuffer sql = new StringBuffer();
            if (splitString == null || splitString.length() == 0 || fieldLongValue.indexOf(splitString) < 0) {
                sql.append(" and (").append(fieldName).append(" = '").append(fieldLongValue).append("')");
            } else {
                String[] fieldValues = fieldLongValue.split(splitString);
                sql.append(" and (");
                boolean hasValidFieldValue = false;
                int n = fieldValues.length;
                for (int i = 0; i < n; ++i) {
                    String fieldValue = fieldValues[i].trim();
                    if (StringUtils.isEmpty((String)fieldValue)) continue;
                    if (!hasValidFieldValue) {
                        sql.append("(").append(fieldName).append(" = '").append(fieldValue).append("')");
                    } else {
                        sql.append(" or (").append(fieldName).append(" = '").append(fieldValue).append("')");
                    }
                    hasValidFieldValue = true;
                }
                sql.append(")");
            }
            return sql.toString();
        }
        return "";
    }

    public static String getAsstActGroupID(Context ctx, String number, String groupTable) throws BOSException {
        if (StringUtil.isEmpty((String)number) || StringUtil.isEmpty((String)groupTable)) {
            return null;
        }
        HashSet<String> numberSet = new HashSet<String>();
        numberSet.add(number);
        EntityViewInfo ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
        CoreBaseCollection ccol = null;
        String groupID = null;
        if ("T_BD_MaterialGroup".equalsIgnoreCase(groupTable)) {
            IMaterialGroup iMaterialGroup = null;
            iMaterialGroup = ctx == null ? MaterialGroupFactory.getRemoteInstance() : MaterialGroupFactory.getLocalInstance((Context)ctx);
            ccol = iMaterialGroup.getCollection(ev);
        } else if ("T_BD_CSSPGroup".equalsIgnoreCase(groupTable)) {
            ICSSPGroup iCSSPGroup = null;
            iCSSPGroup = ctx == null ? CSSPGroupFactory.getRemoteInstance() : CSSPGroupFactory.getLocalInstance((Context)ctx);
            ccol = iCSSPGroup.getCollection(ev);
        }
        for (int i = 0; ccol != null && i < ccol.size(); ++i) {
            CoreBaseInfo info = ccol.get(i);
            groupID = info.getId().toString();
        }
        return groupID;
    }

    public static String getAsstActGroupIDByNumber(Context ctx, String number, String groupTable, AsstActTypeInfo asstActTypeInfo) throws BOSException, SQLException {
        String groupID;
        block15: {
            HashSet<String> numberSet;
            String assactActRealtionData;
            block14: {
                if (StringUtil.isEmpty((String)number) || StringUtil.isEmpty((String)groupTable) || null == asstActTypeInfo) {
                    return null;
                }
                assactActRealtionData = asstActTypeInfo.getRealtionDataObject();
                EntityViewInfo ev = new EntityViewInfo();
                String[] asstActGroupArr = number.split(";");
                numberSet = new HashSet<String>();
                if (asstActGroupArr.length > 1) {
                    String asstActGroupId = asstActGroupArr[1];
                    return asstActGroupId;
                }
                numberSet.add(number);
                ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
                CoreBaseCollection ccol = null;
                groupID = null;
                if (!"T_BD_MaterialGroup".equalsIgnoreCase(groupTable)) break block14;
                IMaterialGroup iMaterialGroup = null;
                iMaterialGroup = ctx == null ? MaterialGroupFactory.getRemoteInstance() : MaterialGroupFactory.getLocalInstance((Context)ctx);
                ccol = iMaterialGroup.getCollection(ev);
                for (int i = 0; ccol != null && i < ccol.size(); ++i) {
                    CoreBaseInfo info = ccol.get(i);
                    groupID = info.getId().toString();
                }
                break block15;
            }
            if ("T_BD_CSSPGroup".equalsIgnoreCase(groupTable)) {
                Connection conn;
                ResultSet rs;
                PreparedStatement pstmt;
                block13: {
                    ArrayList<Integer> conditionRange = new ArrayList<Integer>();
                    conditionRange.add(COMMON_TYPE);
                    if ("T_BD_Customer".equalsIgnoreCase(assactActRealtionData)) {
                        conditionRange.add(CUSTOM_TYPE);
                    } else if ("T_BD_Supplier".equalsIgnoreCase(assactActRealtionData)) {
                        conditionRange.add(SUPPLIER_TYPE);
                    }
                    String sql = ARAPReportBatchUtils.getQueryCSSPGroupSql(numberSet, conditionRange);
                    pstmt = null;
                    rs = null;
                    conn = null;
                    try {
                        conn = EJBFactory.getConnection((Context)ctx);
                        pstmt = conn.prepareStatement(sql);
                        int i = 1;
                        for (Object e : numberSet) {
                            pstmt.setString(i, e.toString());
                            ++i;
                        }
                        for (Integer n : conditionRange) {
                            pstmt.setInt(i, n);
                            ++i;
                        }
                        rs = pstmt.executeQuery();
                        if (!rs.next()) break block13;
                        groupID = rs.getString(1);
                    }
                    catch (SQLException e) {
                        try {
                            throw e;
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                            throw throwable;
                        }
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            }
        }
        return groupID;
    }

    public static String getAsstActGroupLongNumber(Context ctx, String number, String groupTable, AsstActTypeInfo asstActTypeInfo) throws BOSException, SQLException {
        String groupNumber;
        block14: {
            HashSet<String> numberSet;
            String assactActRealtionData;
            block13: {
                if (StringUtil.isEmpty((String)number) || StringUtil.isEmpty((String)groupTable) || null == asstActTypeInfo) {
                    return null;
                }
                assactActRealtionData = asstActTypeInfo.getRealtionDataObject();
                numberSet = new HashSet<String>();
                numberSet.add(number);
                EntityViewInfo ev = ARAPReportBatchUtils.getMultiEqualEntityView("number", numberSet);
                CoreBaseCollection ccol = null;
                groupNumber = null;
                if (!"T_BD_MaterialGroup".equalsIgnoreCase(groupTable)) break block13;
                IMaterialGroup iMaterialGroup = null;
                iMaterialGroup = ctx == null ? MaterialGroupFactory.getRemoteInstance() : MaterialGroupFactory.getLocalInstance((Context)ctx);
                ccol = iMaterialGroup.getCollection(ev);
                for (int i = 0; ccol != null && i < ccol.size(); ++i) {
                    MaterialGroupInfo info = (MaterialGroupInfo)ccol.get(i);
                    groupNumber = info.getLongNumber();
                }
                break block14;
            }
            if ("T_BD_CSSPGroup".equalsIgnoreCase(groupTable)) {
                Connection conn;
                ResultSet rs;
                PreparedStatement pstmt;
                block12: {
                    ArrayList<Integer> conditionRange = new ArrayList<Integer>();
                    conditionRange.add(COMMON_TYPE);
                    if ("T_BD_Customer".equalsIgnoreCase(assactActRealtionData)) {
                        conditionRange.add(CUSTOM_TYPE);
                    } else if ("T_BD_Supplier".equalsIgnoreCase(assactActRealtionData)) {
                        conditionRange.add(SUPPLIER_TYPE);
                    }
                    String sql = ARAPReportBatchUtils.getQueryCSSPGroupSql(numberSet, conditionRange);
                    pstmt = null;
                    rs = null;
                    conn = null;
                    try {
                        conn = EJBFactory.getConnection((Context)ctx);
                        pstmt = conn.prepareStatement(sql);
                        int i = 1;
                        for (Object e : numberSet) {
                            pstmt.setString(i, e.toString());
                            ++i;
                        }
                        for (Integer n : conditionRange) {
                            pstmt.setInt(i, n);
                            ++i;
                        }
                        pstmt.addBatch();
                        rs = pstmt.executeQuery();
                        if (!rs.next()) break block12;
                        groupNumber = rs.getString("FLONGNUMBER");
                    }
                    catch (SQLException e) {
                        try {
                            throw e;
                        }
                        catch (Throwable throwable) {
                            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                            throw throwable;
                        }
                    }
                }
                SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            }
        }
        return groupNumber;
    }

    public static String getAsstActGroupSql(AsstActTypeInfo type, String hasAsstGroup) {
        String temp = null;
        if (type == null) {
            return " ";
        }
        if (StringUtil.isEmpty((String)type.getRealtionDataObject())) {
            return " ";
        }
        if (StringUtil.isEmpty((String)type.getGroupTableName()) || StringUtil.isEmpty((String)type.getGroupMappingFieldName())) {
            return " ";
        }
        if (StringUtil.isEmpty((String)hasAsstGroup)) {
            temp = " left join " + type.getGroupTableName() + " AsstActGroup on AsstActGroup.fid = AsstAct." + type.getGroupMappingFieldName().trim() + " ";
            return temp;
        }
        String tableName = "";
        String asstFieldName = "";
        String groupFieldName = "";
        if ("T_BD_Material".equals(type.getRealtionDataObject())) {
            tableName = "T_BD_MaterialGroupDetial";
            asstFieldName = "FMATERIALID";
            groupFieldName = "FMATERIALGROUPID";
        } else if ("T_BD_Customer".equals(type.getRealtionDataObject())) {
            tableName = "T_BD_CustomerGroupDetail";
            asstFieldName = "FCUSTOMERID";
            groupFieldName = "FCUSTOMERGROUPID";
        } else if ("T_BD_Supplier".equals(type.getRealtionDataObject())) {
            tableName = "t_bd_SupplierGroupDetail";
            asstFieldName = "FSUPPLIERID";
            groupFieldName = "FSUPPLIERGROUPID";
        }
        if ("".equals(tableName.trim())) {
            return " ";
        }
        temp = " left join " + tableName + " AsstActGroupDetail on AsstActGroupDetail." + asstFieldName + " = AsstAct.fid ";
        temp = temp + " left join " + type.getGroupTableName() + " AsstActGroup on AsstActGroupDetail." + groupFieldName + " = AsstActGroup.fid ";
        return temp;
    }

    private static String getQueryCSSPGroupSql(HashSet numberSet, List<Integer> conditionRange) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT CSSPGROUP.FID,CSSPGROUP.FLONGNUMBER");
        sql.append("  FROM T_BD_CSSPGROUP CSSPGROUP ");
        sql.append(" INNER JOIN T_BD_CSSPGROUPSTANDARD GROUPSTA");
        sql.append(" ON CSSPGROUP.FCSSPGROUPSTANDARDID = GROUPSTA.FID");
        sql.append(" WHERE CSSPGROUP.FNUMBER IN (" + ListUtil.transList2PreparedString(numberSet) + ")");
        sql.append(" AND GROUPSTA.FTYPE IN (" + ListUtil.transList2PreparedString(conditionRange) + ")");
        return sql.toString();
    }

    public static DataBaseInfo getAsstActTypeCollection(Context ctx, AsstActTypeInfo asstActTypeInfo, EntityViewInfo ev) throws BOSException {
        CustomerInfo info = null;
        if (null == asstActTypeInfo) {
            return null;
        }
        if ("T_BD_Customer".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            info = ARAPReportBatchUtils.getCustomerCollection(ctx, ev).get(0);
        } else if ("T_BD_Supplier".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            info = ARAPReportBatchUtils.getSupplierCollection(ctx, ev).get(0);
        } else if ("T_BD_Material".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            info = ARAPReportBatchUtils.getMaterialCollection(ctx, ev).get(0);
        } else if ("T_BD_AccountBanks".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            info = ARAPReportBatchUtils.getAccountBankCollection(ctx, ev).get(0);
        } else if ("T_BD_Person".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            info = ARAPReportBatchUtils.getPersonCollection(ctx, ev).get(0);
        } else if ("T_ORG_Company".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            info = ARAPReportBatchUtils.getCompanyOrgUnitCollection(ctx, ev).get(0);
        } else if ("T_ORG_CostCenter".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            info = ARAPReportBatchUtils.getCostCenterOrgUnitCollection(ctx, ev).get(0);
        } else if ("T_ORG_Admin".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            info = ARAPReportBatchUtils.getAdminOrgUnitCollection(ctx, ev).get(0);
        } else if ("T_ORG_Purchase".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            info = ARAPReportBatchUtils.getPurchaseOrgUnitCollection(ctx, ev).get(0);
        } else if ("T_ORG_Storage".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            info = ARAPReportBatchUtils.getStorageOrgUnitCollection(ctx, ev).get(0);
        } else if ("T_ORG_Sale".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            info = ARAPReportBatchUtils.getSaleOrgUnitCollection(ctx, ev).get(0);
        } else if ("T_ORG_ProfitCenter".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            info = ARAPReportBatchUtils.getProfitCenterOrgUnitCollection(ctx, ev).get(0);
        } else if ("T_BD_GeneralAsstActType".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            info = ARAPReportBatchUtils.getGeneralAsstActTypeCollection(ctx, ev).get(0);
        } else if ("T_BD_Bank".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            info = ARAPReportBatchUtils.getBank(ctx, ev).get(0);
        }
        if (info != null) {
            return info;
        }
        return null;
    }

    public static DataBaseCollection getAsstActCollection(Context ctx, AsstActTypeInfo asstActTypeInfo, EntityViewInfo ev) throws BOSException {
        DataBaseCollection coll = new DataBaseCollection();
        if ("T_BD_Customer".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            coll.addObjectCollection((IObjectCollection)ARAPReportBatchUtils.getCustomerCollection(ctx, ev));
        } else if ("T_BD_Supplier".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            coll.addObjectCollection((IObjectCollection)ARAPReportBatchUtils.getSupplierCollection(ctx, ev));
        } else if ("T_BD_Material".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            coll.addObjectCollection((IObjectCollection)ARAPReportBatchUtils.getMaterialCollection(ctx, ev));
        } else if ("T_BD_AccountBanks".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            coll.addObjectCollection((IObjectCollection)ARAPReportBatchUtils.getAccountBankCollection(ctx, ev));
        } else if ("T_BD_Person".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            coll.addObjectCollection((IObjectCollection)ARAPReportBatchUtils.getPersonCollection(ctx, ev));
        } else if ("T_ORG_Company".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            coll.addObjectCollection((IObjectCollection)ARAPReportBatchUtils.getCompanyOrgUnitCollection(ctx, ev));
        } else if ("T_ORG_CostCenter".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            coll.addObjectCollection((IObjectCollection)ARAPReportBatchUtils.getCostCenterOrgUnitCollection(ctx, ev));
        } else if ("T_ORG_Admin".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            coll.addObjectCollection((IObjectCollection)ARAPReportBatchUtils.getAdminOrgUnitCollection(ctx, ev));
        } else if ("T_ORG_Purchase".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            coll.addObjectCollection((IObjectCollection)ARAPReportBatchUtils.getPurchaseOrgUnitCollection(ctx, ev));
        } else if ("T_ORG_Storage".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            coll.addObjectCollection((IObjectCollection)ARAPReportBatchUtils.getStorageOrgUnitCollection(ctx, ev));
        } else if ("T_ORG_Sale".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            coll.addObjectCollection((IObjectCollection)ARAPReportBatchUtils.getSaleOrgUnitCollection(ctx, ev));
        } else if ("T_ORG_ProfitCenter".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            coll.addObjectCollection((IObjectCollection)ARAPReportBatchUtils.getProfitCenterOrgUnitCollection(ctx, ev));
        } else if ("T_BD_GeneralAsstActType".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            coll.addObjectCollection((IObjectCollection)ARAPReportBatchUtils.getGeneralAsstActTypeCollection(ctx, ev));
        } else if ("T_BD_Bank".equalsIgnoreCase(asstActTypeInfo.getRealtionDataObject())) {
            coll.addObjectCollection((IObjectCollection)ARAPReportBatchUtils.getBank(ctx, ev));
        }
        return coll;
    }

    public static PeriodInfo getPeriodByCompany(Context ctx, CompanyOrgUnitInfo info) throws BOSException, EASBizException {
        IArApBillFacade facade = null;
        facade = ctx == null ? ArApBillFacadeFactory.getRemoteInstance() : ArApBillFacadeFactory.getLocalInstance((Context)ctx);
        return facade.getCurrencyPeriod(info);
    }

    public static CompanyOrgUnitCollection getCompanyOrgUnitCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ICompanyOrgUnit company = null;
        company = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        return company.getCompanyOrgUnitCollection(ev);
    }

    public static PeriodCollection getPeriodCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IPeriod iPeriod = null;
        iPeriod = ctx == null ? PeriodFactory.getRemoteInstance() : PeriodFactory.getLocalInstance((Context)ctx);
        return iPeriod.getPeriodCollection(ev);
    }

    public static AdminOrgUnitCollection getAdminOrgUnitCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IAdminOrgUnit iAdminOrgUnit = null;
        iAdminOrgUnit = ctx == null ? AdminOrgUnitFactory.getRemoteInstance() : AdminOrgUnitFactory.getLocalInstance((Context)ctx);
        return iAdminOrgUnit.getAdminOrgUnitCollection(ev);
    }

    public static InnerAccountCollection getInnerAccountCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IInnerAccount iInnerAccount = null;
        iInnerAccount = ctx == null ? InnerAccountFactory.getRemoteInstance() : InnerAccountFactory.getLocalInstance((Context)ctx);
        return iInnerAccount.getInnerAccountCollection(ev);
    }

    public static AccountBankCollection getAccountBankCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IAccountBank iAccountBank = null;
        iAccountBank = ctx == null ? AccountBankFactory.getRemoteInstance() : AccountBankFactory.getLocalInstance((Context)ctx);
        return iAccountBank.getAccountBankCollection(ev);
    }

    public static PersonCollection getPersonCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IPerson iPerson = null;
        iPerson = ctx == null ? PersonFactory.getRemoteInstance() : PersonFactory.getLocalInstance((Context)ctx);
        return iPerson.getPersonCollection(ev);
    }

    public static CurrencyCollection getCurrencyCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ICurrency currency = null;
        currency = ctx == null ? CurrencyFactory.getRemoteInstance() : CurrencyFactory.getLocalInstance((Context)ctx);
        return currency.getCurrencyCollection(ev);
    }

    public static SaleOrgUnitCollection getSaleOrgUnitCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ISaleOrgUnit saleOrgUnit = null;
        saleOrgUnit = ctx == null ? SaleOrgUnitFactory.getRemoteInstance() : SaleOrgUnitFactory.getLocalInstance((Context)ctx);
        return saleOrgUnit.getSaleOrgUnitCollection(ev);
    }

    public static PurchaseOrgUnitCollection getPurchaseOrgUnitCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IPurchaseOrgUnit purchaseOrgUnit = null;
        purchaseOrgUnit = ctx == null ? PurchaseOrgUnitFactory.getRemoteInstance() : PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
        return purchaseOrgUnit.getPurchaseOrgUnitCollection(ev);
    }

    public static ReceivingBillTypeCollection getReceivingBillTypeCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IReceivingBillType receivingBillType = null;
        receivingBillType = ctx == null ? ReceivingBillTypeFactory.getRemoteInstance() : ReceivingBillTypeFactory.getLocalInstance((Context)ctx);
        return receivingBillType.getReceivingBillTypeCollection(ev);
    }

    public static PaymentBillTypeCollection getPaymentBillTypeCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IPaymentBillType paymentBillType = null;
        paymentBillType = ctx == null ? PaymentBillTypeFactory.getRemoteInstance() : PaymentBillTypeFactory.getLocalInstance((Context)ctx);
        return paymentBillType.getPaymentBillTypeCollection(ev);
    }

    public static SettlementTypeCollection getSettlementTypeCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ISettlementType settlementType = null;
        settlementType = ctx == null ? SettlementTypeFactory.getRemoteInstance() : SettlementTypeFactory.getLocalInstance((Context)ctx);
        return settlementType.getSettlementTypeCollection(ev);
    }

    public static SettBizTypeCollection getSettBizTypeCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ISettBizType settBizType = null;
        settBizType = ctx == null ? SettBizTypeFactory.getRemoteInstance() : SettBizTypeFactory.getLocalInstance((Context)ctx);
        return settBizType.getSettBizTypeCollection(ev);
    }

    public static MaterialCollection getMaterialCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IMaterial material = null;
        material = ctx == null ? MaterialFactory.getRemoteInstance() : MaterialFactory.getLocalInstance((Context)ctx);
        return material.getMaterialCollection(ev);
    }

    public static GeneralAsstActTypeCollection getGeneralAsstActTypeCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IGeneralAsstActType iGeneralAsstActType = null;
        iGeneralAsstActType = ctx == null ? GeneralAsstActTypeFactory.getRemoteInstance() : GeneralAsstActTypeFactory.getLocalInstance((Context)ctx);
        return iGeneralAsstActType.getGeneralAsstActTypeCollection(ev);
    }

    public static ProfitCenterOrgUnitCollection getProfitCenterOrgUnitCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IProfitCenterOrgUnit iProfitCenterOrgUnit = null;
        iProfitCenterOrgUnit = ctx == null ? ProfitCenterOrgUnitFactory.getRemoteInstance() : ProfitCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        return iProfitCenterOrgUnit.getProfitCenterOrgUnitCollection(ev);
    }

    public static CostCenterOrgUnitCollection getCostCenterOrgUnitCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ICostCenterOrgUnit iCostCenterOrgUnit = null;
        iCostCenterOrgUnit = ctx == null ? CostCenterOrgUnitFactory.getRemoteInstance() : CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
        return iCostCenterOrgUnit.getCostCenterOrgUnitCollection(ev);
    }

    public static StorageOrgUnitCollection getStorageOrgUnitCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IStorageOrgUnit storageOrgUnit = null;
        storageOrgUnit = ctx == null ? StorageOrgUnitFactory.getRemoteInstance() : StorageOrgUnitFactory.getLocalInstance((Context)ctx);
        return storageOrgUnit.getStorageOrgUnitCollection(ev);
    }

    public static CustomerCollection getCustomerCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ICustomer customer = null;
        customer = ctx == null ? CustomerFactory.getRemoteInstance() : CustomerFactory.getLocalInstance((Context)ctx);
        return customer.getCustomerCollection(ev);
    }

    public static SupplierCollection getSupplierCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        ISupplier supplier = null;
        supplier = ctx == null ? SupplierFactory.getRemoteInstance() : SupplierFactory.getLocalInstance((Context)ctx);
        return supplier.getSupplierCollection(ev);
    }

    public static BankCollection getBank(Context ctx, EntityViewInfo ev) throws BOSException {
        IBank iBank = null;
        iBank = ctx == null ? BankFactory.getRemoteInstance() : BankFactory.getLocalInstance((Context)ctx);
        return iBank.getBankCollection(ev);
    }

    public static MaterialGroupCollection getMaterialGroupCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IMaterialGroup materialGroup = null;
        materialGroup = ctx == null ? MaterialGroupFactory.getRemoteInstance() : MaterialGroupFactory.getLocalInstance((Context)ctx);
        return materialGroup.getMaterialGroupCollection(ev);
    }

    public static Map getRptAuthorizedCompany(Context ctx) throws BOSException, EASBizException {
        IPermission permission = null;
        IObjectPK userPK = null;
        if (ctx == null) {
            permission = PermissionFactory.getRemoteInstance();
            userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId());
        } else {
            permission = PermissionFactory.getLocalInstance((Context)ctx);
            userPK = ctx.getCaller();
        }
        Map authorizedCompany = permission.getAuthorizedOrgs(userPK, OrgType.Company, null, (IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.rpt.client", "RptReportProcessUI"), (IMetaDataPK)new MetaDataPK("rpt_report_calculate"));
        return authorizedCompany;
    }

    public static Timestamp convertToTime(String dateStr) {
        Date date = new Date();
        Timestamp time = new Timestamp(date.getTime());
        int v = 0;
        if (StringUtils.isEmpty((String)dateStr)) {
            return null;
        }
        String[] prop = dateStr.split("-");
        try {
            for (int i = 0; i < 3; ++i) {
                if (i == 0) {
                    time.setYear(Integer.parseInt(prop[i]) - 1900);
                    continue;
                }
                if (i == 1) {
                    v = Integer.parseInt(prop[i]);
                    time.setMonth(--v);
                    continue;
                }
                if (i != 2) continue;
                time.setDate(Integer.parseInt(prop[i]));
            }
        }
        catch (Exception e) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.arap.ArapResource", (String)"152_ARAPReportBatchUtils"));
        }
        return time;
    }

    public static int convertToInt(String intValue) {
        int value = 0;
        value = new Integer(intValue);
        return value;
    }

    public static BizTypeCollection getBizTypeCollection(Context ctx, EntityViewInfo ev) throws BOSException {
        IBizType iBizType = null;
        iBizType = ctx == null ? BizTypeFactory.getRemoteInstance() : BizTypeFactory.getLocalInstance((Context)ctx);
        return iBizType.getBizTypeCollection(ev);
    }
}

