/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ar.AbstractArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.ArApCalculateException;
import com.kingdee.eas.fi.ar.OtherBillentryFactory;
import com.kingdee.eas.fi.arap.util.CalculateCondition;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import java.math.BigDecimal;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ArApBaseCalculate {
    private static final Logger logger = CoreUIObject.getLogger(ArApBaseCalculate.class);
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final BigDecimal ONE = new BigDecimal("1.00");
    public static final BigDecimal ONEHUNDRED = new BigDecimal("100.00");
    private int qtyPrecision = 9;
    private int pricePrecision = 6;
    private int currencyPrecision = 4;
    private int baseCurrencyPrecision = 4;
    private int ratePrecision = 8;
    public static final int TAXRATE_PRECISION = 2;
    private int middlePrecision = 10;
    protected BigDecimal realPrice;
    protected BigDecimal amount;
    protected BigDecimal qty = ZERO;
    protected BigDecimal actualPrice;
    protected BigDecimal taxPrice;
    protected BigDecimal discountRate;
    protected BigDecimal recPayAmount;
    protected BigDecimal price;
    protected BigDecimal taxRate = ZERO;
    protected DiscountModeEnum discountType;
    protected BigDecimal taxAmount;
    protected BigDecimal recPayAmountLocal;
    protected BigDecimal taxAmountLocal;
    protected BigDecimal discountAmount = ZERO;
    protected BigDecimal discountAmountLocal = ZERO;
    protected BigDecimal amountLocal = ZERO;
    protected BigDecimal verifyAmount = ZERO;
    protected BigDecimal verifyAmountLocal = ZERO;
    protected BigDecimal unVerifyAmount = ZERO;
    protected BigDecimal unVerifyAmountLocal = ZERO;
    protected RowTypeInfo rowType;
    protected MeasureUnitInfo unitInfo;
    protected MeasureUnitInfo baseUnitInfo;
    protected MaterialInfo materialInfo;
    protected BigDecimal baseQty;
    protected MeasureUnitInfo assistUnitInfo;
    protected BigDecimal assistQty;
    protected CalculateCondition condition = null;
    private BigDecimal exchangeRate;
    protected Context ctx = null;
    protected boolean isRed = false;
    protected String sourceEntryID;
    protected boolean isDebitAdjustQtyZero = false;

    public ArApBaseCalculate(CalculateCondition condition) {
        this.condition = condition;
        this.exchangeRate = condition.getExchangeRate();
        this.ratePrecision = condition.getRatePrecision();
        this.middlePrecision = condition.getMiddlePrecision();
        this.pricePrecision = condition.getPricePrecision();
        this.currencyPrecision = condition.getCurrencyPrecision();
        this.baseCurrencyPrecision = condition.getBaseCurrencyPrecision();
    }

    protected void initCondition(CalculateCondition cndtn) {
        this.condition = cndtn;
        this.exchangeRate = cndtn.getExchangeRate();
        this.ratePrecision = cndtn.getRatePrecision();
        this.middlePrecision = cndtn.getMiddlePrecision();
        this.pricePrecision = cndtn.getPricePrecision();
        this.currencyPrecision = cndtn.getCurrencyPrecision();
        this.baseCurrencyPrecision = cndtn.getBaseCurrencyPrecision();
    }

    public ArApBaseCalculate(Context ctx, CalculateCondition condition) {
        this(condition);
        this.ctx = ctx;
    }

    public void execute(CalculateCondition cditn) throws EASBizException, BOSException {
        this.init();
        this.initCondition(cditn);
        try {
            this.innerCalculate(cditn);
        }
        catch (ArApCalculateException e) {
            if (this.condition.isDiscountAmountChanged()) {
                this.discountAmount = ZERO;
            } else if (this.condition.isDiscountRateChanged() || this.condition.isDiscountTypeChanged()) {
                this.discountRate = ZERO;
            } else if (this.condition.isTaxAmountChanged()) {
                this.taxAmount = ZERO;
            } else if (this.condition.isTaxPriceChanged()) {
                this.taxPrice = ZERO;
            } else if (this.condition.isPriceChanged()) {
                this.price = ZERO;
            } else if (this.condition.isAmountChanged()) {
                this.amount = ZERO;
            } else if (this.condition.isQtyChanged()) {
                this.qty = ZERO;
            } else if (this.condition.isRecPayAmountChanged()) {
                this.recPayAmount = ZERO;
            } else if (this.condition.isVerifyAmountChanged()) {
                this.verifyAmount = ZERO;
            } else if (this.condition.isVerifyAmountLocalChanged()) {
                this.verifyAmountLocal = ZERO;
            } else if (this.condition.isUnVerifyAmountChanged()) {
                this.unVerifyAmount = ZERO;
            } else if (this.condition.isUnVerifyAmountLocalChanged()) {
                this.unVerifyAmountLocal = ZERO;
            }
            this.innerCalculate(this.condition);
            this.update();
            throw new ArApCalculateException(ArApCalculateException.DATA_INVALID, new Object[]{e.getMessage()});
        }
        this.update();
    }

    public void execute4QtyOnly(CalculateCondition cditn) throws EASBizException, BOSException {
        this.init();
        this.initCondition(cditn);
        if (cditn.isMaterialBill()) {
            if (cditn.isNeedCalBaseQty()) {
                this.calBaseQty();
            }
            if (cditn.isNeedCalAsstQty()) {
                this.calAssistQty();
            }
        }
        this.update();
    }

    public void execute4Trans(CalculateCondition cditn) throws EASBizException, BOSException {
        this.init();
        this.initCondition(cditn);
        boolean isNeedCalculate = true;
        int qtyPrecision = this.qtyPrecision;
        if (cditn.isMaterialBill() && this.materialInfo != null) {
            qtyPrecision = this.getQtyPrecision(this.materialInfo, this.unitInfo.getId().toString());
        }
        if (!this.condition.isAR()) {
            AbstractArApBillEntryBaseInfo apEntryInfo = null;
            try {
                apEntryInfo = com.kingdee.eas.fi.ap.OtherBillentryFactory.getLocalInstance(this.ctx).getOtherBillentryInfo((IObjectPK)new ObjectUuidPK(this.sourceEntryID));
            }
            catch (ObjectNotFoundException e) {
                logger.error((Object)e);
            }
            if (apEntryInfo != null && apEntryInfo.getRecievePayAmount().compareTo(this.recPayAmount) == 0) {
                isNeedCalculate = false;
            }
        } else {
            AbstractArApBillEntryBaseInfo arEntryInfo = null;
            try {
                arEntryInfo = OtherBillentryFactory.getLocalInstance(this.ctx).getOtherBillentryInfo((IObjectPK)new ObjectUuidPK(this.sourceEntryID));
            }
            catch (ObjectNotFoundException e) {
                logger.error((Object)e);
            }
            if (arEntryInfo != null && arEntryInfo.getRecievePayAmount().compareTo(this.recPayAmount) == 0) {
                isNeedCalculate = false;
            }
        }
        if (!isNeedCalculate) {
            this.calActualPrice();
            this.update();
            return;
        }
        if (this.actualPrice.compareTo(ZERO) != 0) {
            this.qty = this.recPayAmount.divide(this.actualPrice, qtyPrecision, 4);
        }
        if (cditn.isMaterialBill() && this.materialInfo != null) {
            this.calBaseQty();
            this.calAssistQty();
        }
        if (cditn.isInTax()) {
            this.calTaxAmount();
            this.calAmount();
        } else {
            this.calAmount();
            this.taxAmount = this.recPayAmount.subtract(this.amount);
            this.taxAmountLocal = this.recPayAmountLocal.subtract(this.amountLocal);
        }
        this.calDiscountAmount();
        this.calUnVerifyAmount();
        this.update();
    }

    public void execute4QuickInput(CalculateCondition cditn) {
        this.init();
        this.initCondition(cditn);
        this.calActualPrice();
        this.calRealPrice();
        this.afterUpdateData();
    }

    public void execute4Split(CalculateCondition cditn) throws EASBizException, BOSException {
        this.init();
        this.initCondition(cditn);
        if (cditn.isMaterialBill()) {
            this.calQty();
            if (cditn.isNeedCalAsstQty()) {
                this.calAssistQty();
            }
        }
        if (cditn.isPresent()) {
            this.taxPrice = ZERO;
            this.price = ZERO;
            this.discountType = DiscountModeEnum.NULL;
            this.discountRate = ZERO;
        }
        this.amount = this.calAmount_reverse(this.amountLocal);
        if (!this.condition.isPriceWithoutTax() && this.condition.isInTax()) {
            if (ONE.subtract(ArApBaseCalculate.calRate(this.taxRate, 2)).compareTo(ZERO) != 0) {
                this.taxAmount = this.amount.multiply(ArApBaseCalculate.calRate(this.taxRate, 2)).divide(ONE.subtract(ArApBaseCalculate.calRate(this.taxRate, 2)), this.currencyPrecision, 4);
                this.taxAmountLocal = this.amountLocal.multiply(ArApBaseCalculate.calRate(this.taxRate, 2)).divide(ONE.subtract(ArApBaseCalculate.calRate(this.taxRate, 2)), this.baseCurrencyPrecision, 4);
            }
        } else {
            this.taxAmount = this.amount.multiply(ArApBaseCalculate.calRate(this.taxRate, 2)).setScale(this.currencyPrecision, 4);
            this.taxAmountLocal = this.amountLocal.multiply(ArApBaseCalculate.calRate(this.taxRate, 2)).setScale(this.baseCurrencyPrecision, 4);
        }
        this.recPayAmount = this.amount.add(this.taxAmount);
        this.recPayAmountLocal = this.amountLocal.add(this.taxAmountLocal);
        this.calDiscountAmount();
        this.update();
    }

    public void execute4BizBill(CalculateCondition cditn) throws EASBizException, BOSException {
        this.init();
        this.initCondition(cditn);
        if (cditn.isMaterialBill()) {
            this.calQty();
            if (cditn.isNeedCalAsstQty()) {
                this.calAssistQty();
            }
        }
        if (cditn.isPresent()) {
            this.taxPrice = ZERO;
            this.price = ZERO;
            this.discountType = DiscountModeEnum.NULL;
            this.discountRate = ZERO;
        }
        if (cditn.isBillRelation()) {
            this.discountAmountLocal = this.calLocalAmount(this.discountAmount);
            this.update();
            return;
        }
        this.taxAmount = this.recPayAmount.subtract(this.amount);
        this.taxAmountLocal = this.recPayAmountLocal.subtract(this.amountLocal);
        if (cditn.isMaterialBill()) {
            if (DiscountModeEnum.PERCENT.equals((Object)this.discountType)) {
                if (this.qty.compareTo(ZERO) != 0 && ONE.subtract(ArApBaseCalculate.calRate(this.discountRate, this.ratePrecision)).compareTo(ZERO) != 0) {
                    this.taxPrice = this.recPayAmount.divide(this.qty, this.pricePrecision, 4).divide(ONE.subtract(ArApBaseCalculate.calRate(this.discountRate, this.ratePrecision)), this.pricePrecision, 4);
                    this.price = this.amount.divide(this.qty, this.pricePrecision, 4).divide(ONE.subtract(ArApBaseCalculate.calRate(this.discountRate, this.ratePrecision)), this.pricePrecision, 4);
                }
            } else if (this.qty.compareTo(ZERO) != 0) {
                this.taxPrice = this.recPayAmount.divide(this.qty, this.pricePrecision, 4).add(this.discountRate);
                this.price = this.amount.divide(this.qty, this.pricePrecision, 4).add(this.discountRate);
            }
            this.calActualPrice();
            this.calRealPrice();
            this.calDiscountAmount();
        }
        this.calRecPayAmount();
        this.update();
    }

    protected void innerCalculate(CalculateCondition cditn) throws ArApCalculateException, EASBizException, BOSException {
        if (cditn.isPriceChanged()) {
            this.taxPrice = this.price.multiply(ONE.add(ArApBaseCalculate.calRate(this.taxRate, 2))).setScale(this.pricePrecision, 4);
        } else if (cditn.isTaxPriceChanged()) {
            if (this.condition.isPriceWithoutTax()) {
                if (ONE.add(ArApBaseCalculate.calRate(this.taxRate, 2)).compareTo(ZERO) != 0) {
                    this.price = this.taxPrice.divide(ONE.add(ArApBaseCalculate.calRate(this.taxRate, 2)), this.pricePrecision, 4);
                }
            } else {
                this.price = this.taxPrice.multiply(ONE.subtract(ArApBaseCalculate.calRate(this.taxRate, 2))).setScale(this.pricePrecision, 4);
            }
        }
        if (!this.simpleCalculate(cditn)) {
            return;
        }
        if (cditn.isNeedCalQty()) {
            this.calQty();
        }
        if (cditn.isNeedCalAsstQty()) {
            this.calAssistQty();
        }
        if (cditn.isNeedCalBaseQty()) {
            this.calBaseQty();
            if (!cditn.isMaterialBill()) {
                this.baseQty = this.qty;
            }
        }
        if (cditn.isPresent()) {
            this.taxPrice = ZERO;
            this.price = ZERO;
            this.discountType = DiscountModeEnum.NULL;
            this.discountRate = ZERO;
        }
        if (cditn.isBillRelation()) {
            this.discountAmountLocal = this.calLocalAmount(this.discountAmount);
            return;
        }
        if (cditn.isInTax()) {
            if (this.condition.isDiscountAmountChanged()) {
                this.calDiscountRate();
                this.discountAmountLocal = this.calLocalAmount(this.discountAmount);
            }
            this.calRecPayAmount();
            if (cditn.isRecPayAmountChanged()) {
                BigDecimal amt;
                BigDecimal bigDecimal = amt = this.isRed ? this.recPayAmount.multiply(new BigDecimal("-1")) : this.recPayAmount;
                if (amt.multiply(this.discountAmount).compareTo(ZERO) < 0 && amt.abs().compareTo(this.discountAmount.abs()) < 0) {
                    throw new ArApCalculateException(ArApCalculateException.RECPAYAMOUNT_INVALID, new String[]{amt.toString()});
                }
                if (!cditn.isReversedExpenseBill()) {
                    this.calTaxPrice();
                } else {
                    this.calEntryQty();
                }
            }
            if (cditn.isTaxAmountChanged()) {
                this.taxAmountLocal = this.calLocalAmount(this.taxAmount);
            } else {
                this.calTaxAmount();
            }
            this.calAmount();
            if (!cditn.isReversedExpenseBill()) {
                this.calPrice();
            }
            if (!cditn.isActualPriceChanged() && !cditn.isReversedExpenseBill()) {
                this.calActualPrice();
            }
            if (!cditn.isReversedExpenseBill()) {
                this.calRealPrice();
            }
            this.calDiscountAmount();
        } else {
            if (cditn.isAmountChanged()) {
                BigDecimal amt;
                BigDecimal bigDecimal = amt = this.isRed ? this.amount.multiply(new BigDecimal("-1")) : this.amount;
                if (amt.multiply(this.discountAmount).compareTo(ZERO) < 0 && amt.abs().compareTo(this.discountAmount.abs()) < 0) {
                    throw new ArApCalculateException(ArApCalculateException.AMOUNT_INVALID, new String[]{amt.toString()});
                }
                this.amountLocal = this.calLocalAmount(this.amount);
                if (!cditn.isReversedExpenseBill()) {
                    this.calPrice();
                } else {
                    this.calEntryQty();
                }
            }
            if (!cditn.isReversedExpenseBill()) {
                this.calTaxPrice();
            }
            this.calDiscountRate();
            this.calDiscountAmount();
            if (!cditn.isAmountChanged()) {
                this.calAmount();
            }
            if (cditn.isTaxAmountChanged()) {
                this.taxAmountLocal = this.calLocalAmount(this.taxAmount);
            } else {
                this.calTaxAmount();
            }
            this.calRecPayAmount();
            if (!cditn.isRealPriceChanged() && !cditn.isReversedExpenseBill()) {
                this.calRealPrice();
            }
            if (!cditn.isReversedExpenseBill()) {
                this.calActualPrice();
            }
        }
        this.calOthers();
    }

    protected boolean simpleCalculate(CalculateCondition cditn) throws ArApCalculateException {
        if (cditn.isTaxAmountChanged()) {
            this.taxAmountLocal = this.calLocalAmount(this.taxAmount);
            if (cditn.isInTax()) {
                this.calAmount();
            } else {
                this.calRecPayAmount();
            }
        } else if (cditn.isVerifyAmountChanged()) {
            this.verifyAmountLocal = this.calLocalAmount(this.verifyAmount);
            this.calUnVerifyAmount();
        } else if (cditn.isVerifyAmountLocalChanged()) {
            this.calUnVerifyAmount();
        } else if (cditn.isUnVerifyAmountChanged()) {
            this.unVerifyAmountLocal = this.calLocalAmount(this.unVerifyAmount);
            this.calVerifyAmount();
        } else if (cditn.isUnVerifyAmountLocalChanged()) {
            this.calVerifyAmount();
        } else {
            return true;
        }
        return false;
    }

    public BigDecimal calRealPrice() {
        if (this.condition.isPresent()) {
            this.realPrice = ZERO;
            return this.realPrice;
        }
        if (this.discountRate.compareTo(ZERO) == 0) {
            this.realPrice = this.price;
        } else if (this.qty.compareTo(ZERO) != 0) {
            this.realPrice = this.amount.divide(this.qty, this.pricePrecision, 4);
        }
        return this.realPrice;
    }

    public BigDecimal calActualPrice() {
        if (this.condition.isPresent()) {
            this.actualPrice = ZERO;
            return this.actualPrice;
        }
        if (this.discountRate.compareTo(ZERO) == 0) {
            this.actualPrice = this.taxPrice;
            return this.actualPrice;
        }
        if (this.condition.isRealPriceChanged()) {
            this.actualPrice = this.taxPrice.multiply(ONE.subtract(ArApBaseCalculate.calRate(this.discountRate, this.ratePrecision))).setScale(this.pricePrecision, 4);
        } else if (ZERO.compareTo(this.qty) != 0) {
            this.actualPrice = this.recPayAmount.divide(this.qty, this.pricePrecision, 4);
        }
        return this.actualPrice;
    }

    public BigDecimal calTaxPrice() {
        if (this.condition.isPresent()) {
            this.taxPrice = ZERO;
            return this.taxPrice;
        }
        if (!this.condition.isInTax()) {
            this.taxPrice = this.price.multiply(ONE.add(ArApBaseCalculate.calRate(this.taxRate, 2))).setScale(this.pricePrecision, 4);
        } else if (this.condition.isRecPayAmountChanged()) {
            if (DiscountModeEnum.PERCENT.equals((Object)this.discountType)) {
                if (ZERO.compareTo(this.qty) != 0 && ONEHUNDRED.compareTo(this.discountRate) != 0) {
                    this.taxPrice = this.recPayAmount.divide(this.qty, this.pricePrecision, 4).divide(ONE.subtract(ArApBaseCalculate.calRate(this.discountRate, this.ratePrecision)), this.pricePrecision, 4);
                }
            } else if (this.qty.compareTo(ZERO) != 0) {
                this.taxPrice = this.recPayAmount.divide(this.qty, this.pricePrecision, 4).add(this.discountRate);
            }
        }
        return this.taxPrice;
    }

    public BigDecimal calPrice() {
        if (this.condition.isPresent()) {
            this.price = ZERO;
            return this.price;
        }
        if (this.condition.isInTax()) {
            if (this.condition.isPriceWithoutTax()) {
                if (ONE.add(ArApBaseCalculate.calRate(this.taxRate, 2)).compareTo(ZERO) != 0) {
                    this.price = this.taxPrice.divide(ONE.add(ArApBaseCalculate.calRate(this.taxRate, 2)), this.pricePrecision, 4);
                }
            } else {
                this.price = this.taxPrice.multiply(ONE.subtract(ArApBaseCalculate.calRate(this.taxRate, 2))).setScale(this.pricePrecision, 4);
            }
        } else if (this.condition.isAmountChanged()) {
            if (DiscountModeEnum.PERCENT.equals((Object)this.discountType)) {
                if (this.qty.compareTo(ZERO) != 0 && ONE.subtract(ArApBaseCalculate.calRate(this.discountRate, this.ratePrecision)).compareTo(ZERO) != 0) {
                    this.price = this.amount.divide(this.qty, this.pricePrecision, 4).divide(ONE.subtract(ArApBaseCalculate.calRate(this.discountRate, this.ratePrecision)), this.pricePrecision, 4);
                }
            } else if (this.qty.compareTo(ZERO) != 0) {
                this.price = this.amount.divide(this.qty, this.pricePrecision, 4).add(this.discountRate);
            }
        }
        return this.price;
    }

    public BigDecimal calAmount() throws ArApCalculateException {
        if (this.condition.isPresent()) {
            this.amount = ZERO;
            this.amountLocal = ZERO;
            return ZERO;
        }
        if (this.condition.isInTax()) {
            this.amount = this.recPayAmount.subtract(this.taxAmount);
            this.amountLocal = this.recPayAmountLocal.subtract(this.taxAmountLocal);
        } else if (this.condition.isDiscountAmountChanged()) {
            BigDecimal discount = this.discountAmount;
            if (this.isRed) {
                discount = this.discountAmount.negate();
            }
            this.amount = this.qty.multiply(this.price).setScale(this.currencyPrecision, 4).subtract(discount.divide(ONE.add(ArApBaseCalculate.calRate(this.taxRate, 2)), this.currencyPrecision, 4));
            this.amountLocal = this.calLocalAmount(this.amount);
        } else {
            this.amount = DiscountModeEnum.PERCENT.equals((Object)this.discountType) ? this.qty.multiply(this.price).multiply(ONE.subtract(ArApBaseCalculate.calRate(this.discountRate, this.ratePrecision))).setScale(this.currencyPrecision, 4) : this.qty.multiply(this.price.subtract(this.discountRate)).setScale(this.currencyPrecision, 4);
            this.amountLocal = this.calLocalAmount(this.amount);
        }
        if (this.isRed && (this.condition.isDebitAdjust() || this.condition.isAllowanceBill())) {
            this.amount = this.amount.negate();
        }
        if (!this.condition.isDebitAdjust() && !this.condition.isAllowanceBill() && ArApBaseCalculate.isNegative(this.amount)) {
            throw new ArApCalculateException(ArApCalculateException.AMOUNT_INVALID, new Object[]{this.amount});
        }
        return this.amount;
    }

    public BigDecimal calTaxAmount() {
        if (this.condition.isPresent()) {
            this.taxAmount = ZERO;
            this.taxAmountLocal = ZERO;
            return ZERO;
        }
        if (this.condition.isPriceWithoutTax()) {
            if (this.condition.isInTax()) {
                if (ONE.add(ArApBaseCalculate.calRate(this.taxRate, 2)).compareTo(ZERO) != 0) {
                    this.taxAmount = this.recPayAmount.divide(ONE.add(ArApBaseCalculate.calRate(this.taxRate, 2)), this.middlePrecision, 4).multiply(ArApBaseCalculate.calRate(this.taxRate, 2)).setScale(this.currencyPrecision, 4);
                }
            } else {
                this.taxAmount = this.amount.multiply(ArApBaseCalculate.calRate(this.taxRate, 2)).setScale(this.currencyPrecision, 4);
            }
        } else {
            this.taxAmount = this.recPayAmount.multiply(ArApBaseCalculate.calRate(this.taxRate, 2)).setScale(this.currencyPrecision, 4);
        }
        if (!(this.condition.isFxEnabled() && (this.condition.isRecPayAmountLocalChanged() || this.condition.isAmountLocalChanged() || this.condition.isTaxAmountLocalChanged() || this.condition.isDiscountAmountLocalChanged()))) {
            this.taxAmountLocal = this.calLocalAmount(this.taxAmount);
        }
        return this.taxAmount;
    }

    public BigDecimal calDiscountAmount() {
        if (this.condition.isPresent()) {
            this.discountType = DiscountModeEnum.NULL;
            this.discountRate = ZERO;
            this.discountAmount = ZERO;
            this.discountAmountLocal = ZERO;
            return ZERO;
        }
        if (this.condition.isDiscountAmountChanged()) {
            this.discountAmountLocal = this.calLocalAmount(this.discountAmount);
            return this.discountAmount;
        }
        this.discountAmount = this.condition.isRealPriceChanged() || DiscountModeEnum.PERCENT.equals((Object)this.discountType) ? this.taxPrice.multiply(this.qty).multiply(ArApBaseCalculate.calRate(this.discountRate, this.ratePrecision)).setScale(this.currencyPrecision, 4) : (this.condition.isInTax() ? this.discountRate.multiply(this.qty).setScale(this.currencyPrecision, 4) : this.discountRate.multiply(this.qty).multiply(ONE.add(ArApBaseCalculate.calRate(this.taxRate, 2))).setScale(this.currencyPrecision, 4));
        if (this.isRed && !this.condition.isDebitAdjust() && !this.condition.isAllowanceBill()) {
            this.discountAmount = this.discountAmount.negate();
        }
        this.discountAmountLocal = this.calLocalAmount(this.discountAmount);
        return this.discountAmount;
    }

    public BigDecimal calDiscountRate() {
        if (this.condition.isDiscountAmountChanged()) {
            BigDecimal qty1;
            if (this.condition.isFullDisCount()) {
                this.discountRate = DiscountModeEnum.PERCENT.equals((Object)this.discountType) ? ONEHUNDRED : (this.condition.isInTax() ? this.taxPrice : this.price);
                return this.discountRate;
            }
            BigDecimal bigDecimal = qty1 = this.isRed && !this.condition.isDebitAdjust() && !this.condition.isAllowanceBill() ? this.qty.negate() : this.qty;
            if (DiscountModeEnum.PERCENT.equals((Object)this.discountType)) {
                if (this.taxPrice.multiply(qty1).compareTo(ZERO) == 0) {
                    return this.discountRate;
                }
                this.discountRate = this.discountAmount.multiply(ONEHUNDRED).divide(this.taxPrice.multiply(qty1), this.ratePrecision, 4);
            } else if (this.condition.isInTax()) {
                if (qty1.compareTo(ZERO) == 0) {
                    return this.discountRate;
                }
                this.discountRate = this.discountAmount.divide(qty1, this.pricePrecision, 4);
            } else {
                this.discountRate = this.discountAmount.divide(qty1.multiply(ONE.add(ArApBaseCalculate.calRate(this.taxRate, 2))), this.pricePrecision, 4);
            }
            return this.discountRate;
        }
        if (!this.condition.isRealPriceChanged()) {
            return this.discountRate;
        }
        if (DiscountModeEnum.PERCENT.equals((Object)this.discountType)) {
            if (this.price.compareTo(ZERO) != 0) {
                this.discountRate = this.realPrice.divide(this.price, this.ratePrecision, 4);
            }
        } else {
            this.discountRate = this.realPrice.subtract(this.price);
        }
        return this.discountRate;
    }

    public BigDecimal calRecPayAmount() throws ArApCalculateException {
        if (!this.condition.isInTax()) {
            if (this.condition.isPresent()) {
                this.recPayAmount = ZERO;
                this.recPayAmountLocal = ZERO;
            } else {
                this.recPayAmount = this.amount.add(this.taxAmount);
                this.recPayAmountLocal = this.amountLocal.add(this.taxAmountLocal);
            }
        } else if (this.condition.isRecPayAmountChanged()) {
            this.recPayAmountLocal = this.calLocalAmount(this.recPayAmount);
        } else if (this.condition.isDiscountAmountChanged()) {
            this.recPayAmount = this.qty.multiply(this.taxPrice).setScale(this.currencyPrecision, 4).subtract(this.isRed && !this.condition.isDebitAdjust() && !this.condition.isAllowanceBill() ? this.discountAmount.negate() : this.discountAmount);
            this.recPayAmountLocal = this.calLocalAmount(this.recPayAmount);
        } else if (this.condition.isTaxAmountChanged() || this.condition.isEntryQtyZero()) {
            this.taxAmountLocal = this.calLocalAmount(this.taxAmount);
        } else {
            this.recPayAmount = DiscountModeEnum.PERCENT.equals((Object)this.discountType) ? this.qty.multiply(this.taxPrice).multiply(ONE.subtract(ArApBaseCalculate.calRate(this.discountRate, this.ratePrecision))).setScale(this.currencyPrecision, 4) : this.qty.multiply(this.taxPrice.subtract(this.discountRate)).setScale(this.currencyPrecision, 4);
            this.recPayAmountLocal = this.calLocalAmount(this.recPayAmount);
        }
        if (!this.condition.isDebitAdjust() && !this.condition.isAllowanceBill() && ArApBaseCalculate.isNegative(this.recPayAmount)) {
            throw new ArApCalculateException(ArApCalculateException.RECPAYAMOUNT_INVALID, new Object[]{this.recPayAmount});
        }
        if (this.condition.isAllowanceBill()) {
            this.unVerifyAmount = ZERO;
            this.unVerifyAmountLocal = ZERO;
            this.calVerifyAmount();
        } else {
            this.verifyAmount = ZERO;
            this.verifyAmountLocal = ZERO;
            this.calUnVerifyAmount();
        }
        if (!this.checkBigDecimal(this.recPayAmount)) {
            throw new ArApCalculateException(ArApCalculateException.AMOUNT_INVALID, new Object[]{this.recPayAmount});
        }
        if (!this.checkBigDecimal(this.recPayAmountLocal)) {
            throw new ArApCalculateException(ArApCalculateException.AMOUNT_INVALID, new Object[]{this.recPayAmountLocal});
        }
        return this.recPayAmount;
    }

    public boolean checkBigDecimal(BigDecimal amount) {
        return amount.scale() <= 4 && amount.precision() - amount.scale() <= 13;
    }

    public BigDecimal calUnVerifyAmount() throws ArApCalculateException {
        this.unVerifyAmount = this.recPayAmount.subtract(this.verifyAmount);
        this.unVerifyAmountLocal = this.recPayAmountLocal.subtract(this.verifyAmountLocal);
        if (!this.condition.isDebitAdjust() && !this.condition.isAllowanceBill() && (ArApBaseCalculate.isNegative(this.unVerifyAmount) || ArApBaseCalculate.isNegative(this.unVerifyAmountLocal))) {
            throw new ArApCalculateException(ArApCalculateException.UNVERIFYAMOUNT_INVALID);
        }
        return this.unVerifyAmount;
    }

    public BigDecimal calVerifyAmount() throws ArApCalculateException {
        this.verifyAmount = this.recPayAmount.subtract(this.unVerifyAmount);
        this.verifyAmountLocal = this.recPayAmountLocal.subtract(this.unVerifyAmountLocal);
        if (!this.condition.isDebitAdjust() && !this.condition.isAllowanceBill() && (ArApBaseCalculate.isNegative(this.verifyAmount) || ArApBaseCalculate.isNegative(this.verifyAmountLocal))) {
            throw new ArApCalculateException(ArApCalculateException.VERIFYAMOUNT_INVALID);
        }
        return this.verifyAmount;
    }

    public BigDecimal calQty() throws EASBizException, BOSException {
        BigDecimal tempQty = null;
        if (this.materialInfo != null && this.unitInfo != null && this.baseUnitInfo != null) {
            tempQty = this.getQty(this.materialInfo.getId().toString(), this.baseUnitInfo, this.unitInfo, this.baseQty);
        }
        this.qty = tempQty == null ? this.qty : tempQty;
        return this.qty;
    }

    public BigDecimal calEntryQty() {
        if (this.condition.isPresent()) {
            return this.qty;
        }
        if (!this.condition.isInTax()) {
            if (DiscountModeEnum.PERCENT.equals((Object)this.discountType)) {
                if (this.price.compareTo(ZERO) != 0 && ONE.subtract(ArApBaseCalculate.calRate(this.discountRate, this.ratePrecision)).compareTo(ZERO) != 0) {
                    this.qty = this.amount.divide(this.price, 10, 4).divide(ONE.subtract(ArApBaseCalculate.calRate(this.discountRate, this.ratePrecision)), 10, 4);
                }
            } else if (this.price.subtract(this.discountRate).compareTo(ZERO) != 0) {
                this.qty = this.amount.divide(this.price.subtract(this.discountRate), 10, 4);
            }
        } else if (this.condition.isRecPayAmountChanged()) {
            if (DiscountModeEnum.PERCENT.equals((Object)this.discountType)) {
                if (ZERO.compareTo(this.taxPrice) != 0 && ONEHUNDRED.compareTo(this.discountRate) != 0) {
                    this.qty = this.recPayAmount.divide(this.taxPrice, 10, 4).divide(ONE.subtract(ArApBaseCalculate.calRate(this.discountRate, this.ratePrecision)), 10, 4);
                }
            } else if (this.taxPrice.subtract(this.discountRate).compareTo(ZERO) != 0) {
                this.qty = this.recPayAmount.divide(this.taxPrice.subtract(this.discountRate), 10, 4);
            }
        }
        return this.qty;
    }

    public BigDecimal calBaseQty() throws EASBizException, BOSException {
        BigDecimal tempQty = null;
        if (this.materialInfo != null && this.unitInfo != null && this.baseUnitInfo != null) {
            tempQty = this.getQty(this.materialInfo.getId().toString(), this.unitInfo, this.baseUnitInfo, this.qty);
        }
        this.baseQty = tempQty == null ? this.baseQty : tempQty;
        return this.baseQty;
    }

    public BigDecimal calAssistQty() throws EASBizException, BOSException {
        BigDecimal tempQty = null;
        if (this.materialInfo != null && this.unitInfo != null && this.assistUnitInfo != null) {
            tempQty = this.getQty(this.materialInfo.getId().toString(), this.unitInfo, this.assistUnitInfo, this.qty);
        }
        this.assistQty = tempQty == null ? this.assistQty : tempQty;
        return this.assistQty;
    }

    protected void calOthers() {
    }

    protected void beforeInitData() {
    }

    protected void initData() {
    }

    protected void updateData() {
    }

    protected void afterUpdateData() {
    }

    public void init() {
        this.beforeInitData();
        this.initData();
    }

    public void update() {
        this.updateData();
        this.afterUpdateData();
    }

    public BigDecimal calLocalAmount(BigDecimal amount) {
        BigDecimal amountLocal = ZERO;
        if (this.condition.isDirectExchangeRate()) {
            amountLocal = amount.multiply(this.exchangeRate).setScale(this.baseCurrencyPrecision, 4);
        } else if (ZERO.compareTo(this.exchangeRate) != 0) {
            amountLocal = amount.divide(this.exchangeRate, this.baseCurrencyPrecision, 4);
        }
        return amountLocal;
    }

    public static BigDecimal calRate(BigDecimal ratePercent, int ratePrecision) {
        BigDecimal rate = null;
        if (ratePercent == null) {
            return ZERO;
        }
        rate = ratePercent.divide(ONEHUNDRED, ratePrecision + 2, 4);
        return rate;
    }

    private BigDecimal getQty(String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        if (unitInfo == null || otherUnitInfo == null) {
            return SysConstant.BIGZERO;
        }
        qty = qty == null ? SysConstant.BIGZERO : qty;
        BigDecimal targetQty = null;
        if (unitInfo.getId().toString().equals(otherUnitInfo.getId().toString())) {
            return qty;
        }
        Map mmuConvsRate = null;
        if ((SCMEntryDataVO)this.condition.getMapObject().get("SCMEntryDataVO") != null) {
            mmuConvsRate = ((SCMEntryDataVO)this.condition.getMapObject().get("SCMEntryDataVO")).getMmuConvsRate();
        }
        BigDecimal baseExchangeRate1 = new BigDecimal("1.00");
        BigDecimal baseExchangeRate2 = new BigDecimal("1.00");
        if (mmuConvsRate != null) {
            if (mmuConvsRate.get(materialID + unitInfo.getId().toString()) != null) {
                baseExchangeRate1 = (BigDecimal)mmuConvsRate.get(materialID + unitInfo.getId().toString());
            }
            if (mmuConvsRate.get(materialID + otherUnitInfo.getId().toString()) != null) {
                baseExchangeRate2 = (BigDecimal)mmuConvsRate.get(materialID + otherUnitInfo.getId().toString());
            }
            if (baseExchangeRate1 == null) {
                baseExchangeRate1 = new BigDecimal("1.00");
            }
            if (baseExchangeRate2 == null) {
                baseExchangeRate2 = new BigDecimal("1.00");
            }
            if (qty != null) {
                BigDecimal baseQty = qty.multiply(baseExchangeRate1);
                int scale = this.qtyPrecision;
                if (baseQty != null) {
                    scale = this.getQtyPrecision(this.materialInfo, otherUnitInfo.getId().toString());
                    targetQty = baseQty.divide(baseExchangeRate2, scale, 4);
                }
            }
        } else {
            IMultiMeasureUnit multiUnit = this.ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx);
            MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
            MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
            if (multiUnifInfo != null && othermultiUnifInfo != null) {
                baseExchangeRate1 = multiUnifInfo.getBaseConvsRate();
                baseExchangeRate2 = othermultiUnifInfo.getBaseConvsRate();
                if (baseExchangeRate1 == null) {
                    baseExchangeRate1 = new BigDecimal("1.00");
                }
                if (baseExchangeRate2 == null) {
                    baseExchangeRate2 = new BigDecimal("1.00");
                }
                if (qty != null) {
                    BigDecimal baseQty = qty.multiply(baseExchangeRate1);
                    int scale = 10;
                    if (baseQty != null) {
                        scale = othermultiUnifInfo.getQtyPrecision();
                        targetQty = baseQty.divide(baseExchangeRate2, scale, 4);
                    }
                }
            }
        }
        return targetQty;
    }

    private int getQtyPrecision(MaterialInfo material, String unitId) throws EASBizException, BOSException {
        int precision = this.qtyPrecision;
        Map mmuPrecisions = null;
        if ((SCMEntryDataVO)this.condition.getMapObject().get("SCMEntryDataVO") != null) {
            mmuPrecisions = ((SCMEntryDataVO)this.condition.getMapObject().get("SCMEntryDataVO")).getMmuPrecisions();
        }
        if (mmuPrecisions != null && mmuPrecisions.get(this.materialInfo.getId().toString() + unitId) != null) {
            precision = (Integer)mmuPrecisions.get(this.materialInfo.getId().toString() + unitId);
        } else {
            IMultiMeasureUnit multiUnit = this.ctx == null ? MultiMeasureUnitFactory.getRemoteInstance() : MultiMeasureUnitFactory.getLocalInstance((Context)this.ctx);
            MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(this.materialInfo.getId().toString(), unitId);
            if (othermultiUnifInfo != null) {
                precision = othermultiUnifInfo.getQtyPrecision();
            }
        }
        return precision;
    }

    public BigDecimal calAmount_reverse(BigDecimal amountLocal) {
        BigDecimal amount = ZERO;
        if (this.condition.isDirectExchangeRate()) {
            amount = amountLocal.divide(this.exchangeRate, this.currencyPrecision, 4);
        } else if (ZERO.compareTo(this.exchangeRate) != 0) {
            amount = amountLocal.multiply(this.exchangeRate).setScale(this.currencyPrecision, 4);
        }
        return amount;
    }

    public void execute4EntryQtyZero(CalculateCondition cditn) throws ArApCalculateException {
        this.init();
        this.initCondition(cditn);
        BigDecimal oldTaxAmount = this.taxAmount;
        BigDecimal oldRecPayAmount = this.recPayAmount;
        if (cditn.isInTax()) {
            if (!(cditn.isFxEnabled() && (cditn.isRecPayAmountLocalChanged() || cditn.isAmountLocalChanged() || cditn.isTaxAmountLocalChanged() || cditn.isDiscountAmountLocalChanged()))) {
                this.calRecPayAmount();
            }
            if (cditn.isTaxAmountChanged()) {
                this.taxAmountLocal = this.calLocalAmount(this.taxAmount);
            } else if (!(cditn.isFxEnabled() && (cditn.isRecPayAmountLocalChanged() || cditn.isAmountLocalChanged() || cditn.isTaxAmountLocalChanged() || cditn.isDiscountAmountLocalChanged()))) {
                this.calTaxAmount();
            }
            this.amount = this.recPayAmount.subtract(this.taxAmount);
            this.amountLocal = this.recPayAmountLocal.subtract(this.taxAmountLocal);
            if (this.recPayAmountLocal.abs().compareTo(this.taxAmountLocal.abs()) < 0) {
                throw new ArApCalculateException(ArApCalculateException.AMOUNT_INVALID, new Object[]{this.amountLocal});
            }
            if (oldTaxAmount.multiply(this.taxAmountLocal).signum() < 0 || oldRecPayAmount.multiply(this.recPayAmountLocal).signum() < 0) {
                throw new ArApCalculateException(ArApCalculateException.AMOUNT_INVALID, new Object[]{this.amountLocal});
            }
        } else {
            if (cditn.isAmountChanged()) {
                this.amountLocal = this.calLocalAmount(this.amount);
            }
            if (cditn.isTaxAmountChanged()) {
                this.taxAmountLocal = this.calLocalAmount(this.taxAmount);
            } else if (!(cditn.isFxEnabled() && (cditn.isRecPayAmountLocalChanged() || cditn.isAmountLocalChanged() || cditn.isTaxAmountLocalChanged() || cditn.isDiscountAmountLocalChanged()))) {
                this.calTaxAmount();
            }
            this.calRecPayAmount();
        }
        this.update();
    }

    public BigDecimal getActualPrice() {
        return this.actualPrice;
    }

    public void setActualPrice(BigDecimal actualPrice) {
        this.actualPrice = actualPrice;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getAmountLocal() {
        return this.amountLocal;
    }

    public void setAmountLocal(BigDecimal amountLocal) {
        this.amountLocal = amountLocal;
    }

    public BigDecimal getAssistQty() {
        return this.assistQty;
    }

    public void setAssistQty(BigDecimal assistQty) {
        this.assistQty = assistQty;
    }

    public MeasureUnitInfo getAssistUnitInfo() {
        return this.assistUnitInfo;
    }

    public void setAssistUnitInfo(MeasureUnitInfo assistUnitInfo) {
        this.assistUnitInfo = assistUnitInfo;
    }

    public BigDecimal getBaseQty() {
        return this.baseQty;
    }

    public void setBaseQty(BigDecimal baseQty) {
        this.baseQty = baseQty;
    }

    public MeasureUnitInfo getBaseUnitInfo() {
        return this.baseUnitInfo;
    }

    public void setBaseUnitInfo(MeasureUnitInfo baseUnitInfo) {
        this.baseUnitInfo = baseUnitInfo;
    }

    public BigDecimal getDiscountAmount() {
        return this.discountAmount;
    }

    public void setDiscountAmount(BigDecimal discountAmount) {
        this.discountAmount = discountAmount;
    }

    public BigDecimal getDiscountAmountLocal() {
        return this.discountAmountLocal;
    }

    public void setDiscountAmountLocal(BigDecimal discountAmountLocal) {
        this.discountAmountLocal = discountAmountLocal;
    }

    public BigDecimal getDiscountRate() {
        return this.discountRate;
    }

    public void setDiscountRate(BigDecimal discountRate) {
        this.discountRate = discountRate;
    }

    public DiscountModeEnum getDiscountType() {
        return this.discountType;
    }

    public void setDiscountType(DiscountModeEnum discountType) {
        this.discountType = discountType;
    }

    public MaterialInfo getMaterialInfo() {
        return this.materialInfo;
    }

    public void setMaterialInfo(MaterialInfo materialInfo) {
        this.materialInfo = materialInfo;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public BigDecimal getQty() {
        return this.qty;
    }

    public void setQty(BigDecimal qty) {
        this.qty = qty;
    }

    public BigDecimal getRealPrice() {
        return this.realPrice;
    }

    public void setRealPrice(BigDecimal realPrice) {
        this.realPrice = realPrice;
    }

    public BigDecimal getRecPayAmount() {
        return this.recPayAmount;
    }

    public void setRecPayAmount(BigDecimal recPayAmount) {
        this.recPayAmount = recPayAmount;
    }

    public BigDecimal getRecPayAmountLocal() {
        return this.recPayAmountLocal;
    }

    public void setRecPayAmountLocal(BigDecimal recPayAmountLocal) {
        this.recPayAmountLocal = recPayAmountLocal;
    }

    public BigDecimal getTaxAmountLocal() {
        return this.taxAmountLocal;
    }

    public void setTaxAmountLocal(BigDecimal taxAmountLocal) {
        this.taxAmountLocal = taxAmountLocal;
    }

    public BigDecimal getTaxPrice() {
        return this.taxPrice;
    }

    public void setTaxPrice(BigDecimal taxPrice) {
        this.taxPrice = taxPrice;
    }

    public BigDecimal getTaxRate() {
        return this.taxRate;
    }

    public void setTaxRate(BigDecimal taxRate) {
        this.taxRate = taxRate;
    }

    public CalculateCondition getCondition() {
        return this.condition;
    }

    public static boolean isNegative(BigDecimal value) {
        return value.compareTo(ZERO) < 0;
    }

    public BigDecimal getTaxAmount() {
        return this.taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public RowTypeInfo getRowType() {
        return this.rowType;
    }

    public void setRowType(RowTypeInfo rowType) {
        this.rowType = rowType;
    }
}

