/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ArApQueryUIUtil {
    private static final ObjectUuidPK ORG_FIVIEW_ID = new ObjectUuidPK("00000000-0000-0000-0000-0000000000024F2827FD");

    private ArApQueryUIUtil() {
    }

    public static List getInfoIds(Object[] infoArr) {
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < infoArr.length; ++i) {
            DataBaseInfo info = (DataBaseInfo)infoArr[i];
            if (info == null) continue;
            ids.add(info.getString("id"));
        }
        return ids;
    }

    public static CoreBaseCollection getInfos(Context context, IUIObject ui, List ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        CoreBaseCollection infos = null;
        String id = ids.get(0).toString();
        BOSObjectType bosType = BOSUuid.read((String)id).getType();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("number");
        FilterInfo filter = new FilterInfo();
        HashSet idSet = new HashSet();
        idSet.addAll(ids);
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        try {
            IDynamicObject iDyn = null;
            iDyn = context == null ? DynamicObjectFactory.getRemoteInstance() : DynamicObjectFactory.getLocalInstance((Context)context);
            infos = (CoreBaseCollection)iDyn.getCollection(bosType, view);
        }
        catch (Exception e) {
            ui.handUIException((Throwable)e);
        }
        return infos;
    }

    public static CompanyOrgUnitCollection getFullPermCompany(Context context, IObjectPK userPK, Object[] selectedComps, String permissionItem) throws Exception {
        if (selectedComps == null || selectedComps.length == 0) {
            return null;
        }
        HashSet<BOSUuid> ids = new HashSet<BOSUuid>();
        for (int i = 0; i < selectedComps.length; ++i) {
            CoreBaseInfo orgInfo = (CoreBaseInfo)selectedComps[i];
            ids.add(orgInfo.getId());
        }
        return ArApQueryUIUtil.getFullPermCompany(context, userPK, ids, permissionItem);
    }

    public static CompanyOrgUnitCollection getFullPermCompany(Context context, IObjectPK userPK, Set ids, String permissionItem) throws Exception {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        IPermission iPerm = null;
        iPerm = context == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)context);
        FullOrgUnitCollection orgs = iPerm.getAuthorizedOrg(userPK, OrgType.Company, (IObjectPK)ORG_FIVIEW_ID, permissionItem);
        HashSet<BOSUuid> withPermIds = new HashSet<BOSUuid>();
        int n = orgs.size();
        for (int i = 0; i < n; ++i) {
            withPermIds.add(orgs.get(i).getId());
        }
        ids.retainAll(withPermIds);
        if (ids == null || ids.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection items = filter.getFilterItems();
        view.setFilter(filter);
        items.add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.getSelector().add("id");
        view.getSelector().add("name");
        view.getSelector().add("number");
        view.getSelector().add("isBizUnit");
        view.getSelector().add("isOnlyUnion");
        view.getSelector().add("cu.id");
        ICompanyOrgUnit iComp = null;
        iComp = context == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)context);
        return iComp.getCompanyOrgUnitCollection(view);
    }
}

