/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.VerificateBillTypeEnum;
import com.kingdee.eas.fi.ar.ArApBillBaseInfo;
import com.kingdee.eas.fi.ar.ArApBillEntryBaseInfo;
import com.kingdee.eas.fi.ar.OtherBillBizException;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.scm.im.inv.IMultiSidesTransferPrices;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPricesFactory;
import com.kingdee.eas.scm.im.inv.MultiSidesTransferPricesInfo;
import com.kingdee.eas.scm.sd.sale.ISaleInnerDealPrice;
import com.kingdee.eas.scm.sd.sale.ISaleOrder;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceFactory;
import com.kingdee.eas.scm.sd.sale.SaleInnerDealPriceInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sm.pur.IPurInnerDealPrice;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceFactory;
import com.kingdee.eas.scm.sm.pur.PurInnerDealPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class ArApSrcBillHelper {
    private static final Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.util.ArApSrcBillHelper");

    public static void reAdmissionPrices(Context ctx, ArApBillBaseInfo info, AbstractObjectCollection entryCol) throws EASBizException, BOSException {
        String arapBillType;
        if (info == null) {
            return;
        }
        BizTypeInfo bizType = info.getBizType();
        BillTypeInfo billTypeInfo = ArApSrcBillHelper.getCoreBillType(entryCol);
        if (bizType == null || billTypeInfo == null) {
            return;
        }
        String string = arapBillType = info instanceof OtherBillInfo ? "1001" : "2001";
        if ("510b6503-0105-1000-e000-0113c0a812fd463ED552".equals(billTypeInfo.getId().toString())) {
            ISaleInnerDealPrice iSaleInner = null;
            ISaleOrderEntry iSaleOderEntry = null;
            SaleOrderEntryInfo saleOrderEntryInfo = null;
            ISaleOrder iSaleOrder = null;
            if (ctx == null) {
                iSaleInner = SaleInnerDealPriceFactory.getRemoteInstance();
                iSaleOderEntry = SaleOrderEntryFactory.getRemoteInstance();
                iSaleOrder = SaleOrderFactory.getRemoteInstance();
            } else {
                iSaleInner = SaleInnerDealPriceFactory.getLocalInstance((Context)ctx);
                iSaleOderEntry = SaleOrderEntryFactory.getLocalInstance((Context)ctx);
                iSaleOrder = SaleOrderFactory.getLocalInstance((Context)ctx);
            }
            String oql = null;
            int n = entryCol.size();
            for (int i = 0; i < n; ++i) {
                ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entryCol.getObject(i);
                String coreBillId = entryInfo.getCoreBillId();
                String coreBillEntryId = entryInfo.getCoreBillEntryId();
                if (coreBillId == null || coreBillEntryId == null) continue;
                boolean isCentral = false;
                String headCompanyId = null;
                String entryCompanyId = null;
                if (ctx != null) {
                    String sql = "select t2.FIsCentralBalance,t2.FCompanyOrgUnitID,t1.FCompanyOrgUnitID from T_SD_SaleOrder t2 inner join T_SD_SaleOrderEntry t1 on t1.fparentid=t2.fid where t1.fid='" + coreBillEntryId + "'";
                    IRowSet roset = DbUtil.executeQuery((Context)ctx, (String)sql);
                    try {
                        while (roset.next()) {
                            isCentral = roset.getBoolean(1);
                            headCompanyId = roset.getString(2);
                            entryCompanyId = roset.getString(3);
                        }
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                        throw new BOSException((Throwable)e);
                    }
                } else {
                    SaleOrderInfo saleOrderInfo = iSaleOrder.getSaleOrderInfo((IObjectPK)new ObjectStringPK(coreBillId));
                    isCentral = saleOrderInfo.isIsCentralBalance();
                    CompanyOrgUnitInfo soCompany = saleOrderInfo.getCompanyOrgUnit();
                    headCompanyId = soCompany.getId().toString();
                }
                String arCompanyId = info.getCompany().getId().toString();
                oql = "select * where id='" + coreBillEntryId + "'";
                saleOrderEntryInfo = iSaleOderEntry.getSaleOrderEntryInfo(oql);
                if (saleOrderEntryInfo == null) continue;
                CompanyOrgUnitInfo soEntryCompany = saleOrderEntryInfo.getCompanyOrgUnit();
                if (isCentral && headCompanyId == null || !isCentral && soEntryCompany == null) {
                    throw new OtherBillBizException(OtherBillBizException.COMPANY_NOTSET);
                }
                if (soEntryCompany != null) {
                    entryCompanyId = soEntryCompany.getId().toString();
                }
                if ("1001".equals(arapBillType) && (VerificateBillTypeEnum.SaleOrder.equals((Object)info.getSourceBillType()) || isCentral && arCompanyId.equals(headCompanyId) || !isCentral && arCompanyId.equals(entryCompanyId))) {
                    if (saleOrderEntryInfo.getPrice() != null) {
                        entryInfo.setPrice(saleOrderEntryInfo.getPrice());
                    }
                    if (saleOrderEntryInfo.getDiscountType() != null) {
                        entryInfo.setDiscountType(saleOrderEntryInfo.getDiscountType());
                    }
                    if (saleOrderEntryInfo.getDiscount() != null) {
                        entryInfo.setDiscountRate(saleOrderEntryInfo.getDiscount());
                    }
                    if (saleOrderEntryInfo.getActualPrice() != null) {
                        entryInfo.setRealPrice(saleOrderEntryInfo.getActualPrice());
                    }
                    if (saleOrderEntryInfo.getTaxRate() != null) {
                        entryInfo.setTaxRate(saleOrderEntryInfo.getTaxRate());
                    }
                    if (saleOrderEntryInfo.getTaxPrice() != null) {
                        entryInfo.setTaxPrice(saleOrderEntryInfo.getTaxPrice());
                    }
                    if (saleOrderEntryInfo.getActualTaxPrice() == null) continue;
                    entryInfo.setActualPrice(saleOrderEntryInfo.getActualTaxPrice());
                    continue;
                }
                SaleInnerDealPriceInfo priceInfo = iSaleInner.getInnerDealPrice(coreBillId, coreBillEntryId);
                if (priceInfo == null) continue;
                if (priceInfo.getPrice() != null) {
                    entryInfo.setPrice(priceInfo.getPrice());
                }
                if (priceInfo.getDiscountMode() != null) {
                    entryInfo.setDiscountType(priceInfo.getDiscountMode());
                }
                if (priceInfo.getDiscount() != null) {
                    entryInfo.setDiscountRate(priceInfo.getDiscount());
                }
                if (priceInfo.getActualPrice() != null) {
                    entryInfo.setRealPrice(priceInfo.getActualPrice());
                }
                if (priceInfo.getTaxRate() != null) {
                    entryInfo.setTaxRate(priceInfo.getTaxRate());
                }
                if (priceInfo.getTaxPrice() != null) {
                    entryInfo.setTaxPrice(priceInfo.getTaxPrice());
                }
                if (priceInfo.getActualTaxPrice() == null) continue;
                entryInfo.setActualPrice(priceInfo.getActualTaxPrice());
            }
        } else if ("510b6503-0105-1000-e000-010bc0a812fd463ED552".equals(billTypeInfo.getId().toString())) {
            IPurInnerDealPrice iPurInner = null;
            IPurOrderEntry iPurOderEntry = null;
            PurOrderEntryInfo purOrderEntryInfo = null;
            IPurOrder iPurOrder = null;
            if (ctx == null) {
                iPurInner = PurInnerDealPriceFactory.getRemoteInstance();
                iPurOderEntry = PurOrderEntryFactory.getRemoteInstance();
                iPurOrder = PurOrderFactory.getRemoteInstance();
            } else {
                iPurInner = PurInnerDealPriceFactory.getLocalInstance((Context)ctx);
                iPurOderEntry = PurOrderEntryFactory.getLocalInstance((Context)ctx);
                iPurOrder = PurOrderFactory.getLocalInstance((Context)ctx);
            }
            String oql = null;
            int n = entryCol.size();
            for (int i = 0; i < n; ++i) {
                ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entryCol.getObject(i);
                String coreBillId = entryInfo.getCoreBillId();
                String coreBillEntryId = entryInfo.getCoreBillEntryId();
                if (coreBillId == null || coreBillEntryId == null) continue;
                boolean isCentral = false;
                String headCompanyId = null;
                String entryCompanyId = null;
                if (ctx != null) {
                    String sql = "select t2.FIsCentralBalance,t2.FCompanyOrgUnitID,t1.FCompanyOrgUnitID from T_SM_PurOrder t2 inner join T_SM_PurOrderEntry t1 on t1.fparentid=t2.fid where t1.fid='" + coreBillEntryId + "'";
                    IRowSet roset = DbUtil.executeQuery((Context)ctx, (String)sql);
                    try {
                        while (roset.next()) {
                            isCentral = roset.getBoolean(1);
                            headCompanyId = roset.getString(2);
                            entryCompanyId = roset.getString(3);
                        }
                    }
                    catch (SQLException e) {
                        logger.error((Object)e);
                        throw new BOSException((Throwable)e);
                    }
                } else {
                    PurOrderInfo purOrderInfo = iPurOrder.getPurOrderInfo((IObjectPK)new ObjectStringPK(coreBillId));
                    isCentral = purOrderInfo.isIsCentralBalance();
                    CompanyOrgUnitInfo soCompany = purOrderInfo.getCompanyOrgUnit();
                    headCompanyId = soCompany.getId().toString();
                }
                String arCompanyId = info.getCompany().getId().toString();
                oql = "select * where id='" + coreBillEntryId + "'";
                purOrderEntryInfo = iPurOderEntry.getPurOrderEntryInfo(oql);
                if (purOrderEntryInfo == null) continue;
                CompanyOrgUnitInfo poEntryCompany = purOrderEntryInfo.getCompanyOrgUnit();
                if (isCentral && headCompanyId == null || !isCentral && poEntryCompany == null) {
                    throw new OtherBillBizException(OtherBillBizException.COMPANY_NOTSET);
                }
                if (poEntryCompany != null) {
                    entryCompanyId = poEntryCompany.getId().toString();
                }
                if (VerificateBillTypeEnum.SaleOrder.equals((Object)info.getSourceBillType()) || isCentral && arCompanyId.equals(headCompanyId) || !isCentral && arCompanyId.equals(entryCompanyId)) {
                    if (purOrderEntryInfo.getPrice() != null) {
                        entryInfo.setPrice(purOrderEntryInfo.getPrice());
                    }
                    entryInfo.setDiscountType(DiscountModeEnum.PERCENT);
                    if (purOrderEntryInfo.getDiscountRate() != null) {
                        entryInfo.setDiscountRate(purOrderEntryInfo.getDiscountRate());
                    }
                    if (purOrderEntryInfo.getActualPrice() != null) {
                        entryInfo.setRealPrice(purOrderEntryInfo.getActualPrice());
                    }
                    if (purOrderEntryInfo.getTaxRate() != null) {
                        entryInfo.setTaxRate(purOrderEntryInfo.getTaxRate());
                    }
                    if (purOrderEntryInfo.getTaxPrice() != null) {
                        entryInfo.setTaxPrice(purOrderEntryInfo.getTaxPrice());
                    }
                    if (purOrderEntryInfo.getActualTaxPrice() == null) continue;
                    entryInfo.setActualPrice(purOrderEntryInfo.getActualTaxPrice());
                    continue;
                }
                PurInnerDealPriceInfo priceInfo = iPurInner.getInnerDealPrice(coreBillId, coreBillEntryId);
                if (priceInfo == null) continue;
                if (priceInfo.getPrice() != null) {
                    entryInfo.setPrice(priceInfo.getPrice());
                }
                if (priceInfo.getDiscountMode() != null) {
                    entryInfo.setDiscountType(priceInfo.getDiscountMode());
                }
                if (priceInfo.getDiscount() != null) {
                    entryInfo.setDiscountRate(priceInfo.getDiscount());
                }
                if (priceInfo.getActualPrice() != null) {
                    entryInfo.setRealPrice(priceInfo.getActualPrice());
                }
                if (priceInfo.getTaxRate() != null) {
                    entryInfo.setTaxRate(priceInfo.getTaxRate());
                }
                if (priceInfo.getTaxPrice() != null) {
                    entryInfo.setTaxPrice(priceInfo.getTaxPrice());
                }
                if (priceInfo.getActualTaxPrice() == null) continue;
                entryInfo.setActualPrice(priceInfo.getActualTaxPrice());
            }
        } else if ("50957179-0105-1000-e003-3152c0a812fd463ED552".equals(billTypeInfo.getId().toString())) {
            IMultiSidesTransferPrices ims = null;
            ims = ctx == null ? MultiSidesTransferPricesFactory.getRemoteInstance() : MultiSidesTransferPricesFactory.getLocalInstance((Context)ctx);
            String[] coreBillEntryIds = new String[entryCol.size()];
            for (int i = 0; i < entryCol.size(); ++i) {
                ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entryCol.getObject(i);
                coreBillEntryIds[i] = entryInfo.getCoreBillEntryId();
            }
            Map priceMap = ims.getPriceInfos(coreBillEntryIds, info.getCompany().getId().toString(), arapBillType, info.getBizType().getId().toString());
            for (int i = 0; i < entryCol.size(); ++i) {
                ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entryCol.getObject(i);
                MultiSidesTransferPricesInfo priceInfo = (MultiSidesTransferPricesInfo)priceMap.get(entryInfo.getCoreBillEntryId());
                if (priceInfo == null) continue;
                entryInfo.setTaxRate(priceInfo.getTaxRate());
                entryInfo.setDiscountType(priceInfo.getDiscountType());
                entryInfo.setDiscountRate(priceInfo.getDiscountRate());
                entryInfo.setActualPrice(priceInfo.getActualTaxPrice());
                entryInfo.setRealPrice(priceInfo.getActualPrcie());
                entryInfo.setPrice(priceInfo.getPrice());
                entryInfo.setTaxPrice(priceInfo.getTaxPrice());
            }
            if ("d8e80652-0117-1000-e000-04c5c0a812202407435C".equals(bizType.getId().toString()) || "LyS5ouN3YEPgQAB/AQBJsCQHQ1w=".equals(bizType.getId().toString()) || "LyS5ouN4YEPgQAB/AQBJsCQHQ1w=".equals(bizType.getId().toString())) {
                // empty if block
            }
        }
    }

    private static Map getPriceInfo(String companyId, String[] coreBillEntryIds) {
        Map priceMap = null;
        return priceMap;
    }

    private static BillTypeInfo getCoreBillType(AbstractObjectCollection entryCol) {
        if (entryCol == null || entryCol.size() == 0) {
            return null;
        }
        ArApBillEntryBaseInfo entryInfo = (ArApBillEntryBaseInfo)entryCol.getObject(0);
        return entryInfo.getCoreBillType();
    }
}

