/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.util.BOSUuid;
import com.kingdee.util.StringUtils;
import java.util.HashSet;
import java.util.Set;

public class ArApStringUtil {
    public static final String DEFAULT_DELIMITER_COMMA = ",";

    public static String convertIdsStr2SqlCondition(String idsStr, String delimiter) {
        if (StringUtils.isEmpty((String)idsStr) || StringUtils.isEmpty((String)delimiter)) {
            return "";
        }
        return "'" + idsStr.replaceAll(delimiter, "'" + delimiter + "'") + "'";
    }

    public static String convertIdsStr2SqlCondition(String idsStr) {
        return ArApStringUtil.convertIdsStr2SqlCondition(idsStr, DEFAULT_DELIMITER_COMMA);
    }

    public static String convertSet2String(Set<String> set) {
        return ArApStringUtil.convertSet2String(set, DEFAULT_DELIMITER_COMMA);
    }

    public static String convertSet2String(Set<String> set, String delimiter) {
        String result = "";
        if (null == set || set.size() == 0 || StringUtils.isEmpty((String)delimiter)) {
            return result;
        }
        StringBuffer buf = new StringBuffer(200);
        for (String val : set) {
            buf.append(val).append(delimiter);
        }
        result = buf.substring(0, buf.length() - 1);
        return result;
    }

    public static Set<String> convertStr2Set(String ids) {
        return ArApStringUtil.convertStr2Set(ids, DEFAULT_DELIMITER_COMMA);
    }

    public static Set<String> convertStr2Set(String ids, String delimiter) {
        if (StringUtils.isEmpty((String)ids) || StringUtils.isEmpty((String)delimiter)) {
            return null;
        }
        String[] strArr = ids.split(delimiter);
        HashSet<String> idSet = new HashSet<String>(strArr.length);
        for (int i = 0; i < strArr.length; ++i) {
            idSet.add(strArr[i]);
        }
        return idSet;
    }

    public static Set<String> convertStr2SetWithCheck(String ids, String delimiter) {
        if (StringUtils.isEmpty((String)ids) || StringUtils.isEmpty((String)delimiter)) {
            return null;
        }
        String[] strArr = ids.split(delimiter);
        HashSet<String> idSet = new HashSet<String>(strArr.length);
        for (int i = 0; i < strArr.length; ++i) {
            if (!BOSUuid.isValid((String)strArr[i], (boolean)false)) continue;
            idSet.add(strArr[i]);
        }
        return idSet;
    }
}

