/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.arap.util.NumericBizCalculator;
import com.kingdee.eas.fi.arap.util.PrecisionFormatUtils;
import java.math.BigDecimal;
import java.util.Date;

public abstract class CurrencyExchangeRateUtils {
    public static ExchangeRateInfo getExchangeRate(CurrencyInfo currency) throws EASBizException, BOSException {
        return CurrencyExchangeRateUtils.getExchangeRate(null, null, currency, new Date());
    }

    public static ExchangeRateInfo getExchangeRate(CompanyOrgUnitInfo company, CurrencyInfo currency) throws EASBizException, BOSException {
        return CurrencyExchangeRateUtils.getExchangeRate(null, company, currency, new Date());
    }

    public static ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo company, CurrencyInfo currency, Date date) throws EASBizException, BOSException {
        ExchangeRateInfo exchangeRate = null;
        if (company == null) {
            company = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (currency != null && company != null && company.getBaseExchangeTable() != null && company.getBaseCurrency() != null) {
            IExchangeRate ie = null;
            ie = ctx == null ? ExchangeRateFactory.getRemoteInstance() : ExchangeRateFactory.getLocalInstance((Context)ctx);
            exchangeRate = ie.getExchangeRate((IObjectPK)new ObjectUuidPK(company.getBaseExchangeTable().getId()), (IObjectPK)new ObjectUuidPK(currency.getId()), (IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()), date);
        }
        return exchangeRate;
    }

    public static BigDecimal visitExchangeRate(ExchangeRateInfo info) {
        return info == null ? NumericBizCalculator.effectualExchangeRate(null) : NumericBizCalculator.effectualExchangeRate(info.getConvertRate());
    }

    public static int visitCovertMode(ExchangeRateInfo info) {
        return info == null ? 0 : info.getConvertMode().getValue();
    }

    public static int visitExchangeRatePrecision(ExchangeRateInfo info) {
        return info == null ? 2 : PrecisionFormatUtils.effectualPrecision(info.getPrecision());
    }
}

