/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.DefaultNoteDataProvider;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.util.MultiLanguageUtil;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSortItem;
import com.kingdee.bos.ctrl.reportone.r1.print.data.R1PrintDataSource;
import com.kingdee.bos.ctrl.reportone.r1.print.engine.exception.R1PrintRuntimeException;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPKFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.fi.arap.ARAPCommonServerFacadeFactory;
import com.kingdee.eas.fi.arap.IARAPCommonServerFacade;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class DefinitionNewDataProvider
extends DefaultNoteDataProvider {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.util.DefinitionNewDataProvider");
    private Set ids = null;
    private boolean isARBill = true;
    private IMetaDataPK qpk = null;
    private Context context;

    public DefinitionNewDataProvider(Context context, List id, IMetaDataPK qpk) {
        this.context = context;
        this.ids = new HashSet(id);
        this.qpk = qpk;
    }

    public DefinitionNewDataProvider(Set id, boolean isARBill) {
        this.ids = id;
        this.isARBill = isARBill;
    }

    public DefinitionNewDataProvider(List id, boolean isARBill) {
        this.ids = new HashSet(id);
        this.isARBill = isARBill;
    }

    public DefinitionNewDataProvider(List id, IMetaDataPK qpk) {
        this.ids = new HashSet(id);
        this.qpk = qpk;
    }

    public IRowSet getData(R1PrintDataSource dataSource) throws Exception {
        IRowSet iRowSet = null;
        try {
            this.isARBill = this.qpk.toString().replace('\\', '.').equals("com.kingdee.eas.fi.ar.app.OtherBillDefPrintQuery");
            if (dataSource.getId().equals("DefinitionData.bos-query")) {
                Context ctx = BOSObjectFactory.getContextFromThread();
                IARAPCommonServerFacade iARAPCommonServerFacade = null == ctx ? ARAPCommonServerFacadeFactory.getRemoteInstance() : ARAPCommonServerFacadeFactory.getLocalInstance((Context)ctx);
                iRowSet = iARAPCommonServerFacade.getDefinitionData(this.isARBill, this.ids);
            } else {
                IMetaDataPK pk;
                if (!StringUtil.isEmptyString((String)dataSource.getReference())) {
                    pk = MetaDataPKFactory.getMetaDataPK((String)dataSource.getReference());
                    log.info((Object)("DefaultNoteDataProvider, datasource has BOSQuery reference. MetaDataPK: " + pk));
                } else {
                    pk = this.qpk;
                }
                if (pk == null) {
                    throw new R1PrintRuntimeException(MultiLanguageUtil.getMLS((String)"client.DefaultNoteDataProvider.exception", (String)"\u96c6\u6210\u5f00\u53d1\u672a\u6307\u5b9a\u7f3a\u7701\u7684MetaDataPK\uff0c\u6a21\u677f\u4e2d\u4e5f\u6ca1\u6709\u5f15\u7528\u4fe1\u606f\u3002"));
                }
                log.info((Object)("com.kingdee.eas.fi.arap.util.DefinitionDataProvider, MetaDataPK is appointed: " + pk));
                IQueryExecutor exec = this.context != null ? QueryExecutorFactory.getRemoteInstanceWithObjectContext((IMetaDataPK)pk, (Context)this.context) : QueryExecutorFactory.getRemoteInstance((IMetaDataPK)pk);
                exec.option().isAutoTranslateEnum = true;
                exec.option().isAutoTranslateBoolean = true;
                exec.option().isIgnoreOrder = true;
                EntityViewInfo ev = this.createWrappedBosRunsstimeInfo(dataSource);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.ids, CompareType.INCLUDE));
                ev.setFilter(filter);
                exec.setObjectView(ev);
                iRowSet = exec.executeQuery();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return iRowSet;
    }

    public EntityViewInfo createWrappedBosRunsstimeInfo(R1PrintDataSource ds) {
        int i;
        EntityViewInfo evi = new EntityViewInfo();
        SorterItemCollection ori = (SorterItemCollection)evi.getSorter().clone();
        evi.getSorter().clear();
        R1PrintDataSortItem[] sorts = ds.getSortFields();
        int c = sorts.length;
        for (i = 0; i < c; ++i) {
            SorterItemInfo sorterItemInfo = new SorterItemInfo();
            sorterItemInfo.setPropertyName(sorts[i].getSortField());
            if (sorts[i].getSortType() == 1) {
                sorterItemInfo.setSortType(SortType.DESCEND);
            } else {
                sorterItemInfo.setSortType(SortType.ASCEND);
            }
            evi.getSorter().add(sorterItemInfo);
        }
        c = ori.size();
        for (i = 0; i < c; ++i) {
            evi.getSorter().add(ori.get(i));
        }
        return evi;
    }
}

