/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util.cor;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.arap.util.NumericBizCalculator;
import com.kingdee.eas.fi.arap.util.cor.HandlerNode;
import com.kingdee.eas.fi.arap.util.cor.Latitude;

public class LocalHandler
extends HandlerNode {
    private String localLatitude = null;

    protected LocalHandler() {
    }

    protected LocalHandler(String nodeName) {
        super(nodeName);
    }

    @Override
    protected void handleChangedByCurrent(Latitude latitude) throws EASBizException, BOSException {
        String localName = this.getNodeName();
        if (latitude.containsKey(localName)) {
            this.value = latitude.visitNumeric(localName);
        } else if (latitude.containsKey(this.localLatitude) && latitude.containsKey("exchangerate")) {
            this.value = NumericBizCalculator.calculateAmountLocal(latitude.visitNumeric(this.localLatitude), latitude.visitExchangeRate("exchangerate"), this.getContext().visitConvertmode(), this.getContext().visitCurrencyPrecision());
            latitude.put(localName, this.value);
        } else if (latitude.containsKey(this.localLatitude) || this.getContext().containsKey(this.localLatitude)) {
            this.value = NumericBizCalculator.calculateAmountLocal(this.getLatitudeValue(latitude, this.localLatitude), this.getContext().visitExchangeRate("exchangerate"), this.getContext().visitConvertmode(), this.getContext().visitCurrencyPrecision());
            latitude.put(localName, this.value);
        } else if (latitude.containsKey("exchangerate")) {
            this.value = NumericBizCalculator.calculateAmountLocal(this.getContext().visitNumeric(this.localLatitude), latitude.visitExchangeRate("exchangerate"), this.getContext().visitConvertmode(), this.getContext().visitCurrencyPrecision());
            latitude.put(localName, this.value);
        }
    }

    protected void setLocalLatitude(String localLatitude) {
        this.localLatitude = localLatitude;
    }

    protected String getLocalLatitude() {
        return this.localLatitude;
    }
}

