/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util.invoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.arap.util.invoice.InvoiceUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class IncomeInvoiceServerUtils {
    public static final String SERVICE_NAME = "com.kingdee.eas.tm.im.util.invoice.IncomeInvoiceServerService";
    public static final String PWY_HELPER_NAME = "com.kingdee.eas.tm.im.PoolPwyUrlHel";
    public static final String AP_RESOURCE = "com.kingdee.eas.fi.ap.ApResource";

    public static boolean isSupport() {
        Class clazz = InvoiceUtils.getClass(SERVICE_NAME);
        return clazz != null;
    }

    public static Map getAmountTaxSum(Map params) throws EASBizException, BOSException {
        Map ret = InvoiceUtils.invoke(SERVICE_NAME, "getAmountTaxSum", params);
        return ret;
    }

    public static Map updateInvoiceInfoAndBotp(Map params) throws EASBizException, BOSException {
        Map ret = InvoiceUtils.invoke(SERVICE_NAME, "updateInvoiceInfoAndBotp", params);
        return ret;
    }

    public static Map delInvoiceInfoAndBotp(Map params) throws EASBizException, BOSException {
        Map ret = InvoiceUtils.invoke(SERVICE_NAME, "delInvoiceInfoAndBotp", params);
        return ret;
    }

    public static Map updateInvoiceInfo(Map params) throws EASBizException, BOSException {
        Map ret = InvoiceUtils.invoke(SERVICE_NAME, "updateInvoiceInfo", params);
        return ret;
    }

    public static Map deleteInvoiceInfo(Map params) throws EASBizException, BOSException {
        Map ret = InvoiceUtils.invoke(SERVICE_NAME, "deleteInvoiceInfo", params);
        return ret;
    }

    public static void updateVoucherInfo(Context ctx, List data) throws EASBizException, BOSException {
        HashMap params = new HashMap();
        params.put("data", data);
        params.put("ctx", ctx);
        InvoiceUtils.invoke(SERVICE_NAME, "updateVoucherInfo", params);
    }

    public static Map viewInvoiceImage(Map params) throws EASBizException, BOSException {
        Map ret = InvoiceUtils.invoke(SERVICE_NAME, "viewInvoiceImage", params);
        if (ret.size() == 0) {
            ret = IncomeInvoiceServerUtils.viewInvoicePdf(params);
        }
        return ret;
    }

    public static Map viewInvoicePdf(Map params) throws EASBizException, BOSException {
        Map ret = InvoiceUtils.invoke(SERVICE_NAME, "viewInvoicePdf", params);
        return ret;
    }

    public static Map getInvoiceMap(Context ctx, OtherBillInfo info, boolean isIntegratedByPWY) throws BOSException, EASBizException {
        Map ret = IncomeInvoiceServerUtils.getInvoiceMap(ctx, info.getInvoiceCode(), info.getInvoiceNumber(), info.getId() == null ? null : info.getId().toString(), isIntegratedByPWY);
        return ret;
    }

    public static Map getInvoiceMap(Context ctx, String invoiceCodes, String invoiceNumbers, String billID, boolean isIntegratedByPWY) throws BOSException, EASBizException {
        Map ret = new HashMap();
        if (invoiceCodes != null && invoiceNumbers != null) {
            HashMap<String, Object> invoiceParams = new HashMap<String, Object>();
            List<String> invoiceCode = ArApBillUtil.getListFromString(invoiceCodes, ";");
            List<String> invoiceNumber = ArApBillUtil.getListFromString(invoiceNumbers, ";");
            ArrayList<String> invoiceCodeNumber = new ArrayList<String>();
            for (int i = 0; i < invoiceCode.size(); ++i) {
                invoiceCodeNumber.add(invoiceCode.get(i) + "_" + invoiceNumber.get(i));
            }
            invoiceParams.put("ctx", ctx);
            invoiceParams.put("invoices", invoiceCodeNumber);
            invoiceParams.put("isIntegratedByPWY", isIntegratedByPWY);
            invoiceParams.put("bizBillId", billID);
            ret = InvoiceUtils.invoke(SERVICE_NAME, "getInvoiceMap", invoiceParams);
        }
        return ret;
    }

    public static String getInvoiceMapExceptionMsg(Locale local, String billNumber, Map<String, Map> ret) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)AP_RESOURCE, (String)"INVOICE_CODE_IS_USE", (Locale)local, (Object[])new Object[]{billNumber}) + "\n");
        for (String key : ret.keySet()) {
            msg.append(ResourceBase.getString((String)AP_RESOURCE, (String)"INVOICE_NUMBER", (Locale)local, (Object[])new Object[]{StringUtils.split((String)key, (String)"_")[0]}) + "\n");
            msg.append(ResourceBase.getString((String)AP_RESOURCE, (String)"INVOICE_CODE", (Locale)local, (Object[])new Object[]{StringUtils.split((String)key, (String)"_")[1]}) + "\n");
            msg.append(ResourceBase.getString((String)AP_RESOURCE, (String)"BIZ_BILL_TYPE", (Locale)local, (Object[])new Object[]{ret.get(key).get("bizBillType")}) + "\n");
            msg.append(ResourceBase.getString((String)AP_RESOURCE, (String)"BIZ_BILL_NUMBER", (Locale)local, (Object[])new Object[]{ret.get(key).get("bizBillNumber")}) + "\n\n");
        }
        return msg.toString();
    }

    public static String getInvoiceMapExceptionMsg4List(Locale local, String billNumber, Map<String, Map> ret) {
        StringBuffer msg = new StringBuffer();
        msg.append(ResourceBase.getString((String)AP_RESOURCE, (String)"INVOICE_CODE_IS_USE", (Locale)local, (Object[])new Object[]{billNumber}) + ",");
        return msg.toString();
    }

    public static String getBaseUrl(Context ctx) throws EASBizException, BOSException {
        String baseUrl = "";
        HashMap<String, Context> params = new HashMap<String, Context>();
        params.put("ctx", ctx);
        Map res = InvoiceUtils.invoke("com.kingdee.eas.tm.im.PoolPwyUrlHelp", "getBaseUrl", new Class[]{Map.class}, params);
        baseUrl = (String)res.get("baseUrl");
        return baseUrl;
    }

    public static Map baseInvoiceCallWithRes(Context ctx, Map paramMap, String invoiceUrl) throws EASBizException, BOSException {
        Map res = new HashMap();
        String companyId = (String)paramMap.get("companyId");
        String isIntegratePwy = ParamManager.getParamValue((Context)ctx, (IObjectPK)new ObjectUuidPK(companyId), (String)"AP_INTEGRATE_PWY");
        if (!Boolean.parseBoolean(isIntegratePwy)) {
            return res;
        }
        invoiceUrl = IncomeInvoiceServerUtils.getBaseUrl(ctx) + invoiceUrl;
        Class[] methodParams = new Class[]{Map.class};
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ctx", ctx);
        params.put("paramMap", paramMap);
        params.put("invoiceUrl", invoiceUrl);
        res = InvoiceUtils.invoke(SERVICE_NAME, "baseInvoiceCallWithRes", methodParams, params);
        return res;
    }

    public static Boolean hasDelInvoiceMethod() {
        try {
            Class<?> clazz = Class.forName(SERVICE_NAME);
            Method method = clazz.getDeclaredMethod("delInvoiceFields", Map.class, Map.class);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        return true;
    }

    public static void delInvoiceFields(Context ctx, String billId) throws EASBizException, BOSException {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ctx", ctx);
        params.put("billId", billId);
        try {
            Class<?> clazz = Class.forName(SERVICE_NAME);
            Method method = clazz.getDeclaredMethod("delInvoiceFields", Map.class, Map.class);
            method.setAccessible(true);
            method.invoke(clazz.newInstance(), params, null);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

