/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util.invoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.session.LoginType;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.cp.bc.ExpenseTypeInfo;
import com.kingdee.eas.cp.bc.IInvoiceTypeEntry;
import com.kingdee.eas.cp.bc.InvoiceTypeEntryCollection;
import com.kingdee.eas.cp.bc.InvoiceTypeEntryFactory;
import com.kingdee.eas.cp.bc.InvoiceTypeEntryInfo;
import com.kingdee.eas.fi.ap.IInvoiceType;
import com.kingdee.eas.fi.ap.IOtherBill;
import com.kingdee.eas.fi.ap.InvoiceSourceEnum;
import com.kingdee.eas.fi.ap.InvoiceTypeCollection;
import com.kingdee.eas.fi.ap.InvoiceTypeFactory;
import com.kingdee.eas.fi.ap.InvoiceTypeInfo;
import com.kingdee.eas.fi.ap.OtherBillCollection;
import com.kingdee.eas.fi.ap.OtherBillFactory;
import com.kingdee.eas.fi.ap.OtherBillInfo;
import com.kingdee.eas.fi.ap.OtherBillInvoiceCollection;
import com.kingdee.eas.fi.ap.OtherBillInvoiceEntryCollection;
import com.kingdee.eas.fi.ap.OtherBillInvoiceEntryInfo;
import com.kingdee.eas.fi.ap.OtherBillInvoiceInfo;
import com.kingdee.eas.fi.ap.OtherBillentryCollection;
import com.kingdee.eas.fi.arap.util.invoice.PwyRequestHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvoiceUtils {
    private static final Logger logger = Logger.getLogger(InvoiceUtils.class);
    private static Map<String, IBizCtrl> bizCtrlMap = new HashMap<String, IBizCtrl>();
    private static Map<String, Method> bizCtrlMethodMap = new HashMap<String, Method>();
    private static Map<String, Class> classMap = new HashMap<String, Class>();
    private static Map<String, Method> classMethodMap = new HashMap<String, Method>();
    private static Map<String, Boolean> isSupportPreInvoiceMap = new HashMap<String, Boolean>();
    private static Map<String, InvoiceTypeInfo> invoiceTypeCache = new HashMap<String, InvoiceTypeInfo>();
    private static InvoiceTypeCollection invoiceTypeCollCache = new InvoiceTypeCollection();

    public static Map invoke(Context ctx, String bosType, String methodName, Map params) throws EASBizException, BOSException {
        Map ret = new HashMap();
        IBizCtrl bizCtrl = InvoiceUtils.getBizCtrl(ctx, bosType);
        if (bizCtrl == null) {
            return ret;
        }
        Method method = bizCtrlMethodMap.get(bosType + "_" + methodName);
        try {
            if (method == null) {
                method = bizCtrl.getClass().getDeclaredMethod(methodName, Map.class);
                bizCtrlMethodMap.put(bosType + "_" + methodName, method);
            }
            ret = (Map)method.invoke((Object)bizCtrl, params);
        }
        catch (Exception e) {
            if (e.getCause() instanceof EASBizException) {
                throw (EASBizException)e.getCause();
            }
            if (e.getCause() instanceof BOSException) {
                throw (BOSException)e.getCause();
            }
            logger.error((Object)("bosType:" + bosType + ",methodName:" + methodName + "  invoke error"));
        }
        return ret;
    }

    public static Map invoke(String className, String bosType, String methodName, Map params) throws EASBizException, BOSException {
        Map ret = new HashMap();
        IBizCtrl bizCtrl = InvoiceUtils.getBizCtrl(className, bosType);
        if (bizCtrl == null) {
            return ret;
        }
        Method method = bizCtrlMethodMap.get(bosType + "_" + methodName);
        try {
            if (method == null) {
                method = bizCtrl.getClass().getDeclaredMethod(methodName, Map.class);
                bizCtrlMethodMap.put(bosType + "_" + methodName, method);
            }
            ret = (Map)method.invoke((Object)bizCtrl, params);
        }
        catch (Exception e) {
            if (e.getCause() instanceof EASBizException) {
                throw (EASBizException)e.getCause();
            }
            if (e.getCause() instanceof BOSException) {
                throw (BOSException)e.getCause();
            }
            logger.error((Object)("bosType:" + bosType + ",methodName:" + methodName + "  invoke error"));
        }
        return ret;
    }

    public static Map invoke(String className, String methodName, Map params) throws EASBizException, BOSException {
        return InvoiceUtils.invoke(className, methodName, new Class[]{Map.class}, params);
    }

    public static Map invoke(String className, String methodName, Class[] methodParams, Map params) throws EASBizException, BOSException {
        Map ret = new HashMap();
        Class clazz = InvoiceUtils.getClass(className);
        if (clazz == null) {
            return ret;
        }
        Method method = classMethodMap.get(className + "_" + methodName);
        try {
            if (method == null) {
                method = clazz.getDeclaredMethod(methodName, methodParams);
                classMethodMap.put(className + "_" + methodName, method);
            }
            Object obj = clazz.newInstance();
            method.setAccessible(true);
            ret = (Map)method.invoke(obj, params);
        }
        catch (Exception e) {
            if (e.getCause() instanceof EASBizException) {
                throw (EASBizException)e.getCause();
            }
            if (e.getCause() instanceof BOSException) {
                throw (BOSException)e.getCause();
            }
            logger.error((Object)("className:" + className + ",methodName:" + methodName + "  invoke error"));
        }
        return ret;
    }

    public static void invokeWithoutRet(String className, String methodName, Class[] methodParams, Map params) throws EASBizException, BOSException {
        Class clazz = InvoiceUtils.getClass(className);
        if (clazz == null) {
            return;
        }
        Method method = classMethodMap.get(className + "_" + methodName);
        try {
            if (method == null) {
                method = clazz.getDeclaredMethod(methodName, methodParams);
                classMethodMap.put(className + "_" + methodName, method);
            }
            Object obj = clazz.newInstance();
            method.setAccessible(true);
            method.invoke(obj, params);
        }
        catch (Exception e) {
            if (e.getCause() instanceof EASBizException) {
                throw (EASBizException)e.getCause();
            }
            if (e.getCause() instanceof BOSException) {
                throw (BOSException)e.getCause();
            }
            logger.error((Object)("className:" + className + ",methodName:" + methodName + "  invoke error"));
        }
    }

    public static IBizCtrl getBizCtrl(Context ctx, String bosType) {
        IBizCtrl bizCtrl = bizCtrlMap.get(bosType);
        if (bizCtrl == null) {
            try {
                bizCtrl = (IBizCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType(bosType));
                bizCtrlMap.put(bizCtrl.getType().toString(), bizCtrl);
            }
            catch (Exception e) {
                logger.error((Object)("bosType:" + bosType + "  bizCtrlNotFound"));
            }
        }
        return bizCtrl;
    }

    public static IBizCtrl getBizCtrl(String className, String bosType) {
        IBizCtrl bizCtrl = bizCtrlMap.get(bosType);
        if (bizCtrl == null) {
            try {
                bizCtrl = (IBizCtrl)BOSObjectFactory.createRemoteBOSObject((BOSObjectType)new BOSObjectType(bosType), Class.forName(className));
                bizCtrlMap.put(bizCtrl.getType().toString(), bizCtrl);
            }
            catch (Exception e) {
                logger.error((Object)("bosType:" + bosType + "  bizCtrlNotFound"));
            }
        }
        return bizCtrl;
    }

    public static Class getClass(String className) {
        Class<?> clazz = classMap.get(className);
        if (clazz == null) {
            try {
                clazz = Class.forName(className);
                classMap.put(className, clazz);
            }
            catch (Exception e) {
                logger.error((Object)("className:" + className + "  ClassNotFound"));
            }
        }
        return clazz;
    }

    public static void dispose(Context ctx, String action, String destId) throws EASBizException, BOSException {
        if (!InvoiceUtils.isSupportPreInvoice(ctx, destId, false)) {
            return;
        }
        String disposer = "com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReq2ArDisposerAdapter";
        try {
            Class clazz = InvoiceUtils.getClass(disposer);
            if (clazz == null) {
                return;
            }
            Object instance = clazz.newInstance();
            Method method = instance.getClass().getMethod("dispose", Context.class, String.class, String.class);
            method.invoke(instance, ctx, action, destId);
        }
        catch (Exception e) {
            if (e.getCause() instanceof EASBizException) {
                throw (EASBizException)e.getCause();
            }
            if (e.getCause() instanceof BOSException) {
                throw (BOSException)e.getCause();
            }
            logger.error((Object)(disposer + " invoke error:" + e.getMessage()));
        }
    }

    public static boolean isSupportPreInvoice(Context ctx, String destId, boolean refresh) throws EASBizException, BOSException {
        Boolean isSupportPreInvoice = isSupportPreInvoiceMap.get(destId);
        if (!refresh && isSupportPreInvoice != null) {
            return isSupportPreInvoice;
        }
        isSupportPreInvoiceMap.put(destId, false);
        if (!InvoiceUtils.isOrderSupport(ctx)) {
            return false;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT 1 FROM T_BOT_Relation ");
        sql.append(" WHERE FSRCENTITYID = ? and  FDESTENTITYID = ? ");
        sql.append(" and FSRCOBJECTID in ( SELECT FParentID FROM T_SD_SaleOrderEntry  ");
        sql.append(" WHERE FID in (SELECT FCoreBillEntryId FROM T_AR_OtherBillEntry");
        sql.append("   WHERE FParentID = ?) )");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{"C48A423A", "AC368D2D", destId});
        try {
            if (rs.next()) {
                isSupportPreInvoiceMap.put(destId, true);
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public static boolean isOrderSupport(Context ctx) throws BOSException {
        try {
            if (InvoiceUtils.isColumnExists(ctx, "T_SD_SaleOrderEntry", "FInvoiceReqQty")) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isColumnExists(Context ctx, String tblName, String columnName) throws SQLException {
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '" + tblName + "' AND KSQL_COL_NAME = '" + columnName + "'  )";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            boolean bl = rs.next();
            return bl;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return false;
    }

    public static InvoiceTypeInfo getInvoiceType(Context ctx, String invoiceTypeNumber) throws BOSException {
        InvoiceTypeInfo invoiceTypeInfo;
        if (invoiceTypeCache.isEmpty()) {
            IInvoiceType iInvoiceType = ctx == null ? InvoiceTypeFactory.getRemoteInstance() : InvoiceTypeFactory.getLocalInstance(ctx);
            InvoiceTypeCollection invoiceTypeCollection = iInvoiceType.getInvoiceTypeCollection();
            for (int i = 0; i < invoiceTypeCollection.size(); ++i) {
                invoiceTypeCache.put(invoiceTypeCollection.get(i).getNumber(), invoiceTypeCollection.get(i));
            }
        }
        if ((invoiceTypeInfo = invoiceTypeCache.get(invoiceTypeNumber)) == null) {
            invoiceTypeInfo = InvoiceUtils.createDefaultInvoiceType(ctx, invoiceTypeNumber);
        }
        return invoiceTypeInfo;
    }

    public static InvoiceTypeCollection getInvoiceTypeColl(Context ctx) throws BOSException {
        InvoiceTypeCollection invoiceTypeCollection;
        if (invoiceTypeCollCache.size() > 0) {
            return invoiceTypeCollCache;
        }
        IInvoiceType iInvoiceType = ctx == null ? InvoiceTypeFactory.getRemoteInstance() : InvoiceTypeFactory.getLocalInstance(ctx);
        invoiceTypeCollCache = invoiceTypeCollection = iInvoiceType.getInvoiceTypeCollection();
        return invoiceTypeCollCache;
    }

    public static void clearInvoiceCache() {
        invoiceTypeCollCache.clear();
        invoiceTypeCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InvoiceTypeInfo createDefaultInvoiceType(Context ctx, String invoiceType) throws BOSException {
        InvoiceTypeInfo invoiceTypeInfo = new InvoiceTypeInfo();
        try {
            IInvoiceType iInvoiceType = ctx == null ? InvoiceTypeFactory.getRemoteInstance() : InvoiceTypeFactory.getLocalInstance(ctx);
            String string = invoiceType;
            synchronized (string) {
                InvoiceTypeCollection invoiceTypeColl = iInvoiceType.getInvoiceTypeCollection("where number='" + invoiceType + "'");
                if (invoiceTypeColl.isEmpty()) {
                    invoiceTypeInfo.setNumber(invoiceType);
                    invoiceTypeInfo.setIsShow(false);
                    invoiceTypeInfo.setName(FMSysDefinedEnum.OTHER.getAlias());
                    invoiceTypeInfo.setInvoiceCodeField("invoiceCode");
                    invoiceTypeInfo.setInvoiceNumberField("invoiceNo");
                    invoiceTypeInfo.setSerialNoField("serialNo");
                    invoiceTypeInfo.setBillDateField("invoiceDate");
                    invoiceTypeInfo.setTaxAmountField("totalAmount");
                    invoiceTypeInfo.setTaxRateField(null);
                    invoiceTypeInfo.setTaxField("totalTaxAmount");
                    invoiceTypeInfo.setAmountField("invoiceAmount");
                    IObjectPK pk = iInvoiceType.addnew(invoiceTypeInfo);
                    invoiceTypeInfo.setId(BOSUuid.read((String)pk.toString()));
                } else {
                    invoiceTypeInfo = invoiceTypeColl.get(0);
                }
                invoiceTypeCache.put(invoiceType, invoiceTypeInfo);
                invoiceTypeCollCache.add(invoiceTypeInfo);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return invoiceTypeInfo;
    }

    public static OtherBillInvoiceInfo transJson2InvoiceInfo(Context ctx, JSONObject jsonObject) throws BOSException {
        return InvoiceUtils.transJson2InvoiceInfo(ctx, jsonObject, true);
    }

    public static OtherBillInvoiceInfo transJson2InvoiceInfo(Context ctx, JSONObject jsonObject, Boolean isTransItems) throws BOSException {
        logger.error((Object)("transJson2InvoiceInfo json:" + jsonObject.toString()));
        OtherBillInvoiceInfo invoiceInfo = new OtherBillInvoiceInfo();
        try {
            invoiceInfo.setId(BOSUuid.create((BOSObjectType)invoiceInfo.getBOSType()));
            InvoiceTypeInfo invoiceTypeInfo = InvoiceUtils.getInvoiceType(ctx, jsonObject.getString("invoiceType"));
            invoiceInfo.setInvoiceType(invoiceTypeInfo);
            invoiceInfo.setInvoiceCode(InvoiceUtils.getJsonField(jsonObject, invoiceTypeInfo.getInvoiceCodeField()));
            invoiceInfo.setInvoiceNumber(InvoiceUtils.getJsonField(jsonObject, invoiceTypeInfo.getInvoiceNumberField()));
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            String invoiceDate = InvoiceUtils.getJsonField(jsonObject, invoiceTypeInfo.getBillDateField());
            if (!StringUtils.isEmpty((String)invoiceDate)) {
                invoiceInfo.setBillDate(df.parse(invoiceDate));
            }
            invoiceInfo.setSerialNo(InvoiceUtils.getJsonField(jsonObject, invoiceTypeInfo.getSerialNoField()));
            String taxAmount = InvoiceUtils.getJsonField(jsonObject, invoiceTypeInfo.getTaxAmountField());
            if (!StringUtils.isEmpty((String)taxAmount)) {
                invoiceInfo.setTaxAmount(new BigDecimal(taxAmount));
            } else {
                invoiceInfo.setTaxAmount(BigDecimal.ZERO);
            }
            String tax = InvoiceUtils.getJsonField(jsonObject, invoiceTypeInfo.getTaxField());
            if (!StringUtils.isEmpty((String)tax)) {
                invoiceInfo.setTax(new BigDecimal(tax));
            } else {
                invoiceInfo.setTax(BigDecimal.ZERO);
            }
            String amount = InvoiceUtils.getJsonField(jsonObject, invoiceTypeInfo.getAmountField());
            if (!StringUtils.isEmpty((String)amount)) {
                invoiceInfo.setAmount(new BigDecimal(amount));
            } else {
                invoiceInfo.setAmount(invoiceInfo.getTaxAmount().subtract(invoiceInfo.getTax()));
            }
            String taxRate = InvoiceUtils.getJsonField(jsonObject, invoiceTypeInfo.getTaxRateField());
            if (!StringUtils.isEmpty((String)taxRate)) {
                invoiceInfo.setTaxRate(new BigDecimal(taxRate).multiply(new BigDecimal("100")));
            }
            invoiceInfo.setInvoiceSource(InvoiceSourceEnum.pwyImported);
            if (jsonObject.has("items") && isTransItems.booleanValue()) {
                JSONArray items = jsonObject.getJSONArray("items");
                OtherBillInvoiceEntryCollection itemColl = new OtherBillInvoiceEntryCollection();
                for (int i = 0; i < items.length(); ++i) {
                    JSONObject itemJson = items.getJSONObject(i);
                    OtherBillInvoiceEntryInfo invoiceItem = new OtherBillInvoiceEntryInfo();
                    invoiceItem.setId(BOSUuid.create((BOSObjectType)invoiceItem.getBOSType()));
                    invoiceItem.setGoodsCode(InvoiceUtils.getJsonField(itemJson, "goodsCode"));
                    invoiceItem.setGoodsName(InvoiceUtils.getJsonField(itemJson, "goodsName"));
                    invoiceItem.setSpecModel(InvoiceUtils.getJsonField(itemJson, "specModel"));
                    invoiceItem.setUnit(InvoiceUtils.getJsonField(itemJson, "unit"));
                    BigDecimal unitPrice = StringUtils.isEmpty((String)InvoiceUtils.getJsonField(itemJson, "unitPrice")) ? BigDecimal.ZERO : new BigDecimal(InvoiceUtils.getJsonField(itemJson, "unitPrice"));
                    invoiceItem.setUnitPrice(unitPrice);
                    BigDecimal num = StringUtils.isEmpty((String)InvoiceUtils.getJsonField(itemJson, "num")) ? BigDecimal.ZERO : new BigDecimal(InvoiceUtils.getJsonField(itemJson, "num"));
                    invoiceItem.setNum(num);
                    BigDecimal itemTaxAmount = StringUtils.isEmpty((String)InvoiceUtils.getJsonField(itemJson, "taxAmount")) ? BigDecimal.ZERO : new BigDecimal(InvoiceUtils.getJsonField(itemJson, "taxAmount"));
                    invoiceItem.setTaxAmount(itemTaxAmount);
                    BigDecimal itemTaxRate = StringUtils.isEmpty((String)InvoiceUtils.getJsonField(itemJson, "taxRate")) ? BigDecimal.ZERO : new BigDecimal(InvoiceUtils.getJsonField(itemJson, "taxRate"));
                    invoiceItem.setTaxRate(itemTaxRate);
                    BigDecimal detailAmount = StringUtils.isEmpty((String)InvoiceUtils.getJsonField(itemJson, "detailAmount")) ? BigDecimal.ZERO : new BigDecimal(InvoiceUtils.getJsonField(itemJson, "detailAmount"));
                    invoiceItem.setDetailAmount(detailAmount);
                    invoiceItem.setZeroTaxRateFlag(InvoiceUtils.getJsonField(itemJson, "zeroTaxRateFlag"));
                    invoiceItem.setDiscountType(InvoiceUtils.getJsonField(itemJson, "discountType"));
                    if (StringUtils.isEmpty((String)invoiceItem.getDiscountType())) {
                        invoiceItem.setDiscountType("0");
                    }
                    invoiceItem.setPreferentialPolicy(InvoiceUtils.getJsonField(itemJson, "preferentialPolicy"));
                    invoiceItem.setVersionNo(InvoiceUtils.getJsonField(itemJson, "versionNo"));
                    itemColl.add(invoiceItem);
                }
                invoiceInfo.put("itemColl", (Object)itemColl);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return invoiceInfo;
    }

    private static String getJsonField(JSONObject jsonObject, String fieldName) throws JSONException {
        String value = "";
        if (StringUtils.isEmpty((String)fieldName)) {
            return null;
        }
        JSONObject json = jsonObject;
        if (fieldName.indexOf(";") > -1) {
            String[] fieldArr = fieldName.split(";");
            for (int i = 0; i < fieldArr.length && json.has(fieldArr[i]); ++i) {
                if (i == fieldArr.length - 1) {
                    value = json.getString(fieldArr[i]);
                    continue;
                }
                if (json.getJSONArray(fieldArr[i]).length() != 0) {
                    json = json.getJSONArray(fieldArr[i]).getJSONObject(0);
                    continue;
                }
                break;
            }
        } else if (json.has(fieldName)) {
            value = json.getString(fieldName);
        }
        return value;
    }

    public static OtherBillInvoiceCollection transJson2InvoiceCollection(Context ctx, JSONObject json) throws BOSException {
        OtherBillInvoiceCollection invoiceCollection = new OtherBillInvoiceCollection();
        JSONArray array = new JSONArray();
        boolean flag = true;
        try {
            if (json == null || !json.has("data")) {
                return invoiceCollection;
            }
            while (flag) {
                if (json.get("data") instanceof JSONArray) {
                    array = json.getJSONArray("data");
                    flag = false;
                    continue;
                }
                if (!json.has("data")) {
                    flag = false;
                    continue;
                }
                json = json.getJSONObject("data");
            }
            int size = array.length();
            for (int i = 0; i < size; ++i) {
                JSONObject jsono = array.getJSONObject(i);
                invoiceCollection.add(InvoiceUtils.transJson2InvoiceInfo(ctx, jsono));
            }
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
        return invoiceCollection;
    }

    public static OtherBillInvoiceCollection transJson2InvoiceCollectionWithReload(Context ctx, String companyId, JSONObject json) throws BOSException, EASBizException {
        OtherBillInvoiceCollection invoiceCollection = new OtherBillInvoiceCollection();
        JSONArray array = new JSONArray();
        boolean flag = true;
        try {
            if (json == null || !json.has("data")) {
                return invoiceCollection;
            }
            Set<Object> errData = new HashSet();
            if (json.has("TAX_APPWYDOWNLOADFAILD_SERIALS")) {
                HashMap errInvoices = (HashMap)json.get("TAX_APPWYDOWNLOADFAILD_SERIALS");
                errData = errInvoices.keySet();
            }
            while (flag) {
                if (json.get("data") instanceof JSONArray) {
                    array = json.getJSONArray("data");
                    flag = false;
                    continue;
                }
                if (!json.has("data")) {
                    flag = false;
                    continue;
                }
                json = json.getJSONObject("data");
            }
            int size = array.length();
            if (size > 0) {
                String serialNos = "";
                for (int i = 0; i < size; ++i) {
                    JSONObject jsono = array.getJSONObject(i);
                    String serialNo = jsono.getString("serialNo");
                    if (errData.contains(serialNo)) continue;
                    serialNos = serialNos + serialNo + ",";
                }
                if (serialNos.length() > 0) {
                    serialNos = serialNos.substring(0, serialNos.length() - 1);
                    invoiceCollection = PwyRequestHelper.getInvoiceInfoBySerialsNos(ctx, serialNos, companyId);
                }
            }
        }
        catch (JSONException e) {
            throw new BOSException((Throwable)e);
        }
        return invoiceCollection;
    }

    public static OtherBillInvoiceInfo transIncomeInvoice2APInvoice(Context ctx, CoreBaseInfo incomeInvoice) throws BOSException {
        OtherBillInvoiceInfo invoiceInfo = new OtherBillInvoiceInfo();
        invoiceInfo.setId(BOSUuid.create((BOSObjectType)invoiceInfo.getBOSType()));
        invoiceInfo.setInvoiceSource(InvoiceSourceEnum.invoiceImported);
        if ("AF83503C".equals(incomeInvoice.getBOSType().toString())) {
            invoiceInfo.setInvoiceType(InvoiceUtils.getInvoiceType(ctx, (String)incomeInvoice.get("invoiceType")));
            invoiceInfo.setInvoiceCode((String)incomeInvoice.get("invoiceCode"));
            invoiceInfo.setInvoiceNumber((String)incomeInvoice.get("invoiceNo"));
            invoiceInfo.setTaxAmount((BigDecimal)incomeInvoice.get("totalAmount"));
            invoiceInfo.setTax((BigDecimal)incomeInvoice.get("totalTaxAmount"));
            invoiceInfo.setAmount((BigDecimal)incomeInvoice.get("invoiceAmount"));
            invoiceInfo.setSerialNo((String)incomeInvoice.get("serialNo"));
            invoiceInfo.setIncomeInvoiceID(incomeInvoice.get("id").toString());
            invoiceInfo.setBillDate((Date)incomeInvoice.get("invoiceDate"));
            AbstractObjectCollection incomeInvoiceEntries = (AbstractObjectCollection)incomeInvoice.get("entry");
            if (incomeInvoiceEntries != null && incomeInvoiceEntries.size() > 0 && incomeInvoiceEntries.getObject(0).get("taxRate") != null) {
                invoiceInfo.setTaxRate(incomeInvoiceEntries.getObject(0).getBigDecimal("taxRate").multiply(new BigDecimal("100")));
            }
        } else {
            invoiceInfo.setInvoiceType(InvoiceUtils.getInvoiceType(ctx, (String)incomeInvoice.get("tmInvoiceType")));
            invoiceInfo.setInvoiceCode((String)incomeInvoice.get("invoiceCode"));
            invoiceInfo.setInvoiceNumber((String)incomeInvoice.get("invoiceNumber"));
            invoiceInfo.setTaxAmount((BigDecimal)incomeInvoice.get("amountTax"));
            invoiceInfo.setAmount((BigDecimal)incomeInvoice.get("amount"));
            invoiceInfo.setTax((BigDecimal)incomeInvoice.get("tax"));
            invoiceInfo.setSerialNo((String)incomeInvoice.get("serialNo"));
            invoiceInfo.setIncomeInvoiceID(incomeInvoice.get("id").toString());
            invoiceInfo.setBillDate((Date)incomeInvoice.get("bizDate"));
            AbstractObjectCollection incomeInvoiceEntries = (AbstractObjectCollection)incomeInvoice.get("entries");
            if (incomeInvoiceEntries != null && incomeInvoiceEntries.size() > 0 && incomeInvoiceEntries.getObject(0).get("taxRate") != null) {
                invoiceInfo.setTaxRate(incomeInvoiceEntries.getObject(0).getBigDecimal("taxRate").multiply(new BigDecimal("100")));
            }
        }
        return invoiceInfo;
    }

    public static String verifyInvoiceAmount(Context ctx, Set idSet, OtherBillCollection otherBillCollection) throws BOSException, EASBizException {
        StringBuffer errMsgAll = new StringBuffer();
        StringBuffer errMsg = new StringBuffer();
        Locale locale = null;
        locale = ctx != null ? ctx.getLocale() : SysContext.getSysContext().getOriginLocale();
        if (otherBillCollection == null && idSet != null) {
            EntityViewInfo ev = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("number");
            selector.add("entry.recievePayAmountLocal");
            selector.add("entry.taxAmountLocal");
            selector.add("otherBillInvoice.taxAmount");
            selector.add("otherBillInvoice.tax");
            ev.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            FilterItemInfo idFilter = new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE);
            filter.getFilterItems().add(idFilter);
            ev.setFilter(filter);
            IOtherBill iOtherBill = null;
            iOtherBill = ctx == null ? OtherBillFactory.getRemoteInstance() : OtherBillFactory.getLocalInstance(ctx);
            otherBillCollection = iOtherBill.getOtherBillCollection(ev);
        }
        if (otherBillCollection != null && otherBillCollection.size() > 0) {
            for (int i = 0; i < otherBillCollection.size(); ++i) {
                int j;
                errMsg.setLength(0);
                OtherBillInfo billInfo = otherBillCollection.get(i);
                BigDecimal entryAmount = BigDecimal.ZERO;
                BigDecimal entryTaxAmount = BigDecimal.ZERO;
                BigDecimal invoiceAmount = BigDecimal.ZERO;
                BigDecimal invoiceTaxAmount = BigDecimal.ZERO;
                OtherBillInvoiceCollection invoiceCollection = billInfo.getOtherBillInvoice();
                for (j = invoiceCollection.size() - 1; j >= 0; --j) {
                    OtherBillInvoiceInfo invoiceInfo = invoiceCollection.get(j);
                    if (invoiceInfo.getInvoiceNumber() != null || invoiceInfo.getInvoiceCode() != null || invoiceInfo.getTaxAmount() != null && invoiceInfo.getTaxAmount().compareTo(BigDecimal.ZERO) != 0) continue;
                    invoiceCollection.remove(invoiceInfo);
                }
                if (invoiceCollection == null || invoiceCollection.size() == 0) continue;
                for (j = 0; j < invoiceCollection.size(); ++j) {
                    if (invoiceCollection.get(j).getTaxAmount() != null) {
                        invoiceAmount = invoiceAmount.add(invoiceCollection.get(j).getTaxAmount());
                    }
                    if (invoiceCollection.get(j).getTax() == null) continue;
                    invoiceTaxAmount = invoiceTaxAmount.add(invoiceCollection.get(j).getTax());
                }
                OtherBillentryCollection entryColl = billInfo.getEntry();
                for (int j2 = 0; j2 < entryColl.size(); ++j2) {
                    if (entryColl.get(j2).getRecievePayAmountLocal() != null) {
                        entryAmount = entryAmount.add(entryColl.get(j2).getRecievePayAmountLocal());
                    }
                    if (entryColl.get(j2).getTaxAmountLocal() == null) continue;
                    entryTaxAmount = entryTaxAmount.add(entryColl.get(j2).getTaxAmountLocal());
                }
                if (entryAmount.compareTo(invoiceAmount) != 0) {
                    errMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.ApResource", (String)"AMOUNT_DIFF", (Locale)locale, (Object[])new String[]{entryAmount.subtract(invoiceAmount).abs().toString()}));
                }
                if (entryTaxAmount.compareTo(invoiceTaxAmount) != 0) {
                    if (errMsg.length() > 0) {
                        errMsg.append(";");
                    }
                    errMsg.append(ResourceBase.getString((String)"com.kingdee.eas.fi.ap.ApResource", (String)"TAXAMOUNT_DIFF", (Locale)locale, (Object[])new String[]{entryTaxAmount.subtract(invoiceTaxAmount).abs().toString()}));
                }
                if (errMsg.length() <= 0) continue;
                errMsg.insert(0, ResourceBase.getString((String)"com.kingdee.eas.fi.ap.ApResource", (String)"BILL_NO", (Locale)locale, (Object[])new String[]{billInfo.getNumber()}));
                if (errMsgAll.length() > 0) {
                    if (ctx != null && !LoginType.GUI.equals(ctx.get((Object)"LOGIN_TYPE"))) {
                        errMsgAll.append("<br>");
                    } else {
                        errMsgAll.append("\n");
                    }
                }
                errMsgAll.append(errMsg);
            }
        }
        return errMsgAll.toString();
    }

    public static Map getExpenseTypeByInvoiceType(Context ctx, InvoiceTypeCollection invoiceTypeColl, String companyId) throws EASBizException, BOSException {
        HashMap<String, ExpenseTypeInfo> expenseTypeMap = new HashMap<String, ExpenseTypeInfo>();
        IInvoiceTypeEntry iInvoiceTypeEntry = ctx == null ? InvoiceTypeEntryFactory.getRemoteInstance() : InvoiceTypeEntryFactory.getLocalInstance((Context)ctx);
        EntityViewInfo invoiceTypeEV = new EntityViewInfo();
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("expenseType.*");
        selectors.add("expenseType.operationType.*");
        selectors.add("expenseType.entry.*");
        selectors.add("expenseType.defaultUnit.*");
        selectors.add("ticketTypeId.number");
        invoiceTypeEV.setSelector(selectors);
        FilterInfo filterInfo = new FilterInfo();
        HashSet<String> invoiceTypeNumbers = new HashSet<String>();
        if (invoiceTypeColl == null) {
            invoiceTypeColl = InvoiceUtils.getInvoiceTypeColl(ctx);
        }
        for (int i = 0; i < invoiceTypeColl.size(); ++i) {
            invoiceTypeNumbers.add(invoiceTypeColl.get(i).getNumber());
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("ticketTypeId.number", invoiceTypeNumbers, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
        invoiceTypeEV.setFilter(filterInfo);
        InvoiceTypeEntryCollection invoiceTypeEntryCollection = iInvoiceTypeEntry.getInvoiceTypeEntryCollection(invoiceTypeEV);
        for (int i = 0; i < invoiceTypeEntryCollection.size(); ++i) {
            InvoiceTypeEntryInfo entry = invoiceTypeEntryCollection.get(i);
            expenseTypeMap.put(entry.getTicketTypeId().getNumber(), entry.getExpenseType());
        }
        return expenseTypeMap;
    }

    public static String getInvoiceTypeStr(Map<String, InvoiceTypeInfo> selectedInvoiceType, Locale locale) {
        String invoiceTypes = "";
        if (!selectedInvoiceType.isEmpty()) {
            for (String key : selectedInvoiceType.keySet()) {
                if (StringUtils.isEmpty((String)selectedInvoiceType.get(key).getName(locale))) continue;
                invoiceTypes = invoiceTypes + selectedInvoiceType.get(key).getName(locale) + ";";
            }
            if (!StringUtils.isEmpty((String)invoiceTypes)) {
                invoiceTypes = invoiceTypes.substring(0, invoiceTypes.length() - 1);
            }
        }
        return invoiceTypes;
    }
}

