/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap.util.paramconvertor;

import com.kingdee.bos.Context;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.permission.UserType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.fi.ar.IReportQueryParam;
import com.kingdee.eas.fi.arap.BosTypeEnum;
import com.kingdee.eas.fi.arap.billValidator.util.PaySecurityParam;
import com.kingdee.eas.fi.arap.client.util.ArApQueryUIUtil;
import com.kingdee.eas.fi.arap.util.CollectionUtil;
import com.kingdee.eas.fi.arap.util.paramconvertor.IRptParamConvertor;
import com.kingdee.util.TypeConversionUtils;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class PaySecurityParamConnvertor
implements IRptParamConvertor {
    private PaySecurityParam param = null;
    private final String COMPANYS = "companys";
    private final String DATE_FROM = "dateFrom";
    private final String DATE_TO = "dateTo";
    private String USER_TYPE = "userType";
    private String CRTL_BILL_TYPE = "crtlBillType";
    private String CHK_PASS = "chkPass";
    private String CHK_UN_PASS = "chkUnPass";

    @Override
    public IReportQueryParam getRptParam() {
        return this.param;
    }

    @Override
    public void setRptParam(IReportQueryParam rptQryParam) {
        this.param = (PaySecurityParam)rptQryParam;
    }

    @Override
    public void read(Context ctx, CustomerParams custParam) throws Exception {
        this.read(ctx, custParam.getCustomerParamsHashMap());
    }

    @Override
    public void read(Context ctx, com.kingdee.eas.base.commonquery.client.CustomerParams custParam) throws Exception {
        this.read(ctx, custParam.getCustomerParamsHashMap());
    }

    public void read(Context ctx, HashMap paramMap) throws Exception {
        if (this.getRptParam() == null || paramMap == null) {
            return;
        }
        String ids = TypeConversionUtils.objToString(paramMap.get("companys"));
        Set<String> idSet = CollectionUtil.toSet(ids);
        CompanyOrgUnitCollection comps = ArApQueryUIUtil.getFullPermCompany(this.param.getUserPK(), idSet, this.param.getPermItem());
        List<FullOrgUnitInfo> fullOrgUnits = CollectionUtil.toList(comps);
        this.param.setCompanys(fullOrgUnits == null ? null : (FullOrgUnitInfo[])fullOrgUnits.toArray());
        long dateFrom = TypeConversionUtils.objToLLong(paramMap.get("dateFrom"));
        this.param.setDateFrom(new Timestamp(dateFrom));
        long dateTo = TypeConversionUtils.objToLLong(paramMap.get("dateTo"));
        this.param.setDateTo(new Timestamp(dateTo));
        int type = TypeConversionUtils.objToInt(paramMap.get(this.USER_TYPE));
        UserType userType = type == 0 ? null : UserType.getEnum((int)type);
        this.param.setUserType(userType);
        String bosType = TypeConversionUtils.objToString(paramMap.get(this.CRTL_BILL_TYPE));
        BosTypeEnum crtlBillType = null == bosType ? null : BosTypeEnum.getEnum(bosType);
        this.param.setCrtlBillType(crtlBillType);
        this.param.setChkPass(TypeConversionUtils.objToBoolean(paramMap.get(this.CHK_PASS)));
        this.param.setChkUnPass(TypeConversionUtils.objToBoolean(paramMap.get(this.CHK_UN_PASS)));
    }

    @Override
    public CustomerParams convert() {
        CustomerParams custParam = new CustomerParams();
        FullOrgUnitInfo[] orgs = this.param.getCompanys();
        StringBuilder buf = null;
        if (null != orgs) {
            buf = new StringBuilder(orgs.length * 44);
            for (int i = 0; i < orgs.length; ++i) {
                buf.append(orgs[i].getId().toString());
                if (i == orgs.length - 1) continue;
                buf.append(CollectionUtil.SPLIT_COMMA);
            }
        }
        custParam.addCustomerParam("companys", null == buf ? null : buf.toString());
        custParam.putLong("dateFrom", null == this.param.getDateFrom() ? 0L : this.param.getDateFrom().getTime());
        custParam.putLong("dateTo", null == this.param.getDateTo() ? 0L : this.param.getDateTo().getTime());
        custParam.putInt(this.USER_TYPE, null == this.param.getUserType() ? 0 : this.param.getUserType().getValue());
        custParam.addCustomerParam(this.CRTL_BILL_TYPE, null == this.param.getCrtlBillType() ? null : this.param.getCrtlBillType().getValue());
        custParam.addCustomerParam(this.CHK_PASS, String.valueOf(this.param.isChkPass()));
        custParam.addCustomerParam(this.CHK_UN_PASS, String.valueOf(this.param.isChkUnPass()));
        return custParam;
    }

    @Override
    public com.kingdee.eas.base.commonquery.client.CustomerParams convertClient() {
        CustomerParams customerParams = this.convert();
        com.kingdee.eas.base.commonquery.client.CustomerParams c = new com.kingdee.eas.base.commonquery.client.CustomerParams();
        c.setHm(customerParams.getCustomerParamsHashMap());
        return c;
    }
}

