/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.eas.base.core.IEASBillEntryInfo;
import com.kingdee.eas.base.core.IEASBillHeadInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillDisposerAction;
import com.kingdee.eas.fi.cas.IReceivingDisposer;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CheckOffStatusEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.sd.sale.ISaleInvoice;
import com.kingdee.eas.scm.sd.sale.ISaleOrderEntry;
import com.kingdee.eas.scm.sd.sale.SaleInvBizException;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceFactory;
import com.kingdee.eas.scm.sd.sale.SaleInvoiceInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryFactory;
import com.kingdee.eas.scm.sd.sale.SaleOrderEntryInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;

public class SaleInvoiceDisposer
implements IReceivingDisposer {
    public BigDecimal getCashRebate(Date billDate, BigDecimal arAmount, String srcBillId, String srcBillEntryId) {
        return null;
    }

    public void dispose(Context ctx, BillDisposerAction action) throws BOSException, EASBizException {
        if (action.getActionType().getValue() == 5) {
            IEASBillEntryInfo receEntryInfo;
            IObjectCollection receEntryCollect;
            IEASBillHeadInfo receivingBillInfo = null;
            if (action.getDestBill() != null) {
                receivingBillInfo = (IEASBillHeadInfo)action.getDestBill();
            }
            if (receivingBillInfo != null && (receEntryCollect = receivingBillInfo.getEntries()) != null && receEntryCollect.size() > 0 && (receEntryInfo = (IEASBillEntryInfo)receEntryCollect.getObject(0)) != null && receEntryInfo.getSourceBillId() != null) {
                SaleInvoiceEntryCollection collection;
                ObjectUuidPK invoicePK = new ObjectUuidPK(receEntryInfo.getSourceBillId());
                ISaleInvoice isaleInvoice = null;
                ISaleOrderEntry isaleOrderEntry = null;
                if (ctx != null) {
                    isaleInvoice = SaleInvoiceFactory.getLocalInstance((Context)ctx);
                    isaleOrderEntry = SaleOrderEntryFactory.getLocalInstance((Context)ctx);
                } else {
                    isaleInvoice = SaleInvoiceFactory.getRemoteInstance();
                    isaleOrderEntry = SaleOrderEntryFactory.getRemoteInstance();
                }
                SaleInvoiceInfo invoiceInfo = isaleInvoice.getSaleInvoiceInfo((IObjectPK)invoicePK);
                if (invoiceInfo != null && (collection = invoiceInfo.getEntries()) != null && collection.size() > 0) {
                    int num = collection.size();
                    for (int i = 0; i < num; ++i) {
                        SaleInvoiceEntryInfo entryInfo = collection.get(i);
                        entryInfo.setWriteOffStatus(CheckOffStatusEnum.COMPLETECHEKCKOFF);
                        String SALEORDER_BILLTYPEID = "510b6503-0105-1000-e000-0113c0a812fd463ED552";
                        if (entryInfo.getCoreBillType() == null || !entryInfo.getCoreBillType().getId().toString().equals(SALEORDER_BILLTYPEID) || entryInfo.getSaleOrderEntry() == null) continue;
                        ObjectStringPK orderEntryPK = new ObjectStringPK(entryInfo.getSaleOrderEntry());
                        SaleOrderEntryInfo orderEntryInfo = isaleOrderEntry.getSaleOrderEntryInfo((IObjectPK)orderEntryPK);
                        BigDecimal oldReceAmount = orderEntryInfo.getTotalReceivedAmount();
                        if (oldReceAmount == null) {
                            oldReceAmount = new BigDecimal("0.00");
                        }
                        if (action.getActionType().getValue() == 5) {
                            orderEntryInfo.setTotalReceivedAmount(oldReceAmount.add(entryInfo.getTaxAmount().abs()));
                        }
                        isaleOrderEntry.update((IObjectPK)orderEntryPK, (CoreBaseInfo)orderEntryInfo);
                    }
                }
            }
        } else if (action.getActionType().getValue() == 10) {
            IEASBillEntryInfo receEntryInfo;
            IObjectCollection receEntryCollect;
            IEASBillHeadInfo receivingBillInfo = null;
            if (action.getDestBill() != null) {
                receivingBillInfo = (IEASBillHeadInfo)action.getDestBill();
            }
            if (receivingBillInfo != null && (receEntryCollect = receivingBillInfo.getEntries()) != null && receEntryCollect.size() > 0 && (receEntryInfo = (IEASBillEntryInfo)receEntryCollect.getObject(0)) != null && receEntryInfo.getSourceBillId() != null) {
                ObjectUuidPK invoicePK = new ObjectUuidPK(receEntryInfo.getSourceBillId());
                ISaleInvoice isaleInvoice = null;
                IBOTRelation ibotRelation = null;
                if (ctx != null) {
                    isaleInvoice = SaleInvoiceFactory.getLocalInstance((Context)ctx);
                    ibotRelation = BOTRelationFactory.getLocalInstance((Context)ctx);
                } else {
                    isaleInvoice = SaleInvoiceFactory.getRemoteInstance();
                    ibotRelation = BOTRelationFactory.getRemoteInstance();
                }
                SaleInvoiceInfo invoiceInfo = isaleInvoice.getSaleInvoiceInfo((IObjectPK)invoicePK);
                ArrayList list = ibotRelation.getDestObjIdByDestType(receivingBillInfo.getId().toString(), new VoucherInfo().getBOSType().toString());
                if (list != null && list.size() > 0) {
                    String id = list.get(0).toString();
                    IVoucher ivoucher = null;
                    ivoucher = ctx != null ? VoucherFactory.getLocalInstance((Context)ctx) : VoucherFactory.getRemoteInstance();
                    VoucherInfo voucherinfo = (VoucherInfo)ivoucher.getValue((IObjectPK)new ObjectStringPK(id));
                    invoiceInfo.setVoucherNumber(voucherinfo.getNumber());
                    invoiceInfo.setVoucher(voucherinfo);
                    invoiceInfo.setFiVouchered(true);
                    isaleInvoice.update((IObjectPK)new ObjectUuidPK(invoiceInfo.getId()), (CoreBaseInfo)invoiceInfo);
                }
            }
        } else if (action.getActionType().getValue() == 4) {
            IEASBillHeadInfo receivingBillInfo = null;
            if (action.getDestBill() != null) {
                receivingBillInfo = (IEASBillHeadInfo)action.getDestBill();
            }
            if (receivingBillInfo != null) {
                throw new SaleInvBizException(SaleInvBizException.RECEBILLWRITEBACKERROR_CANTUNAUDIT, new Object[]{receivingBillInfo.getNumber()});
            }
        } else if (action.getActionType().getValue() == 6) {
            IEASBillHeadInfo receivingBillInfo = null;
            if (action.getDestBill() != null) {
                receivingBillInfo = (IEASBillHeadInfo)action.getDestBill();
            }
            if (receivingBillInfo != null) {
                throw new SaleInvBizException(SaleInvBizException.RECEBILLWRITEBACKERROR_CANTUNREC, new Object[]{receivingBillInfo.getNumber()});
            }
        }
    }
}

