/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.fi.arap.api.IMacthUiIsOK;
import com.kingdee.eas.fi.arap.client.util.ArApBillUIUtil;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.client.ReceivingBillUI;
import com.kingdee.eas.fi.cas.client.ReceivingFilterUI;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.scm.sd.api.ISaleOrderExtendsInfo;
import com.kingdee.eas.scm.sd.sale.ReceivingMatchEntryCollection;
import com.kingdee.eas.scm.sd.sale.ReceivingMatchEntryInfo;
import com.kingdee.eas.scm.sd.sale.ReceivingMatchFactory;
import com.kingdee.eas.scm.sd.sale.ReceivingMatchInfo;
import com.kingdee.eas.scm.sd.sale.client.AbstractReceivingMatchRecordUI;
import com.kingdee.eas.scm.sd.sale.client.ReceivingMatchRecordFilterUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ReceivingMatchRecordUI
extends AbstractReceivingMatchRecordUI
implements IMacthUiIsOK {
    private static final Logger logger = CoreUIObject.getLogger(ReceivingMatchRecordUI.class);
    private boolean ok = false;
    private boolean forEdit = false;
    private ISaleOrderExtendsInfo order;
    private ReceivingMatchInfo receivingMatchInfo;
    private ReceivingFilterUI filterUI;
    private Color fullUsedColor = new Color(0xDDEEFF);
    private Color partUsedColor = new Color(0xEEDDFF);
    private Color normalColor = new Color(0xFFFFFF);
    public static final String SALEUIRESOURCE_PATH = "com.kingdee.eas.scm.sd.sale.SaleUIResource";
    private static final BigDecimal MAXVAL = new BigDecimal("999999999999.9999");
    private static final BigDecimal MINVAL = new BigDecimal("-999999999999.9999");
    private static final String SALEORDER_BILLTYPEID = "510b6503-0105-1000-e000-0113c0a812fd463ED552";
    private BigDecimal ZERO = new BigDecimal("0");
    private Color matchedColColor = new Color(0xFFFFF0);
    private boolean firstQuery = true;
    private String[] amountFields = new String[]{"actRecAmt", "actRecLocAmt", "verifiedAmt", "unVerifiedAmt", "entries.amount", "entries.amountVc", "entries.unVcAmount", "entries.rebate", "entries.actualAmt", "entries.actualAmtVc", "receivingMatchEntry.amount", "entries.unmatchedAmount"};
    FillListener fillListener = new FillListener();

    public void onLoad() throws Exception {
        int i;
        Object currencyPrecision;
        this.setIsCountAndSumRow(true);
        Map ctx = this.getUIContext();
        Boolean b = (Boolean)ctx.get("forEdit");
        this.forEdit = b == null ? false : b;
        String orderId = (String)ctx.get("orderId");
        if (!b.booleanValue()) {
            ctx.put("BOTPViewStatus", 1);
        } else {
            ctx.put("BOTPViewStatus", 0);
        }
        this.loadInitData(orderId);
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tblMain.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.getMatchedCol().getStyleAttributes().setBackground(this.matchedColColor);
        this.getUnMatchedCol().getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.getMatchedCol().getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        int precision = 2;
        if (this.tblMain.getRowCount() > 0 && (currencyPrecision = this.tblMain.getCell(0, "currency.precision").getValue()) != null) {
            try {
                precision = Integer.valueOf(currencyPrecision.toString());
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        this.txtUnMatched.setMaximumValue((Comparable)MAXVAL);
        this.txtUnMatched.setMinimumValue((Comparable)MINVAL);
        this.txtUnMatched.setDataType(1);
        this.txtUnMatched.setPrecision(precision);
        this.txtMatched.setMaximumValue((Comparable)MAXVAL);
        this.txtMatched.setMinimumValue((Comparable)MINVAL);
        this.txtMatched.setDataType(1);
        this.txtMatched.setPrecision(precision);
        this.txtUnMatched.setEditable(false);
        this.txtMatched.setEditable(false);
        this.actionSave.setEnabled(false);
        HashMap map = this.getActionManager().getActionSet();
        for (String action : map.keySet()) {
            boolean visiable = "actionQuery".equals(action) || "actionExit".equals(action) || "actionTraceDown".equals(action) || this.forEdit && "actionSave".equals(action);
            ((ItemAction)map.get(action)).setVisible(visiable);
        }
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.tblMain.getColumn("currency.precision").getStyleAttributes().setHided(false);
        String[] dateCols = new String[]{"bizDate", "createTime", "auditDate"};
        int size = dateCols.length;
        for (i = 0; i < size; ++i) {
            this.tblMain.getColumn(dateCols[i]).getStyleAttributes().setNumberFormat(ArApBillUtil.getDateFormatString());
        }
        if (this.forEdit) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReceivingMatchRecordUI.this.tblMain.requestFocus();
                }
            });
            this.getMatchedCol().getStyleAttributes().setLocked(false);
            this.getMatchedCol().setEditor((ICellEditor)ReceivingMatchRecordUI.createAmountEditor(precision, false));
            this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editStopping(KDTEditEvent e) {
                    ReceivingMatchRecordUI.this.onCellEditValueChanged(e);
                }

                public void editStopped(KDTEditEvent e) {
                    ReceivingMatchRecordUI.this.tableValueChanged(e);
                }
            });
        }
        for (i = 0; i < this.amountFields.length; ++i) {
            this.tblMain.getColumn(this.amountFields[i]).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    protected boolean isShowQueryDialogOnLoad() {
        return this.forEdit;
    }

    public String[] getMergeColumnKeys() {
        this.tblMain.checkParsed();
        String[] keys = new String[]{"number", "bizDate", "payerType.name", "payerNumber", "payerName", "billStatus", "currency.name", "exchangeRate", "adminOrgUnit.name", "person.name", "settlementType.name", "settlementNumber", "description", "payeeAccountBank.name", "payeeAccount.name", "payeeBank.name", "oppAccount.name", "actRecAmt", "actRecLocAmt", "verifiedAmt", "unVerifiedAmt", "coreBillType.name", "fiVouchered", "voucherType.name", "voucher.number", "payerBank", "payerAccountBank"};
        return keys;
    }

    private IColumn getMatchedCol() {
        return this.tblMain.getColumn("receivingMatchEntry.amount");
    }

    private IColumn getUnMatchedCol() {
        return this.tblMain.getColumn("entries.unmatchedAmount");
    }

    private void onCellEditValueChanged(KDTEditEvent e) {
        int r = e.getRowIndex();
        BigDecimal unmatched = this.getCellDoubleValue(this.tblMain.getCell(r, this.getUnMatchedCol().getColumnIndex()));
        Object obj = e.getValue();
        if (obj instanceof Number) {
            BigDecimal matched;
            BigDecimal bigDecimal = matched = obj == null ? this.ZERO : BigDecimal.valueOf(((Number)obj).doubleValue());
            if (matched.compareTo(unmatched) > 0) {
                e.setCancel(true);
            }
        } else if (obj == null) {
            obj = this.ZERO;
            e.setValue(obj);
        } else {
            e.setCancel(true);
        }
        if (!e.isCancel()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReceivingMatchRecordUI.this.refreshMatchUI();
                }
            });
        }
    }

    private BigDecimal getCellDoubleValue(ICell cell) {
        Object obj = cell.getValue();
        if (obj instanceof Number) {
            return BigDecimal.valueOf(((Number)obj).doubleValue());
        }
        return this.ZERO;
    }

    private static KDTDefaultCellEditor createAmountEditor(int precision, boolean isNegatived) {
        KDFormattedTextField f = new KDFormattedTextField();
        f.setDataType(1);
        f.setPrecision(precision);
        f.setMaximumValue((Comparable)MAXVAL);
        f.setMinimumValue((Comparable)MINVAL);
        f.setHorizontalAlignment(4);
        f.setSupportedEmpty(true);
        f.setRemoveingZeroInDispaly(false);
        f.setNegatived(isNegatived);
        return new KDTDefaultCellEditor((JTextField)f);
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        final boolean noResult = rowSet == null || rowSet.size() == 0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReceivingMatchRecordUI.this.data2UI(noResult);
                ReceivingMatchRecordUI.this.firstQuery = false;
            }
        });
    }

    protected void execQuery() {
        super.execQuery();
        this.firstQuery = true;
    }

    private void data2UI(boolean noResult) {
        this.txtUnMatched.setValue((Object)this.getUnPrereceivedAmount());
        this.txtMatched.setValue((Object)this.receivingMatchInfo.getAmount());
        int col_matched_index = this.getMatchedCol().getColumnIndex();
        if (noResult) {
            this.lblTip.setVisible(false);
            this.actionSave.setEnabled(false);
        } else {
            if (this.forEdit) {
                int n = this.tblMain.getRowCount3();
                for (int i = 0; i < n; ++i) {
                    this.tblMain.getRow(i).getCell(col_matched_index).setValue((Object)this.ZERO);
                }
                if (this.firstQuery) {
                    this.autoMatch();
                }
            } else {
                int col_entriesId_index = this.tblMain.getColumn("entries.id").getColumnIndex();
                int n = this.tblMain.getRowCount3();
                for (int i = 0; i < n; ++i) {
                    String entriesId = (String)this.tblMain.getCell(i, col_entriesId_index).getValue();
                    this.tblMain.getCell(i, col_matched_index).setValue((Object)this.getMatchedAMountByReceivingBillEntryId(entriesId));
                }
            }
            this.refreshMatchUI();
        }
    }

    private BigDecimal getUnPrereceivedAmount() {
        BigDecimal prepayment = this.order.getPrepayment() != null ? this.order.getPrepayment() : this.ZERO;
        BigDecimal beenPaidPrepayment = this.order.getBeenPaidPrepayment() != null ? this.order.getBeenPaidPrepayment() : this.ZERO;
        return prepayment.subtract(beenPaidPrepayment);
    }

    private BigDecimal getMatchedAMountByReceivingBillEntryId(String id) {
        ReceivingMatchEntryCollection mec = this.receivingMatchInfo.getEntrys();
        int n = mec.size();
        for (int i = 0; i < n; ++i) {
            String matchedBillEntryId = mec.get(i).getReceivingBillEntry().getId().toString();
            if (!id.equals(matchedBillEntryId)) continue;
            return mec.get(i).getAmount();
        }
        return this.ZERO;
    }

    private void autoMatch() {
        int col_matched_index = this.getMatchedCol().getColumnIndex();
        int col_unmatched_index = this.getUnMatchedCol().getColumnIndex();
        BigDecimal unmatched = this.getUnPrereceivedAmount();
        BigDecimal matched = this.ZERO;
        int n = this.tblMain.getRowCount3();
        for (int i = 0; i < n; ++i) {
            BigDecimal full = this.getCellDoubleValue(this.tblMain.getCell(i, col_unmatched_index));
            BigDecimal curMatch = this.ZERO;
            curMatch = matched.add(full).compareTo(unmatched) <= 0 ? full : unmatched.subtract(matched);
            this.tblMain.getCell(i, col_matched_index).setValue((Object)curMatch);
            matched = matched.add(curMatch);
            if (matched.compareTo(unmatched) == 0) break;
        }
    }

    private void refreshMatchUI() {
        double d2;
        this.actionSave.setEnabled(false);
        int col_matched_index = this.getMatchedCol().getColumnIndex();
        int col_unmatched_index = this.getUnMatchedCol().getColumnIndex();
        if (this.forEdit) {
            BigDecimal total = this.ZERO;
            int n = this.tblMain.getRowCount3();
            for (int i = 0; i < n; ++i) {
                total = total.add(this.getCellDoubleValue(this.tblMain.getCell(i, col_matched_index)));
            }
            this.txtMatched.setValue((Object)total);
            this.actionSave.setEnabled(total.compareTo(this.ZERO) > 0);
        }
        int n = this.tblMain.getRowCount3();
        for (int i = 0; i < n; ++i) {
            BigDecimal dt;
            BigDecimal dd = this.getCellDoubleValue(this.tblMain.getCell(i, col_matched_index));
            Color c = dd.compareTo(this.ZERO) > 0 ? (dd.compareTo(dt = this.getCellDoubleValue(this.tblMain.getCell(i, col_unmatched_index)).subtract(dd)) == 0 || dt.compareTo(this.ZERO) == 0 ? this.fullUsedColor : this.partUsedColor) : this.normalColor;
            this.tblMain.getRow(i).getStyleAttributes().setBackground(c);
            this.tblMain.getCell(i, col_matched_index).getStyleAttributes().setBackground(this.matchedColColor);
        }
        double d1 = this.txtUnMatched.getNumberValue() == null ? 0.0 : this.txtUnMatched.getNumberValue().doubleValue();
        double d = d2 = this.txtMatched.getNumberValue() == null ? 0.0 : this.txtMatched.getNumberValue().doubleValue();
        if (d1 != d2) {
            Object currencyPrecision;
            double dt = d2 - d1;
            BigDecimal v = new BigDecimal(Double.toString(dt));
            int precision = 2;
            if (this.tblMain.getRowCount() > 0 && (currencyPrecision = this.tblMain.getCell(0, "currency.precision").getValue()) != null) {
                try {
                    precision = Integer.valueOf(currencyPrecision.toString());
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage());
                }
            }
            v = v.setScale(precision, 4);
            String prefix = dt > 0.0 ? "+" : "";
            this.lblTip.setToolTipText(prefix + v);
            this.lblTip.setText(prefix + v);
            this.lblTip.setVisible(true);
            this.lblTip.setUserObject((Object)v);
        } else {
            this.clearMatchTip();
        }
        if (n < 0) {
            this.clearMatchTip();
        }
    }

    private void clearMatchTip() {
        this.lblTip.setText("");
        this.lblTip.setVisible(false);
        this.lblTip.setUserObject((Object)this.ZERO);
    }

    private static String getUIResource(String key) {
        return EASResource.getString((String)SALEUIRESOURCE_PATH, (String)key);
    }

    private void loadInitData(String orderId) {
        try {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            selector.add("companyOrgUnit.*");
            selector.add("entries.*");
            selector.add("entries.paymentCustomer.*");
            this.order = (ISaleOrderExtendsInfo)BusinessProcessUtil.getValueByBosType(null, (IObjectPK)new ObjectUuidPK(orderId), (SelectorItemCollection)selector);
            if (this.forEdit && this.order.isIsMatched()) {
                MsgBox.showInfo((Component)((Object)this), (String)ReceivingMatchRecordUI.getUIResource("saleorder_already_match_receivingbill"));
                SysUtil.abort();
            }
            this.receivingMatchInfo = ReceivingMatchFactory.getRemoteInstance().getMatchInfo(this.order.getId().toString());
            this.receivingMatchInfo.setSaleOrderID(this.order.getId().toString());
            if (this.forEdit) {
                this.receivingMatchInfo.setCompany(this.order.getCompanyOrgUnit());
            }
            this.setUITitle(this.getUITitle() + " - " + ReceivingMatchRecordUI.getUIResource("receivingmatchui_title_saleorder") + this.order.getNumber());
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo ff = new FilterInfo();
        FilterItemCollection fc = ff.getFilterItems();
        if (this.forEdit) {
            fc.add(new FilterItemInfo("billStatus", (Object)new Integer(14)));
            fc.add(new FilterItemInfo("company.id", (Object)this.order.getCompanyOrgUnit().getId().toString()));
            fc.add(new FilterItemInfo("entries.recBillType.number", (Object)new Integer(101)));
            fc.add(new FilterItemInfo("entries.entryRecBillType.preSetBillType.number", (Object)new Integer(101)));
            fc.add(new FilterItemInfo("currency.id", (Object)this.order.getCurrency().getId().toString()));
            if (this.order.getEntries().size() > 0) {
                String companyID = "";
                if (this.order.getEntries() != null && this.order.getEntries().getObject(0).get("paymentCustomer") != null) {
                    CustomerInfo customer = (CustomerInfo)this.order.getEntries().getObject(0).get("paymentCustomer");
                    companyID = customer.getId().toString();
                }
                fc.add(new FilterItemInfo("payerID", (Object)companyID));
            }
            fc.add(new FilterItemInfo("entries.unmatchedAmount", (Object)this.ZERO, CompareType.GREATER));
            fc.add(new FilterItemInfo("entries.coreBillType.id", (Object)SALEORDER_BILLTYPEID, CompareType.NOTEQUALS));
            fc.add(new FilterItemInfo("entries.coreBillType.id", null, CompareType.EQUALS));
            if (this.order.getEntries().size() > 0) {
                ff.setMaskString("#0and#1and(#2or#3)and#4and#5and#6and(#7or#8)");
            } else {
                ff.setMaskString("#0and#1and(#2or#3)and#4and#5and(#6or#7)");
            }
        } else {
            ReceivingMatchEntryCollection en = this.receivingMatchInfo.getEntrys();
            HashSet<String> receivingBIllEntryIdSet = new HashSet<String>();
            int n = en.size();
            for (int i = 0; i < n; ++i) {
                receivingBIllEntryIdSet.add(en.get(i).getReceivingBillEntry().getId().toString());
            }
            if (receivingBIllEntryIdSet != null && receivingBIllEntryIdSet.size() > 0) {
                fc.add(new FilterItemInfo("entries.id", receivingBIllEntryIdSet, CompareType.INCLUDE));
            }
        }
        return ff;
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected String getQueryName() {
        return "com.kingdee.eas.scm.sd.sale.ReceivingMatchRecordViewQuery";
    }

    protected String getQueryUiName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return (ICoreBase)BusinessProcessUtil.getBizInteface(null, (BOSObjectType)new BOSObjectType("C48A423A"));
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int col_matched_index = this.getMatchedCol().getColumnIndex();
        if (e.getClickCount() >= 2) {
            if (this.forEdit && e.getColIndex() != col_matched_index) {
                int col_unmatched_index = this.getUnMatchedCol().getColumnIndex();
                KDTSelectBlock b = this.tblMain.getSelectManager().get();
                if (b != null) {
                    int r = b.getBeginRow();
                    IRow row = this.tblMain.getRow(r);
                    ICell cell = row.getCell(col_matched_index);
                    BigDecimal oldValue = this.getCellDoubleValue(cell);
                    BigDecimal fullValue = this.getCellDoubleValue(row.getCell(col_unmatched_index));
                    BigDecimal newValue = this.ZERO;
                    if (oldValue.compareTo(this.ZERO) == 0) {
                        BigDecimal total = this.ZERO;
                        int n = this.tblMain.getRowCount3();
                        for (int i = 0; i < n; ++i) {
                            if (i == r) continue;
                            total = total.add(this.getCellDoubleValue(this.tblMain.getCell(i, col_matched_index)));
                        }
                        BigDecimal dt = this.getUnPrereceivedAmount().subtract(total);
                        newValue = dt.compareTo(fullValue) > 0 || dt.compareTo(this.ZERO) <= 0 ? fullValue : dt;
                    } else if (oldValue.compareTo(fullValue) < 0) {
                        newValue = fullValue;
                    } else {
                        newValue = this.ZERO;
                        cell.setValue((Object)this.ZERO);
                    }
                    if (oldValue.compareTo(newValue) != 0) {
                        cell.setValue((Object)newValue);
                        this.refreshMatchUI();
                    }
                }
            } else if (!this.forEdit) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ReceivingMatchRecordUI.this.setCursorOfWair();
                            ReceivingMatchRecordUI.this.actionTraceDown_actionPerformed(null);
                        }
                        catch (Exception e) {
                            ReceivingMatchRecordUI.this.handleException(e);
                        }
                        finally {
                            ReceivingMatchRecordUI.this.setCursorOfDefault();
                        }
                    }
                });
            }
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        this.actionTraceDown.setEnabled(this.getSelectTop() != -1);
    }

    private boolean save() throws EASBizException, BOSException {
        if (this.tblMain.getRowCount3() == 0) {
            return false;
        }
        double dt = ((BigDecimal)this.lblTip.getUserObject()).doubleValue();
        if (dt < 0.0 ? MsgBox.showConfirm2((Component)((Object)this), (String)ReceivingMatchRecordUI.getUIResource("confirm_save_match_lessthan")) != 0 : dt > 0.0 && MsgBox.showConfirm2((Component)((Object)this), (String)ReceivingMatchRecordUI.getUIResource("confirm_save_match_largethan")) != 0) {
            return false;
        }
        int col_matched_index = this.getMatchedCol().getColumnIndex();
        int col_entriesId_index = this.tblMain.getColumn("entries.id").getColumnIndex();
        ReceivingMatchInfo mm = (ReceivingMatchInfo)this.receivingMatchInfo.clone();
        BigDecimal prepayAmount = this.order.getPrepayment();
        ReceivingMatchEntryCollection entries = mm.getEntrys();
        BigDecimal matched = this.ZERO;
        int n = this.tblMain.getRowCount3();
        for (int i = 0; i < n; ++i) {
            BigDecimal dd = this.getCellDoubleValue(this.tblMain.getCell(i, col_matched_index));
            if (dd.compareTo(this.ZERO) <= 0) continue;
            matched = matched.add(dd);
            ReceivingMatchEntryInfo item = new ReceivingMatchEntryInfo();
            item.setAmount(dd);
            ReceivingBillEntryInfo rbEntry = new ReceivingBillEntryInfo();
            rbEntry.setId(BOSUuid.read((String)((String)this.tblMain.getCell(i, col_entriesId_index).getValue())));
            item.put("receivingBillEntry", rbEntry);
            entries.addObject((IObjectValue)item);
        }
        BigDecimal orderMatchedAmount = new BigDecimal(this.txtUnMatched.getBigDecimalValue().toString());
        BigDecimal sumMatchedAmount = matched;
        if (dt == 0.0 && orderMatchedAmount.compareTo(sumMatchedAmount) > 0 ? MsgBox.showConfirm2((Component)((Object)this), (String)ReceivingMatchRecordUI.getUIResource("confirm_save_match_lessthan")) != 0 : dt == 0.0 && orderMatchedAmount.compareTo(sumMatchedAmount) < 0 && MsgBox.showConfirm2((Component)((Object)this), (String)ReceivingMatchRecordUI.getUIResource("confirm_save_match_largethan")) != 0) {
            return false;
        }
        if (prepayAmount.compareTo(sumMatchedAmount) < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ReceivingMatchRecordUI.getUIResource("orderAmount_largethan_prepareAmount"));
            return false;
        }
        mm.setAmount(sumMatchedAmount);
        mm.setMatcher(SysContext.getSysContext().getCurrentUserInfo());
        ReceivingMatchFactory.getRemoteInstance().match(this.order.getId().toString(), mm);
        return true;
    }

    private int getSelectTop() {
        KDTSelectBlock b = this.tblMain.getSelectManager().get();
        if (b != null) {
            return b.getTop();
        }
        return -1;
    }

    @Override
    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        int r = this.getSelectTop();
        if (r != -1) {
            String id = (String)this.tblMain.getCell(r, "id").getValue();
            UIContext ctx = new UIContext((Object)this);
            ctx.put((Object)"ID", (Object)id);
            ctx.put((Object)"openModel", (Object)"frame");
            try {
                IUIWindow ui = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(ReceivingBillUI.class.getName(), (Map)ctx, null, OprtState.VIEW);
                ui.show();
            }
            catch (Exception e1) {
                this.handleException(e1);
            }
        }
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.save()) {
            this.ok = true;
            this.getUIWindow().hide();
        }
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        this.ok = false;
        this.getUIWindow().hide();
    }

    public boolean isOK() {
        return this.ok;
    }

    protected void initListener() {
        super.initListener();
        this.tblMain.getDataRequestManager().addDataFillListener((KDTDataFillListener)this.fillListener);
    }

    private void setListUITablePrecision(int start, int end) {
        for (int i = start; i <= end; ++i) {
            IRow row = this.tblMain.getRow(i);
            int precision = 2;
            ICell cell = row.getCell("currency.precision");
            if (cell != null && cell.getValue() != null) {
                precision = Integer.parseInt(cell.getValue().toString());
            }
            for (int j = 0; j < this.amountFields.length; ++j) {
                ArApBillUIUtil.setPrecision(row.getCell(this.amountFields[j]), precision);
            }
        }
    }

    protected SystemEnum getSysEnum() {
        return SystemEnum.ACCOUNTSRECEIVABLE;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new ReceivingMatchRecordFilterUI(false, SourceTypeEnum.AR, this.cache, this.order, this.receivingMatchInfo);
        }
        if (this.getBOTPViewStatus() == 1) {
            this.filterUI.getUIContext().put("TargetBillType", "ReceiptForm");
        }
        return this.filterUI;
    }

    protected CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog queryDlg = super.getQueryDlg();
        queryDlg.setWidth(424);
        queryDlg.setHeight(342);
        return queryDlg;
    }

    protected boolean isFootVisible() {
        return true;
    }

    private void tableValueChanged(KDTEditEvent e) {
        int rowIndex = e.getRowIndex();
        BigDecimal prepayAmount = this.order.getPrepayment();
        BigDecimal matched = this.ZERO;
        int n = this.tblMain.getRowCount3();
        for (int i = 0; i < n; ++i) {
            BigDecimal dd = this.getCellDoubleValue(this.tblMain.getCell(i, this.getMatchedCol().getColumnIndex()));
            if (dd.compareTo(this.ZERO) <= 0) continue;
            matched = matched.add(dd);
        }
        if (prepayAmount.compareTo(matched) < 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ReceivingMatchRecordUI.getUIResource("orderAmount_largethan_prepareAmount"));
            this.tblMain.getCell(rowIndex, this.getMatchedCol().getColumnIndex()).setValue(e.getOldValue());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReceivingMatchRecordUI.this.refreshMatchUI();
                }
            });
        }
    }

    protected void initDapButtons() throws Exception {
        super.initDapButtons();
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
    }

    private final class FillListener
    implements KDTDataFillListener {
        private FillListener() {
        }

        public void afterDataFill(KDTDataRequestEvent e) {
            ReceivingMatchRecordUI.this.setListUITablePrecision(e.getFirstRow(), e.getLastRow());
        }
    }
}

