/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.sale.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.dynbusiness.util.BusinessProcessUtil;
import com.kingdee.eas.fi.arap.util.ArApBillUtil;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.framework.report.util.CellMatrix;
import com.kingdee.eas.framework.report.util.KDTableUtil;
import com.kingdee.eas.scm.common.client.SCMClientUtils;
import com.kingdee.eas.scm.sd.api.ISaleOrderExtendsInfo;
import com.kingdee.eas.scm.sd.sale.ReceivingMatchEntryCollection;
import com.kingdee.eas.scm.sd.sale.ReceivingMatchEntryInfo;
import com.kingdee.eas.scm.sd.sale.ReceivingMatchFactory;
import com.kingdee.eas.scm.sd.sale.ReceivingMatchInfo;
import com.kingdee.eas.scm.sd.sale.client.AbstractReceivingMatchUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.swing.JScrollBar;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ReceivingMatchUI
extends AbstractReceivingMatchUI {
    private static final Logger logger = CoreUIObject.getLogger(ReceivingMatchUI.class);
    private boolean ok = false;
    private ReceivingMatchInfo receivingMatchInfo;
    private ISaleOrderExtendsInfo saleOrder;
    private boolean forEdit = false;
    private IColumn col_number;
    private IColumn col_seq;
    private IColumn col_bizDate;
    private IColumn col_payerType;
    private IColumn col_payer;
    private IColumn col_unmatched;
    private IColumn col_matched;
    public static final String SALEUIRESOURCE_PATH = "com.kingdee.eas.scm.sd.sale.SaleUIResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.col_number = this.tblMain.getColumn("number");
        this.col_seq = this.tblMain.getColumn("seq");
        this.col_bizDate = this.tblMain.getColumn("bizDate");
        this.col_payerType = this.tblMain.getColumn("payerType");
        this.col_payer = this.tblMain.getColumn("payer");
        this.col_unmatched = this.tblMain.getColumn("unmatched");
        this.col_matched = this.tblMain.getColumn("matched");
        this.col_number.setWidth(120);
        this.col_number.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.col_seq.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.CENTER);
        this.col_unmatched.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.col_matched.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.col_bizDate.getStyleAttributes().setNumberFormat(ArApBillUtil.getDateFormatString());
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getLayoutManager().setVerticalScrollBar(new JScrollBar(1));
        this.tblMain.getLayoutManager().setHorizonScrollBar(new JScrollBar(0));
        this.txtUnMatched.setEditable(false);
        this.txtMatched.setEditable(false);
        this.txtUnMatched.setMaximumValue((Comparable)SCMClientUtils.MAXVAL);
        this.txtUnMatched.setMinimumValue((Comparable)SCMClientUtils.MINVAL);
        this.txtUnMatched.setDataType(1);
        this.txtUnMatched.setPrecision(3);
        this.txtMatched.setMaximumValue((Comparable)SCMClientUtils.MAXVAL);
        this.txtMatched.setMinimumValue((Comparable)SCMClientUtils.MINVAL);
        this.txtMatched.setDataType(1);
        this.txtMatched.setPrecision(3);
        this.load();
        this.btnOK.setVisible(this.forEdit);
        if (this.forEdit) {
            this.autoMatch();
            this.data2UI();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ReceivingMatchUI.this.tblMain.requestFocus();
                }
            });
            this.col_matched.getStyleAttributes().setLocked(false);
            this.col_matched.setEditor((ICellEditor)ReceivingMatchUI.createAmountEditor(3, false));
            this.tblMain.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

                public void editStopping(KDTEditEvent e) {
                    ReceivingMatchUI.this.onCellEditValueChanged(e);
                }
            });
        } else {
            this.btnCancel.setText(ReceivingMatchUI.getUIResource("receivingmatchui_button_close"));
            this.data2UI();
        }
    }

    private static KDTDefaultCellEditor createAmountEditor(int i, boolean isNegatived) {
        KDFormattedTextField f = new KDFormattedTextField();
        f.setDataType(1);
        f.setPrecision(i % 11);
        f.setMaximumValue((Comparable)SCMClientUtils.MAXVAL);
        f.setMinimumValue((Comparable)SCMClientUtils.MINVAL);
        f.setHorizontalAlignment(4);
        f.setSupportedEmpty(true);
        f.setRemoveingZeroInDispaly(false);
        f.setNegatived(isNegatived);
        return new KDTDefaultCellEditor((JTextField)f);
    }

    public static String getUIResource(String key) {
        return EASResource.getString((String)SALEUIRESOURCE_PATH, (String)key);
    }

    private void load() {
        Map ctx = this.getUIContext();
        String orderId = (String)ctx.get("orderId");
        Boolean b = (Boolean)ctx.get("forEdit");
        this.forEdit = b == null ? false : b;
        try {
            this.receivingMatchInfo = ReceivingMatchFactory.getRemoteInstance().getMatchInfo(orderId);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("*");
            this.saleOrder = (ISaleOrderExtendsInfo)BusinessProcessUtil.getValueByBosType(null, (IObjectPK)new ObjectUuidPK(this.receivingMatchInfo.getSaleOrderID()), (SelectorItemCollection)selector);
            this.setUITitle(this.getUITitle() + "-" + ReceivingMatchUI.getUIResource("receivingmatchui_title_saleorder") + this.saleOrder.getNumber());
            if (this.forEdit && this.saleOrder.isIsMatched()) {
                MsgBox.showInfo((Component)((Object)this), (String)ReceivingMatchUI.getUIResource("saleorder_already_match_receivingbill"));
                SysUtil.abort();
            }
        }
        catch (Exception e) {
            this.handleException(e);
            SysUtil.abort();
        }
    }

    private void onCellEditValueChanged(KDTEditEvent e) {
        int r = e.getRowIndex();
        double unmatched = this.getMatchedValue(this.tblMain.getCell(r, this.col_unmatched.getColumnIndex()));
        Object obj = e.getValue();
        if (obj instanceof Number) {
            double matched = ((Number)obj).doubleValue();
            if (matched > unmatched) {
                e.setCancel(true);
            }
        } else if (obj == null) {
            obj = new BigDecimal("0");
            e.setValue(obj);
        } else {
            e.setCancel(true);
        }
        if (!e.isCancel()) {
            this.receivingMatchInfo.getEntrys().get(r).setAmount(new BigDecimal(String.valueOf(obj)));
            this.refreshMatchUI();
        }
    }

    private void refreshMatchUI() {
        double matched = 0.0;
        int n = this.receivingMatchInfo.getEntrys().size();
        for (int i = 0; i < n; ++i) {
            Color c;
            ReceivingMatchEntryInfo entry = this.receivingMatchInfo.getEntrys().get(i);
            double dd = entry.getAmount().doubleValue();
            if (dd > 0.0) {
                matched += dd;
                ReceivingBillEntryInfo re = entry.getReceivingBillEntry();
                double dt = re.getAmount().subtract(re.getMatchedAmount()).doubleValue();
                c = dd == dt || dt == 0.0 ? new Color(0xDDEEFF) : new Color(0xEEDDFF);
            } else {
                c = new Color(0xFFFFFF);
            }
            this.tblMain.getRow(i).getStyleAttributes().setBackground(c);
            this.tblMain.getCell(i, this.col_matched.getColumnIndex()).getStyleAttributes().setBackground(new Color(0xFFFFF0));
        }
        this.receivingMatchInfo.setAmount(new BigDecimal(matched));
        this.txtMatched.setValue((Object)this.receivingMatchInfo.getAmount());
        BigDecimal bMatched = new BigDecimal(matched);
        if (bMatched.compareTo(this.saleOrder.getUnPrereceivedAmount()) != 0) {
            double dt = matched - this.saleOrder.getUnPrereceivedAmount().doubleValue();
            BigDecimal v = new BigDecimal(Double.toString(dt));
            v = v.setScale(3, 4);
            String prefix = dt > 0.0 ? "+" : "";
            this.lblTip.setToolTipText(prefix + v);
            this.lblTip.setText(prefix + v);
            this.lblTip.setVisible(true);
            this.lblTip.setUserObject((Object)v);
        } else {
            this.lblTip.setVisible(false);
            this.lblTip.setUserObject((Object)new BigDecimal("0"));
        }
    }

    private void autoMatch() {
        double unmatched = this.saleOrder.getUnPrereceivedAmount().doubleValue();
        double matched = 0.0;
        int n = this.receivingMatchInfo.getEntrys().size();
        for (int i = 0; i < n; ++i) {
            ReceivingMatchEntryInfo entry = this.receivingMatchInfo.getEntrys().get(i);
            ReceivingBillEntryInfo re = entry.getReceivingBillEntry();
            double full = re.getAmount().subtract(re.getMatchedAmount()).doubleValue();
            double dd = 0.0;
            dd = matched + full <= unmatched ? full : unmatched - matched;
            entry.setAmount(new BigDecimal(dd));
            BigDecimal bUnmatched = new BigDecimal(Double.toString(unmatched));
            BigDecimal bMatched = new BigDecimal(Double.toString(matched += dd));
            if (bMatched.compareTo(bUnmatched) == 0) break;
        }
        this.receivingMatchInfo.setAmount(new BigDecimal(matched));
    }

    private double getMatchedValue(ICell cell) {
        Object obj = cell.getValue();
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        return 0.0;
    }

    private void data2UI() {
        this.txtUnMatched.setValue((Object)this.saleOrder.getUnPrereceivedAmount());
        this.tblMain.removeRows();
        int n = this.receivingMatchInfo.getEntrys().size();
        this.btnOK.setEnabled(n > 0);
        Object[][] dd = new Object[n][1];
        for (int i = 0; i < n; ++i) {
            ReceivingMatchEntryInfo entry = this.receivingMatchInfo.getEntrys().get(i);
            IRow row = this.tblMain.addRow();
            ReceivingBillEntryInfo re = entry.getReceivingBillEntry();
            dd[i][0] = re.getReceivingBill().getNumber();
            row.getCell(this.col_number.getKey()).setValue((Object)re.getReceivingBill().getNumber());
            row.getCell(this.col_seq.getKey()).setValue((Object)new Integer(re.getSeq()));
            row.getCell(this.col_bizDate.getKey()).setValue((Object)re.getReceivingBill().getBizDate());
            row.getCell(this.col_payerType.getKey()).setValue((Object)re.getReceivingBill().getPayerType());
            row.getCell(this.col_payer.getKey()).setValue((Object)re.getReceivingBill().getPayerName());
            BigDecimal bc = re.getAmount().subtract(re.getMatchedAmount());
            row.getCell(this.col_unmatched.getKey()).setValue((Object)bc);
            row.getCell(this.col_matched.getKey()).setValue((Object)entry.getAmount());
        }
        KDTableUtil.mergeTableCell((List)CellMatrix.parseAutoMatchMergeRegion((Object[][])dd), (boolean)false, (KDTable)this.tblMain);
        this.refreshMatchUI();
    }

    private boolean save() throws EASBizException, BOSException {
        double dt = ((BigDecimal)this.lblTip.getUserObject()).doubleValue();
        if (dt < 0.0 ? MsgBox.showConfirm2((Component)((Object)this), (String)ReceivingMatchUI.getUIResource("confirm_save_match_lessthan")) != 0 : dt > 0.0 && MsgBox.showConfirm2((Component)((Object)this), (String)ReceivingMatchUI.getUIResource("confirm_save_match_largethan")) != 0) {
            return false;
        }
        ReceivingMatchInfo mm = (ReceivingMatchInfo)this.receivingMatchInfo.clone();
        ReceivingMatchEntryCollection mc = mm.getEntrys();
        ReceivingMatchEntryInfo e = null;
        int size = mc.size();
        for (int i = 0; i < size; ++i) {
            e = mc.get(i);
            if (e == null || e.getAmount().doubleValue() != 0.0) continue;
            mc.removeObject(i);
            --i;
        }
        mm.setMatcher(SysContext.getSysContext().getCurrentUserInfo());
        if (this.receivingMatchInfo != null && this.saleOrder != null) {
            ReceivingMatchFactory.getRemoteInstance().match(this.saleOrder.getId().toString(), mm);
        }
        return true;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        if (this.save()) {
            this.ok = true;
            this.getUIWindow().hide();
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.ok = false;
        this.getUIWindow().hide();
    }

    public boolean isOK() {
        return this.ok;
    }
}

