/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arap_tax.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.ar.ArInvoiceCollection;
import com.kingdee.eas.fi.ar.ArInvoiceFactory;
import com.kingdee.eas.fi.ar.IArInvoice;
import com.kingdee.eas.fi.arap.InvoiceTypeEnum;
import com.kingdee.eas.fi.arap.client.InvoiceQueryUI;
import com.kingdee.eas.fi.arap_tax.GTaxImportLog;
import com.kingdee.eas.fi.arap_tax.GTaxImporter;
import com.kingdee.eas.fi.arap_tax.ITaxRelation;
import com.kingdee.eas.fi.arap_tax.SaleInvoiceExporter;
import com.kingdee.eas.fi.arap_tax.TaxBaseDataFactory;
import com.kingdee.eas.fi.arap_tax.TaxBaseDataInfo;
import com.kingdee.eas.fi.arap_tax.TaxBillTypeEnum;
import com.kingdee.eas.fi.arap_tax.TaxFileTypeEnum;
import com.kingdee.eas.fi.arap_tax.TaxRelationFactory;
import com.kingdee.eas.fi.arap_tax.TaxRelationInfo;
import com.kingdee.eas.fi.arap_tax.TaxRelationTypeEnum;
import com.kingdee.eas.fi.arap_tax.client.AbstractTaxRelationList;
import com.kingdee.eas.fi.arap_tax.client.GTaxDataFileUI;
import com.kingdee.eas.fi.arap_tax.client.GTaxDataLogUI;
import com.kingdee.eas.fi.arap_tax.client.TaxBaseDataEdit;
import com.kingdee.eas.fi.arap_tax.client.TaxRelationEdit;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class TaxRelationList
extends AbstractTaxRelationList {
    private static final Logger logger = CoreUIObject.getLogger(TaxRelationList.class);
    private static final String RES = "com.kingdee.eas.fi.arap_tax.client.GTaxEasResource";
    private CommonQueryDialog exportViewDialog = null;
    private File importDataFile = null;
    private File exportDataFile = null;
    public String resClassName = "com.kingdee.eas.fi.ar.ArReport";
    private final InvoiceQueryUI vatInvoiceQueryUI = new InvoiceQueryUI(InvoiceTypeEnum.VAT);
    private final InvoiceQueryUI generalInvoiceQueryUI = new InvoiceQueryUI(InvoiceTypeEnum.GENERAL);
    private CustomerQueryPanel queryUI = null;
    public static final String SCMRESOURCE_PATH = "com.kingdee.eas.scm.common.SCMResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.btnBaseDataMap.setIcon(EASResource.getIcon((String)"imgTbtn_addmapping"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
        this.actionImport.setVisible(false);
        this.tblMain.getColumn("name").setWidth(200);
        this.tblMain.getColumn("note").setWidth(160);
    }

    protected String getEditUIName() {
        return TaxRelationEdit.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TaxRelationFactory.getRemoteInstance();
    }

    @Override
    protected void btnBaseDataMap_actionPerformed(ActionEvent e) throws Exception {
        String billID = this.getSelectedKeyValue();
        if (billID == null || billID.length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)"taxlist_1"));
            SysUtil.abort();
        }
        TaxBaseDataInfo data = null;
        try {
            data = TaxBaseDataFactory.getRemoteInstance().getTaxBaseDataInfo(" where  relationID='" + billID + "'");
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        if (data != null) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"RelationID", (Object)billID);
            uiContext.put((Object)"ID", (Object)data.getId().toString());
            uiContext.put((Object)"actionEvent", (Object)e);
            IUIWindow relationUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TaxBaseDataEdit.class.getName(), (Map)uiContext, null, OprtState.EDIT);
            relationUI.show();
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"RelationID", (Object)billID);
            uiContext.put((Object)"actionEvent", (Object)e);
            IUIWindow relationUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(TaxBaseDataEdit.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            relationUI.show();
        }
    }

    @Override
    public void actionExport_actionPerformed(ActionEvent e) throws Exception {
        File file;
        TaxRelationInfo rInfo = this.getSelectedInfo();
        if (rInfo == null || rInfo.getRelationType().equals((Object)TaxRelationTypeEnum.Import)) {
            return;
        }
        EntityViewInfo entityViewInfo = this.getExportEntityView(rInfo);
        if (entityViewInfo == null) {
            this.setShowMessagePolicy(2);
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.scm.sd.sale.SALEAutoGenerateResource", (String)"20_TaxRelationList"));
            this.setIsShowTextOnly(false);
            this.setMessageBgcolor(SHOW_MESSAGE_BG_DEFAULT);
            this.setMessageIcon(SHOW_MESSAGE_ICON_ERROR);
            this.showMessage();
            return;
        }
        this.exportDataFile = file = this.getImportExportFile(rInfo.getFiletype(), true);
        if (file == null) {
            return;
        }
        this.setCursorOfWair();
        Date beginDate = new Date();
        IArInvoice iArInvoice = ArInvoiceFactory.getRemoteInstance();
        ArInvoiceCollection collection = iArInvoice.getArInvoiceCollection(entityViewInfo);
        if (collection == null || collection.size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"InvoiceNull"));
            SysUtil.abort();
        }
        SaleInvoiceExporter exporter = new SaleInvoiceExporter(rInfo);
        GTaxImportLog log = exporter.export(collection, file);
        log.startTime = beginDate;
        UIContext logCtx = new UIContext((Object)this);
        logCtx.put((Object)"exportLog", (Object)log);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(GTaxDataLogUI.class.getName(), (Map)logCtx);
        uiWindow.show();
    }

    public static String getStandardFilterTitle(String uiKey) {
        String value = TaxRelationList.getResource("ConditionFilter");
        if ("Missing Resource".equals(value)) {
            value = "ConditionFilter";
        }
        return uiKey + " - " + value;
    }

    public static String getResource(String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return EASResource.getString((String)SCMRESOURCE_PATH, (String)strKey);
    }

    private EntityViewInfo getExportEntityView(TaxRelationInfo info) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.fi.ar.app", "ArInvoiceQuery");
        if (this.exportViewDialog == null) {
            this.exportViewDialog = new CommonQueryDialog();
            this.exportViewDialog.setQueryObjectPK((IMetaDataPK)queryPK);
            this.exportViewDialog.setOwner((Component)this.getUIContext().get("OwnerWindow"));
            this.exportViewDialog.setShowFilter(true);
            this.exportViewDialog.setShowSorter(true);
            this.exportViewDialog.setTitle(TaxRelationList.getStandardFilterTitle(this.getUITitle()));
            this.exportViewDialog.setWidth(495);
            this.exportViewDialog.setHeight(267);
        }
        this.queryUI = TaxBillTypeEnum.SaleInvoice.equals((Object)info.getBilltype()) ? this.vatInvoiceQueryUI : this.generalInvoiceQueryUI;
        this.exportViewDialog.clearUserPanels();
        this.exportViewDialog.addUserPanel((KDPanel)this.queryUI);
        this.exportViewDialog.setParentUIClassName(TaxRelationList.class.getName());
        this.setCursorOfDefault();
        EntityViewInfo queryEV = null;
        if (!this.exportViewDialog.show()) {
            SysUtil.abort();
        }
        queryEV = this.getEntityViewInfo(this.exportViewDialog.getEntityViewInfoResult());
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        queryEV.getSelector().clear();
        queryEV.getSelector().add("id");
        exec.setObjectView(queryEV);
        IRowSet rowSet = exec.executeQuery();
        if (rowSet == null || rowSet.size() == 0) {
            return null;
        }
        HashSet<String> idSet = new HashSet<String>();
        rowSet.beforeFirst();
        while (rowSet.next() && !StringUtils.isEmpty((String)rowSet.getString("id"))) {
            String id = rowSet.getString("id");
            if (!BOSUuid.isValidLength((String)id)) continue;
            idSet.add(id);
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("auditPerson.*");
        sic.add("drawer.*");
        sic.add("invPerson.*");
        sic.add("accountBank.bankAccountNumber");
        sic.add("entries.*");
        sic.add("entries.material.*");
        sic.add("entries.measureUnit.name");
        ev.getSelector().addObjectCollection((IObjectCollection)sic);
        ev.setFilter(filter);
        return ev;
    }

    private File getImportExportFile(TaxFileTypeEnum fileType, boolean fExport) throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"fileType", (Object)fileType);
        if (fExport) {
            uiCtx.put((Object)"selectedFile", (Object)this.exportDataFile);
            uiCtx.put((Object)"export", (Object)"true");
        } else {
            uiCtx.put((Object)"selectedFile", (Object)this.importDataFile);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(GTaxDataFileUI.class.getName(), (Map)uiCtx);
        uiWindow.show();
        GTaxDataFileUI fileUI = (GTaxDataFileUI)uiWindow.getUIObject();
        return fileUI.getSelectedFile();
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        this.setCursorOfDefault();
        TaxRelationInfo rInfo = this.getSelectedInfo();
        if (rInfo == null || !rInfo.getRelationType().equals((Object)TaxRelationTypeEnum.Import)) {
            return;
        }
        this.importDataFile = this.getImportExportFile(rInfo.getFiletype(), false);
        if (this.importDataFile == null) {
            return;
        }
        this.setCursorOfWair();
        GTaxImporter invoiceImporter = new GTaxImporter(rInfo);
        GTaxImportLog log = invoiceImporter.importData(this.importDataFile);
        UIContext param = new UIContext((Object)this);
        param.put((Object)"importLog", (Object)log);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(GTaxDataLogUI.class.getName(), (Map)param);
        uiWindow.show();
    }

    private TaxRelationInfo getSelectedInfo() throws BOSException, EASBizException {
        String id = this.getSelectedKeyValue();
        if (id == null || id.length() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)this.resClassName, (String)"taxlist_1"));
            return null;
        }
        ITaxRelation iRelation = TaxRelationFactory.getRemoteInstance();
        ObjectStringPK pk = new ObjectStringPK(id);
        TaxRelationInfo rInfo = iRelation.getTaxRelationInfo((IObjectPK)pk);
        return rInfo;
    }
}

