/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgSelect;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.OrgUnitTreePromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.arf.ArRefundmentBillCollection;
import com.kingdee.eas.fi.arf.ArRefundmentBillEntryCollection;
import com.kingdee.eas.fi.arf.ArRefundmentBillEntryInfo;
import com.kingdee.eas.fi.arf.ArRefundmentBillFactory;
import com.kingdee.eas.fi.arf.ArRefundmentBillInfo;
import com.kingdee.eas.fi.arf.IArRefundmentBill;
import com.kingdee.eas.fi.arf.client.AbstractArRefundmentBillEditUI;
import com.kingdee.eas.fi.arf.client.BillPrintDataSource;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ArRefundmentBillEditUI
extends AbstractArRefundmentBillEditUI {
    public static final BigDecimal MAXVAL = new BigDecimal("999999999999.9999");
    public static final BigDecimal MINVAL = new BigDecimal("-999999999999.9999");
    private UserInfo currentUser = null;
    private CompanyOrgUnitInfo currentCompany = null;
    private ICodingRuleManager iCodingRuleManager;
    private static final Logger logger = CoreUIObject.getLogger(ArRefundmentBillEditUI.class);
    IDynamicObject dynamicObject = null;
    private Map amountFields = new HashMap();
    private String sNumber = "";
    private static final String PERSON_HOMEPHONE_KEY = "person_homePhone_key";
    private static final String CUSTOMER_ADDRESS_KEY = "customer_address_key";
    private boolean isBotpCreateView = false;

    public ArRefundmentBillEditUI() throws Exception {
        this.currentUser = SysContext.getSysContext().getCurrentUserInfo();
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
    }

    public void loadFields() {
        if (this.getBOTPViewStatus() == 1) {
            this.editData.setTotalAmount(this.calculateTotalAmount());
            this.setEntryValue(this.editData.getEntries());
        }
        if (this.editData.getCurrency() != null) {
            this.setPrecision(this.editData.getCurrency());
        }
        this.txttotalAmount.setRemoveingZeroInDispaly(false);
        this.txttotalAmount.setHorizontalAlignment(4);
        this.prmtAccountCussent.setEnabled(false);
        this.prmtasstActType.setEnabled(false);
        this.prmtcurrency.setEnabled(false);
        this.dataBinder.loadFields();
        this.setNumberEnabled();
        this.kdtEntrys.setEditable(false);
        this.prmtAccountCussent.setValue(null);
        if (this.editData.getAsstActId() != null && this.editData.getAsstActId().toString().length() > 0 && !this.editData.getAsstActId().toString().equals("0")) {
            BOSUuid uuid = BOSUuid.read((String)this.editData.getAsstActId());
            ObjectUuidPK pk = new ObjectUuidPK(uuid);
            BOSObjectType objType = uuid.getType();
            try {
                if (this.dynamicObject == null) {
                    this.dynamicObject = DynamicObjectFactory.getRemoteInstance();
                }
                IObjectValue objectValue = this.dynamicObject.getValue(objType, (IObjectPK)pk);
                this.prmtAccountCussent.setData((Object)objectValue);
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        this.prmtCompany.setValue((Object)this.currentCompany);
        this.bizPromptCreator.setValue((Object)this.currentUser);
        Date now = new Date();
        this.dateCreateTime.setValue((Object)new Timestamp(now.getTime()));
        this.prmtAccountCussent.setEnabled(false);
        this.setBillTotalAmount();
        this.setEntryValue();
        this.actionEdit.setEnabled(false);
        this.actionRemove.setEnabled(false);
        if ("ADDNEW".equals(this.getOprtState())) {
            this.actionSubmit.setEnabled(false);
            this.actionCreateFrom.setEnabled(true);
            this.actionRevoke.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
        } else if ("EDIT".equals(this.getOprtState()) && this.editData.getBillStatus() == null) {
            this.actionSubmit.setEnabled(true);
            this.actionCreateFrom.setEnabled(false);
            this.actionRevoke.setEnabled(true);
            this.actionRemoveLine.setEnabled(true);
        } else if (DeletedStatusEnum.NORMAL.equals((Object)this.editData.getBillStatus())) {
            this.actionSubmit.setEnabled(false);
            this.actionCreateFrom.setEnabled(false);
            this.actionRevoke.setEnabled(true);
            this.actionRemoveLine.setEnabled(false);
        } else {
            this.actionSubmit.setEnabled(false);
            this.actionCreateFrom.setEnabled(false);
            this.actionRevoke.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
        }
        try {
            this.setAcctCussentProps();
        }
        catch (Exception e) {
            logger.error((Object)"Set acct cussent properties error:", (Throwable)e);
        }
    }

    private void setAcctCussentProps() throws EASBizException, BOSException {
        String officePhone = null;
        if (this.editData.getAsstActId() != null) {
            BOSUuid asstActId = BOSUuid.read((String)this.editData.getAsstActId());
            if (new CustomerInfo().getBOSType().equals((Object)asstActId.getType())) {
                CustomerInfo customerInfo = CustomerFactory.getRemoteInstance().getCustomerInfo("select address where id='" + this.editData.getAsstActId() + "'");
                this.editData.put(CUSTOMER_ADDRESS_KEY, customerInfo.getAddress());
            }
        }
        ObjectUuidPK pk = null;
        if (this.editData.getCreator() != null) {
            pk = new ObjectUuidPK(this.editData.getCreator().getId());
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("person.officePhone");
        UserInfo userInfo = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)pk, sic);
        if (userInfo.getPerson() != null) {
            officePhone = userInfo.getPerson().getOfficePhone();
        }
        this.editData.put(PERSON_HOMEPHONE_KEY, officePhone);
    }

    private void setBillTotalAmount() {
        int rowIndex = 0;
        BigDecimal totalAmount = new BigDecimal("0.00");
        BigDecimal receiveAmount = new BigDecimal("0.00");
        this.prmtAccountCussent.setEnabled(false);
        this.prmtAccountCussent.setEnabled(false);
        this.prmtasstActType.setEnabled(false);
        this.billStatus.setEnabled(false);
        this.prmtcurrency.setEnabled(false);
        this.txttotalAmount.setEditable(false);
        this.pkbillDate.setEnabled(true);
        CurrencyInfo currencyInfo = (CurrencyInfo)this.prmtcurrency.getData();
        int precision = 2;
        if (currencyInfo != null) {
            precision = currencyInfo.getPrecision();
        }
        KDFormattedTextField currencyTextField = this.getBigDecimalTextField(precision, true);
        currencyTextField.setRoundingMode(4);
        String format = ArRefundmentBillEditUI.getNumberFormat(precision);
        KDTDefaultCellEditor numCellEditor = new KDTDefaultCellEditor((JTextField)currencyTextField);
        this.kdtEntrys.getColumn("amount").setEditor((ICellEditor)numCellEditor);
        this.kdtEntrys.getColumn("amount").getStyleAttributes().setNumberFormat(format);
        this.kdtEntrys.getColumn("price").setEditor((ICellEditor)numCellEditor);
        this.kdtEntrys.getColumn("price").getStyleAttributes().setNumberFormat(format);
        this.kdtEntrys.getColumn("quantity").setEditor((ICellEditor)numCellEditor);
        this.kdtEntrys.getColumn("quantity").getStyleAttributes().setNumberFormat(format);
        while (rowIndex < this.kdtEntrys.getRowCount()) {
            IRow row = this.kdtEntrys.getRow(rowIndex);
            receiveAmount = (BigDecimal)row.getCell("amount").getValue();
            if (receiveAmount != null) {
                totalAmount = totalAmount.add(receiveAmount);
            }
            ++rowIndex;
        }
        this.txttotalAmount.setValue((Object)totalAmount.abs());
    }

    private void setEntryValue(ArRefundmentBillEntryCollection entryCol) {
        for (int i = 0; i < entryCol.size(); ++i) {
            ArRefundmentBillEntryInfo entryInfo = entryCol.get(i);
            if (entryInfo.getQuantity() == null || entryInfo.getQuantity().compareTo(new BigDecimal("0.0")) == 0) {
                entryInfo.setQuantity(new BigDecimal("1"));
                if (entryInfo.getAmount() == null) continue;
                entryInfo.setPrice(entryInfo.getAmount().abs());
                continue;
            }
            entryInfo.setQuantity(entryInfo.getQuantity().abs());
        }
    }

    private void setEntryValue() {
        BigDecimal quantity = new BigDecimal("0.00");
        BigDecimal amount = new BigDecimal("0.00");
        for (int rowIndex = 0; rowIndex < this.kdtEntrys.getRowCount(); ++rowIndex) {
            IRow row = this.kdtEntrys.getRow(rowIndex);
            quantity = (BigDecimal)row.getCell("quantity").getValue();
            amount = (BigDecimal)row.getCell("amount").getValue();
            if (quantity == null || quantity.compareTo(new BigDecimal("0.0")) == 0) {
                row.getCell("quantity").setValue((Object)new BigDecimal("1"));
                row.getCell("price").setValue((Object)amount.abs());
            } else {
                row.getCell("quantity").setValue((Object)quantity.abs());
            }
            row.getCell("amount").setValue((Object)amount.abs());
        }
    }

    public void storeFields() {
        super.storeFields();
        if (this.prmtAccountCussent.getValue() != null) {
            IObjectValue accountCussent = (IObjectValue)this.prmtAccountCussent.getValue();
            this.editData.setAsstActId(accountCussent.getString("id"));
            this.editData.setAsstActName(accountCussent.getString("name"));
            this.editData.setAsstActNumber(accountCussent.getString("number"));
        }
        this.initOldData((IObjectValue)this.editData);
    }

    public void onLoad() throws Exception {
        this.actionAddLine.setVisible(false);
        this.actionRemoveLine.setVisible(true);
        this.actionInsertLine.setVisible(false);
        this.actionCopyFrom.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionMultiapprove.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionTraceUp.setVisible(false);
        this.actionAttachment.setVisible(false);
        this.prmtAccountCussent.setEnabled(false);
        this.prmtasstActType.setEnabled(false);
        this.prmtCompany.setEnabled(false);
        super.onLoad();
        ArRefundmentBillEditUI.setCompanyF7((IUIObject)this, this.prmtCompany, this.currentCompany);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    private BigDecimal calculateTotalAmount() {
        BigDecimal totalAmount = new BigDecimal("0.00");
        ArRefundmentBillEntryCollection entryCol = this.editData.getEntries();
        for (int i = 0; i < entryCol.size(); ++i) {
            ArRefundmentBillEntryInfo entryInfo = entryCol.get(i);
            if (entryInfo.getAmount() == null) continue;
            totalAmount = totalAmount.add(entryInfo.getAmount());
        }
        return totalAmount;
    }

    private void setPrecision(CurrencyInfo currencyInfo) {
        int precision = currencyInfo.getPrecision();
        this.txttotalAmount.setPrecision(precision);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getCU() == null) {
            this.editData.setCU(this.currentCompany.getCU());
        }
        super.actionSubmit_actionPerformed(e);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.invokePrintFunction(e, true);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.invokePrintFunction(e, false);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.btnCreateFrom.setEnabled(true);
        this.pkbillDate.setEnabled(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setOprtState("EDIT");
        this.pkbillDate.setEnabled(true);
        if ("EDIT".equals(this.oprtState)) {
            this.actionRemoveLine.setEnabled(true);
            this.pkbillDate.setEnabled(true);
            this.billStatus.setEnabled(false);
        }
    }

    public void actionCreateFrom_actionPerformed(ActionEvent e) throws Exception {
        this.sNumber = this.txtNumber.getText();
        HashMap<String, String> ctx = new HashMap<String, String>();
        this.isBotpCreateView = true;
        ctx.put("TargetBillType", "arRefundmentBill");
        this.getBillEdit().createFrom(this.getMainOrgContext(), ctx);
        if (!StringUtils.isEmpty((String)this.sNumber)) {
            this.txtNumber.setText(this.sNumber);
        }
        this.actionSubmit.setEnabled(true);
    }

    public int getBtpCreateFromType() {
        return 1;
    }

    protected String getEditUIName() {
        return ArRefundmentBillEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ArRefundmentBillFactory.getRemoteInstance();
    }

    protected KDTable getDetailTable() {
        return this.kdtEntrys;
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return new ArRefundmentBillEntryInfo();
    }

    protected IObjectValue createNewData() {
        ArRefundmentBillInfo objectValue = new ArRefundmentBillInfo();
        objectValue.setCompany(this.currentCompany);
        objectValue.setCreator(this.currentUser);
        Date now = new Date();
        objectValue.setCreateTime(new Timestamp(now.getTime()));
        objectValue.setBillStatus(DeletedStatusEnum.NORMAL);
        return objectValue;
    }

    private void setNumberEnabled() {
        if (this.editData == null) {
            return;
        }
        try {
            boolean isAutoNumber = this.isAutoNumber();
            if ("ADDNEW".equals(this.getOprtState())) {
                if (isAutoNumber) {
                    this.txtNumber.setEnabled(false);
                }
            } else if ("EDIT".equals(this.getOprtState())) {
                boolean isAddView = this.isAddView();
                if (isAutoNumber) {
                    if (this.editData.getBillStatus() == null && isAddView && StringUtils.isEmpty((String)this.editData.getNumber())) {
                        this.txtNumber.setEnabled(false);
                        this.txtNumber.setText(ArRefundmentBillEditUI.getNumberFromCodeRule(this.editData));
                    }
                } else {
                    this.txtNumber.setEnabled(true);
                    this.txtNumber.setText(this.sNumber);
                }
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private boolean isAddView() throws BOSException, CodingRuleException, EASBizException {
        if (this.iCodingRuleManager == null) {
            this.iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        }
        return this.iCodingRuleManager.isAddView((IObjectValue)this.editData, this.currentCompany.getId().toString());
    }

    private boolean isAutoNumber() throws CodingRuleException, EASBizException, BOSException {
        if (this.iCodingRuleManager == null) {
            this.iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        }
        return this.iCodingRuleManager.isExist((IObjectValue)this.editData, this.currentCompany.getId().toString());
    }

    private boolean isCheckNumber() throws CodingRuleException, EASBizException, BOSException {
        return !this.isAutoNumber() || this.isAddView();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        IRow row = null;
        int entryRowCount = this.kdtEntrys.getRowCount();
        if (entryRowCount <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)ArRefundmentBillEditUI.getStrResource("entryIsNull"));
            SysUtil.abort();
        }
        if (StringUtils.isEmpty((String)this.txtNumber.getText()) && this.isCheckNumber()) {
            MsgBox.showError((Component)((Object)this), (String)ArRefundmentBillEditUI.getStrResource("numberIsNull"));
            this.txtNumber.requestFocus();
            SysUtil.abort();
        }
        if (this.pkbillDate.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)ArRefundmentBillEditUI.getStrResource("invDateIsNull"));
            this.pkbillDate.requestFocus();
            SysUtil.abort();
        }
        if (this.editData.getAsstActId() == null || this.prmtAccountCussent.getValue() == null) {
            MsgBox.showError((Component)((Object)this), (String)ArRefundmentBillEditUI.getStrResource("AcctAccountIsNull"));
            SysUtil.abort();
        }
        for (int i = 0; i < entryRowCount; ++i) {
            row = this.kdtEntrys.getRow(i);
            if (row.getCell("srcBillEntryId").getValue() != null && row.getCell("id").getValue() != null) continue;
            MsgBox.showInfo((String)ArRefundmentBillEditUI.getStrResource("SourceIDIsNull"));
            SysUtil.abort();
        }
        super.beforeStoreFields(e);
    }

    public void actionRevoke_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            IArRefundmentBill iArRefundmentBill = ArRefundmentBillFactory.getRemoteInstance();
            iArRefundmentBill.revoke((IObjectPK)pk);
            this.billStatus.setSelectedIndex(1);
            this.btnRevoke.setEnabled(false);
            this.btnCreateFrom.setEnabled(false);
            this.actionRemove.setEnabled(false);
            this.actionRemoveLine.setEnabled(false);
            this.actionRevoke.setEnabled(false);
            this.btnRemoveLine.setEnabled(false);
            this.actionCreateFrom.setEnabled(false);
            this.actionEdit.setEnabled(false);
            this.btnEdit.setEnabled(false);
        }
    }

    protected void invokePrintFunction(ActionEvent e, boolean noPreview) {
        ArRefundmentBillCollection billCol = new ArRefundmentBillCollection();
        billCol.add(this.editData);
        KDNoteHelper appHlp = new KDNoteHelper();
        BillPrintDataSource rsprv = new BillPrintDataSource(billCol){

            public BillPrintDataSource.ColDesc[] getColDesc() {
                return new BillPrintDataSource.ColDesc[]{new BillPrintDataSource.ColDesc("FNumber", "number"), new BillPrintDataSource.ColDesc("FBillDate", "billDate", 2), new BillPrintDataSource.ColDesc("FCussType", "asstActType.name"), new BillPrintDataSource.ColDesc("FCurrency", "currency.name"), new BillPrintDataSource.ColDesc("FTotalAmount", "totalAmount", 1, "2"), new BillPrintDataSource.ColDesc("FCussNum", "asstActNumber"), new BillPrintDataSource.ColDesc("FCussName", "asstActName"), new BillPrintDataSource.ColDesc("FSummary", "entries.remark"), new BillPrintDataSource.ColDesc("FTicketNumber", "entries.ticketNumber"), new BillPrintDataSource.ColDesc("FBizDate", "entries.bizDate", 2), new BillPrintDataSource.ColDesc("FChangeNumber", "entries.ticketNumber"), new BillPrintDataSource.ColDesc("FMaturityDate", "entries.maturityDate", 2), new BillPrintDataSource.ColDesc("FQuantity", "entries.quantity", 1, "2"), new BillPrintDataSource.ColDesc("FPrice", "entries.price", 1, "2"), new BillPrintDataSource.ColDesc("FDiscount", "entries.discount", 1, "2"), new BillPrintDataSource.ColDesc("FAmount", "entries.amount", 1, "2"), new BillPrintDataSource.ColDesc("FPersonPhone", ArRefundmentBillEditUI.PERSON_HOMEPHONE_KEY), new BillPrintDataSource.ColDesc("FCustomerAddress", ArRefundmentBillEditUI.CUSTOMER_ADDRESS_KEY)};
            }
        };
        if (noPreview) {
            appHlp.print("/FI/ArF/ArReFundBill", (Object)rsprv, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview("/FI/ArF/ArReFundBill", (Object)rsprv, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    protected void applyDefaultValue(IObjectValue vo) {
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("cu.id"));
        return sic;
    }

    public SelectorItemCollection getBOTPSelectors() {
        SelectorItemCollection sic = super.getBOTPSelectors();
        sic.add(new SelectorItemInfo("cu.id"));
        return sic;
    }

    public void setOprtState(String oprtType) {
        if (this.isBotpCreateView) {
            super.setOprtState("EDIT");
        } else {
            super.setOprtState(oprtType);
        }
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public KDFormattedTextField getBigDecimalTextField(int precision, boolean isNegatived) {
        String key = String.valueOf(precision) + String.valueOf(isNegatived);
        KDFormattedTextField amountField = (KDFormattedTextField)this.amountFields.get(key);
        if (amountField == null) {
            amountField = new KDFormattedTextField();
            amountField.setDataType(1);
            amountField.setPrecision(precision);
            amountField.setMaximumValue((Comparable)MAXVAL);
            amountField.setMinimumValue((Comparable)MINVAL);
            amountField.setHorizontalAlignment(4);
            amountField.setSupportedEmpty(true);
            amountField.setRemoveingZeroInDispaly(false);
            amountField.setNegatived(isNegatived);
            this.amountFields.put(key, amountField);
        }
        return amountField;
    }

    public static String getNumberFormat(int precision) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < precision; ++i) {
            buffer.append("0");
        }
        String precisionTag = buffer.toString();
        if (precisionTag.length() > 0) {
            precisionTag = "." + precisionTag;
        }
        String format = "#,##0" + precisionTag;
        return format;
    }

    public static String getNumberFromCodeRule(BillBaseInfo billInfo) throws CodingRuleException, EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        String sysNumber = null;
        if (billInfo.getCompany() == null) {
            return null;
        }
        String companyID = billInfo.getCompany().getId().toString();
        sysNumber = iCodingRuleManager.getNumber((IObjectValue)billInfo, companyID);
        return sysNumber;
    }

    public static void setCompanyF7(IUIObject uiObj, KDBizPromptBox prmtCompany, CompanyOrgUnitInfo currentCompany) {
        OrgType[] CompanyType = new OrgType[]{OrgType.Company};
        prmtCompany.setEditFormat("$number$");
        prmtCompany.setDisplayFormat("$name$");
        prmtCompany.setEditable(true);
        prmtCompany.setCommitFormat("$number$");
        OrgUnitTreePromptBox boxCompany = new OrgUnitTreePromptBox(uiObj, CompanyType, null, OrgSelect.OnlySelectCompanyEntity, false, false, false);
        prmtCompany.setSelector((KDPromptSelector)boxCompany);
        prmtCompany.setData((Object)currentCompany);
        prmtCompany.setEnabled(false);
    }

    public static String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.arf.client.ArfResource", (String)resKey);
    }
}

