/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.arf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ISystemStatusCtrol;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolCollection;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.arf.ArRefundmentBillFactory;
import com.kingdee.eas.fi.arf.ArRefundmentBillInfo;
import com.kingdee.eas.fi.arf.IArRefundmentBill;
import com.kingdee.eas.fi.arf.client.AbstractArRefundmentBillListUI;
import com.kingdee.eas.fi.arf.client.ArRefundmentBillEditUI;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ArRefundmentBillListUI
extends AbstractArRefundmentBillListUI {
    private static final Logger logger = CoreUIObject.getLogger(ArRefundmentBillListUI.class);
    private CompanyOrgUnitInfo currentCompany = null;
    protected static final String COL_PRECISION = "currency.precision";
    private String[] AMOUNTFIELDS = new String[]{"entrys.amount", "totalAmount", "entrys.price", "entrys.quantity"};
    private int basePrecision = 2;
    private UserInfo currentUser = null;

    public ArRefundmentBillListUI() throws Exception {
        if (this.currentUser == null) {
            this.currentUser = SysContext.getSysContext().getCurrentUserInfo();
        }
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (this.currentCompany == null) {
            MsgBox.showInfo((Component)((Object)this), (String)ArRefundmentBillListUI.getStrResource("currentCompanyIsNull"));
            SysUtil.abort();
        }
        if (this.currentCompany.isIsOnlyUnion()) {
            MsgBox.showInfo((Component)((Object)this), (String)ArRefundmentBillListUI.getStrResource("currentCompanyIsVirtual"));
            SysUtil.abort();
        }
        if (this.currentCompany.getBaseCurrency() != null) {
            this.basePrecision = ArRefundmentBillListUI.getBaseCurrency(this.currentCompany).getPrecision();
        } else {
            MsgBox.showError((Component)((Object)this), (String)ArRefundmentBillListUI.getStrResource("currentBaseCurrencyIsNull"));
            SysUtil.abort();
        }
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                ArRefundmentBillListUI.this.tblMain_afterDataFill(e);
            }
        });
    }

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        SystemStatusCtrolInfo ctrlInfo = ArRefundmentBillListUI.getSysStatusCtrolInfo(this.currentCompany, SystemEnum.GENERALLEDGER);
        if (ctrlInfo == null || !ctrlInfo.isIsStart()) {
            MsgBox.showError((Component)((Object)this), (String)ArRefundmentBillListUI.getStrResource("GLIsNotStart"));
            SysUtil.abort();
        }
        super.onLoad();
        this.actionMultiapprove.setVisible(false);
        this.actionNextPerson.setVisible(false);
        this.actionVoucher.setVisible(false);
        this.actionDelVoucher.setVisible(false);
        this.actionCopyTo.setVisible(false);
        this.actionCreateTo.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionTraceDown.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionAttachment.setVisible(true);
        this.menuEdit.setVisible(false);
        this.menuWorkFlow.setVisible(false);
        this.actionWorkFlowG.setVisible(false);
        this.btnRevoke.setIcon(EASResource.getIcon((String)"imgTbtn_blankout"));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        view.setFilter(filter);
        this.actionRemove.setEnabled(false);
        this.actionRemove.setVisible(false);
        this.btnRemove.setVisible(false);
        this.btnRemove.setEnabled(false);
        this.actionEdit.setEnabled(false);
        this.btnEdit.setEnabled(false);
        this.btnEdit.setVisible(false);
        this.actionRevoke.setVisible(false);
        this.tblMain.setColumnMoveable(true);
    }

    public void actionRevoke_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String[] billIdList = this.getSelectedListId();
        IArRefundmentBill iArRefundmentBill = ArRefundmentBillFactory.getRemoteInstance();
        for (int i = 0; i < billIdList.length; ++i) {
            ObjectUuidPK pk = new ObjectUuidPK(billIdList[i]);
            iArRefundmentBill.revoke((IObjectPK)pk);
        }
        this.actionRefresh_actionPerformed(null);
    }

    public String[] getSelectedListId() {
        this.checkSelected();
        ArrayList blocks = this.tblMain.getSelectManager().getBlocks();
        ArrayList<Object> idList = new ArrayList<Object>();
        for (KDTSelectBlock block : blocks) {
            int top = block.getTop();
            int bottom = block.getBottom();
            for (int rowIndex = top; rowIndex <= bottom; ++rowIndex) {
                ICell cell = this.tblMain.getRow(rowIndex).getCell(this.getKeyFieldName());
                if (idList.contains(cell.getValue())) continue;
                idList.add(cell.getValue());
            }
        }
        String[] listId = null;
        if (idList != null && idList.size() > 0) {
            Iterator iterat = idList.iterator();
            listId = new String[idList.size()];
            int index = 0;
            while (iterat.hasNext()) {
                listId[index] = (String)iterat.next();
                ++index;
            }
        }
        return listId;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
    }

    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception {
        super.actionPageSetup_actionPerformed(e);
    }

    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception {
        super.actionExitCurrent_actionPerformed(e);
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
    }

    public void actionAbout_actionPerformed(ActionEvent e) throws Exception {
        super.actionAbout_actionPerformed(e);
    }

    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception {
        super.actionOnLoad_actionPerformed(e);
    }

    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMessage_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionImportData_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        super.actionAttachment_actionPerformed(e);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        super.actionExportData_actionPerformed(e);
    }

    public void actionToExcel_actionPerformed(ActionEvent e) throws Exception {
        super.actionToExcel_actionPerformed(e);
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionStartWorkFlow_actionPerformed(e);
    }

    public void actionPublishReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionPublishReport_actionPerformed(e);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCreateTo_actionPerformed(e);
    }

    public void actionCopyTo_actionPerformed(ActionEvent e) throws Exception {
        super.actionCopyTo_actionPerformed(e);
    }

    public void actionTraceUp_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceUp_actionPerformed(e);
    }

    public void actionTraceDown_actionPerformed(ActionEvent e) throws Exception {
        super.actionTraceDown_actionPerformed(e);
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    public void actionDelVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelVoucher_actionPerformed(e);
    }

    public void actionAuditResult_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditResult_actionPerformed(e);
    }

    public void actionViewDoProccess_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewDoProccess_actionPerformed(e);
    }

    public void actionMultiapprove_actionPerformed(ActionEvent e) throws Exception {
        super.actionMultiapprove_actionPerformed(e);
    }

    public void actionNextPerson_actionPerformed(ActionEvent e) throws Exception {
        super.actionNextPerson_actionPerformed(e);
    }

    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrint_actionPerformed(e);
    }

    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionTDPrintPreview_actionPerformed(e);
    }

    protected String getEditUIName() {
        return ArRefundmentBillEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return ArRefundmentBillFactory.getRemoteInstance();
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected IObjectValue createNewData() {
        ArRefundmentBillInfo objectValue = new ArRefundmentBillInfo();
        return objectValue;
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        FilterItemInfo companyFilter = new FilterItemInfo("company.id", (Object)this.currentCompany.getId(), CompareType.EQUALS);
        FilterItemInfo statusFilter = new FilterItemInfo("billStatus", (Object)Integer.valueOf("0"), CompareType.NOTEQUALS);
        FilterInfo oldFilter = ev.getFilter();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(companyFilter);
        filter.getFilterItems().add(statusFilter);
        try {
            oldFilter.mergeFilter(filter, "AND");
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        ev.setFilter(oldFilter);
        super.beforeExcutQuery(ev);
    }

    public void tblMain_afterDataFill(KDTDataRequestEvent e) {
        try {
            this.changeShowData(e.getFirstRow(), e.getLastRow());
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
            logger.error((Object)"After data fill", (Throwable)e1);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
            logger.error((Object)"After data fill", (Throwable)e1);
        }
    }

    private void changeShowData(int fistRow, int lastRow) throws EASBizException, BOSException {
        for (int i = fistRow; i <= lastRow; ++i) {
            IRow row = this.tblMain.getRow(i);
            ICell cell = row.getCell(COL_PRECISION);
            int precision = 2;
            if (cell != null && cell.getValue() != null) {
                try {
                    precision = Integer.parseInt(cell.getValue().toString());
                }
                catch (Exception e) {
                    precision = 2;
                }
            }
            for (int j = 0; j < this.AMOUNTFIELDS.length; ++j) {
                ArRefundmentBillListUI.setPrecision(row.getCell(this.AMOUNTFIELDS[j]), precision);
            }
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.GENERALLEDGER;
    }

    public static SystemStatusCtrolInfo getSysStatusCtrolInfo(CompanyOrgUnitInfo cmpnyOrgUntInfObj, SystemEnum system) throws BOSException {
        if (!(cmpnyOrgUntInfObj instanceof CompanyOrgUnitInfo)) {
            throw new IllegalArgumentException("Current company is null!");
        }
        CompanyOrgUnitInfo cmpnyOrgUntInf = cmpnyOrgUntInfObj;
        String cmpnyOrgUntID = cmpnyOrgUntInf.getId().toString();
        ISystemStatusCtrol systemStatusCtrol = SystemStatusCtrolFactory.getRemoteInstance();
        String cndtn0 = "(company='" + cmpnyOrgUntID + "')";
        String cndtn1 = "(systemStatus.name=" + system.getValue() + ")";
        String cndtn = cndtn0 + " and " + cndtn1;
        String oql = "select *,currentPeriod.*,startPeriod.* where " + cndtn;
        SystemStatusCtrolCollection systmStsCtrlCllctn = systemStatusCtrol.getSystemStatusCtrolCollection(oql);
        int size = systmStsCtrlCllctn.size();
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            SystemStatusCtrolInfo systmStsCtrlInf = systmStsCtrlCllctn.get(0);
            return systmStsCtrlInf;
        }
        throw new IllegalArgumentException();
    }

    public static CurrencyInfo getBaseCurrency(CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        if (company == null || company.getBaseCurrency() == null) {
            throw new IllegalArgumentException();
        }
        return CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId()));
    }

    public static void setPrecision(ICell cell, int precision) {
        if (cell == null) {
            return;
        }
        String sFormat = ArRefundmentBillListUI.getNumberFormat(precision);
        cell.getStyleAttributes().setNumberFormat(sFormat);
    }

    public static String getNumberFormat(int precision) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < precision; ++i) {
            buffer.append("0");
        }
        String precisionTag = buffer.toString();
        if (precisionTag.length() > 0) {
            precisionTag = "." + precisionTag;
        }
        String format = "#,##0" + precisionTag;
        return format;
    }

    public static String getStrResource(String resKey) {
        return EASResource.getString((String)"com.kingdee.eas.fi.arf.client.ArfResource", (String)resKey);
    }
}

