/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.BookTypeEnum;
import com.kingdee.eas.fi.books.RuleEnum;
import com.kingdee.eas.fi.books.client.AbstractAccountSchemeEditUI;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.framework.ICoreBase;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class AccountSchemeEditUI
extends AbstractAccountSchemeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountSchemeEditUI.class);

    public AccountSchemeEditUI() throws Exception {
        this.jbInit();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kcbRule.addItems(RuleEnum.getEnumList().toArray());
        this.kcbBookType.addItems(BookTypeEnum.getEnumList().toArray());
        if (this.editData != null) {
            this.kcbRule.setSelectedIndex(RuleEnum.getEnumList().indexOf((Object)this.editData.getRule()));
            this.kcbBookType.setSelectedIndex(BookTypeEnum.getEnumList().indexOf((Object)this.editData.getBookType()));
        }
        this.txtNumber.setRequired(true);
        this.txtName.setRequired(true);
        this.setUIMenuBar(null);
        this.chkMenuItemSubmitAndAddNew.setSelected(false);
    }

    private void jbInit() {
        this.initMyIcon();
    }

    public void initMyIcon() {
        this.btnSave.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnCancel.setVisible(false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_LOCAL_CURRENCY_ID, CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("id", (Object)CurrencyInfo.GENERAL_REPORT_CURRENCY_ID, CompareType.NOTEQUALS));
        fic.add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        filter.setMaskString("#0 AND #1 AND #2");
        this.prmtCurrency.setEntityViewInfo(view);
        this.prmtReportCurrency.setEntityViewInfo(view);
        this.txtNumber.setMaxLength(40);
        this.txtName.setMaxLength(40);
        this.kDTextArea1.setMaxLength(100);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        this.setFieldsStatus();
    }

    private void setFieldsStatus() {
        if (this.getOprtState().equals(OprtState.EDIT) && this.editData.getId() != null) {
            boolean isUse = this.editData.isIsLock();
            try {
                if (!isUse && !this.editData.isIsMaster()) {
                    isUse = BooksUtil.isUsedByCompany(null, this.editData.getId().toString()) != null;
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            if (isUse) {
                this.prmtPeriodType.setEnabled(false);
                this.prmtAdjRateTable.setEnabled(false);
                this.prmtCurrency.setEnabled(false);
                this.prmtRateTable.setEnabled(false);
                this.prmtAccountTable.setEnabled(false);
                this.prmtReportCurrency.setEnabled(false);
                this.prmtRptRateTable.setEnabled(false);
                this.comboType.setEnabled(false);
                this.kcbBookType.setEnabled(false);
                this.kcbRule.setEnabled(false);
            }
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("isMaster"));
        sic.add(new SelectorItemInfo("isLock"));
        return sic;
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        super.actionCancel_actionPerformed(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setFieldsStatus();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        AcountSchemeInfo data = new AcountSchemeInfo();
        data.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        data.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        CompanyOrgUnitInfo company = BooksUtil.getCurrentMasterCompany(null);
        if (company != null) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("baseCurrency.id"));
            sic.add(new SelectorItemInfo("baseCurrency.number"));
            sic.add(new SelectorItemInfo("baseCurrency.name"));
            sic.add(new SelectorItemInfo("reportCurrency.id"));
            sic.add(new SelectorItemInfo("reportCurrency.number"));
            sic.add(new SelectorItemInfo("reportCurrency.name"));
            sic.add(new SelectorItemInfo("accountPeriodType.id"));
            sic.add(new SelectorItemInfo("accountPeriodType.number"));
            sic.add(new SelectorItemInfo("accountPeriodType.name"));
            sic.add(new SelectorItemInfo("reportConvertMode"));
            sic.add(new SelectorItemInfo("accountTable.id"));
            sic.add(new SelectorItemInfo("accountTable.name"));
            sic.add(new SelectorItemInfo("accountTable.number"));
            sic.add(new SelectorItemInfo("baseExchangeTable.id"));
            sic.add(new SelectorItemInfo("baseExchangeTable.name"));
            sic.add(new SelectorItemInfo("baseExchangeTable.number"));
            sic.add(new SelectorItemInfo("adjustExchangeTable.id"));
            sic.add(new SelectorItemInfo("adjustExchangeTable.name"));
            sic.add(new SelectorItemInfo("adjustExchangeTable.number"));
            sic.add(new SelectorItemInfo("reportExchangeTable.id"));
            sic.add(new SelectorItemInfo("reportExchangeTable.name"));
            sic.add(new SelectorItemInfo("reportExchangeTable.number"));
            try {
                company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()), sic);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            data.setAccountTable(company.getAccountTable());
            data.setPeriodType(company.getAccountPeriodType());
            data.setAdjRateTable(company.getAdjustExchangeTable());
            data.setCurrency(company.getBaseCurrency());
            data.setRptRateTable(company.getReportExchangeTable());
            data.setReportCurrency(company.getReportCurrency());
            data.setRateTable(company.getBaseExchangeTable());
            data.setType(company.getReportConvertMode());
        }
        data.setRule(RuleEnum.CHINA);
        data.setBookType(BookTypeEnum.FI);
        return data;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AcountSchemeFactory.getRemoteInstance();
    }
}

