/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.IAcountScheme;
import com.kingdee.eas.fi.books.client.AbstractAccountSchemeListUI;
import com.kingdee.eas.fi.books.client.AccountSchemeEditUI;
import com.kingdee.eas.fi.books.client.SwitchBookUtil;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class AccountSchemeListUI
extends AbstractAccountSchemeListUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountSchemeListUI.class);

    public AccountSchemeListUI() throws Exception {
        this.tblMain.checkParsed();
        this.tblMain.getColumn("id").getStyleAttributes().setHided(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initData();
        this.initMyIcon();
    }

    private void initData() throws Exception {
        BooksUtil.checkBook(null);
    }

    private void initMyIcon() {
        this.btnLock.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnUnLock.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.menuItemLock.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemUnLock.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnSwitch.setEnabled(true);
        this.actionLock.setEnabled(true);
        this.actionUnLock.setEnabled(true);
        this.btnSwitch.setVisible(false);
        this.actionRule.setVisible(false);
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                AccountSchemeListUI.this.afterSelectLine(e);
            }
        });
        this.tblMain.getSelectManager().select(0, 0);
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected String getEditUIName() {
        return AccountSchemeEditUI.class.getName();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AcountSchemeFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    @Override
    public void actionLock_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList selectList = this.getSelectedIdValues();
        for (int i = 0; i < selectList.size(); ++i) {
            if (selectList.get(i) == null) continue;
            ((IAcountScheme)this.getBizInterface()).lock(selectList.get(i).toString());
        }
        this.refreshList();
    }

    @Override
    public void actionUnLock_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList selectList = this.getSelectedIdValues();
        for (int i = 0; i < selectList.size(); ++i) {
            if (selectList.get(i) == null) continue;
            ((IAcountScheme)this.getBizInterface()).unLock(selectList.get(i).toString());
        }
        this.refreshList();
    }

    @Override
    public void actionRule_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = null;
        try {
            uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.books.client.AccountSchemeRuleUI", (Map)uiContext, null, OprtState.VIEW);
        }
        catch (UIException ex) {
            logger.error((Object)ex);
            this.handUIException(ex);
        }
        uiWindow.show();
    }

    @Override
    public void actionSwitch_actionPerformed(ActionEvent e) throws Exception {
        SwitchBookUtil.switchBooks((Object)this);
    }

    public EntityViewInfo mergeFilter(EntityViewInfo viewInfo) {
        SorterItemCollection sorters = viewInfo.getSorter();
        sorters.add(new SorterItemInfo("number"));
        return viewInfo;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        return super.getQueryExecutor(queryPK, this.mergeFilter(viewInfo));
    }

    protected void afterSelectLine(KDTSelectEvent e) {
        KDTSelectManager sm = this.tblMain.getSelectManager();
        int blockCount = sm.size();
        if (blockCount <= 0) {
            return;
        }
        KDTSelectBlock block = sm.get(0);
        IRow row = this.tblMain.getRow(block.getTop());
        if (row == null) {
            return;
        }
        Object obj = row.getCell("isLock").getValue();
        if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            this.actionUnLock.setEnabled(false);
            this.actionLock.setEnabled(true);
        } else {
            this.actionUnLock.setEnabled(true);
            this.actionLock.setEnabled(false);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2) {
            ActionEvent evt = new ActionEvent(this.btnView, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.GENERALLEDGER;
    }
}

