/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.books.AccountRuleFactory;
import com.kingdee.eas.fi.books.AcountSchemeCollection;
import com.kingdee.eas.fi.books.AcountSchemeFactory;
import com.kingdee.eas.fi.books.AcountSchemeInfo;
import com.kingdee.eas.fi.books.IAccountRule;
import com.kingdee.eas.fi.books.IAcountScheme;
import com.kingdee.eas.fi.books.client.AbstractAccountSchemeRuleListUI;
import com.kingdee.eas.fi.books.client.AccountSchemeRuleEditUI;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.framework.util.FilterUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class AccountSchemeRuleListUI
extends AbstractAccountSchemeRuleListUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountSchemeRuleListUI.class);
    private CompanyOrgUnitInfo curCompany;
    protected CommonQueryDialog dialog;
    protected String subSchemeId;

    public AccountSchemeRuleListUI() throws Exception {
        this.initMyIcon();
    }

    public void onLoad() throws Exception {
        BooksUtil.checkBook(null);
        this.curCompany = BooksUtil.getCurrentMasterCompany(null);
        super.onLoad();
        this.initData();
    }

    private void initData() throws Exception {
    }

    private void initMyIcon() {
        this.actionGroupEdit.setVisible(false);
        this.actionGroupMoveTree.setVisible(false);
        this.actionGroupRemove.setVisible(false);
        this.actionGroupView.setVisible(false);
        this.actionGroupAddNew.setVisible(false);
        this.actionMoveTree.setVisible(false);
        this.btnDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.menuItemDisEnable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.menuItemEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnMainAsstRelationSet.setIcon(EASResource.getIcon((String)"imgTbtn_settingrelating"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 1 && e.getClickCount() == 1) {
            int rowIndex = e.getRowIndex();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return;
            }
            Object obj = row.getCell("isEnable").getValue();
            if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
                this.actionEnable.setEnabled(false);
                this.actionDisenable.setEnabled(true);
            } else {
                this.actionEnable.setEnabled(true);
                this.actionDisenable.setEnabled(false);
            }
            return;
        }
        if (e.getType() == 1) {
            ActionEvent evt = new ActionEvent(this.btnView, 0, "Double Clicked");
            ItemAction actView = this.getActionFromActionEvent(evt);
            actView.actionPerformed(evt);
            this.setPreSelecteRow();
        } else {
            super.tblMain_tableClicked(e);
        }
    }

    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (e == null || e.getSelectBlock() == null) {
            return;
        }
        int rowIndex = e.getSelectBlock().getTop();
        IRow row = this.tblMain.getRow(rowIndex);
        if (row == null) {
            return;
        }
        Object obj = row.getCell("isEnable").getValue();
        if (obj instanceof Boolean && ((Boolean)obj).booleanValue()) {
            this.actionEnable.setEnabled(false);
            this.actionDisenable.setEnabled(true);
            this.actionEdit.setEnabled(false);
        } else {
            this.actionEnable.setEnabled(true);
            this.actionDisenable.setEnabled(false);
            this.actionEdit.setEnabled(true);
        }
    }

    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        DefaultKingdeeTreeNode selectTreeNode = (DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent();
        Object tmpObject = selectTreeNode.getUserObject();
        if (tmpObject instanceof AcountSchemeInfo) {
            uiContext.remove((Object)"ParentNode");
            uiContext.put((Object)"ParentNode", tmpObject);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Leaf_MustSelected"));
            SysUtil.abort();
        }
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        String queryName;
        IQuerySolutionFacade iQuery;
        if (this.dialog == null) {
            this.dialog = this.initCommonQueryDialog();
        }
        if (!this.isPerformDefaultQuery(iQuery = QuerySolutionFacadeFactory.getRemoteInstance(), queryName = AccountSchemeRuleListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName()) && !this.isFirstDefaultQuery()) {
            if (this.dialog.show()) {
                this.doQuery(this.dialog);
                this.buildTreeFilter();
                if (!FilterUtility.hasFilterItem((FilterInfo)this.mainQuery.getFilter())) {
                    this.mainQuery = this.dialog.getEntityViewInfoResult();
                } else {
                    this.MergeCommonQuery(this.dialog.getEntityViewInfoResult());
                }
                this.execQuery();
            } else {
                SysUtil.abort();
            }
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        super.actionView_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String pk = this.getSelectedKeyValue();
        ((IAccountRule)this.getBizInterface()).enable(pk);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.books.BOOKSAutoGenerateResource", (String)"3_AccountSchemeRuleListUI"));
        this.treeMain_valueChanged(null);
    }

    @Override
    public void actionDisenable_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String pk = this.getSelectedKeyValue();
        ((IAccountRule)this.getBizInterface()).disEnable(pk);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.books.BOOKSAutoGenerateResource", (String)"4_AccountSchemeRuleListUI"));
        this.treeMain_valueChanged(null);
    }

    @Override
    public void actionMainAsstRelationSet_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create("com.kingdee.eas.fi.books.client.MainAsstOrgRelationUI", (Map)uiContext);
        uiWindow.show();
    }

    protected IObjectPK getSelectedTreeKeyValue() {
        String key = this.getSelectedNodeKeyValue();
        if (key != null) {
            return new ObjectUuidPK(key);
        }
        return null;
    }

    protected String getGroupEditUIName() {
        return null;
    }

    protected String getQueryFieldName() {
        return "accountScheme.id";
    }

    protected String getKeyFieldName() {
        return "id";
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected String getEditUIName() {
        return AccountSchemeRuleEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccountRuleFactory.getRemoteInstance();
    }

    protected void initTree() throws Exception {
        KDTreeNode rootNode = new KDTreeNode((Object)EASResource.getString((String)"com.kingdee.eas.fi.books.AccountBooksResource", (String)"Books"));
        SorterItemInfo sorter = new SorterItemInfo("number");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isMaster", (Object)new Integer(0)));
        AcountSchemeInfo scheme = BooksUtil.getCurrentBook(null);
        if (!scheme.isIsMaster()) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)scheme.getId().toString()));
        }
        view.setFilter(filter);
        view.getSorter().add(sorter);
        IAcountScheme iAcountScheme = AcountSchemeFactory.getRemoteInstance();
        AcountSchemeCollection acountSchemeCollection = iAcountScheme.getAcountSchemeCollection(view);
        if (acountSchemeCollection != null) {
            int count = acountSchemeCollection.size();
            for (int i = 0; i < count; ++i) {
                AcountSchemeInfo acountSchemeInfo = acountSchemeCollection.get(i);
                KDTreeNode child = new KDTreeNode((Object)acountSchemeInfo);
                child.setText(acountSchemeInfo.getNumber() + " - " + acountSchemeInfo.getName());
                rootNode.add((MutableTreeNode)child);
                this.subSchemeId = acountSchemeInfo.getId().toString();
            }
        }
        DefaultTreeModel treeModel = new DefaultTreeModel((TreeNode)rootNode);
        this.treeMain.setModel((TreeModel)treeModel);
        TreePath path = new TreePath(rootNode);
        this.treeMain.expandPath(path);
        this.treeMain.setSelectionPath(path);
    }

    protected void buildTreeFilter() {
        this.mainQuery = this.dialog.getEntityViewInfoResult();
        if (this.mainQuery == null) {
            this.mainQuery = this.getDefaultEntityViewInfo();
        }
        if (this.mainQuery == null) {
            this.mainQuery = new EntityViewInfo();
        }
        try {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.curCompany.getId().toString()));
            filter.setMaskString(" #0 ");
            if (this.mainQuery.getFilter() != null && this.mainQuery.getFilter().getFilterItems() != null && this.mainQuery.getFilter().getFilterItems().size() > 0) {
                this.mainQuery.getFilter().mergeFilter(filter, "AND");
            } else {
                this.mainQuery.setFilter(filter);
            }
            this.mainQuery.getFilter().mergeFilter(this.getTreeFilter(), "AND");
        }
        catch (BOSException ex) {
            this.handleException((Exception)((Object)ex));
            this.abort();
        }
    }

    protected FilterInfo getTreeFilter() {
        KDTreeNode treeNode = (KDTreeNode)this.treeMain.getLastSelectedPathComponent();
        FilterInfo filterInfo = new FilterInfo();
        if (BooksUtil.isMasterBook(null)) {
            if (treeNode != null && this.getSelectedNodeKeyValue() != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("accountScheme.id", (Object)this.getSelectedNodeKeyValue()));
                filterInfo.setMaskString(" #0 ");
            }
        } else if (treeNode != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("accountScheme.id", (Object)this.subSchemeId));
            filterInfo.setMaskString(" #0 ");
        }
        return filterInfo;
    }

    protected String getSelectedNodeKeyValue() {
        KDTreeNode treeNode = this.getSelectedTreeNode();
        if (treeNode != null && treeNode.getUserObject() instanceof AcountSchemeInfo) {
            return ((AcountSchemeInfo)treeNode.getUserObject()).getId().toString();
        }
        return null;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.GENERALLEDGER;
    }
}

