/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.books.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectListener;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.books.AccountRuleFactory;
import com.kingdee.eas.fi.books.AccountRuleInfo;
import com.kingdee.eas.fi.books.IAccountRule;
import com.kingdee.eas.fi.books.VoucherStatusEnum;
import com.kingdee.eas.fi.books.client.AbstractAccountSchemeRuleUI;
import com.kingdee.eas.fi.books.util.BooksRuleInfo;
import com.kingdee.eas.fi.books.util.BooksUtil;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.enums.StringEnum;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class AccountSchemeRuleUI
extends AbstractAccountSchemeRuleUI {
    private static final Logger logger = CoreUIObject.getLogger(AccountSchemeRuleUI.class);
    private BooksRuleInfo ruleInfo = null;
    private HashMap oriMap = new HashMap();

    public AccountSchemeRuleUI() throws Exception {
        this.initTableStyle();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initMyIcon();
    }

    private void initData() {
        String rule = this.getSelectedKeyValue();
        this.oriMap.clear();
        try {
            this.ruleInfo = ((IAccountRule)this.getBizInterface()).getRuleS(rule);
            for (String key : this.ruleInfo.getProperties().keySet()) {
                String value = ((AccountRuleInfo)this.ruleInfo.getProperties().get(key)).getValue().getValue();
                this.oriMap.put(key, value);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    private void initMyIcon() {
        this.actionAddNew.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionQuery.setVisible(false);
        this.actionRefresh.setVisible(false);
        this.actionLocate.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.btnView.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnView.setText(EASResource.getString((String)"com.kingdee.eas.fi.books.AccountBooksResource", (String)"Save"));
        this.btnView.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.books.AccountBooksResource", (String)"Save"));
        this.menuItemView.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    protected void initTableStyle() throws Exception {
        this.tblMain.addKDTSelectListener(new KDTSelectListener(){

            public void tableSelectChanged(KDTSelectEvent e) {
                AccountSchemeRuleUI.this.afterSelectLine(e);
            }
        });
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.save();
    }

    protected void afterSelectLine(KDTSelectEvent e) {
        KDTSelectManager sm = this.tblMain.getSelectManager();
        int blockCount = sm.size();
        if (blockCount <= 0) {
            return;
        }
        this.initData();
        this.initElement();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return AccountRuleFactory.getRemoteInstance();
    }

    protected boolean isIgnoreCUFilter() {
        return true;
    }

    private void save() throws Exception {
        if (this.ruleInfo == null || this.ruleInfo.getProperties() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.books.AccountBooksResource", (String)"NotexitBooks"));
            return;
        }
        HashMap prop = this.ruleInfo.getProperties();
        this.storeField(prop);
        HashMap<String, AccountRuleInfo> newmap = new HashMap<String, AccountRuleInfo>();
        HashMap<String, AccountRuleInfo> changedmap = new HashMap<String, AccountRuleInfo>();
        for (String key : prop.keySet()) {
            AccountRuleInfo info = (AccountRuleInfo)prop.get(key);
            String newValue = info.getValue().getValue();
            if (newValue.equals(this.oriMap.get(key))) continue;
            if (info.getId() == null) {
                AccountRuleInfo info2 = (AccountRuleInfo)info.clone();
                info2.setId(BOSUuid.create((BOSObjectType)info2.getBOSType()));
                info2.put("status", "new");
                info2.setAccountScheme(this.ruleInfo.getBook());
                newmap.put(key, info2);
                continue;
            }
            AccountRuleInfo item = new AccountRuleInfo();
            item.setId(((AccountRuleInfo)prop.get(key)).getId());
            item.put("status", "update");
            item.setValue(VoucherStatusEnum.getEnum(newValue));
            changedmap.put(key, item);
        }
        BooksRuleInfo saveInfo = new BooksRuleInfo();
        saveInfo.setBook(this.ruleInfo.getBook());
        HashMap<String, AccountRuleInfo> savemap = new HashMap<String, AccountRuleInfo>();
        saveInfo.setProperties(savemap);
        savemap.putAll(newmap);
        savemap.putAll(changedmap);
        ((IAccountRule)this.getBizInterface()).save(saveInfo);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.books.BOOKSAutoGenerateResource", (String)"7_MainAsstOrgRelationUI"));
        for (String key : changedmap.keySet()) {
            this.oriMap.put(key, ((AccountRuleInfo)changedmap.get(key)).getValue());
        }
        for (String key : newmap.keySet()) {
            prop.put(key, (AccountRuleInfo)newmap.get(key));
            this.oriMap.put(key, ((AccountRuleInfo)newmap.get(key)).getValue());
        }
    }

    private void initElement() {
    }

    private void storeField(HashMap prop) {
    }

    private void saveCBComponentValue(HashMap prop, Component[] comps) {
        for (int i = 0; i < comps.length; ++i) {
            Object object;
            String name = comps[i].getName();
            String value = null;
            if (comps[i] instanceof KDCheckBox) {
                value = ((KDCheckBox)comps[i]).isSelected() ? "true" : "false";
            } else if (comps[i] instanceof KDComboBox) {
                object = ((KDComboBox)comps[i]).getSelectedItem();
                if (object instanceof StringEnum) {
                    value = ((StringEnum)object).getValue();
                }
            } else if (comps[i] instanceof KDBizPromptBox && (object = ((KDBizPromptBox)comps[i]).getValue()) instanceof ObjectBaseInfo) {
                value = ((ObjectBaseInfo)object).getId().toString();
            }
            if (value == null) continue;
            AccountRuleInfo item = (AccountRuleInfo)prop.get(name);
            if (item != null) {
                item.setValue(VoucherStatusEnum.getEnum(value));
                continue;
            }
            AccountRuleInfo info = new AccountRuleInfo();
            info.setValue(VoucherStatusEnum.getEnum(value));
            info.setNumber(name);
            prop.put(name, info);
        }
    }

    public EntityViewInfo mergeFilter(EntityViewInfo viewInfo) {
        CompanyOrgUnitInfo company = BooksUtil.getCurrentMasterCompany(null);
        String sql = " select FaccountSchemeID from T_org_company where FmainOrgId='" + company.getId().toString() + "'";
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("isMaster", (Object)new Integer(0), CompareType.EQUALS));
        fic.add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
        viewInfo.setFilter(filter);
        SorterItemCollection sorters = viewInfo.getSorter();
        sorters.add(new SorterItemInfo("number"));
        return viewInfo;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        return super.getQueryExecutor(queryPK, this.mergeFilter(viewInfo));
    }
}

